/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLSet;
import com.fis.ekyc.nfc.build_in.eidparser.lds.SecurityInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CardAccessFile
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd.lds");
    private static final long serialVersionUID = -3536507558193769951L;
    private Set<SecurityInfo> securityInfos;

    public CardAccessFile(Collection<SecurityInfo> collection) {
        if (collection != null) {
            HashSet<SecurityInfo> hashSet;
            CardAccessFile cardAccessFile = serializable;
            Serializable serializable = hashSet;
            hashSet = new HashSet<SecurityInfo>(collection);
            cardAccessFile.securityInfos = serializable;
            return;
        }
        throw new IllegalArgumentException("Null securityInfos");
    }

    public CardAccessFile(InputStream inputStream) {
        CardAccessFile cardAccessFile = this;
        cardAccessFile.readContent(inputStream);
    }

    public CardAccessFile(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream;
        CardAccessFile cardAccessFile = byteArrayInputStream2;
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        cardAccessFile.readContent(byteArrayInputStream2);
    }

    public void readContent(InputStream object) {
        this.securityInfos = new HashSet<SecurityInfo>();
        object = (ASN1Set)new ASN1InputStream((InputStream)object).readObject();
        for (int k = 0; k < ((ASN1Set)object).size(); ++k) {
            SecurityInfo securityInfo;
            try {
                securityInfo = SecurityInfo.getInstance(((ASN1Set)object).getObjectAt(k).toASN1Primitive());
                if (securityInfo == null) continue;
            }
            catch (Exception exception) {}
            this.securityInfos.add(securityInfo);
        }
    }

    public void writeContent(OutputStream outputStream) {
        ASN1EncodableVector aSN1EncodableVector;
        CardAccessFile cardAccessFile = aSN1EncodableVector2;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector();
        Iterator<SecurityInfo> iterator = cardAccessFile.securityInfos.iterator();
        while (iterator.hasNext()) {
            aSN1EncodableVector2.add(iterator.next().getDERObject());
        }
        outputStream.write(new DLSet(aSN1EncodableVector2).getEncoded("DER"));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getEncoded() {
        Throwable throwable2222222;
        ByteArrayOutputStream byteArrayOutputStream2;
        block10: {
            ByteArrayOutputStream byteArrayOutputStream2;
            byteArrayOutputStream2 = byteArrayOutputStream2;
            byteArrayOutputStream2();
            ((CardAccessFile)object).writeContent(byteArrayOutputStream2);
            byteArrayOutputStream2.flush();
            Object object = byteArrayOutputStream2.toByteArray();
            {
                byte[] byArray;
                ByteArrayOutputStream byteArrayOutputStream3;
                catch (Throwable throwable2222222) {
                    break block10;
                }
                catch (IOException iOException) {}
                {
                    byteArrayOutputStream3 = byteArrayOutputStream2;
                    LOGGER.log(Level.WARNING, "Exception while encoding", iOException);
                    byArray = null;
                }
                try {
                    byteArrayOutputStream3.close();
                    return byArray;
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, "Error closing stream", iOException);
                }
                return byArray;
            }
            try {
                byteArrayOutputStream2.close();
                return object;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.FINE, "Error closing stream", iOException);
            }
            return object;
        }
        try {
            byteArrayOutputStream2.close();
            throw throwable2222222;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error closing stream", iOException);
        }
        throw throwable2222222;
    }

    public Collection<SecurityInfo> getSecurityInfos() {
        return Collections.unmodifiableCollection(this.securityInfos);
    }

    public int getSecurityInfosSize() {
        return this.securityInfos.size();
    }

    public SecurityInfo getSecurityInfo(int n) {
        return (SecurityInfo)this.securityInfos.toArray()[n];
    }

    public String toString() {
        return a.a("CardAccessFile [").append(this.securityInfos.toString()).append("]").toString();
    }

    public boolean equals(Object set) {
        if (set == null) {
            return false;
        }
        if (!set.getClass().equals(set2.getClass())) {
            return false;
        }
        CardAccessFile cardAccessFile = set2;
        Set<SecurityInfo> set2 = (CardAccessFile)((Object)set);
        set = cardAccessFile.securityInfos;
        if (set == null) {
            return ((CardAccessFile)((Object)set2)).securityInfos == null;
        }
        set2 = ((CardAccessFile)((Object)set2)).securityInfos;
        if (set2 == null) {
            return set == null;
        }
        return set.equals(set2);
    }

    public int hashCode() {
        return this.securityInfos.hashCode() * 7 + 61;
    }
}

