/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLSet;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.ContentInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.SignedData;
import com.fis.ekyc.nfc.build_in.eidparser.lds.ChipAuthenticationInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.ChipAuthenticationPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.PACEInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.SecurityInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.SignedDataUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CardSecurityFile
implements Serializable {
    private static final long serialVersionUID = -3535507558193769952L;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private static final String CONTENT_TYPE_OID = "0.4.0.127.0.7.3.2.1";
    private String digestAlgorithm;
    private String digestEncryptionAlgorithm;
    private Set<SecurityInfo> securityInfos;
    private byte[] encryptedDigest;
    private X509Certificate certificate;

    public CardSecurityFile(String string2, String string3, Collection<SecurityInfo> collection, PrivateKey privateKey, X509Certificate x509Certificate) {
        this(string2, string3, collection, privateKey, x509Certificate, null);
    }

    public CardSecurityFile(String string2, String string3, Collection<SecurityInfo> collection, PrivateKey privateKey, X509Certificate x509Certificate, String string4) {
        this(string2, string3, collection, (byte[])null, x509Certificate);
        this.encryptedDigest = SignedDataUtil.signData(string2, string3, CONTENT_TYPE_OID, CardSecurityFile.toContentInfo(CONTENT_TYPE_OID, collection), privateKey, string4);
    }

    public CardSecurityFile(String string2, String string3, Collection<SecurityInfo> collection, byte[] byArray, X509Certificate x509Certificate) {
        if (collection != null) {
            if (x509Certificate != null) {
                HashSet<SecurityInfo> hashSet;
                CardSecurityFile cardSecurityFile = serializable;
                cardSecurityFile.digestAlgorithm = string2;
                cardSecurityFile.digestEncryptionAlgorithm = string3;
                Serializable serializable = hashSet;
                hashSet = new HashSet<SecurityInfo>(collection);
                cardSecurityFile.securityInfos = serializable;
                cardSecurityFile.encryptedDigest = byArray;
                cardSecurityFile.certificate = x509Certificate;
                return;
            }
            throw new IllegalArgumentException("Null certificate");
        }
        throw new IllegalArgumentException("Null securityInfos");
    }

    public CardSecurityFile(InputStream inputStream) {
        CardSecurityFile cardSecurityFile = this;
        cardSecurityFile.readContent(inputStream);
    }

    private static ContentInfo toContentInfo(String object, Collection<SecurityInfo> object2) {
        DEROctetString dEROctetString;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        ContentInfo contentInfo;
        ContentInfo contentInfo2;
        DLSet dLSet;
        ASN1EncodableVector aSN1EncodableVector;
        Collection<SecurityInfo> collection = object2;
        object2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector();
        Object object3 = collection.iterator();
        while (true) {
            if (!object3.hasNext()) break;
            ((ASN1EncodableVector)object2).add(object3.next().getDERObject());
            continue;
            break;
        }
        object3 = dLSet;
        try {
            ContentInfo contentInfo3;
            dLSet = new DLSet((ASN1EncodableVector)object2);
            contentInfo2 = contentInfo3;
            contentInfo = contentInfo3;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Error creating signedData", iOException);
            throw new IllegalArgumentException("Error DER encoding the security infos");
        }
        object2 = aSN1ObjectIdentifier;
        aSN1ObjectIdentifier = new ASN1ObjectIdentifier((String)object);
        object = dEROctetString;
        dEROctetString = new DEROctetString((ASN1Encodable)object3);
        contentInfo2((ASN1ObjectIdentifier)object2, (ASN1Encodable)object);
        return contentInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<SecurityInfo> getSecurityInfos(SignedData aSN1Object) {
        HashSet<SecurityInfo> hashSet;
        if (!((aSN1Object = SignedDataUtil.getContent((SignedData)aSN1Object)) instanceof ASN1Set)) {
            throw new IOException(a.a("Was expecting an ASN1Set, found ").append(aSN1Object.getClass()).toString());
        }
        aSN1Object = (ASN1Set)aSN1Object;
        HashSet<SecurityInfo> hashSet2 = hashSet;
        hashSet = new HashSet<SecurityInfo>();
        int n = 0;
        while (true) {
            block7: {
                if (n >= ((ASN1Set)aSN1Object).size()) {
                    return hashSet2;
                }
                try {
                    SecurityInfo securityInfo = SecurityInfo.getInstance(((ASN1Set)aSN1Object).getObjectAt(n).toASN1Primitive());
                    if (securityInfo == null) {
                        LOGGER.log(Level.WARNING, "Could not parse, skipping security info");
                        break block7;
                    }
                    hashSet2.add(securityInfo);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "Exception while parsing, skipping security info", exception);
                }
            }
            ++n;
        }
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public String getDigestEncryptionAlgorithm() {
        return this.digestEncryptionAlgorithm;
    }

    public byte[] getEncryptedDigest() {
        byte[] byArray;
        Object object = ((CardSecurityFile)object).encryptedDigest;
        if (((CardSecurityFile)object).encryptedDigest == null) {
            byArray = null;
        } else {
            Object object2 = object;
            byArray = Arrays.copyOf((byte[])object2, ((Object)object2).length);
        }
        return byArray;
    }

    public void readContent(InputStream object) {
        object = SignedDataUtil.readSignedData((InputStream)object);
        this.digestAlgorithm = SignedDataUtil.getSignerInfoDigestAlgorithm((SignedData)object);
        this.digestEncryptionAlgorithm = SignedDataUtil.getDigestEncryptionAlgorithm((SignedData)object);
        List<X509Certificate> list = SignedDataUtil.getCertificates((SignedData)object);
        if (list != null && !list.isEmpty()) {
            List<X509Certificate> list2 = list;
            list = list2.get(list2.size() - 1);
        } else {
            list = null;
        }
        this.certificate = list;
        this.securityInfos = CardSecurityFile.getSecurityInfos((SignedData)object);
        this.encryptedDigest = SignedDataUtil.getEncryptedDigest((SignedData)object);
    }

    public void writeContent(OutputStream outputStream) {
        CardSecurityFile cardSecurityFile = string3;
        ContentInfo contentInfo = CardSecurityFile.toContentInfo(CONTENT_TYPE_OID, ((CardSecurityFile)((Object)string3)).securityInfos);
        String string2 = cardSecurityFile.digestAlgorithm;
        CardSecurityFile cardSecurityFile2 = string3;
        CardSecurityFile cardSecurityFile3 = cardSecurityFile2;
        CardSecurityFile cardSecurityFile4 = cardSecurityFile2;
        String string3 = cardSecurityFile2.digestEncryptionAlgorithm;
        String string4 = CONTENT_TYPE_OID;
        byte[] byArray = cardSecurityFile4.encryptedDigest;
        X509Certificate x509Certificate = cardSecurityFile3.certificate;
        try {
            SignedDataUtil.writeData(SignedDataUtil.createSignedData(string2, string3, string4, contentInfo, byArray, x509Certificate), outputStream);
            return;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IOException("General security exception", generalSecurityException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("Unsupported algorithm", noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new IOException("Certificate exception during SignedData creation", certificateException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getEncoded() {
        Throwable throwable2222222;
        ByteArrayOutputStream byteArrayOutputStream2;
        block10: {
            ByteArrayOutputStream byteArrayOutputStream2;
            byteArrayOutputStream2 = byteArrayOutputStream2;
            byteArrayOutputStream2();
            ((CardSecurityFile)object).writeContent(byteArrayOutputStream2);
            byteArrayOutputStream2.flush();
            Object object = byteArrayOutputStream2.toByteArray();
            {
                byte[] byArray;
                ByteArrayOutputStream byteArrayOutputStream3;
                catch (Throwable throwable2222222) {
                    break block10;
                }
                catch (IOException iOException) {}
                {
                    byteArrayOutputStream3 = byteArrayOutputStream2;
                    LOGGER.log(Level.WARNING, "Exception while encoding", iOException);
                    byArray = null;
                }
                try {
                    byteArrayOutputStream3.close();
                    return byArray;
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, "Error closing stream");
                }
                return byArray;
            }
            try {
                byteArrayOutputStream2.close();
                return object;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.FINE, "Error closing stream");
            }
            return object;
        }
        try {
            byteArrayOutputStream2.close();
            throw throwable2222222;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error closing stream");
        }
        throw throwable2222222;
    }

    public Collection<SecurityInfo> getSecurityInfos() {
        return Collections.unmodifiableCollection(this.securityInfos);
    }

    @Deprecated
    public Collection<PACEInfo> getPACEInfos() {
        ArrayList<PACEInfo> arrayList;
        ArrayList<PACEInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<PACEInfo>(((CardSecurityFile)this).securityInfos.size());
        for (SecurityInfo securityInfo : ((CardSecurityFile)this).securityInfos) {
            if (!(securityInfo instanceof PACEInfo)) continue;
            arrayList2.add((PACEInfo)securityInfo);
        }
        return arrayList2;
    }

    @Deprecated
    public Collection<ChipAuthenticationInfo> getChipAuthenticationInfos() {
        ArrayList<ChipAuthenticationInfo> arrayList;
        ArrayList<ChipAuthenticationInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<ChipAuthenticationInfo>(((CardSecurityFile)this).securityInfos.size());
        for (SecurityInfo securityInfo : ((CardSecurityFile)this).securityInfos) {
            if (!(securityInfo instanceof ChipAuthenticationInfo)) continue;
            arrayList2.add((ChipAuthenticationInfo)securityInfo);
        }
        return arrayList2;
    }

    @Deprecated
    public Collection<ChipAuthenticationPublicKeyInfo> getChipAuthenticationPublicKeyInfos() {
        ArrayList<ChipAuthenticationPublicKeyInfo> arrayList;
        ArrayList<ChipAuthenticationPublicKeyInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<ChipAuthenticationPublicKeyInfo>(((CardSecurityFile)this).securityInfos.size());
        for (SecurityInfo securityInfo : ((CardSecurityFile)this).securityInfos) {
            if (!(securityInfo instanceof ChipAuthenticationPublicKeyInfo)) continue;
            arrayList2.add((ChipAuthenticationPublicKeyInfo)securityInfo);
        }
        return arrayList2;
    }

    public String toString() {
        return a.a("CardSecurityFile [").append(this.securityInfos.toString()).append("]").toString();
    }

    public boolean equals(Object set) {
        if (set == null) {
            return false;
        }
        if (!set.getClass().equals(set2.getClass())) {
            return false;
        }
        CardSecurityFile cardSecurityFile = set2;
        Set<SecurityInfo> set2 = (CardSecurityFile)((Object)set);
        set = cardSecurityFile.securityInfos;
        if (set == null) {
            return ((CardSecurityFile)((Object)set2)).securityInfos == null;
        }
        set2 = ((CardSecurityFile)((Object)set2)).securityInfos;
        if (set2 == null) {
            return set == null;
        }
        return set.equals(set2);
    }

    public int hashCode() {
        return this.securityInfos.hashCode() * 3 + 63;
    }
}

