/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.eidparser.lds.AbstractImageInfo;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVInputStream;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVOutputStream;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class DisplayedImageInfo
extends AbstractImageInfo {
    private static final long serialVersionUID = 3801320585294302721L;
    public static final int DISPLAYED_PORTRAIT_TAG = 24384;
    public static final int DISPLAYED_SIGNATURE_OR_MARK_TAG = 24387;
    private int displayedImageTag;

    public DisplayedImageInfo(int n, byte[] byArray) {
        int n2 = n;
        super(n2, DisplayedImageInfo.getMimeTypeFromType(n2));
        this.displayedImageTag = DisplayedImageInfo.getDisplayedImageTagFromType(n);
        this.setImageBytes(byArray);
    }

    public DisplayedImageInfo(InputStream inputStream) {
        DisplayedImageInfo displayedImageInfo = this;
        displayedImageInfo.readObject(inputStream);
    }

    private static String getMimeTypeFromType(int n) {
        if (n != 0) {
            if (n != 1) {
                if (n == 2) {
                    return "image/x-wsq";
                }
                throw new NumberFormatException(h.a(n, a.a("Unknown type: ")));
            }
            return "image/jpeg";
        }
        return "image/jpeg";
    }

    private static int getDisplayedImageTagFromType(int n) {
        if (n != 0) {
            if (n == 1) {
                return 24387;
            }
            throw new NumberFormatException(h.a(n, a.a("Unknown type: ")));
        }
        return 24384;
    }

    private static int getTypeFromDisplayedImageTag(int n) {
        if (n != 24384) {
            if (n == 24387) {
                return 1;
            }
            throw new NumberFormatException(h.a(n, a.a("Unknown tag: ")));
        }
        return 0;
    }

    @Override
    public void readObject(InputStream inputStream) {
        int n;
        if (inputStream instanceof TLVInputStream) {
            inputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream;
            TLVInputStream tLVInputStream2 = tLVInputStream;
            tLVInputStream = new TLVInputStream(inputStream);
            inputStream = tLVInputStream2;
        }
        serializable.displayedImageTag = n = ((TLVInputStream)inputStream).readTag();
        if (n != 24384 && n != 24387) {
            DisplayedImageInfo displayedImageInfo = serializable;
            Serializable serializable = a.a("Expected tag 0x5F40 or 0x5F43, found ");
            throw new IllegalArgumentException(h.a(displayedImageInfo.displayedImageTag, (StringBuilder)serializable));
        }
        InputStream inputStream2 = inputStream;
        DisplayedImageInfo displayedImageInfo = serializable;
        int n2 = DisplayedImageInfo.getTypeFromDisplayedImageTag(n);
        displayedImageInfo.setType(n2);
        displayedImageInfo.setMimeType(DisplayedImageInfo.getMimeTypeFromType(n2));
        serializable.readImage(inputStream2, ((TLVInputStream)inputStream2).readLength());
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        if (outputStream instanceof TLVOutputStream) {
            outputStream = (TLVOutputStream)outputStream;
        } else {
            TLVOutputStream tLVOutputStream;
            TLVOutputStream tLVOutputStream2 = tLVOutputStream;
            tLVOutputStream = new TLVOutputStream(outputStream);
            outputStream = tLVOutputStream2;
        }
        OutputStream outputStream2 = outputStream;
        ((TLVOutputStream)outputStream2).writeTag(DisplayedImageInfo.getDisplayedImageTagFromType(this.getType()));
        this.writeImage(outputStream2);
        ((TLVOutputStream)outputStream).writeValueEnd();
    }

    public int getDisplayedImageTag() {
        return this.displayedImageTag;
    }

    @Override
    public long getRecordLength() {
        DisplayedImageInfo displayedImageInfo = this;
        int n = displayedImageInfo.getImageLength();
        return (long)TLVUtil.getTagLength(DisplayedImageInfo.getDisplayedImageTagFromType(displayedImageInfo.getType())) + 0L + (long)TLVUtil.getLengthLength(n) + (long)n;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.displayedImageTag;
    }

    @Override
    public boolean equals(Object object) {
        if (displayedImageInfo2 == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (displayedImageInfo2.getClass() != object.getClass()) {
            return false;
        }
        DisplayedImageInfo displayedImageInfo = displayedImageInfo2;
        DisplayedImageInfo displayedImageInfo2 = (DisplayedImageInfo)object;
        return displayedImageInfo.displayedImageTag == displayedImageInfo2.displayedImageTag;
    }
}

