/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X962NamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X962Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.eidparser.Util;
import com.fis.ekyc.nfc.build_in.eidparser.lds.SecurityInfo;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PACEDomainParameterInfo
extends SecurityInfo {
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private static final long serialVersionUID = -5851251908152594728L;
    public static final String ID_PRIME_FIELD = "1.2.840.10045.1.1";
    public static final String ID_EC_PUBLIC_KEY = "1.2.840.10045.2.1";
    public static final String ID_DH_PUBLIC_NUMBER = "1.2.840.10046.2.1";
    private String oid;
    private transient AlgorithmIdentifier domainParameter;
    private BigInteger parameterId;

    public PACEDomainParameterInfo(String string2, AlgorithmIdentifier algorithmIdentifier) {
        this(string2, algorithmIdentifier, null);
    }

    public PACEDomainParameterInfo(String string2, AlgorithmIdentifier algorithmIdentifier, BigInteger bigInteger) {
        if (PACEDomainParameterInfo.checkRequiredIdentifier(string2)) {
            PACEDomainParameterInfo pACEDomainParameterInfo = this;
            pACEDomainParameterInfo.oid = string2;
            pACEDomainParameterInfo.domainParameter = algorithmIdentifier;
            pACEDomainParameterInfo.parameterId = bigInteger;
            return;
        }
        throw new IllegalArgumentException(i.a("Invalid protocol id: ", string2));
    }

    public static boolean checkRequiredIdentifier(String string2) {
        return "0.4.0.127.0.7.2.2.4.1".equals(string2) || "0.4.0.127.0.7.2.2.4.2".equals(string2) || "0.4.0.127.0.7.2.2.4.3".equals(string2) || "0.4.0.127.0.7.2.2.4.4".equals(string2) || "0.4.0.127.0.7.2.2.4.6".equals(string2);
    }

    @Deprecated
    public static AlgorithmIdentifier toAlgorithmIdentifier(ECParameterSpec aSN1EncodableArray) {
        DLSequence dLSequence;
        DEROctetString dEROctetString;
        DEROctetString dEROctetString2;
        ASN1Integer aSN1Integer;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        ArrayList<ASN1Primitive> arrayList = new ArrayList<ASN1Primitive>();
        arrayList.add(new ASN1Integer(BigInteger.ONE));
        ASN1Primitive aSN1Primitive = aSN1ObjectIdentifier;
        aSN1ObjectIdentifier = new ASN1ObjectIdentifier(ID_PRIME_FIELD);
        EllipticCurve ellipticCurve = aSN1EncodableArray.getCurve();
        Object object = (ECFieldFp)ellipticCurve.getField();
        ASN1Integer aSN1Integer2 = aSN1Integer;
        aSN1Integer = new ASN1Integer(((ECFieldFp)object).getP());
        arrayList.add(new DLSequence(new ASN1Encodable[]{aSN1Primitive, aSN1Integer2}));
        aSN1Primitive = dEROctetString2;
        dEROctetString2 = new DEROctetString(Util.i2os(ellipticCurve.getA()));
        object = dEROctetString;
        dEROctetString = new DEROctetString(Util.i2os(ellipticCurve.getB()));
        arrayList.add(new DLSequence(new ASN1Encodable[]{aSN1Primitive, object}));
        arrayList.add(new DEROctetString(Util.ecPoint2OS(aSN1EncodableArray.getGenerator(), aSN1EncodableArray.getCurve().getField().getFieldSize())));
        arrayList.add(new ASN1Integer(aSN1EncodableArray.getOrder()));
        arrayList.add(new ASN1Integer(aSN1EncodableArray.getCofactor()));
        aSN1EncodableArray = new ASN1Encodable[arrayList.size()];
        arrayList.toArray(aSN1EncodableArray);
        aSN1Primitive = dLSequence;
        dLSequence = new DLSequence(aSN1EncodableArray);
        return new AlgorithmIdentifier(new ASN1ObjectIdentifier(ID_EC_PUBLIC_KEY), aSN1Primitive);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static ECParameterSpec toECParameterSpec(AlgorithmIdentifier object) {
        EllipticCurve ellipticCurve;
        Object object2;
        java.security.spec.ECPoint eCPoint;
        BigInteger bigInteger;
        Object object3;
        ASN1Sequence aSN1Sequence;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        block17: {
            if (!((object = ((AlgorithmIdentifier)object).getParameters()) instanceof ASN1Sequence)) {
                throw new IllegalArgumentException("Was expecting an ASN.1 sequence");
            }
            try {
                object9 = X962Parameters.getInstance(object);
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Exception", exception);
                break block17;
            }
            {
                if (!((X962Parameters)object9).isNamedCurve()) break block17;
                object9 = (ASN1ObjectIdentifier)((X962Parameters)object9).getParameters();
            }
            {
                Object object10 = X962NamedCurves.getByOID((ASN1ObjectIdentifier)object9);
                X9ECParameters x9ECParameters = object10;
                object9 = X962NamedCurves.getName((ASN1ObjectIdentifier)object9);
                object10 = x9ECParameters.getCurve();
                ECPoint eCPoint2 = x9ECParameters.getG();
                BigInteger bigInteger2 = x9ECParameters.getN();
                BigInteger bigInteger3 = x9ECParameters.getH();
                byte[] byArray = x9ECParameters.getSeed();
                return Util.toECNamedCurveSpec(new ECNamedCurveParameterSpec((String)object9, (ECCurve)object10, eCPoint2, bigInteger2, bigInteger3, byArray));
            }
        }
        if (((ASN1Sequence)(object = (ASN1Sequence)object)).size() < 5) {
            throw new IllegalArgumentException("Was expecting an ASN.1 sequence of length 5 or longer");
        }
        try {
            Object object11 = object;
            object8 = object11;
            object7 = object11;
            object6 = object11;
            object5 = object11;
            object4 = object11;
            ((ASN1Integer)((ASN1Sequence)object11).getObjectAt(0)).getValue();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Exception", exception);
            throw new IllegalArgumentException("Could not get EC parameters from explicit parameters");
        }
        {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)((ASN1Sequence)object6).getObjectAt(1);
            aSN1Sequence = aSN1Sequence2;
            ((ASN1ObjectIdentifier)aSN1Sequence2.getObjectAt(0)).getId();
        }
        {
            object9 = ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getPositiveValue();
            ASN1Sequence aSN1Sequence3 = (ASN1Sequence)((ASN1Sequence)object5).getObjectAt(2);
            object3 = (ASN1OctetString)aSN1Sequence3.getObjectAt(0);
            object3 = Util.os2i(((ASN1OctetString)object3).getOctets());
            bigInteger = Util.os2i(((ASN1OctetString)aSN1Sequence3.getObjectAt(1)).getOctets());
            eCPoint = Util.os2ECPoint(((ASN1OctetString)((ASN1Sequence)object4).getObjectAt(3)).getOctets());
        }
        {
            object2 = eCPoint.getAffineX();
        }
        {
            eCPoint.getAffineY().pow(2).mod((BigInteger)object9);
        }
        {
            ((BigInteger)object2).pow(3).add(((BigInteger)object3).multiply((BigInteger)object2)).add(bigInteger).mod((BigInteger)object9);
        }
        object2 = ellipticCurve;
        {
            ellipticCurve = new EllipticCurve(new ECFieldFp((BigInteger)object9), (BigInteger)object3, bigInteger);
            object9 = ((ASN1Integer)((ASN1Sequence)object8).getObjectAt(4)).getPositiveValue();
            if (((ASN1Sequence)object7).size() <= 5) {
                return new ECParameterSpec((EllipticCurve)object2, eCPoint, (BigInteger)object9, 1);
            }
            object = ((ASN1Integer)((ASN1Sequence)object).getObjectAt(5)).getValue();
            int n = ((BigInteger)object).intValue();
            return new ECParameterSpec((EllipticCurve)object2, eCPoint, (BigInteger)object9, n);
        }
    }

    private static AlgorithmIdentifier toAlgorithmIdentifier(String object, ASN1Encodable aSN1Encodable) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        if (!"0.4.0.127.0.7.2.2.4.1".equals(object) && !"0.4.0.127.0.7.2.2.4.3".equals(object)) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier2;
            if (!("0.4.0.127.0.7.2.2.4.2".equals(object) || "0.4.0.127.0.7.2.2.4.4".equals(object) || "0.4.0.127.0.7.2.2.4.6".equals(object))) {
                throw new IllegalArgumentException(i.a("Cannot infer algorithm OID from protocol OID: ", (String)object));
            }
            object = aSN1ObjectIdentifier2;
            aSN1ObjectIdentifier2 = new ASN1ObjectIdentifier(ID_EC_PUBLIC_KEY);
            return new AlgorithmIdentifier((ASN1ObjectIdentifier)object, aSN1Encodable);
        }
        object = aSN1ObjectIdentifier;
        aSN1ObjectIdentifier = new ASN1ObjectIdentifier(ID_DH_PUBLIC_NUMBER);
        return new AlgorithmIdentifier((ASN1ObjectIdentifier)object, aSN1Encodable);
    }

    private static String toProtocolOIDString(String string2) {
        if ("0.4.0.127.0.7.2.2.4.1".equals(string2)) {
            return "id-PACE-DH-GM";
        }
        if ("0.4.0.127.0.7.2.2.4.2".equals(string2)) {
            return "id-PACE-ECDH-GM";
        }
        if ("0.4.0.127.0.7.2.2.4.3".equals(string2)) {
            return "id-PACE-DH-IM";
        }
        if ("0.4.0.127.0.7.2.2.4.4".equals(string2)) {
            return "id-PACE-ECDH-IM";
        }
        if ("0.4.0.127.0.7.2.2.4.6".equals(string2)) {
            return "id-PACE-ECDH-CAM";
        }
        return string2;
    }

    @Override
    public String getObjectIdentifier() {
        return this.oid;
    }

    @Override
    public String getProtocolOIDString() {
        return PACEDomainParameterInfo.toProtocolOIDString(this.oid);
    }

    public BigInteger getParameterId() {
        return this.parameterId;
    }

    public AlgorithmParameterSpec getParameters() {
        if (!ID_DH_PUBLIC_NUMBER.equals(this.oid)) {
            if (ID_EC_PUBLIC_KEY.equals(this.oid)) {
                return PACEDomainParameterInfo.toECParameterSpec(this.domainParameter);
            }
            throw new IllegalStateException(a.a("Unsupported PACEDomainParameterInfo type ").append(this.oid).toString());
        }
        throw new IllegalStateException("DH PACEDomainParameterInfo not yet implemented");
    }

    @Override
    @Deprecated
    public ASN1Primitive getDERObject() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2;
        ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector3();
        aSN1EncodableVector3.add(new ASN1ObjectIdentifier(serializable.oid));
        aSN1EncodableVector.add(serializable.domainParameter);
        Serializable serializable = serializable.parameterId;
        if (serializable != null) {
            ASN1Integer aSN1Integer;
            ASN1Integer aSN1Integer2 = aSN1Integer;
            aSN1Integer = new ASN1Integer((BigInteger)serializable);
            aSN1EncodableVector2.add(aSN1Integer2);
        }
        return new DLSequence(aSN1EncodableVector2);
    }

    public String toString() {
        StringBuilder stringBuilder = a.a("PACEDomainParameterInfo[protocol: ").append(PACEDomainParameterInfo.toProtocolOIDString(((PACEDomainParameterInfo)((Object)string2)).oid)).append(", domainParameter: [algorithm: ").append(((PACEDomainParameterInfo)((Object)string2)).domainParameter.getAlgorithm().getId()).append(", parameters: ").append(((PACEDomainParameterInfo)((Object)string2)).domainParameter.getParameters());
        String string2 = ((PACEDomainParameterInfo)((Object)string2)).parameterId == null ? "" : a.a(", parameterId: ").append(((PACEDomainParameterInfo)((Object)string2)).parameterId).toString();
        return d.a.a(stringBuilder, string2, "]");
    }

    public int hashCode() {
        PACEDomainParameterInfo pACEDomainParameterInfo = this;
        int n = pACEDomainParameterInfo.oid.hashCode() * 7 + 111111111;
        n = pACEDomainParameterInfo.domainParameter.hashCode() * 5 + n;
        int n2 = 3;
        BigInteger bigInteger = pACEDomainParameterInfo.parameterId;
        return (bigInteger == null ? 333 : bigInteger.hashCode()) * n2 + n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == pACEDomainParameterInfo2) {
            return true;
        }
        if (!PACEDomainParameterInfo.class.equals(object.getClass())) {
            return false;
        }
        PACEDomainParameterInfo pACEDomainParameterInfo = pACEDomainParameterInfo2;
        PACEDomainParameterInfo pACEDomainParameterInfo2 = (PACEDomainParameterInfo)object;
        return pACEDomainParameterInfo.getDERObject().equals(pACEDomainParameterInfo2.getDERObject());
    }
}

