/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLSequence;
import com.fis.ekyc.nfc.build_in.eidparser.lds.SecurityInfo;
import java.util.logging.Logger;

public class TerminalAuthenticationInfo
extends SecurityInfo {
    private static final long serialVersionUID = 6220506985707094044L;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd.lds");
    public static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private String oid;
    private int version;
    private transient ASN1Sequence efCVCA;

    public TerminalAuthenticationInfo(String string2, int n, ASN1Sequence aSN1Sequence) {
        TerminalAuthenticationInfo terminalAuthenticationInfo = this;
        terminalAuthenticationInfo.oid = string2;
        terminalAuthenticationInfo.version = n;
        terminalAuthenticationInfo.efCVCA = aSN1Sequence;
        terminalAuthenticationInfo.checkFields();
    }

    public TerminalAuthenticationInfo(String string2, int n) {
        this(string2, n, null);
    }

    public TerminalAuthenticationInfo() {
        this(SecurityInfo.ID_TA, 1);
    }

    public TerminalAuthenticationInfo(short s, byte by) {
        TerminalAuthenticationInfo terminalAuthenticationInfo = string2;
        String string2 = SecurityInfo.ID_TA;
        ASN1Sequence aSN1Sequence = TerminalAuthenticationInfo.constructEFCVCA(s, by);
        terminalAuthenticationInfo(string2, 1, aSN1Sequence);
    }

    public static boolean checkRequiredIdentifier(String string2) {
        return SecurityInfo.ID_TA.equals(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkFields() {
        try {
            ASN1Sequence aSN1Sequence;
            if (!TerminalAuthenticationInfo.checkRequiredIdentifier(this.oid)) throw new IllegalArgumentException("Wrong identifier: " + this.oid);
            int n = this.version;
            if (n != 1 && n != 2) {
                LOGGER.warning("Wrong version. Was expecting 1 or 2, found " + this.version);
            }
            if ((aSN1Sequence = this.efCVCA) == null) return;
            if (((ASN1OctetString)aSN1Sequence.getObjectAt(0)).getOctets().length != 2) throw new IllegalArgumentException("Malformed FID.");
            if (this.efCVCA.size() != 2) return;
            if (((ASN1OctetString)this.efCVCA.getObjectAt(1)).getOctets().length != 1) throw new IllegalArgumentException("Malformed SFI.");
            return;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Malformed TerminalAuthenticationInfo", exception);
        }
    }

    private static ASN1Sequence constructEFCVCA(short s, byte by) {
        DEROctetString dEROctetString;
        if (by != -1) {
            DEROctetString dEROctetString2;
            DEROctetString dEROctetString3;
            ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[2];
            DEROctetString dEROctetString4 = dEROctetString3;
            dEROctetString3 = new DEROctetString(new byte[]{(byte)((s & 0xFF00) >> 8), (byte)(s & 0xFF)});
            aSN1EncodableArray[0] = dEROctetString4;
            DEROctetString dEROctetString5 = dEROctetString2;
            dEROctetString2 = new DEROctetString(new byte[]{(byte)(by & 0xFF)});
            aSN1EncodableArray[1] = dEROctetString5;
            return new DLSequence(aSN1EncodableArray);
        }
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[1];
        DEROctetString dEROctetString6 = dEROctetString;
        dEROctetString = new DEROctetString(new byte[]{(byte)((s & 0xFF00) >> 8), (byte)(s & 0xFF)});
        aSN1EncodableArray[0] = dEROctetString6;
        return new DLSequence(aSN1EncodableArray);
    }

    private static short getFID(ASN1Sequence object) {
        if (object == null) {
            return -1;
        }
        byte[] byArray = ((ASN1OctetString)((ASN1Sequence)object).getObjectAt(0)).getOctets();
        object = byArray;
        return (short)((byArray[0] & 0xFF) << 8 | object[1] & 0xFF);
    }

    private static byte getSFI(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence == null) {
            return -1;
        }
        if (aSN1Sequence.size() != 2) {
            return -1;
        }
        return ((ASN1OctetString)aSN1Sequence.getObjectAt(1)).getOctets()[0];
    }

    private String toProtocolOIDString(String string2) {
        if (SecurityInfo.ID_TA.equals(string2)) {
            return "id-TA";
        }
        if (SecurityInfo.ID_TA_RSA.equals(string2)) {
            return "id-TA-RSA";
        }
        if (SecurityInfo.ID_TA_RSA_V1_5_SHA_1.equals(string2)) {
            return "id-TA-RSA-v1-5-SHA-1";
        }
        if (SecurityInfo.ID_TA_RSA_V1_5_SHA_256.equals(string2)) {
            return "id-TA-RSA-v1-5-SHA-256";
        }
        if (SecurityInfo.ID_TA_RSA_PSS_SHA_1.equals(string2)) {
            return "id-TA-RSA-PSS-SHA-1";
        }
        if (SecurityInfo.ID_TA_RSA_PSS_SHA_256.equals(string2)) {
            return "id-TA-RSA-PSS-SHA-256";
        }
        if (SecurityInfo.ID_TA_ECDSA.equals(string2)) {
            return "id-TA-ECDSA";
        }
        if (SecurityInfo.ID_TA_ECDSA_SHA_1.equals(string2)) {
            return "id-TA-ECDSA-SHA-1";
        }
        if (SecurityInfo.ID_TA_ECDSA_SHA_224.equals(string2)) {
            return "id-TA-ECDSA-SHA-224";
        }
        if (SecurityInfo.ID_TA_ECDSA_SHA_256.equals(string2)) {
            return "id-TA-ECDSA-SHA-256";
        }
        return string2;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    @Deprecated
    public ASN1Primitive getDERObject() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        new ASN1EncodableVector().add(new ASN1ObjectIdentifier(((TerminalAuthenticationInfo)((Object)aSN1Sequence)).oid));
        aSN1EncodableVector2.add(new ASN1Integer(((TerminalAuthenticationInfo)((Object)aSN1Sequence)).version));
        ASN1Sequence aSN1Sequence = ((TerminalAuthenticationInfo)((Object)aSN1Sequence)).efCVCA;
        if (aSN1Sequence != null) {
            aSN1EncodableVector2.add(aSN1Sequence);
        }
        return new DLSequence(aSN1EncodableVector2);
    }

    @Override
    public String getObjectIdentifier() {
        return this.oid;
    }

    @Override
    public String getProtocolOIDString() {
        TerminalAuthenticationInfo terminalAuthenticationInfo = this;
        return terminalAuthenticationInfo.toProtocolOIDString(terminalAuthenticationInfo.oid);
    }

    public int getFileId() {
        return TerminalAuthenticationInfo.getFID(this.efCVCA);
    }

    public byte getShortFileId() {
        return TerminalAuthenticationInfo.getSFI(this.efCVCA);
    }

    public String toString() {
        TerminalAuthenticationInfo terminalAuthenticationInfo = this;
        return a.a("TerminalAuthenticationInfo [protocol: ").append(terminalAuthenticationInfo.toProtocolOIDString(terminalAuthenticationInfo.oid)).append(", version: ").append(this.version).append(", fileID: ").append(this.getFileId()).append(", shortFileID: ").append(this.getShortFileId()).append("]").toString();
    }

    public int hashCode() {
        int n = 123;
        int n2 = 7;
        String string2 = this.oid;
        n2 = (string2 == null ? 0 : string2.hashCode()) * n2;
        TerminalAuthenticationInfo terminalAuthenticationInfo = this;
        int n3 = n2 + n;
        n3 = terminalAuthenticationInfo.version * 5 + n3;
        n = 3;
        ASN1Sequence aSN1Sequence = terminalAuthenticationInfo.efCVCA;
        return (aSN1Sequence == null ? 1 : aSN1Sequence.hashCode()) * n + n3;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!TerminalAuthenticationInfo.class.equals(object.getClass())) {
            return false;
        }
        object = (TerminalAuthenticationInfo)object;
        ASN1Sequence aSN1Sequence = this.efCVCA;
        if (aSN1Sequence == null && ((TerminalAuthenticationInfo)object).efCVCA != null) {
            return false;
        }
        if (aSN1Sequence != null && ((TerminalAuthenticationInfo)object).efCVCA == null) {
            return false;
        }
        return this.getDERObject().equals(((TerminalAuthenticationInfo)object).getDERObject());
    }
}

