/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.icao;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.eidparser.lds.AbstractLDSInfo;
import com.fis.ekyc.nfc.build_in.scuba.data.Gender;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class MRZInfo
extends AbstractLDSInfo {
    private static final long serialVersionUID = 7054965914471297804L;
    public static final int DOC_TYPE_UNSPECIFIED = 0;
    public static final int DOC_TYPE_ID1 = 1;
    public static final int DOC_TYPE_ID2 = 2;
    public static final int DOC_TYPE_ID3 = 3;
    private static final String MRZ_CHARS = "<0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private DocumentType documentType;
    private String documentCode;
    private String issuingState;
    private String primaryIdentifier;
    private String secondaryIdentifier;
    private String nationality;
    private String documentNumber;
    private String dateOfBirth;
    private Gender gender;
    private String dateOfExpiry;
    private char documentNumberCheckDigit;
    private char dateOfBirthCheckDigit;
    private char dateOfExpiryCheckDigit;
    private char compositeCheckDigit;
    private String optionalData1;
    private String optionalData2;

    public static MRZInfo createTD1MRZInfo(String string2, String string3, String string4, String string5, String string6, Gender gender, String string7, String string8, String string9, String string10, String string11) {
        return new MRZInfo(DocumentType.TD1, string2, string3, string4, string5, string6, gender, string7, string8, string9, string10, string11);
    }

    public static MRZInfo createTD2MRZInfo(String string2, String string3, String string4, String string5, String string6, String string7, String string8, Gender gender, String string9, String string10) {
        return new MRZInfo(DocumentType.TD2, string2, string3, string6, string10, string8, gender, string9, string7, null, string4, string5);
    }

    public static MRZInfo createTD3MRZInfo(String string2, String string3, String string4, String string5, String string6, String string7, String string8, Gender gender, String string9, String object) {
        String string10 = object;
        object = DocumentType.TD3;
        String string11 = MRZInfo.personalNumberToOptionalData(string10);
        return new MRZInfo((DocumentType)((Object)object), string2, string3, string6, string11, string8, gender, string9, string7, null, string4, string5);
    }

    public static MRZInfo createMRVAMRZInfo(String string2, String string3, String string4, String string5, String string6, String string7, String string8, Gender gender, String string9, String string10) {
        return new MRZInfo(DocumentType.MRVA, string2, string3, string6, string10, string8, gender, string9, string7, null, string4, string5);
    }

    public static MRZInfo createMRVBMRZInfo(String string2, String string3, String string4, String string5, String string6, String string7, String string8, Gender gender, String string9, String string10) {
        return new MRZInfo(DocumentType.MRVB, string2, string3, string6, string10, string8, gender, string9, string7, null, string4, string5);
    }

    @Deprecated
    public MRZInfo(String string2, String string3, String string4, String string5, String string6, String string7, String string8, Gender gender, String string9, String string10) {
        MRZInfo mRZInfo = object;
        Object object = MRZInfo.getDocumentTypeFromDocumentCode(string2);
        string10 = MRZInfo.personalNumberToOptionalData(string10);
        mRZInfo((DocumentType)((Object)object), string2, string3, string6, string10, string8, gender, string9, string7, null, string4, string5);
    }

    @Deprecated
    public MRZInfo(String string2, String string3, String string4, String string5, String string6, Gender gender, String string7, String string8, String string9, String string10, String string11) {
        this(MRZInfo.getDocumentTypeFromDocumentCode(string2), string2, string3, string4, string5, string6, gender, string7, string8, string9, string10, string11);
    }

    public MRZInfo(InputStream inputStream, int n) {
        MRZInfo mRZInfo = this;
        try {
            mRZInfo.readObject(inputStream, n);
            return;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
    }

    public MRZInfo(String string2) {
        if (string2 != null) {
            ByteArrayInputStream byteArrayInputStream;
            string2 = string2.trim().replace("\n", "");
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
            try {
                byteArrayInputStream = new ByteArrayInputStream(string2.getBytes("UTF-8"));
                this.readObject(byteArrayInputStream2, string2.length());
                return;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Exception", iOException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalStateException("Exception", unsupportedEncodingException);
            }
        }
        throw new IllegalArgumentException("Null string");
    }

    private MRZInfo(DocumentType documentType, String string2, String string3, String string4, String string5, String string6, Gender gender, String string7, String string8, String string9, String string10, String string11) {
        this.documentType = documentType;
        if (MRZInfo.isDocumentCodeConsistentWithDocumentType(documentType, string2)) {
            if (MRZInfo.isOptionalDataConsistentWithDocumentType(documentType, string5, string9)) {
                if (gender != null) {
                    this.documentCode = MRZInfo.trimTrailingFillerChars(string2);
                    this.issuingState = string3;
                    this.primaryIdentifier = string10;
                    this.secondaryIdentifier = string11;
                    this.documentNumber = MRZInfo.trimTrailingFillerChars(string4);
                    this.nationality = string8;
                    this.dateOfBirth = string6;
                    this.gender = gender;
                    this.dateOfExpiry = string7;
                    if (string5 == null) {
                        string5 = "";
                    }
                    this.optionalData1 = string5;
                    this.optionalData2 = string9;
                    this.checkDigit();
                    return;
                }
                throw new IllegalArgumentException("Gender must not be null");
            }
            throw new IllegalArgumentException("Wrong optional data length");
        }
        throw new IllegalArgumentException("Wrong document code");
    }

    public static char checkDigit(String string2) {
        return MRZInfo.checkDigit(string2, false);
    }

    private void readObject(InputStream inputStream, int n) {
        DocumentType documentType;
        Object object;
        if (inputStream instanceof DataInputStream) {
            inputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream;
            object = dataInputStream;
            dataInputStream = new DataInputStream(inputStream);
            inputStream = object;
        }
        this.documentCode = object = MRZInfo.trimTrailingFillerChars(this.readString((DataInputStream)inputStream, 2));
        this.documentType = documentType = MRZInfo.getDocumentType((String)object, n);
        int n2 = 1.$SwitchMap$com$fis$ekyc$nfc$build_in$eidparser$lds$icao$MRZInfo$DocumentType[documentType.ordinal()];
        if (n2 != 1) {
            if (n2 != 2 && n2 != 3) {
                this.readObjectTD3OrMRVA(inputStream);
            } else {
                this.readObjectTD2orMRVB(inputStream);
            }
        } else {
            this.readObjectTD1(inputStream);
        }
    }

    private void readObjectTD1(InputStream inputStream) {
        Object object;
        if (inputStream instanceof DataInputStream) {
            inputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream;
            object = dataInputStream;
            dataInputStream = new DataInputStream(inputStream);
            inputStream = object;
        }
        MRZInfo mRZInfo = this;
        this.issuingState = this.readCountry((DataInputStream)inputStream);
        this.documentNumber = this.readString((DataInputStream)inputStream, 9);
        this.documentNumberCheckDigit = (char)((DataInputStream)inputStream).readUnsignedByte();
        object = MRZInfo.trimTrailingFillerChars(mRZInfo.readString((DataInputStream)inputStream, 15));
        mRZInfo.optionalData1 = object;
        if (mRZInfo.documentNumberCheckDigit == '<' && !((String)object).isEmpty()) {
            String string2 = this.optionalData1;
            this.documentNumber = this.documentNumber + string2.substring(0, string2.length() - 1);
            String string3 = this.optionalData1;
            this.documentNumberCheckDigit = string3.charAt(string3.length() - 1);
            this.optionalData1 = "";
        }
        MRZInfo mRZInfo2 = this;
        this.documentNumber = MRZInfo.trimTrailingFillerChars(this.documentNumber);
        this.dateOfBirth = this.readDateOfBirth((DataInputStream)inputStream);
        this.dateOfBirthCheckDigit = (char)((DataInputStream)inputStream).readUnsignedByte();
        this.gender = this.readGender((DataInputStream)inputStream);
        this.dateOfExpiry = this.readDateOfExpiry((DataInputStream)inputStream);
        this.dateOfExpiryCheckDigit = (char)((DataInputStream)inputStream).readUnsignedByte();
        this.nationality = this.readCountry((DataInputStream)inputStream);
        this.optionalData2 = this.readString((DataInputStream)inputStream, 11);
        this.compositeCheckDigit = (char)((DataInputStream)inputStream).readUnsignedByte();
        mRZInfo2.readNameIdentifiers(mRZInfo2.readString((DataInputStream)inputStream, 30));
    }

    private void readObjectTD2orMRVB(InputStream inputStream) {
        Object object;
        if (inputStream instanceof DataInputStream) {
            inputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream;
            object = dataInputStream;
            dataInputStream = new DataInputStream(inputStream);
            inputStream = object;
        }
        MRZInfo mRZInfo = this;
        MRZInfo mRZInfo2 = this;
        this.issuingState = this.readCountry((DataInputStream)inputStream);
        mRZInfo2.readNameIdentifiers(mRZInfo2.readString((DataInputStream)inputStream, 31));
        this.documentNumber = MRZInfo.trimTrailingFillerChars(this.readString((DataInputStream)inputStream, 9));
        this.documentNumberCheckDigit = (char)((DataInputStream)inputStream).readUnsignedByte();
        this.nationality = this.readCountry((DataInputStream)inputStream);
        this.dateOfBirth = this.readDateOfBirth((DataInputStream)inputStream);
        this.dateOfBirthCheckDigit = (char)((DataInputStream)inputStream).readUnsignedByte();
        this.gender = this.readGender((DataInputStream)inputStream);
        this.dateOfExpiry = this.readDateOfExpiry((DataInputStream)inputStream);
        this.dateOfExpiryCheckDigit = (char)((DataInputStream)inputStream).readUnsignedByte();
        object = MRZInfo.trimTrailingFillerChars(mRZInfo.readString((DataInputStream)inputStream, 7));
        mRZInfo.optionalData1 = object;
        if (mRZInfo.documentType == DocumentType.TD2 && this.documentNumberCheckDigit == '<' && !((String)object).isEmpty()) {
            String string2 = this.optionalData1;
            this.documentNumber = this.documentNumber + string2.substring(0, string2.length() - 1);
            String string3 = this.optionalData1;
            this.documentNumberCheckDigit = string3.charAt(string3.length() - 1);
            this.optionalData1 = "";
        }
        this.documentNumber = MRZInfo.trimTrailingFillerChars(this.documentNumber);
        this.compositeCheckDigit = (char)((DataInputStream)inputStream).readUnsignedByte();
    }

    private void readObjectTD3OrMRVA(InputStream inputStream) {
        if (inputStream instanceof DataInputStream) {
            inputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream;
            DataInputStream dataInputStream2 = dataInputStream;
            dataInputStream = new DataInputStream(inputStream);
            inputStream = dataInputStream2;
        }
        MRZInfo mRZInfo = this;
        this.issuingState = this.readCountry((DataInputStream)inputStream);
        mRZInfo.readNameIdentifiers(mRZInfo.readString((DataInputStream)inputStream, 39));
        this.documentNumber = MRZInfo.trimTrailingFillerChars(this.readString((DataInputStream)inputStream, 9));
        this.documentNumberCheckDigit = (char)((DataInputStream)inputStream).readUnsignedByte();
        this.nationality = this.readCountry((DataInputStream)inputStream);
        this.dateOfBirth = this.readDateOfBirth((DataInputStream)inputStream);
        this.dateOfBirthCheckDigit = (char)((DataInputStream)inputStream).readUnsignedByte();
        this.gender = this.readGender((DataInputStream)inputStream);
        this.dateOfExpiry = this.readDateOfExpiry((DataInputStream)inputStream);
        this.dateOfExpiryCheckDigit = (char)((DataInputStream)inputStream).readUnsignedByte();
        this.optionalData1 = MRZInfo.trimTrailingFillerChars(this.readString((DataInputStream)inputStream, 15));
        this.compositeCheckDigit = (char)((DataInputStream)inputStream).readUnsignedByte();
    }

    private void writeObjectTD1(OutputStream outputStream) {
        if (outputStream instanceof DataOutputStream) {
            outputStream = (DataOutputStream)outputStream;
        } else {
            DataOutputStream dataOutputStream;
            DataOutputStream dataOutputStream2 = dataOutputStream;
            dataOutputStream = new DataOutputStream(outputStream);
            outputStream = dataOutputStream2;
        }
        MRZInfo mRZInfo = this;
        this.writeDocumentType((DataOutputStream)outputStream);
        mRZInfo.writeIssuingState((DataOutputStream)outputStream);
        if (mRZInfo.documentNumber.length() > 9 && MRZInfo.equalsModuloFillerChars(this.optionalData1, "")) {
            MRZInfo mRZInfo2 = this;
            mRZInfo2.writeString(mRZInfo2.documentNumber.substring(0, 9), (DataOutputStream)outputStream, 9);
            ((DataOutputStream)outputStream).write(60);
            String string2 = this.documentNumber;
            this.writeString(string2.substring(9, string2.length()) + this.documentNumberCheckDigit + "<", (DataOutputStream)outputStream, 15);
        } else {
            MRZInfo mRZInfo3 = this;
            MRZInfo mRZInfo4 = this;
            mRZInfo4.writeString(mRZInfo4.documentNumber, (DataOutputStream)outputStream, 9);
            ((DataOutputStream)outputStream).write(mRZInfo4.documentNumberCheckDigit);
            mRZInfo3.writeString(mRZInfo3.optionalData1, (DataOutputStream)outputStream, 15);
        }
        OutputStream outputStream2 = outputStream;
        MRZInfo mRZInfo5 = this;
        OutputStream outputStream3 = outputStream;
        MRZInfo mRZInfo6 = this;
        OutputStream outputStream4 = outputStream;
        MRZInfo mRZInfo7 = this;
        mRZInfo7.writeDateOfBirth((DataOutputStream)outputStream);
        ((DataOutputStream)outputStream4).write(mRZInfo7.dateOfBirthCheckDigit);
        this.writeGender((DataOutputStream)outputStream4);
        mRZInfo6.writeDateOfExpiry((DataOutputStream)outputStream);
        ((DataOutputStream)outputStream3).write(mRZInfo6.dateOfExpiryCheckDigit);
        mRZInfo5.writeNationality((DataOutputStream)outputStream3);
        mRZInfo5.writeString(mRZInfo5.optionalData2, (DataOutputStream)outputStream, 11);
        ((DataOutputStream)outputStream2).write(mRZInfo5.compositeCheckDigit);
        this.writeName((DataOutputStream)outputStream2, 30);
    }

    private void writeObjectTD2OrMRVB(OutputStream outputStream) {
        if (outputStream instanceof DataOutputStream) {
            outputStream = (DataOutputStream)outputStream;
        } else {
            DataOutputStream dataOutputStream;
            DataOutputStream dataOutputStream2 = dataOutputStream;
            dataOutputStream = new DataOutputStream(outputStream);
            outputStream = dataOutputStream2;
        }
        MRZInfo mRZInfo = this;
        this.writeDocumentType((DataOutputStream)outputStream);
        this.writeIssuingState((DataOutputStream)outputStream);
        mRZInfo.writeName((DataOutputStream)outputStream, 31);
        boolean bl = mRZInfo.documentType == DocumentType.TD2 && this.documentNumber.length() > 9 && MRZInfo.equalsModuloFillerChars(this.optionalData1, "");
        if (bl) {
            MRZInfo mRZInfo2 = this;
            mRZInfo2.writeString(mRZInfo2.documentNumber.substring(0, 9), (DataOutputStream)outputStream, 9);
            ((DataOutputStream)outputStream).write(60);
        } else {
            MRZInfo mRZInfo3 = this;
            mRZInfo3.writeString(mRZInfo3.documentNumber, (DataOutputStream)outputStream, 9);
            ((DataOutputStream)outputStream).write(mRZInfo3.documentNumberCheckDigit);
        }
        MRZInfo mRZInfo4 = this;
        OutputStream outputStream2 = outputStream;
        MRZInfo mRZInfo5 = this;
        this.writeNationality((DataOutputStream)outputStream);
        mRZInfo5.writeDateOfBirth((DataOutputStream)outputStream);
        ((DataOutputStream)outputStream2).write(mRZInfo5.dateOfBirthCheckDigit);
        this.writeGender((DataOutputStream)outputStream2);
        mRZInfo4.writeDateOfExpiry((DataOutputStream)outputStream);
        ((DataOutputStream)outputStream).write(mRZInfo4.dateOfExpiryCheckDigit);
        if (this.documentType == DocumentType.MRVB) {
            MRZInfo mRZInfo6 = this;
            mRZInfo6.writeString(mRZInfo6.optionalData1, (DataOutputStream)outputStream, 8);
        } else if (bl) {
            MRZInfo mRZInfo7 = this;
            String string2 = this.documentNumber;
            mRZInfo7.writeString(string2.substring(9, string2.length()) + this.documentNumberCheckDigit + "<", (DataOutputStream)outputStream, 7);
            ((DataOutputStream)outputStream).write(mRZInfo7.compositeCheckDigit);
        } else {
            MRZInfo mRZInfo8 = this;
            mRZInfo8.writeString(mRZInfo8.optionalData1, (DataOutputStream)outputStream, 7);
            ((DataOutputStream)outputStream).write(mRZInfo8.compositeCheckDigit);
        }
    }

    private void writeObjectTD3OrMRVA(OutputStream outputStream) {
        if (outputStream instanceof DataOutputStream) {
            outputStream = (DataOutputStream)outputStream;
        } else {
            DataOutputStream dataOutputStream;
            DataOutputStream dataOutputStream2 = dataOutputStream;
            dataOutputStream = new DataOutputStream(outputStream);
            outputStream = dataOutputStream2;
        }
        MRZInfo mRZInfo = this;
        OutputStream outputStream2 = outputStream;
        MRZInfo mRZInfo2 = this;
        OutputStream outputStream3 = outputStream;
        MRZInfo mRZInfo3 = this;
        this.writeDocumentType((DataOutputStream)outputStream);
        this.writeIssuingState((DataOutputStream)outputStream);
        mRZInfo3.writeName((DataOutputStream)outputStream, 39);
        mRZInfo3.writeString(mRZInfo3.documentNumber, (DataOutputStream)outputStream, 9);
        ((DataOutputStream)outputStream3).write(mRZInfo3.documentNumberCheckDigit);
        this.writeNationality((DataOutputStream)outputStream3);
        mRZInfo2.writeDateOfBirth((DataOutputStream)outputStream);
        ((DataOutputStream)outputStream2).write(mRZInfo2.dateOfBirthCheckDigit);
        this.writeGender((DataOutputStream)outputStream2);
        mRZInfo.writeDateOfExpiry((DataOutputStream)outputStream);
        ((DataOutputStream)outputStream).write(mRZInfo.dateOfExpiryCheckDigit);
        if (this.documentType == DocumentType.MRVA) {
            MRZInfo mRZInfo4 = this;
            mRZInfo4.writeString(mRZInfo4.optionalData1, (DataOutputStream)outputStream, 16);
        } else {
            MRZInfo mRZInfo5 = this;
            mRZInfo5.writeString(mRZInfo5.optionalData1, (DataOutputStream)outputStream, 15);
            ((DataOutputStream)outputStream).write(mRZInfo5.compositeCheckDigit);
        }
    }

    private void readNameIdentifiers(String string2) {
        int n = string2.indexOf("<<");
        if (n < 0) {
            MRZInfo mRZInfo = this;
            mRZInfo.primaryIdentifier = MRZInfo.trimTrailingFillerChars(string2).replace("<", " ");
            mRZInfo.secondaryIdentifier = "";
        } else {
            this.primaryIdentifier = MRZInfo.trimTrailingFillerChars(string2.substring(0, n));
            this.readSecondaryIdentifiers(string2.substring(n + 2));
        }
    }

    private void readSecondaryIdentifiers(String string2) {
        this.secondaryIdentifier = MRZInfo.trimTrailingFillerChars(string2).replace("<", " ");
    }

    private void writeString(String string2, DataOutputStream dataOutputStream, int n) {
        ((OutputStream)dataOutputStream).write(MRZInfo.mrzFormat(string2, n).getBytes("UTF-8"));
    }

    private void writeIssuingState(DataOutputStream dataOutputStream) {
        ((OutputStream)dataOutputStream).write(this.issuingState.getBytes("UTF-8"));
    }

    private void writeDateOfExpiry(DataOutputStream dataOutputStream) {
        ((OutputStream)dataOutputStream).write(this.dateOfExpiry.getBytes("UTF-8"));
    }

    private void writeGender(DataOutputStream dataOutputStream) {
        ((OutputStream)dataOutputStream).write(MRZInfo.genderToString(this.gender).getBytes("UTF-8"));
    }

    private void writeDateOfBirth(DataOutputStream dataOutputStream) {
        ((OutputStream)dataOutputStream).write(this.dateOfBirth.getBytes("UTF-8"));
    }

    private void writeNationality(DataOutputStream dataOutputStream) {
        ((OutputStream)dataOutputStream).write(this.nationality.getBytes("UTF-8"));
    }

    private void writeName(DataOutputStream dataOutputStream, int n) {
        ((OutputStream)dataOutputStream).write(MRZInfo.nameToString(this.primaryIdentifier, this.secondaryIdentifier, n).getBytes("UTF-8"));
    }

    private void writeDocumentType(DataOutputStream dataOutputStream) {
        MRZInfo mRZInfo = this;
        mRZInfo.writeString(mRZInfo.documentCode, dataOutputStream, 2);
    }

    private static String genderToString(Gender gender) {
        int n = 1.$SwitchMap$com$fis$ekyc$nfc$build_in$scuba$data$Gender[gender.ordinal()];
        if (n != 1) {
            if (n != 2) {
                return "<";
            }
            return "F";
        }
        return "M";
    }

    private static String personalNumberToOptionalData(String string2) {
        if (string2 != null && !MRZInfo.equalsModuloFillerChars(string2, "")) {
            if (string2.length() == 15) {
                return string2;
            }
            if (string2.length() <= 14) {
                return MRZInfo.mrzFormat(string2, 14) + MRZInfo.checkDigit(string2, true);
            }
            throw new IllegalArgumentException(i.a("Wrong personal number: ", string2));
        }
        return "";
    }

    private static String nameToString(String stringArray, String string2, int n) {
        StringBuilder stringBuilder;
        stringArray = stringArray.split(" |<");
        String[] stringArray2 = string2 != null && !string2.trim().isEmpty() ? string2.split(" |<") : new String[]{};
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n2 = 1;
        for (String string3 : stringArray) {
            if (n2 != 0) {
                n2 = 0;
            } else {
                stringBuilder2.append('<');
            }
            stringBuilder2.append(string3);
        }
        if (string2 != null && !string2.trim().isEmpty()) {
            stringBuilder2.append("<<");
            boolean bl = true;
            for (String string4 : stringArray2) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder2.append('<');
                }
                stringBuilder2.append(string4);
            }
        }
        return MRZInfo.mrzFormat(stringBuilder2.toString(), n);
    }

    private String readCountry(DataInputStream dataInputStream) {
        return this.readString(dataInputStream, 3);
    }

    private Gender readGender(DataInputStream dataInputStream) {
        if ("M".equalsIgnoreCase((String)(this = ((MRZInfo)this).readString(dataInputStream, 1)))) {
            return Gender.MALE;
        }
        return "F".equalsIgnoreCase((String)this) ? Gender.FEMALE : Gender.UNKNOWN;
    }

    private String readDateOfBirth(DataInputStream dataInputStream) {
        return this.readString(dataInputStream, 6);
    }

    private String readDateOfExpiry(DataInputStream dataInputStream) {
        return this.readString(dataInputStream, 6);
    }

    private String readString(DataInputStream dataInputStream, int n) {
        byte[] byArray = new byte[n];
        Object object = byArray;
        dataInputStream.readFully(byArray);
        return new String((byte[])object).trim();
    }

    private String getComposite(DocumentType object) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n = this.documentNumber.length();
        switch (1.$SwitchMap$com$fis$ekyc$nfc$build_in$eidparser$lds$icao$MRZInfo$DocumentType[((Enum)object).ordinal()]) {
            default: {
                throw new IllegalStateException("Unsupported document type");
            }
            case 4: 
            case 5: {
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder2.append(this.documentNumber);
                stringBuilder2.append(this.documentNumberCheckDigit);
                stringBuilder2.append(this.dateOfBirth);
                stringBuilder2.append(this.dateOfBirthCheckDigit);
                stringBuilder2.append(this.dateOfExpiry);
                stringBuilder2.append(this.dateOfExpiryCheckDigit);
                stringBuilder3.append(MRZInfo.mrzFormat(this.optionalData1, 15));
                return stringBuilder3.toString();
            }
            case 2: 
            case 3: {
                StringBuilder stringBuilder4 = stringBuilder2;
                stringBuilder2.append(this.documentNumber);
                stringBuilder2.append(this.documentNumberCheckDigit);
                stringBuilder2.append(this.dateOfBirth);
                stringBuilder2.append(this.dateOfBirthCheckDigit);
                stringBuilder2.append(this.dateOfExpiry);
                stringBuilder2.append(this.dateOfExpiryCheckDigit);
                stringBuilder4.append(MRZInfo.mrzFormat(this.optionalData1, 7));
                return stringBuilder4.toString();
            }
            case 1: 
        }
        if (n <= 9) {
            stringBuilder2.append(MRZInfo.mrzFormat(this.documentNumber, 9));
            stringBuilder2.append(this.documentNumberCheckDigit);
            stringBuilder2.append(MRZInfo.mrzFormat(this.optionalData1, 15));
        } else {
            StringBuilder stringBuilder5 = stringBuilder2;
            stringBuilder5.append(this.documentNumber.substring(0, 9));
            stringBuilder5.append("<");
            object = this.documentNumber.substring(9);
            stringBuilder2.append((String)object);
            stringBuilder2.append(this.documentNumberCheckDigit);
            String string2 = MRZInfo.mrzFormat(this.optionalData1, 15).substring(((String)object).length() + 1);
            stringBuilder2.append(MRZInfo.mrzFormat(string2, string2.length()));
        }
        StringBuilder stringBuilder6 = stringBuilder2;
        stringBuilder2.append(this.dateOfBirth);
        stringBuilder2.append(this.dateOfBirthCheckDigit);
        stringBuilder2.append(this.dateOfExpiry);
        stringBuilder2.append(this.dateOfExpiryCheckDigit);
        stringBuilder6.append(MRZInfo.mrzFormat(this.optionalData2, 11));
        return stringBuilder6.toString();
    }

    private void checkDigit() {
        MRZInfo mRZInfo = this;
        mRZInfo.documentNumberCheckDigit = MRZInfo.checkDigit(mRZInfo.documentNumber);
        mRZInfo.dateOfBirthCheckDigit = MRZInfo.checkDigit(mRZInfo.dateOfBirth);
        mRZInfo.dateOfExpiryCheckDigit = MRZInfo.checkDigit(mRZInfo.dateOfExpiry);
        if (mRZInfo.documentType == DocumentType.TD3 && this.optionalData1.length() < 15) {
            MRZInfo mRZInfo2 = this;
            String string2 = MRZInfo.mrzFormat(mRZInfo2.optionalData1, 14);
            mRZInfo2.optionalData1 = string2 + MRZInfo.checkDigit(MRZInfo.mrzFormat(mRZInfo2.optionalData1, 14), true);
        }
        MRZInfo mRZInfo3 = this;
        mRZInfo3.compositeCheckDigit = MRZInfo.checkDigit(mRZInfo3.getComposite(mRZInfo3.documentType));
    }

    private static String mrzFormat(String string2, int n) {
        if (string2 == null) {
            return "";
        }
        if (string2.length() <= n) {
            StringBuilder stringBuilder;
            string2 = string2.toUpperCase().trim();
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            for (int k = 0; k < string2.length(); ++k) {
                char c2 = string2.charAt(k);
                if (MRZ_CHARS.indexOf(c2) == -1) {
                    stringBuilder2.append('<');
                    continue;
                }
                stringBuilder2.append(c2);
            }
            while (stringBuilder2.length() < n) {
                stringBuilder2.append("<");
            }
            return stringBuilder2.toString();
        }
        throw new IllegalArgumentException(a.a("Argument too wide (").append(string2.length()).append(" > ").append(n).append(")").toString());
    }

    public static boolean equalsModuloFillerChars(String string2, String string3) {
        if (string2 == string3) {
            return true;
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        String string4 = string2;
        int n = Math.max(string4.length(), string3.length());
        return MRZInfo.mrzFormat(string4, n).equals(MRZInfo.mrzFormat(string3, n));
    }

    private static DocumentType getDocumentType(String string2, int n) {
        if (string2 != null && string2.length() >= 1 && string2.length() <= 2) {
            if (n != 72) {
                if (n != 88) {
                    if (n != 90) {
                        return DocumentType.UNKNOWN;
                    }
                    return DocumentType.TD1;
                }
                if (string2.startsWith("V")) {
                    return DocumentType.MRVA;
                }
                return DocumentType.TD3;
            }
            if (string2.startsWith("V")) {
                return DocumentType.MRVB;
            }
            return DocumentType.TD2;
        }
        throw new IllegalArgumentException(i.a("Was expecting 1 or 2 digit document code, got ", string2));
    }

    private static DocumentType getDocumentTypeFromDocumentCode(String string2) {
        if (!(string2.startsWith("A") || string2.startsWith("C") || string2.startsWith("I"))) {
            if (string2.startsWith("V")) {
                return DocumentType.MRVB;
            }
            return string2.startsWith("P") ? DocumentType.TD3 : DocumentType.UNKNOWN;
        }
        return DocumentType.TD1;
    }

    private static String trimTrailingFillerChars(String object) {
        object = ((String)object).trim().getBytes();
        for (int k = (v1059247).length - 1; k >= 0 && object[k] == 60; --k) {
            object[k] = 32;
        }
        return new String((byte[])object).trim();
    }

    private static boolean isDocumentCodeConsistentWithDocumentType(DocumentType documentType, String string2) {
        if (string2 == null) {
            return false;
        }
        if (string2.length() != 1 && string2.length() != 2) {
            return false;
        }
        switch (1.$SwitchMap$com$fis$ekyc$nfc$build_in$eidparser$lds$icao$MRZInfo$DocumentType[documentType.ordinal()]) {
            default: {
                return false;
            }
            case 5: {
                return string2.startsWith("P");
            }
            case 3: 
            case 4: {
                return string2.startsWith("V");
            }
            case 1: 
            case 2: 
        }
        return string2.startsWith("C") || string2.startsWith("I") || string2.startsWith("A");
    }

    private static boolean isOptionalDataConsistentWithDocumentType(DocumentType documentType, String string2, String string3) {
        switch (1.$SwitchMap$com$fis$ekyc$nfc$build_in$eidparser$lds$icao$MRZInfo$DocumentType[documentType.ordinal()]) {
            default: {
                return false;
            }
            case 5: {
                return (string2 == null || string2.length() <= 15) && string3 == null;
            }
            case 4: {
                return (string2 == null || string2.length() <= 16) && string3 == null;
            }
            case 3: {
                return (string2 == null || string2.length() <= 8) && string3 == null;
            }
            case 2: {
                return (string2 == null || string2.length() <= 7) && string3 == null;
            }
            case 1: 
        }
        return !(string2 != null && string2.length() > 15 || string3 != null && string3.length() > 11);
    }

    /*
     * Unable to fully structure code
     */
    private static char checkDigit(String var0, boolean var1_5) {
        block16: {
            block17: {
                if (var0 != null) break block17;
                v0 = new byte[]{};
lbl4:
                // 2 sources

                while (true) {
                    var0 = v0;
                    ** GOTO lbl11
                    break;
                }
            }
            v0 = var0.getBytes("UTF-8");
            ** continue;
lbl11:
            // 1 sources

            v1 = new int[3];
            var2_6 = v1;
            v1[0] = 7;
            v1[1] = 3;
            v1[2] = 1;
            var3_7 = 0;
            var4_8 = 0;
            while (true) {
                if (var4_8 >= ((Object)var0).length) break;
                v2 = var2_6[var4_8 % 3] * MRZInfo.decodeMRZDigit((byte)var0[var4_8]);
                var3_7 = (v2 + var3_7) % 10;
                ++var4_8;
                continue;
                break;
            }
            var0 = Integer.toString(var3_7);
            if (var0.length() != 1) break block16;
            var0_1 = var0.getBytes("UTF-8")[0];
            if (var1_5 && var0_1 == 48) {
                var0_1 = 60;
            }
            return (char)var0_1;
        }
        try {
            throw new IllegalStateException("Error in computing check digit.");
        }
        catch (Exception var0_2) {
            throw new IllegalArgumentException("Error in computing check digit", var0_2);
        }
        catch (UnsupportedEncodingException var0_3) {
            throw new IllegalStateException("Error in computing check digit", var0_3);
        }
        catch (NumberFormatException var0_4) {
            throw new IllegalStateException("Error in computing check digit", var0_4);
        }
    }

    /*
     * Exception decompiling
     */
    private static int decodeMRZDigit(byte var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CASE]], but top level block is 40[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public String getDateOfExpiry() {
        return this.dateOfExpiry;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    @Deprecated
    public int getDocumentType() {
        return this.documentType.getCode();
    }

    public String getDocumentCode() {
        return this.documentCode;
    }

    public String getIssuingState() {
        return this.issuingState;
    }

    public String getPrimaryIdentifier() {
        return this.primaryIdentifier;
    }

    public String getSecondaryIdentifier() {
        return this.secondaryIdentifier;
    }

    public String[] getSecondaryIdentifierComponents() {
        return this.secondaryIdentifier.split(" |<");
    }

    public String getNationality() {
        return this.nationality;
    }

    public String getPersonalNumber() {
        String string2 = this.optionalData1;
        if (string2 == null) {
            return null;
        }
        return string2.length() > 14 ? MRZInfo.trimTrailingFillerChars(this.optionalData1.substring(0, 14)) : MRZInfo.trimTrailingFillerChars(this.optionalData1);
    }

    public Gender getGender() {
        return this.gender;
    }

    public String getOptionalData1() {
        return this.optionalData1;
    }

    public String getOptionalData2() {
        return this.optionalData2;
    }

    @Deprecated
    public void setDocumentCode(String string2) {
        this.documentCode = string2;
        this.documentType = MRZInfo.getDocumentTypeFromDocumentCode(string2);
        if (this.documentType == DocumentType.TD1 && this.optionalData2 == null) {
            this.optionalData2 = "";
        }
    }

    @Deprecated
    public void setDocumentNumber(String string2) {
        this.documentNumber = string2.trim();
        this.checkDigit();
    }

    @Deprecated
    public void setPrimaryIdentifier(String string2) {
        this.primaryIdentifier = string2.trim();
        this.checkDigit();
    }

    @Deprecated
    public void setSecondaryIdentifierComponents(String[] stringArray) {
        if (stringArray == null) {
            this.secondaryIdentifier = null;
        } else {
            for (int k = 0; k < stringArray.length; ++k) {
                String cfr_ignored_0 = stringArray[k];
            }
        }
        this.checkDigit();
    }

    @Deprecated
    public void setSecondaryIdentifiers(String string2) {
        MRZInfo mRZInfo = this;
        mRZInfo.readSecondaryIdentifiers(string2.trim());
        mRZInfo.checkDigit();
    }

    @Deprecated
    public void setDateOfBirth(String string2) {
        this.dateOfBirth = string2;
        this.checkDigit();
    }

    @Deprecated
    public void setDateOfExpiry(String string2) {
        this.dateOfExpiry = string2;
        this.checkDigit();
    }

    @Deprecated
    public void setIssuingState(String string2) {
        this.issuingState = string2;
        this.checkDigit();
    }

    @Deprecated
    public void setPersonalNumber(String string2) {
        if (string2 != null && string2.length() <= 14) {
            this.optionalData1 = MRZInfo.mrzFormat(string2, 14) + MRZInfo.checkDigit(string2, true);
            return;
        }
        throw new IllegalArgumentException("Wrong personal number");
    }

    @Deprecated
    public void setNationality(String string2) {
        this.nationality = string2;
        this.checkDigit();
    }

    @Deprecated
    public void setOptionalData2(String string2) {
        this.optionalData2 = MRZInfo.trimTrailingFillerChars(string2);
        this.checkDigit();
    }

    @Deprecated
    public void setGender(Gender gender) {
        this.gender = gender;
        this.checkDigit();
    }

    public String toString() {
        String string2;
        block7: {
            block8: {
                block9: {
                    String string3;
                    string2 = string3;
                    try {
                        int n = new String(this.getEncoded(), "UTF-8").length();
                        if (n == 72) break block7;
                        if (n == 88) break block8;
                        if (n == 90) break block9;
                        return string2;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new IllegalStateException(unsupportedEncodingException);
                    }
                }
                return string2.substring(0, 30) + "\n" + string2.substring(30, 60) + "\n" + string2.substring(60, 90) + "\n";
            }
            return string2.substring(0, 44) + "\n" + string2.substring(44, 88) + "\n";
        }
        return string2.substring(0, 36) + "\n" + string2.substring(36, 72) + "\n";
    }

    public int hashCode() {
        return this.toString().hashCode() * 2 + 53;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        object = (MRZInfo)object;
        Object object2 = ((MRZInfo)this).documentCode;
        return (object2 == null && ((MRZInfo)object).documentCode == null || object2 != null && ((String)object2).equals(((MRZInfo)object).documentCode)) && ((object2 = ((MRZInfo)this).issuingState) == null && ((MRZInfo)object).issuingState == null || object2 != null && ((String)object2).equals(((MRZInfo)object).issuingState)) && ((object2 = ((MRZInfo)this).primaryIdentifier) == null && ((MRZInfo)object).primaryIdentifier == null || object2 != null && ((String)object2).equals(((MRZInfo)object).primaryIdentifier)) && ((object2 = ((MRZInfo)this).secondaryIdentifier) == null && ((MRZInfo)object).secondaryIdentifier == null || MRZInfo.equalsModuloFillerChars((String)object2, ((MRZInfo)object).secondaryIdentifier)) && ((object2 = ((MRZInfo)this).nationality) == null && ((MRZInfo)object).nationality == null || object2 != null && ((String)object2).equals(((MRZInfo)object).nationality)) && ((object2 = ((MRZInfo)this).documentNumber) == null && ((MRZInfo)object).documentNumber == null || object2 != null && ((String)object2).equals(((MRZInfo)object).documentNumber)) && ((object2 = ((MRZInfo)this).optionalData1) == null && ((MRZInfo)object).optionalData1 == null || object2 != null && ((String)object2).equals(((MRZInfo)object).optionalData1) || ((MRZInfo)this).getPersonalNumber().equals(((MRZInfo)object).getPersonalNumber())) && ((object2 = ((MRZInfo)this).dateOfBirth) == null && ((MRZInfo)object).dateOfBirth == null || object2 != null && ((String)object2).equals(((MRZInfo)object).dateOfBirth)) && ((object2 = ((MRZInfo)this).gender) == null && ((MRZInfo)object).gender == null || object2 != null && object2.equals((Object)((MRZInfo)object).gender)) && ((object2 = ((MRZInfo)this).dateOfExpiry) == null && ((MRZInfo)object).dateOfExpiry == null || object2 != null && ((String)object2).equals(((MRZInfo)object).dateOfExpiry)) && ((this = ((MRZInfo)this).optionalData2) == null && ((MRZInfo)object).optionalData2 == null || this != null && MRZInfo.equalsModuloFillerChars((String)this, ((MRZInfo)object).optionalData2));
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        switch (1.$SwitchMap$com$fis$ekyc$nfc$build_in$eidparser$lds$icao$MRZInfo$DocumentType[this.documentType.ordinal()]) {
            default: {
                throw new IllegalStateException("Unsupported document type ");
            }
            case 4: 
            case 5: {
                this.writeObjectTD3OrMRVA(outputStream);
                break;
            }
            case 2: 
            case 3: {
                this.writeObjectTD2OrMRVB(outputStream);
                break;
            }
            case 1: {
                this.writeObjectTD1(outputStream);
            }
        }
    }

    public static final class DocumentType
    extends Enum<DocumentType> {
        public static final /* enum */ DocumentType UNKNOWN;
        public static final /* enum */ DocumentType TD1;
        public static final /* enum */ DocumentType TD2;
        public static final /* enum */ DocumentType TD3;
        public static final /* enum */ DocumentType MRVA;
        public static final /* enum */ DocumentType MRVB;
        private static final /* synthetic */ DocumentType[] $VALUES;
        private int code;

        public static DocumentType[] values() {
            return (DocumentType[])$VALUES.clone();
        }

        public static DocumentType valueOf(String string2) {
            return Enum.valueOf(DocumentType.class, string2);
        }

        private DocumentType(int n2) {
            this.code = n2;
        }

        static {
            DocumentType documentType;
            DocumentType documentType2;
            DocumentType documentType3;
            DocumentType documentType4;
            DocumentType documentType5;
            DocumentType documentType6;
            DocumentType documentType7 = documentType6;
            UNKNOWN = new DocumentType(0);
            DocumentType documentType8 = documentType5;
            TD1 = new DocumentType(1);
            DocumentType documentType9 = documentType4;
            TD2 = new DocumentType(2);
            DocumentType documentType10 = documentType3;
            TD3 = new DocumentType(3);
            DocumentType documentType11 = documentType2;
            MRVA = new DocumentType(4);
            DocumentType documentType12 = documentType;
            MRVB = new DocumentType(5);
            $VALUES = new DocumentType[]{documentType7, documentType8, documentType9, documentType10, documentType11, documentType12};
        }

        public int getCode() {
            return this.code;
        }
    }
}

