/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.iso19794;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.eidparser.lds.AbstractImageInfo;
import com.fis.ekyc.nfc.build_in.scuba.data.Gender;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public class FaceImageInfo
extends AbstractImageInfo {
    private static final long serialVersionUID = -1751069410327594067L;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    public static final int EYE_COLOR_UNSPECIFIED = 0;
    public static final int EYE_COLOR_BLACK = 1;
    public static final int EYE_COLOR_BLUE = 2;
    public static final int EYE_COLOR_BROWN = 3;
    public static final int EYE_COLOR_GRAY = 4;
    public static final int EYE_COLOR_GREEN = 5;
    public static final int EYE_COLOR_MULTI_COLORED = 6;
    public static final int EYE_COLOR_PINK = 7;
    public static final int EYE_COLOR_UNKNOWN = 255;
    public static final int HAIR_COLOR_UNSPECIFIED = 0;
    public static final int HAIR_COLOR_BALD = 1;
    public static final int HAIR_COLOR_BLACK = 2;
    public static final int HAIR_COLOR_BLONDE = 3;
    public static final int HAIR_COLOR_BROWN = 4;
    public static final int HAIR_COLOR_GRAY = 5;
    public static final int HAIR_COLOR_WHITE = 6;
    public static final int HAIR_COLOR_RED = 7;
    public static final int HAIR_COLOR_GREEN = 8;
    public static final int HAIR_COLOR_BLUE = 9;
    public static final int HAIR_COLOR_UNKNOWN = 255;
    private static final int FEATURE_FEATURES_ARE_SPECIFIED_FLAG = 1;
    private static final int FEATURE_GLASSES_FLAG = 2;
    private static final int FEATURE_MOUSTACHE_FLAG = 4;
    private static final int FEATURE_BEARD_FLAG = 8;
    private static final int FEATURE_TEETH_VISIBLE_FLAG = 16;
    private static final int FEATURE_BLINK_FLAG = 32;
    private static final int FEATURE_MOUTH_OPEN_FLAG = 64;
    private static final int FEATURE_LEFT_EYE_PATCH_FLAG = 128;
    private static final int FEATURE_RIGHT_EYE_PATCH = 256;
    private static final int FEATURE_DARK_GLASSES = 512;
    private static final int FEATURE_DISTORTING_MEDICAL_CONDITION = 1024;
    public static final short EXPRESSION_UNSPECIFIED = 0;
    public static final short EXPRESSION_NEUTRAL = 1;
    public static final short EXPRESSION_SMILE_CLOSED = 2;
    public static final short EXPRESSION_SMILE_OPEN = 3;
    public static final short EXPRESSION_RAISED_EYEBROWS = 4;
    public static final short EXPRESSION_EYES_LOOKING_AWAY = 5;
    public static final short EXPRESSION_SQUINTING = 6;
    public static final short EXPRESSION_FROWNING = 7;
    public static final int FACE_IMAGE_TYPE_BASIC = 0;
    public static final int FACE_IMAGE_TYPE_FULL_FRONTAL = 1;
    public static final int FACE_IMAGE_TYPE_TOKEN_FRONTAL = 2;
    public static final int IMAGE_DATA_TYPE_JPEG = 0;
    public static final int IMAGE_DATA_TYPE_JPEG2000 = 1;
    public static final int IMAGE_COLOR_SPACE_UNSPECIFIED = 0;
    public static final int IMAGE_COLOR_SPACE_RGB24 = 1;
    public static final int IMAGE_COLOR_SPACE_YUV422 = 2;
    public static final int IMAGE_COLOR_SPACE_GRAY8 = 3;
    public static final int IMAGE_COLOR_SPACE_OTHER = 4;
    public static final int SOURCE_TYPE_UNSPECIFIED = 0;
    public static final int SOURCE_TYPE_STATIC_PHOTO_UNKNOWN_SOURCE = 1;
    public static final int SOURCE_TYPE_STATIC_PHOTO_DIGITAL_CAM = 2;
    public static final int SOURCE_TYPE_STATIC_PHOTO_SCANNER = 3;
    public static final int SOURCE_TYPE_VIDEO_FRAME_UNKNOWN_SOURCE = 4;
    public static final int SOURCE_TYPE_VIDEO_FRAME_ANALOG_CAM = 5;
    public static final int SOURCE_TYPE_VIDEO_FRAME_DIGITAL_CAM = 6;
    public static final int SOURCE_TYPE_UNKNOWN = 7;
    private static final int YAW = 0;
    private static final int PITCH = 1;
    private static final int ROLL = 2;
    private long recordLength;
    private Gender gender;
    private EyeColor eyeColor;
    private int hairColor;
    private int featureMask;
    private int expression;
    private int[] poseAngle;
    private int[] poseAngleUncertainty;
    private FeaturePoint[] featurePoints;
    private int faceImageType;
    private int imageDataType;
    private int colorSpace;
    private int sourceType;
    private int deviceType;
    private int quality;

    public FaceImageInfo(Gender gender, EyeColor featurePointArray, int n, int n2, int n3, int[] nArray, int[] nArray2, int n4, int n5, int n6, int n7, int n8, FeaturePoint[] featurePointArray2, int n9, int n10, InputStream inputStream, int n11, int n12) {
        long l = n11;
        String string2 = FaceImageInfo.toMimeType(n12);
        super(0, n9, n10, inputStream, l, string2);
        if (inputStream != null) {
            if (gender == null) {
                gender = Gender.UNSPECIFIED;
            }
            ((FaceImageInfo)object).gender = gender;
            if (featurePointArray == null) {
                featurePointArray = EyeColor.UNSPECIFIED;
            }
            FaceImageInfo faceImageInfo = object;
            faceImageInfo.eyeColor = featurePointArray;
            faceImageInfo.featureMask = n;
            faceImageInfo.hairColor = n2;
            faceImageInfo.expression = n3;
            faceImageInfo.colorSpace = n5;
            faceImageInfo.sourceType = n6;
            faceImageInfo.deviceType = n7;
            int n13 = featurePointArray2 == null ? 0 : featurePointArray2.length;
            featurePointArray = new FeaturePoint[n13];
            ((FaceImageInfo)object).featurePoints = featurePointArray;
            if (n13 > 0) {
                System.arraycopy(featurePointArray2, 0, featurePointArray, 0, n13);
            }
            FaceImageInfo faceImageInfo2 = object;
            FaceImageInfo faceImageInfo3 = object;
            FaceImageInfo faceImageInfo4 = object;
            FaceImageInfo faceImageInfo5 = object;
            FaceImageInfo faceImageInfo6 = object;
            FaceImageInfo faceImageInfo7 = object;
            FaceImageInfo faceImageInfo8 = object;
            FaceImageInfo faceImageInfo9 = object;
            FaceImageInfo faceImageInfo10 = object;
            int[] nArray3 = new int[3];
            Object object = nArray3;
            faceImageInfo10.poseAngle = nArray3;
            System.arraycopy(nArray, 0, object, 0, 3);
            int[] nArray4 = new int[3];
            object = nArray4;
            faceImageInfo9.poseAngleUncertainty = nArray4;
            System.arraycopy(nArray2, 0, object, 0, 3);
            faceImageInfo8.imageDataType = n12;
            faceImageInfo7.recordLength = (long)(n13 * 8) + 20L + 12L + l;
            faceImageInfo6.faceImageType = n4;
            faceImageInfo5.colorSpace = n5;
            faceImageInfo4.sourceType = n6;
            faceImageInfo3.deviceType = n7;
            faceImageInfo2.quality = n8;
            return;
        }
        throw new IllegalArgumentException("Null image");
    }

    public FaceImageInfo(InputStream inputStream) {
        FaceImageInfo faceImageInfo = this;
        super(0);
        faceImageInfo.readObject(inputStream);
    }

    private void writeFacialRecordData(OutputStream object) {
        DataOutputStream dataOutputStream;
        DataOutputStream dataOutputStream2 = dataOutputStream;
        dataOutputStream2((OutputStream)object);
        dataOutputStream.writeShort(this.featurePoints.length);
        object = this.gender;
        int n = object == null ? Gender.UNSPECIFIED.toInt() : ((Gender)((Object)object)).toInt();
        dataOutputStream2.writeByte(n);
        EyeColor eyeColor = this.eyeColor;
        int n2 = eyeColor == null ? EyeColor.UNSPECIFIED.toInt() : eyeColor.toInt();
        dataOutputStream2.writeByte(n2);
        dataOutputStream2.writeByte(this.hairColor);
        dataOutputStream2.writeByte((byte)(((long)this.featureMask & 0xFF0000L) >> 16));
        dataOutputStream2.writeByte((byte)(((long)this.featureMask & 0xFF00L) >> 8));
        dataOutputStream2.writeByte((byte)((long)this.featureMask & 0xFFL));
        dataOutputStream2.writeShort(this.expression);
        for (n2 = 0; n2 < 3; ++n2) {
            dataOutputStream2.writeByte(this.poseAngle[n2]);
        }
        for (n2 = 0; n2 < 3; ++n2) {
            dataOutputStream2.writeByte(this.poseAngleUncertainty[n2]);
        }
        FeaturePoint[] featurePointArray = this.featurePoints;
        int n3 = this.featurePoints.length;
        for (int k = 0; k < n3; ++k) {
            DataOutputStream dataOutputStream3 = dataOutputStream2;
            FeaturePoint featurePoint = featurePointArray[k];
            dataOutputStream3.writeByte(featurePoint.getType());
            dataOutputStream3.writeByte(featurePoint.getMajorCode() << 4 | featurePoint.getMinorCode());
            dataOutputStream3.writeShort(featurePoint.getX());
            dataOutputStream3.writeShort(featurePoint.getY());
            dataOutputStream3.writeShort(0);
        }
        DataOutputStream dataOutputStream4 = dataOutputStream2;
        DataOutputStream dataOutputStream5 = dataOutputStream2;
        dataOutputStream2.writeByte(this.faceImageType);
        dataOutputStream2.writeByte(this.imageDataType);
        dataOutputStream2.writeShort(this.getWidth());
        dataOutputStream2.writeShort(this.getHeight());
        dataOutputStream2.writeByte(this.colorSpace);
        dataOutputStream2.writeByte(this.sourceType);
        dataOutputStream2.writeShort(this.deviceType);
        dataOutputStream5.writeShort(this.quality);
        this.writeImage(dataOutputStream5);
        dataOutputStream4.flush();
        ((OutputStream)dataOutputStream4).close();
    }

    private String hairColorToString() {
        switch (this.hairColor) {
            default: {
                return "unknown";
            }
            case 9: {
                return "blue";
            }
            case 8: {
                return "green";
            }
            case 7: {
                return "red";
            }
            case 6: {
                return "white";
            }
            case 5: {
                return "gray";
            }
            case 4: {
                return "brown";
            }
            case 3: {
                return "blonde";
            }
            case 2: {
                return "black";
            }
            case 1: {
                return "bald";
            }
            case 0: 
        }
        return "unspecified";
    }

    private String featureMaskToString() {
        StringBuilder stringBuilder;
        ArrayList<String> arrayList;
        if ((((FaceImageInfo)serializable).featureMask & 1) == 0) {
            return "";
        }
        Object object = arrayList;
        arrayList = new ArrayList<String>();
        if ((((FaceImageInfo)serializable).featureMask & 2) != 0) {
            ((ArrayList)object).add("glasses");
        }
        if ((((FaceImageInfo)serializable).featureMask & 4) != 0) {
            ((ArrayList)object).add("moustache");
        }
        if ((((FaceImageInfo)serializable).featureMask & 8) != 0) {
            ((ArrayList)object).add("beard");
        }
        if ((((FaceImageInfo)serializable).featureMask & 0x10) != 0) {
            ((ArrayList)object).add("teeth visible");
        }
        if ((((FaceImageInfo)serializable).featureMask & 0x20) != 0) {
            ((ArrayList)object).add("blink");
        }
        if ((((FaceImageInfo)serializable).featureMask & 0x40) != 0) {
            ((ArrayList)object).add("mouth open");
        }
        if ((((FaceImageInfo)serializable).featureMask & 0x80) != 0) {
            ((ArrayList)object).add("left eye patch");
        }
        if ((((FaceImageInfo)serializable).featureMask & 0x100) != 0) {
            ((ArrayList)object).add("right eye patch");
        }
        if ((((FaceImageInfo)serializable).featureMask & 0x200) != 0) {
            ((ArrayList)object).add("dark glasses");
        }
        if ((((FaceImageInfo)serializable).featureMask & 0x400) != 0) {
            ((ArrayList)object).add("distorting medical condition (which could impact feature point detection)");
        }
        Serializable serializable = stringBuilder;
        stringBuilder = new StringBuilder();
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            ((StringBuilder)serializable).append((String)object.next());
            if (!object.hasNext()) continue;
            ((StringBuilder)serializable).append(", ");
        }
        return ((StringBuilder)serializable).toString();
    }

    private String expressionToString() {
        switch (this.expression) {
            default: {
                return "unknown";
            }
            case 7: {
                return "frowning";
            }
            case 6: {
                return "squinting";
            }
            case 5: {
                return "eyes looking away from the camera";
            }
            case 4: {
                return "raised eyebrows";
            }
            case 3: {
                return "a smile where the inside of the mouth and/or teeth is exposed";
            }
            case 2: {
                return "a smile where the inside of the mouth and/or teeth is not exposed (closed jaw)";
            }
            case 1: {
                return "neutral (non-smiling) with both eyes open and mouth closed";
            }
            case 0: 
        }
        return "unspecified";
    }

    private String poseAngleToString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append("(");
        stringBuilder2.append("y: ").append(this.poseAngle[0]);
        if (this.poseAngleUncertainty[0] != 0) {
            stringBuilder2.append(" (").append(this.poseAngleUncertainty[0]).append(")");
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append(", ");
        stringBuilder3.append("p:").append(this.poseAngle[1]);
        if (this.poseAngleUncertainty[1] != 0) {
            stringBuilder2.append(" (").append(this.poseAngleUncertainty[1]).append(")");
        }
        StringBuilder stringBuilder4 = stringBuilder2;
        stringBuilder4.append(", ");
        stringBuilder4.append("r: ").append(this.poseAngle[2]);
        if (this.poseAngleUncertainty[2] != 0) {
            stringBuilder2.append(" (").append(this.poseAngleUncertainty[2]).append(")");
        }
        StringBuilder stringBuilder5 = stringBuilder2;
        stringBuilder5.append(")");
        return stringBuilder5.toString();
    }

    private String faceImageTypeToString() {
        int n = this.faceImageType;
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    return "unknown";
                }
                return "token frontal";
            }
            return "full frontal";
        }
        return "basic";
    }

    private String sourceTypeToString() {
        switch (this.sourceType) {
            default: {
                return "unknown";
            }
            case 6: {
                return "single video frame from a digital camera";
            }
            case 5: {
                return "single video frame from an analogue camera";
            }
            case 4: {
                return "single video frame from an unknown source";
            }
            case 3: {
                return "static photograph from a scanner";
            }
            case 2: {
                return "static photograph from a digital still-image camera";
            }
            case 1: {
                return "static photograph from an unknown source";
            }
            case 0: 
        }
        return "unspecified";
    }

    private static String toMimeType(int n) {
        if (n != 0) {
            if (n != 1) {
                LOGGER.warning("Unknown image type: " + n);
                return null;
            }
            return "image/jp2";
        }
        return "image/jpeg";
    }

    @Override
    public void readObject(InputStream inputStream) {
        int n;
        DataInputStream dataInputStream;
        if (inputStream instanceof DataInputStream) {
            dataInputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream2;
            dataInputStream = dataInputStream2;
            dataInputStream2 = new DataInputStream(inputStream);
        }
        FaceImageInfo faceImageInfo = this;
        DataInputStream dataInputStream3 = dataInputStream;
        this.recordLength = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
        int n2 = dataInputStream3.readUnsignedShort();
        this.gender = Gender.getInstance(dataInputStream3.readUnsignedByte());
        this.eyeColor = EyeColor.toEyeColor(dataInputStream.readUnsignedByte());
        this.hairColor = dataInputStream.readUnsignedByte();
        this.featureMask = dataInputStream.readUnsignedByte();
        this.featureMask = this.featureMask << 16 | dataInputStream.readUnsignedShort();
        faceImageInfo.expression = dataInputStream.readShort();
        faceImageInfo.poseAngle = new int[3];
        this.poseAngle[0] = n = dataInputStream.readUnsignedByte();
        this.poseAngle[1] = n = dataInputStream.readUnsignedByte();
        n = dataInputStream.readUnsignedByte();
        FaceImageInfo faceImageInfo2 = this;
        faceImageInfo2.poseAngle[2] = n;
        int[] nArray = new int[3];
        int[] nArray2 = nArray;
        this.poseAngleUncertainty = nArray2;
        nArray[0] = dataInputStream.readUnsignedByte();
        faceImageInfo2.poseAngleUncertainty[1] = dataInputStream.readUnsignedByte();
        faceImageInfo2.poseAngleUncertainty[2] = dataInputStream.readUnsignedByte();
        this.featurePoints = new FeaturePoint[n2];
        for (int k = 0; k < n2; ++k) {
            FeaturePoint featurePoint;
            DataInputStream dataInputStream4 = dataInputStream;
            int n3 = dataInputStream4.readUnsignedByte();
            byte by = dataInputStream4.readByte();
            int n4 = dataInputStream4.readUnsignedShort();
            int n5 = dataInputStream4.readUnsignedShort();
            long l = 0L;
            while (l < 2L) {
                l = ((InputStream)dataInputStream).skip(2L) + l;
            }
            FeaturePoint featurePoint2 = featurePoint;
            featurePoint = new FeaturePoint(n3, by, n4, n5);
            this.featurePoints[k] = featurePoint2;
        }
        this.faceImageType = dataInputStream.readUnsignedByte();
        this.imageDataType = dataInputStream.readUnsignedByte();
        this.setWidth(dataInputStream.readUnsignedShort());
        this.setHeight(dataInputStream.readUnsignedShort());
        this.colorSpace = dataInputStream.readUnsignedByte();
        this.sourceType = dataInputStream.readUnsignedByte();
        this.deviceType = dataInputStream.readUnsignedShort();
        this.quality = dataInputStream.readUnsignedShort();
        if (this.getWidth() <= 0) {
            this.setWidth(800);
        }
        if (this.getHeight() <= 0) {
            this.setHeight(600);
        }
        FaceImageInfo faceImageInfo3 = this;
        faceImageInfo3.setMimeType(FaceImageInfo.toMimeType(faceImageInfo3.imageDataType));
        this.readImage(inputStream, faceImageInfo3.recordLength - 20L - (long)(n2 * 8) - 12L);
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        DataOutputStream dataOutputStream;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ((FaceImageInfo)object).writeFacialRecordData(byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Object object = byArray;
        long l = (long)byArray.length + 4L;
        DataOutputStream dataOutputStream2 = dataOutputStream;
        dataOutputStream2(outputStream);
        dataOutputStream2.writeInt((int)l);
        ((OutputStream)dataOutputStream).write((byte[])object);
        dataOutputStream.flush();
    }

    @Override
    public long getRecordLength() {
        return this.recordLength;
    }

    public FeaturePoint[] getFeaturePoints() {
        return this.featurePoints;
    }

    public int getExpression() {
        return this.expression;
    }

    public EyeColor getEyeColor() {
        return this.eyeColor;
    }

    public Gender getGender() {
        return this.gender;
    }

    public int getHairColor() {
        return this.hairColor;
    }

    public int getFaceImageType() {
        return this.faceImageType;
    }

    public int getFeatureMask() {
        return this.featureMask;
    }

    public int getQuality() {
        return this.quality;
    }

    public int getSourceType() {
        return this.sourceType;
    }

    public int getImageDataType() {
        return this.imageDataType;
    }

    public int getColorSpace() {
        return this.colorSpace;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public int[] getPoseAngle() {
        int[] nArray = new int[3];
        System.arraycopy(this.poseAngle, 0, nArray, 0, 3);
        return nArray;
    }

    public int[] getPoseAngleUncertainty() {
        int[] nArray = new int[3];
        System.arraycopy(this.poseAngleUncertainty, 0, nArray, 0, 3);
        return nArray;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append("FaceImageInfo [");
        stringBuilder2.append("Image size: ").append(featurePointArray.getWidth()).append(" x ").append(featurePointArray.getHeight()).append(", ");
        StringBuilder stringBuilder3 = stringBuilder2.append("Gender: ");
        Enum enum_ = featurePointArray.gender;
        if (enum_ == null) {
            enum_ = Gender.UNSPECIFIED;
        }
        stringBuilder3.append(enum_).append(", ");
        stringBuilder3 = stringBuilder2.append("Eye color: ");
        enum_ = featurePointArray.eyeColor;
        if (enum_ == null) {
            enum_ = EyeColor.UNSPECIFIED;
        }
        StringBuilder stringBuilder4 = stringBuilder2;
        stringBuilder3.append(enum_).append(", ");
        stringBuilder4.append("Hair color: ").append(featurePointArray.hairColorToString()).append(", ");
        stringBuilder4.append("Feature mask: ").append(featurePointArray.featureMaskToString()).append(", ");
        stringBuilder4.append("Expression: ").append(featurePointArray.expressionToString()).append(", ");
        stringBuilder4.append("Pose angle: ").append(featurePointArray.poseAngleToString()).append(", ");
        stringBuilder4.append("Face image type: ").append(featurePointArray.faceImageTypeToString()).append(", ");
        stringBuilder4.append("Source type: ").append(featurePointArray.sourceTypeToString()).append(", ");
        stringBuilder4.append("FeaturePoints [");
        FeaturePoint[] featurePointArray = featurePointArray.featurePoints;
        if (featurePointArray.featurePoints != null && featurePointArray.length > 0) {
            boolean bl = true;
            for (FeaturePoint featurePoint : featurePointArray) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder2.append(", ");
                }
                stringBuilder2.append(featurePoint.toString());
            }
        }
        StringBuilder stringBuilder5 = stringBuilder2;
        stringBuilder5.append("]");
        stringBuilder5.append("]");
        return stringBuilder5.toString();
    }

    @Override
    public int hashCode() {
        FaceImageInfo faceImageInfo = this;
        int n = (((super.hashCode() * 31 + this.colorSpace) * 31 + this.deviceType) * 31 + this.expression) * 31;
        EyeColor eyeColor = faceImageInfo.eyeColor;
        int n2 = eyeColor == null ? 0 : ((Object)((Object)eyeColor)).hashCode();
        n = ((((n + n2) * 31 + this.faceImageType) * 31 + this.featureMask) * 31 + Arrays.hashCode(this.featurePoints)) * 31;
        Gender gender = this.gender;
        int n3 = gender == null ? 0 : ((Object)((Object)gender)).hashCode();
        FaceImageInfo faceImageInfo2 = this;
        n = (((n + n3) * 31 + this.hairColor) * 31 + this.imageDataType) * 31;
        n = (Arrays.hashCode(faceImageInfo2.poseAngle) + n) * 31;
        long l = this.recordLength;
        return (((Arrays.hashCode(faceImageInfo2.poseAngleUncertainty) + n) * 31 + this.quality) * 31 + (int)(l ^ l >>> 32)) * 31 + this.sourceType;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (FaceImageInfo)object;
        return this.colorSpace == ((FaceImageInfo)object).colorSpace && this.deviceType == ((FaceImageInfo)object).deviceType && this.expression == ((FaceImageInfo)object).expression && this.eyeColor == ((FaceImageInfo)object).eyeColor && this.faceImageType == ((FaceImageInfo)object).faceImageType && this.featureMask == ((FaceImageInfo)object).featureMask && Arrays.equals(this.featurePoints, ((FaceImageInfo)object).featurePoints) && this.gender == ((FaceImageInfo)object).gender && this.hairColor == ((FaceImageInfo)object).hairColor && this.imageDataType == ((FaceImageInfo)object).imageDataType && Arrays.equals(this.poseAngle, ((FaceImageInfo)object).poseAngle) && Arrays.equals(this.poseAngleUncertainty, ((FaceImageInfo)object).poseAngleUncertainty) && this.quality == ((FaceImageInfo)object).quality && this.recordLength == ((FaceImageInfo)object).recordLength && this.sourceType == ((FaceImageInfo)object).sourceType;
    }

    public static final class EyeColor
    extends Enum<EyeColor> {
        public static final /* enum */ EyeColor UNSPECIFIED;
        public static final /* enum */ EyeColor BLACK;
        public static final /* enum */ EyeColor BLUE;
        public static final /* enum */ EyeColor BROWN;
        public static final /* enum */ EyeColor GRAY;
        public static final /* enum */ EyeColor GREEN;
        public static final /* enum */ EyeColor MULTI_COLORED;
        public static final /* enum */ EyeColor PINK;
        public static final /* enum */ EyeColor UNKNOWN;
        private static final /* synthetic */ EyeColor[] $VALUES;
        private int code;

        public static EyeColor[] values() {
            return (EyeColor[])$VALUES.clone();
        }

        public static EyeColor valueOf(String string2) {
            return Enum.valueOf(EyeColor.class, string2);
        }

        private EyeColor(int n2) {
            this.code = n2;
        }

        public static EyeColor toEyeColor(int n) {
            for (EyeColor eyeColor : EyeColor.values()) {
                if (eyeColor.toInt() != n) continue;
                return eyeColor;
            }
            return UNKNOWN;
        }

        static {
            EyeColor eyeColor;
            EyeColor eyeColor2;
            EyeColor eyeColor3;
            EyeColor eyeColor4;
            EyeColor eyeColor5;
            EyeColor eyeColor6;
            EyeColor eyeColor7;
            EyeColor eyeColor8;
            EyeColor eyeColor9;
            EyeColor eyeColor10 = eyeColor9;
            UNSPECIFIED = new EyeColor(0);
            EyeColor eyeColor11 = eyeColor8;
            BLACK = new EyeColor(1);
            EyeColor eyeColor12 = eyeColor7;
            BLUE = new EyeColor(2);
            EyeColor eyeColor13 = eyeColor6;
            BROWN = new EyeColor(3);
            EyeColor eyeColor14 = eyeColor5;
            GRAY = new EyeColor(4);
            EyeColor eyeColor15 = eyeColor4;
            GREEN = new EyeColor(5);
            EyeColor eyeColor16 = eyeColor3;
            MULTI_COLORED = new EyeColor(6);
            EyeColor eyeColor17 = eyeColor2;
            PINK = new EyeColor(7);
            EyeColor eyeColor18 = eyeColor;
            UNKNOWN = new EyeColor(255);
            $VALUES = new EyeColor[]{eyeColor10, eyeColor11, eyeColor12, eyeColor13, eyeColor14, eyeColor15, eyeColor16, eyeColor17, eyeColor18};
        }

        public int toInt() {
            return this.code;
        }
    }

    public static final class HairColor
    extends Enum<HairColor> {
        public static final /* enum */ HairColor UNSPECIFIED;
        public static final /* enum */ HairColor BALD;
        public static final /* enum */ HairColor BLACK;
        public static final /* enum */ HairColor BLONDE;
        public static final /* enum */ HairColor BROWN;
        public static final /* enum */ HairColor GRAY;
        public static final /* enum */ HairColor WHITE;
        public static final /* enum */ HairColor RED;
        public static final /* enum */ HairColor GREEN;
        public static final /* enum */ HairColor BLUE;
        public static final /* enum */ HairColor UNKNOWN;
        private static final /* synthetic */ HairColor[] $VALUES;
        private int code;

        public static HairColor[] values() {
            return (HairColor[])$VALUES.clone();
        }

        public static HairColor valueOf(String string2) {
            return Enum.valueOf(HairColor.class, string2);
        }

        private HairColor(int n2) {
            this.code = n2;
        }

        public static HairColor toHairColor(int n) {
            for (HairColor hairColor : HairColor.values()) {
                if (hairColor.toInt() != n) continue;
                return hairColor;
            }
            return UNKNOWN;
        }

        static {
            HairColor hairColor;
            HairColor hairColor2;
            HairColor hairColor3;
            HairColor hairColor4;
            HairColor hairColor5;
            HairColor hairColor6;
            HairColor hairColor7;
            HairColor hairColor8;
            HairColor hairColor9;
            HairColor hairColor10;
            HairColor hairColor11;
            HairColor hairColor12 = hairColor11;
            UNSPECIFIED = new HairColor(0);
            HairColor hairColor13 = hairColor10;
            BALD = new HairColor(1);
            HairColor hairColor14 = hairColor9;
            BLACK = new HairColor(2);
            HairColor hairColor15 = hairColor8;
            BLONDE = new HairColor(3);
            HairColor hairColor16 = hairColor7;
            BROWN = new HairColor(4);
            HairColor hairColor17 = hairColor6;
            GRAY = new HairColor(5);
            HairColor hairColor18 = hairColor5;
            WHITE = new HairColor(6);
            HairColor hairColor19 = hairColor4;
            RED = new HairColor(7);
            HairColor hairColor20 = hairColor3;
            GREEN = new HairColor(8);
            HairColor hairColor21 = hairColor2;
            BLUE = new HairColor(9);
            HairColor hairColor22 = hairColor;
            UNKNOWN = new HairColor(255);
            $VALUES = new HairColor[]{hairColor12, hairColor13, hairColor14, hairColor15, hairColor16, hairColor17, hairColor18, hairColor19, hairColor20, hairColor21, hairColor22};
        }

        public int toInt() {
            return this.code;
        }
    }

    public static final class Features
    extends Enum<Features> {
        public static final /* enum */ Features FEATURES_ARE_SPECIFIED;
        public static final /* enum */ Features GLASSES;
        public static final /* enum */ Features MOUSTACHE;
        public static final /* enum */ Features BEARD;
        public static final /* enum */ Features TEETH_VISIBLE;
        public static final /* enum */ Features BLINK;
        public static final /* enum */ Features MOUTH_OPEN;
        public static final /* enum */ Features LEFT_EYE_PATCH;
        public static final /* enum */ Features RIGHT_EYE_PATCH;
        public static final /* enum */ Features DARK_GLASSES;
        public static final /* enum */ Features DISTORTING_MEDICAL_CONDITION;
        private static final /* synthetic */ Features[] $VALUES;

        public static Features[] values() {
            return (Features[])$VALUES.clone();
        }

        public static Features valueOf(String string2) {
            return Enum.valueOf(Features.class, string2);
        }

        static {
            Features features;
            Features features2;
            Features features3;
            Features features4;
            Features features5;
            Features features6;
            Features features7;
            Features features8;
            Features features9;
            Features features10;
            Features features11;
            Features features12 = features11;
            FEATURES_ARE_SPECIFIED = new Features();
            Features features13 = features10;
            GLASSES = new Features();
            Features features14 = features9;
            MOUSTACHE = new Features();
            Features features15 = features8;
            BEARD = new Features();
            Features features16 = features7;
            TEETH_VISIBLE = new Features();
            Features features17 = features6;
            BLINK = new Features();
            Features features18 = features5;
            MOUTH_OPEN = new Features();
            Features features19 = features4;
            LEFT_EYE_PATCH = new Features();
            Features features20 = features3;
            RIGHT_EYE_PATCH = new Features();
            Features features21 = features2;
            DARK_GLASSES = new Features();
            Features features22 = features;
            DISTORTING_MEDICAL_CONDITION = new Features();
            $VALUES = new Features[]{features12, features13, features14, features15, features16, features17, features18, features19, features20, features21, features22};
        }
    }

    public static final class Expression
    extends Enum<Expression> {
        public static final /* enum */ Expression UNSPECIFIED;
        public static final /* enum */ Expression NEUTRAL;
        public static final /* enum */ Expression SMILE_CLOSED;
        public static final /* enum */ Expression SMILE_OPEN;
        public static final /* enum */ Expression RAISED_EYEBROWS;
        public static final /* enum */ Expression EYES_LOOKING_AWAY;
        public static final /* enum */ Expression SQUINTING;
        public static final /* enum */ Expression FROWNING;
        private static final /* synthetic */ Expression[] $VALUES;

        public static Expression[] values() {
            return (Expression[])$VALUES.clone();
        }

        public static Expression valueOf(String string2) {
            return Enum.valueOf(Expression.class, string2);
        }

        static {
            Expression expression;
            Expression expression2;
            Expression expression3;
            Expression expression4;
            Expression expression5;
            Expression expression6;
            Expression expression7;
            Expression expression8;
            Expression expression9 = expression8;
            UNSPECIFIED = new Expression();
            Expression expression10 = expression7;
            NEUTRAL = new Expression();
            Expression expression11 = expression6;
            SMILE_CLOSED = new Expression();
            Expression expression12 = expression5;
            SMILE_OPEN = new Expression();
            Expression expression13 = expression4;
            RAISED_EYEBROWS = new Expression();
            Expression expression14 = expression3;
            EYES_LOOKING_AWAY = new Expression();
            Expression expression15 = expression2;
            SQUINTING = new Expression();
            Expression expression16 = expression;
            FROWNING = new Expression();
            $VALUES = new Expression[]{expression9, expression10, expression11, expression12, expression13, expression14, expression15, expression16};
        }
    }

    public static final class FaceImageType
    extends Enum<FaceImageType> {
        public static final /* enum */ FaceImageType BASIC;
        public static final /* enum */ FaceImageType FULL_FRONTAL;
        public static final /* enum */ FaceImageType TOKEN_FRONTAL;
        private static final /* synthetic */ FaceImageType[] $VALUES;

        public static FaceImageType[] values() {
            return (FaceImageType[])$VALUES.clone();
        }

        public static FaceImageType valueOf(String string2) {
            return Enum.valueOf(FaceImageType.class, string2);
        }

        static {
            FaceImageType faceImageType;
            FaceImageType faceImageType2;
            FaceImageType faceImageType3;
            FaceImageType faceImageType4 = faceImageType3;
            BASIC = new FaceImageType();
            FaceImageType faceImageType5 = faceImageType2;
            FULL_FRONTAL = new FaceImageType();
            FaceImageType faceImageType6 = faceImageType;
            TOKEN_FRONTAL = new FaceImageType();
            $VALUES = new FaceImageType[]{faceImageType4, faceImageType5, faceImageType6};
        }
    }

    public static final class ImageDataType
    extends Enum<ImageDataType> {
        public static final /* enum */ ImageDataType TYPE_JPEG;
        public static final /* enum */ ImageDataType TYPE_JPEG2000;
        private static final /* synthetic */ ImageDataType[] $VALUES;

        public static ImageDataType[] values() {
            return (ImageDataType[])$VALUES.clone();
        }

        public static ImageDataType valueOf(String string2) {
            return Enum.valueOf(ImageDataType.class, string2);
        }

        static {
            ImageDataType imageDataType;
            ImageDataType imageDataType2;
            ImageDataType imageDataType3 = imageDataType2;
            TYPE_JPEG = new ImageDataType();
            ImageDataType imageDataType4 = imageDataType;
            TYPE_JPEG2000 = new ImageDataType();
            $VALUES = new ImageDataType[]{imageDataType3, imageDataType4};
        }
    }

    public static final class ImageColorSpace
    extends Enum<ImageColorSpace> {
        public static final /* enum */ ImageColorSpace UNSPECIFIED;
        public static final /* enum */ ImageColorSpace RGB24;
        public static final /* enum */ ImageColorSpace YUV422;
        public static final /* enum */ ImageColorSpace GRAY8;
        public static final /* enum */ ImageColorSpace OTHER;
        private static final /* synthetic */ ImageColorSpace[] $VALUES;

        public static ImageColorSpace[] values() {
            return (ImageColorSpace[])$VALUES.clone();
        }

        public static ImageColorSpace valueOf(String string2) {
            return Enum.valueOf(ImageColorSpace.class, string2);
        }

        static {
            ImageColorSpace imageColorSpace;
            ImageColorSpace imageColorSpace2;
            ImageColorSpace imageColorSpace3;
            ImageColorSpace imageColorSpace4;
            ImageColorSpace imageColorSpace5;
            ImageColorSpace imageColorSpace6 = imageColorSpace5;
            UNSPECIFIED = new ImageColorSpace();
            ImageColorSpace imageColorSpace7 = imageColorSpace4;
            RGB24 = new ImageColorSpace();
            ImageColorSpace imageColorSpace8 = imageColorSpace3;
            YUV422 = new ImageColorSpace();
            ImageColorSpace imageColorSpace9 = imageColorSpace2;
            GRAY8 = new ImageColorSpace();
            ImageColorSpace imageColorSpace10 = imageColorSpace;
            OTHER = new ImageColorSpace();
            $VALUES = new ImageColorSpace[]{imageColorSpace6, imageColorSpace7, imageColorSpace8, imageColorSpace9, imageColorSpace10};
        }
    }

    public static final class SourceType
    extends Enum<SourceType> {
        public static final /* enum */ SourceType UNSPECIFIED;
        public static final /* enum */ SourceType STATIC_PHOTO_UNKNOWN_SOURCE;
        public static final /* enum */ SourceType STATIC_PHOTO_DIGITAL_CAM;
        public static final /* enum */ SourceType STATIC_PHOTO_SCANNER;
        public static final /* enum */ SourceType VIDEO_FRAME_UNKNOWN_SOURCE;
        public static final /* enum */ SourceType VIDEO_FRAME_ANALOG_CAM;
        public static final /* enum */ SourceType VIDEO_FRAME_DIGITAL_CAM;
        public static final /* enum */ SourceType UNKNOWN;
        private static final /* synthetic */ SourceType[] $VALUES;

        public static SourceType[] values() {
            return (SourceType[])$VALUES.clone();
        }

        public static SourceType valueOf(String string2) {
            return Enum.valueOf(SourceType.class, string2);
        }

        static {
            SourceType sourceType;
            SourceType sourceType2;
            SourceType sourceType3;
            SourceType sourceType4;
            SourceType sourceType5;
            SourceType sourceType6;
            SourceType sourceType7;
            SourceType sourceType8;
            SourceType sourceType9 = sourceType8;
            UNSPECIFIED = new SourceType();
            SourceType sourceType10 = sourceType7;
            STATIC_PHOTO_UNKNOWN_SOURCE = new SourceType();
            SourceType sourceType11 = sourceType6;
            STATIC_PHOTO_DIGITAL_CAM = new SourceType();
            SourceType sourceType12 = sourceType5;
            STATIC_PHOTO_SCANNER = new SourceType();
            SourceType sourceType13 = sourceType4;
            VIDEO_FRAME_UNKNOWN_SOURCE = new SourceType();
            SourceType sourceType14 = sourceType3;
            VIDEO_FRAME_ANALOG_CAM = new SourceType();
            SourceType sourceType15 = sourceType2;
            VIDEO_FRAME_DIGITAL_CAM = new SourceType();
            SourceType sourceType16 = sourceType;
            UNKNOWN = new SourceType();
            $VALUES = new SourceType[]{sourceType9, sourceType10, sourceType11, sourceType12, sourceType13, sourceType14, sourceType15, sourceType16};
        }
    }

    public static class FeaturePoint
    implements Serializable {
        private static final long serialVersionUID = -4209679423938065215L;
        private int type;
        private int majorCode;
        private int minorCode;
        private int x;
        private int y;

        public FeaturePoint(int n, int n2, int n3, int n4, int n5) {
            this.type = n;
            this.majorCode = n2;
            this.minorCode = n3;
            this.x = n4;
            this.y = n5;
        }

        public FeaturePoint(int n, byte by, int n2, int n3) {
            byte by2 = by;
            int n4 = (by2 & 0xF0) >> 4;
            this(n, n4, by2 & 0xF, n2, n3);
        }

        public int getMajorCode() {
            return this.majorCode;
        }

        public int getMinorCode() {
            return this.minorCode;
        }

        public int getType() {
            return this.type;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String toString() {
            StringBuilder stringBuilder = a.a("( point: ").append(this.getMajorCode()).append(".").append(this.getMinorCode()).append(", type: ");
            return b.a(h.a.a(this.type, stringBuilder, ", (").append(this.x).append(", "), this.y, "))");
        }
    }
}

