/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.iso19794;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.BiometricDataBlock;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.StandardBiometricHeader;
import com.fis.ekyc.nfc.build_in.eidparser.lds.AbstractListInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.iso19794.FingerImageInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;

public class FingerInfo
extends AbstractListInfo<FingerImageInfo>
implements BiometricDataBlock {
    private static final long serialVersionUID = 5808625058034008176L;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private static final int FORMAT_IDENTIFIER = 1179210240;
    private static final int VERSION_NUMBER = 0x30313000;
    private static final int FORMAT_OWNER_VALUE = 257;
    private static final int FORMAT_TYPE_VALUE = 7;
    public static final int SCALE_UNITS_PPI = 1;
    public static final int SCALE_UNITS_PPCM = 2;
    public static final int COMPRESSION_UNCOMPRESSED_NO_BIT_PACKING = 0;
    public static final int COMPRESSION_UNCOMPRESSED_BIT_PACKED = 1;
    public static final int COMPRESSION_WSQ = 2;
    public static final int COMPRESSION_JPEG = 3;
    public static final int COMPRESSION_JPEG2000 = 4;
    public static final int COMPRESSION_PNG = 5;
    private int captureDeviceId;
    private int acquisitionLevel;
    private int scaleUnits;
    private int scanResolutionHorizontal;
    private int scanResolutionVertical;
    private int imageResolutionHorizontal;
    private int imageResolutionVertical;
    private int depth;
    private int compressionAlgorithm;
    private StandardBiometricHeader sbh;

    public FingerInfo(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, List<FingerImageInfo> list) {
        this(null, n, n2, n3, n4, n5, n6, n7, n8, n9, list);
    }

    public FingerInfo(StandardBiometricHeader standardBiometricHeader, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, List<FingerImageInfo> list) {
        FingerInfo fingerInfo = this;
        fingerInfo.sbh = standardBiometricHeader;
        fingerInfo.captureDeviceId = n;
        fingerInfo.acquisitionLevel = n2;
        fingerInfo.scaleUnits = n3;
        fingerInfo.scanResolutionHorizontal = n4;
        fingerInfo.scanResolutionVertical = n5;
        fingerInfo.imageResolutionHorizontal = n6;
        fingerInfo.imageResolutionVertical = n7;
        fingerInfo.depth = n8;
        fingerInfo.compressionAlgorithm = n9;
        fingerInfo.addAll(list);
    }

    public FingerInfo(InputStream inputStream) {
        this(null, inputStream);
    }

    public FingerInfo(StandardBiometricHeader standardBiometricHeader, InputStream inputStream) {
        FingerInfo fingerInfo = this;
        fingerInfo.sbh = standardBiometricHeader;
        fingerInfo.readObject(inputStream);
    }

    private static long readUnsignedLong(InputStream object, int n) {
        if (object instanceof DataInputStream) {
            object = (DataInputStream)object;
        } else {
            DataInputStream dataInputStream;
            DataInputStream dataInputStream2 = dataInputStream;
            dataInputStream = new DataInputStream((InputStream)object);
            object = dataInputStream2;
        }
        InputStream inputStream = object;
        byte[] byArray = new byte[n];
        object = byArray;
        ((DataInputStream)inputStream).readFully(byArray);
        long l = 0L;
        for (int k = 0; k < n; ++k) {
            l = (l << 8) + (long)(object[k] & 0xFF);
        }
        return l;
    }

    private static void writeLong(long l, OutputStream outputStream, int n) {
        if (n > 0) {
            int n2;
            for (n2 = 0; n2 < n - 8; ++n2) {
                outputStream.write(0);
            }
            if (n > 8) {
                n = 8;
            }
            --n;
            while (n >= 0) {
                n2 = n * 8;
                outputStream.write((byte)((l & 255L << n2) >> n2));
                --n;
            }
        }
    }

    public static String toMimeType(int n) {
        switch (n) {
            default: {
                return null;
            }
            case 5: {
                return "image/png";
            }
            case 4: {
                return "image/jpeg2000";
            }
            case 3: {
                return "image/jpeg";
            }
            case 2: {
                return "image/x-wsq";
            }
            case 1: {
                return "image/raw";
            }
            case 0: 
        }
        return "image/raw";
    }

    public static int fromMimeType(String string2) {
        if ("image/x-wsq".equals(string2)) {
            return 2;
        }
        if ("image/jpeg".equals(string2)) {
            return 3;
        }
        if ("image/jpeg2000".equals(string2)) {
            return 4;
        }
        if ("images/png".equals(string2)) {
            return 5;
        }
        throw new IllegalArgumentException("Did not recognize mimeType");
    }

    private int getBiometricSubtype() {
        int n = 0;
        int n2 = 1;
        Iterator iterator = this.getSubRecords().iterator();
        while (iterator.hasNext()) {
            int n3 = ((FingerImageInfo)iterator.next()).getBiometricSubtype();
            if (n2 != 0) {
                n2 = n = 0;
                n = n3;
                continue;
            }
            n &= n3;
        }
        return n;
    }

    public int getCaptureDeviceId() {
        return this.captureDeviceId;
    }

    public int getAcquisitionLevel() {
        return this.acquisitionLevel;
    }

    public int getScaleUnits() {
        return this.scaleUnits;
    }

    public int getHorizontalScanningResolution() {
        return this.scanResolutionHorizontal;
    }

    public int getVerticalScanningResolution() {
        return this.scanResolutionVertical;
    }

    public int getHorizontalImageResolution() {
        return this.imageResolutionHorizontal;
    }

    public int getVerticalImageResolution() {
        return this.imageResolutionVertical;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    @Override
    public void readObject(InputStream inputStream) {
        DataInputStream dataInputStream;
        if (inputStream instanceof DataInputStream) {
            dataInputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream2;
            dataInputStream = dataInputStream2;
            dataInputStream2 = new DataInputStream(inputStream);
        }
        int n = dataInputStream.readInt();
        if (n == 1179210240) {
            n = dataInputStream.readInt();
            if (n == 0x30313000) {
                long l = FingerInfo.readUnsignedLong(dataInputStream, 6);
                DataInputStream dataInputStream3 = dataInputStream;
                this.captureDeviceId = dataInputStream.readUnsignedShort();
                this.acquisitionLevel = dataInputStream.readUnsignedShort();
                int n2 = dataInputStream3.readUnsignedByte();
                this.scaleUnits = dataInputStream3.readUnsignedByte();
                this.scanResolutionHorizontal = dataInputStream.readUnsignedShort();
                this.scanResolutionVertical = dataInputStream.readUnsignedShort();
                this.imageResolutionHorizontal = dataInputStream.readUnsignedShort();
                this.imageResolutionVertical = dataInputStream.readUnsignedShort();
                this.depth = dataInputStream.readUnsignedByte();
                this.compressionAlgorithm = dataInputStream.readUnsignedByte();
                dataInputStream.readUnsignedShort();
                long l2 = l - 32L;
                long l3 = 0L;
                for (int k = 0; k < n2; ++k) {
                    FingerImageInfo fingerImageInfo = new FingerImageInfo(inputStream, this.compressionAlgorithm);
                    l3 = fingerImageInfo.getRecordLength() + l3;
                    this.add(fingerImageInfo);
                }
                if (l2 != l3) {
                    LOGGER.warning("ConstructedDataLength and dataLength differ: dataLength = " + l2 + ", constructedDataLength = " + l3);
                }
                return;
            }
            throw new IllegalArgumentException(h.a(n, a.a("'010' version number expected! Found ")));
        }
        throw new IllegalArgumentException(h.a(n, a.a("'FIR' marker expected! Found ")));
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        long l = 32L;
        long l2 = 0L;
        List list = ((AbstractListInfo)((Object)iterator2)).getSubRecords();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            l2 = ((FingerImageInfo)iterator.next()).getRecordLength() + l2;
        }
        l += l2;
        if (outputStream instanceof DataOutputStream) {
            outputStream = (DataOutputStream)outputStream;
        } else {
            DataOutputStream dataOutputStream;
            DataOutputStream dataOutputStream2 = dataOutputStream;
            dataOutputStream = new DataOutputStream(outputStream);
            outputStream = dataOutputStream2;
        }
        OutputStream outputStream2 = outputStream;
        OutputStream outputStream3 = outputStream;
        ((DataOutputStream)outputStream3).writeInt(1179210240);
        ((DataOutputStream)outputStream3).writeInt(0x30313000);
        FingerInfo.writeLong(l, outputStream3, 6);
        ((DataOutputStream)outputStream).writeShort(((FingerInfo)((Object)iterator2)).captureDeviceId);
        ((DataOutputStream)outputStream).writeShort(((FingerInfo)((Object)iterator2)).acquisitionLevel);
        ((DataOutputStream)outputStream).writeByte(list.size());
        ((DataOutputStream)outputStream).writeByte(((FingerInfo)((Object)iterator2)).scaleUnits);
        ((DataOutputStream)outputStream).writeShort(((FingerInfo)((Object)iterator2)).scanResolutionHorizontal);
        ((DataOutputStream)outputStream).writeShort(((FingerInfo)((Object)iterator2)).scanResolutionVertical);
        ((DataOutputStream)outputStream).writeShort(((FingerInfo)((Object)iterator2)).imageResolutionHorizontal);
        ((DataOutputStream)outputStream).writeShort(((FingerInfo)((Object)iterator2)).imageResolutionVertical);
        ((DataOutputStream)outputStream).writeByte(((FingerInfo)((Object)iterator2)).depth);
        ((DataOutputStream)outputStream2).writeByte(((FingerInfo)((Object)iterator2)).compressionAlgorithm);
        ((DataOutputStream)outputStream2).writeShort(0);
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            ((FingerImageInfo)iterator2.next()).writeObject(outputStream);
        }
    }

    @Override
    public int hashCode() {
        FingerInfo fingerInfo = this;
        int n = ((((((super.hashCode() * 31 + this.acquisitionLevel) * 31 + this.captureDeviceId) * 31 + this.compressionAlgorithm) * 31 + this.depth) * 31 + this.imageResolutionHorizontal) * 31 + this.imageResolutionVertical) * 31;
        StandardBiometricHeader standardBiometricHeader = fingerInfo.sbh;
        int n2 = standardBiometricHeader == null ? 0 : standardBiometricHeader.hashCode();
        return (((n + n2) * 31 + this.scaleUnits) * 31 + this.scanResolutionHorizontal) * 31 + this.scanResolutionVertical;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (FingerInfo)object;
        return this.acquisitionLevel == ((FingerInfo)object).acquisitionLevel && this.captureDeviceId == ((FingerInfo)object).captureDeviceId && this.compressionAlgorithm == ((FingerInfo)object).compressionAlgorithm && this.depth == ((FingerInfo)object).depth && this.imageResolutionHorizontal == ((FingerInfo)object).imageResolutionHorizontal && this.imageResolutionVertical == ((FingerInfo)object).imageResolutionVertical && this.scaleUnits == ((FingerInfo)object).scaleUnits && this.scanResolutionHorizontal == ((FingerInfo)object).scanResolutionHorizontal && this.scanResolutionVertical == ((FingerInfo)object).scanResolutionVertical;
    }

    public String toString() {
        StringBuilder stringBuilder;
        FingerInfo fingerInfo = serializable;
        Serializable serializable = stringBuilder;
        new StringBuilder().append("FingerInfo [");
        Iterator iterator = fingerInfo.getSubRecords().iterator();
        while (iterator.hasNext()) {
            ((StringBuilder)serializable).append(((FingerImageInfo)iterator.next()).toString());
        }
        Serializable serializable2 = serializable;
        ((StringBuilder)serializable2).append("]");
        return ((StringBuilder)serializable2).toString();
    }

    @Override
    public StandardBiometricHeader getStandardBiometricHeader() {
        if (this.sbh == null) {
            TreeMap<Integer, byte[]> treeMap;
            byte[] byArray = new byte[1];
            byte[] byArray2 = byArray;
            byArray[0] = 8;
            byte[] byArray3 = new byte[1];
            byte[] byArray4 = byArray3;
            byArray3[0] = (byte)this.getBiometricSubtype();
            byte[] byArray5 = new byte[2];
            byte[] byArray6 = byArray5;
            byArray5[0] = 1;
            byArray5[1] = 1;
            byte[] byArray7 = new byte[2];
            byte[] byArray8 = byArray7;
            byArray7[0] = 0;
            byArray7[1] = 7;
            TreeMap<Integer, byte[]> treeMap2 = treeMap;
            new TreeMap<Integer, byte[]>().put(129, byArray2);
            treeMap2.put(130, byArray4);
            treeMap2.put(135, byArray6);
            treeMap2.put(136, byArray8);
            this.sbh = new StandardBiometricHeader(treeMap2);
        }
        return this.sbh;
    }

    public List<FingerImageInfo> getFingerImageInfos() {
        return this.getSubRecords();
    }

    public void addFingerImageInfo(FingerImageInfo fingerImageInfo) {
        this.add(fingerImageInfo);
    }

    public void removeFingerImageInfo(int n) {
        this.remove(n);
    }
}

