/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.iso19794;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.BiometricDataBlock;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.StandardBiometricHeader;
import com.fis.ekyc.nfc.build_in.eidparser.lds.AbstractListInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.iso19794.IrisBiometricSubtypeInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;

public class IrisInfo
extends AbstractListInfo<IrisBiometricSubtypeInfo>
implements BiometricDataBlock {
    private static final long serialVersionUID = -3415309711643815511L;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private static final int FORMAT_IDENTIFIER = 1229541888;
    private static final int VERSION_NUMBER = 0x30313000;
    private static final int FORMAT_OWNER_VALUE = 257;
    private static final int FORMAT_TYPE_VALUE = 9;
    public static final int IMAGEFORMAT_MONO_RAW = 2;
    public static final int IMAGEFORMAT_RGB_RAW = 4;
    public static final int IMAGEFORMAT_MONO_JPEG = 6;
    public static final int IMAGEFORMAT_RGB_JPEG = 8;
    public static final int IMAGEFORMAT_MONO_JPEG_LS = 10;
    public static final int IMAGEFORMAT_RGB_JPEG_LS = 12;
    public static final int IMAGEFORMAT_MONO_JPEG2000 = 14;
    public static final int IMAGEFORMAT_RGB_JPEG2000 = 16;
    public static final int CAPTURE_DEVICE_UNDEF = 0;
    public static final int ORIENTATION_UNDEF = 0;
    public static final int ORIENTATION_BASE = 1;
    public static final int ORIENTATION_FLIPPED = 2;
    public static final int SCAN_TYPE_UNDEF = 0;
    public static final int SCAN_TYPE_PROGRESSIVE = 1;
    public static final int SCAN_TYPE_INTERLACE_FRAME = 2;
    public static final int SCAN_TYPE_INTERLACE_FIELD = 3;
    public static final int SCAN_TYPE_CORRECTED = 4;
    public static final int IROCC_UNDEF = 0;
    public static final int IROCC_PROCESSED = 1;
    public static final int IROCC_ZEROFILL = 0;
    public static final int IROC_UNITFILL = 1;
    public static final int INTENSITY_DEPTH_UNDEF = 0;
    public static final int TRANS_UNDEF = 0;
    public static final int TRANS_STD = 1;
    public static final int IRBNDY_UNDEF = 0;
    public static final int IRBNDY_PROCESSED = 1;
    private long recordLength;
    private int captureDeviceId;
    private int horizontalOrientation;
    private int verticalOrientation;
    private int scanType;
    private int irisOcclusion;
    private int occlusionFilling;
    private int boundaryExtraction;
    private int irisDiameter;
    private int imageFormat;
    private int rawImageWidth;
    private int rawImageHeight;
    private int intensityDepth;
    private int imageTransformation;
    private byte[] deviceUniqueId;
    private StandardBiometricHeader sbh;

    public IrisInfo(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, byte[] byArray, List<IrisBiometricSubtypeInfo> list) {
        this(null, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, byArray, list);
    }

    public IrisInfo(StandardBiometricHeader standardBiometricHeader, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, byte[] byArray, List<IrisBiometricSubtypeInfo> list) {
        ((IrisInfo)object).sbh = standardBiometricHeader;
        if (list != null) {
            IrisInfo irisInfo = object;
            irisInfo.captureDeviceId = n;
            irisInfo.horizontalOrientation = n2;
            irisInfo.verticalOrientation = n3;
            irisInfo.scanType = n4;
            irisInfo.irisOcclusion = n5;
            irisInfo.occlusionFilling = n6;
            irisInfo.boundaryExtraction = n7;
            irisInfo.irisDiameter = n8;
            irisInfo.imageFormat = n9;
            irisInfo.rawImageWidth = n10;
            irisInfo.rawImageHeight = n11;
            irisInfo.intensityDepth = n12;
            irisInfo.imageTransformation = n13;
            long l = 45L;
            long l2 = 0L;
            for (IrisBiometricSubtypeInfo irisBiometricSubtypeInfo : list) {
                l2 = irisBiometricSubtypeInfo.getRecordLength() + l2;
                ((AbstractListInfo)object).add(irisBiometricSubtypeInfo);
            }
            if (byArray != null && byArray.length == 16) {
                IrisInfo irisInfo2 = object;
                IrisInfo irisInfo3 = object;
                byte[] byArray2 = new byte[16];
                Object object = byArray2;
                irisInfo3.deviceUniqueId = byArray2;
                int n14 = byArray.length;
                System.arraycopy(byArray, 0, object, 0, n14);
                irisInfo2.recordLength = l2 + l;
                return;
            }
            throw new IllegalArgumentException("deviceUniqueId invalid");
        }
        throw new IllegalArgumentException("Null irisBiometricSubtypeInfos");
    }

    public IrisInfo(InputStream inputStream) {
        this(null, inputStream);
    }

    public IrisInfo(StandardBiometricHeader standardBiometricHeader, InputStream inputStream) {
        IrisInfo irisInfo = this;
        irisInfo.sbh = standardBiometricHeader;
        irisInfo.readObject(inputStream);
    }

    private int getBiometricSubtype() {
        int n = 0;
        Iterator iterator = this.getSubRecords().iterator();
        while (iterator.hasNext()) {
            n &= ((IrisBiometricSubtypeInfo)iterator.next()).getBiometricSubtype();
        }
        return n;
    }

    @Override
    public void readObject(InputStream inputStream) {
        DataInputStream dataInputStream;
        if (inputStream instanceof DataInputStream) {
            dataInputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream2;
            dataInputStream = dataInputStream2;
            dataInputStream2 = new DataInputStream(inputStream);
        }
        int n = dataInputStream.readInt();
        if (n == 1229541888) {
            n = dataInputStream.readInt();
            if (n == 0x30313000) {
                long l;
                DataInputStream dataInputStream3 = dataInputStream;
                DataInputStream dataInputStream4 = dataInputStream;
                long l2 = dataInputStream4.readInt();
                this.recordLength = l = l2;
                l = 45L;
                long l3 = l2 - 45L;
                this.captureDeviceId = dataInputStream4.readUnsignedShort();
                int n2 = dataInputStream3.readUnsignedByte();
                int n3 = dataInputStream3.readUnsignedShort();
                if ((long)n3 == l) {
                    IrisInfo irisInfo = this;
                    int n4 = dataInputStream.readUnsignedShort();
                    this.horizontalOrientation = n4 & 3;
                    this.verticalOrientation = (n4 & 0xC) >> 2;
                    this.scanType = (n4 & 0x70) >> 4;
                    this.irisOcclusion = (n4 & 0x80) >> 7;
                    this.occlusionFilling = (n4 & 0x100) >> 8;
                    this.boundaryExtraction = (n4 & 0x200) >> 9;
                    this.irisDiameter = dataInputStream.readUnsignedShort();
                    this.imageFormat = dataInputStream.readUnsignedShort();
                    this.rawImageWidth = dataInputStream.readUnsignedShort();
                    this.rawImageHeight = dataInputStream.readUnsignedShort();
                    this.intensityDepth = dataInputStream.readUnsignedByte();
                    irisInfo.imageTransformation = dataInputStream.readUnsignedByte();
                    byte[] byArray = new byte[16];
                    irisInfo.deviceUniqueId = byArray;
                    dataInputStream.readFully(byArray);
                    long l4 = 0L;
                    for (int k = 0; k < n2; ++k) {
                        IrisBiometricSubtypeInfo irisBiometricSubtypeInfo = new IrisBiometricSubtypeInfo(inputStream, this.imageFormat);
                        l4 = irisBiometricSubtypeInfo.getRecordLength() + l4;
                        this.add(irisBiometricSubtypeInfo);
                    }
                    if (l3 != l4) {
                        LOGGER.warning("ConstructedDataLength and dataLength differ: dataLength = " + l3 + ", constructedDataLength = " + l4);
                    }
                    return;
                }
                throw new IllegalArgumentException("Expected header length " + l + ", found " + n3);
            }
            throw new IllegalArgumentException(h.a(n, a.a("'010' version number expected! Found ")));
        }
        throw new IllegalArgumentException(h.a(n, a.a("'IIR' marker expected! Found ")));
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        Object object;
        int n = 45;
        int n2 = 0;
        List list = ((AbstractListInfo)((Object)iterator)).getSubRecords();
        for (IrisBiometricSubtypeInfo irisBiometricSubtypeInfo : list) {
            long l = n2;
            n2 = (int)(irisBiometricSubtypeInfo.getRecordLength() + l);
        }
        n2 = n + n2;
        if (outputStream instanceof DataOutputStream) {
            object = (DataOutputStream)outputStream;
        } else {
            DataOutputStream dataOutputStream;
            object = dataOutputStream;
            dataOutputStream = new DataOutputStream(outputStream);
        }
        Object object2 = object;
        ((DataOutputStream)object2).writeInt(1229541888);
        ((DataOutputStream)object2).writeInt(0x30313000);
        ((DataOutputStream)object).writeInt(n2);
        ((DataOutputStream)object).writeShort(((IrisInfo)((Object)iterator)).captureDeviceId);
        ((DataOutputStream)object).writeByte(list.size());
        ((DataOutputStream)object).writeShort(n);
        ((DataOutputStream)object).writeShort(((IrisInfo)((Object)iterator)).horizontalOrientation & 3 | 0 | ((IrisInfo)((Object)iterator)).verticalOrientation << 2 & 0xC | ((IrisInfo)((Object)iterator)).scanType << 4 & 0x70 | ((IrisInfo)((Object)iterator)).irisOcclusion << 7 & 0x80 | ((IrisInfo)((Object)iterator)).occlusionFilling << 8 & 0x100 | ((IrisInfo)((Object)iterator)).boundaryExtraction << 9 & 0x200);
        ((DataOutputStream)object).writeShort(((IrisInfo)((Object)iterator)).irisDiameter);
        ((DataOutputStream)object).writeShort(((IrisInfo)((Object)iterator)).imageFormat);
        ((DataOutputStream)object).writeShort(((IrisInfo)((Object)iterator)).rawImageWidth);
        ((DataOutputStream)object).writeShort(((IrisInfo)((Object)iterator)).rawImageHeight);
        ((DataOutputStream)object).writeByte(((IrisInfo)((Object)iterator)).intensityDepth);
        ((DataOutputStream)object).writeByte(((IrisInfo)((Object)iterator)).imageTransformation);
        ((OutputStream)object).write(((IrisInfo)((Object)iterator)).deviceUniqueId);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((IrisBiometricSubtypeInfo)iterator.next()).writeObject(outputStream);
        }
    }

    public int getCaptureDeviceId() {
        return this.captureDeviceId;
    }

    public int getHorizontalOrientation() {
        return this.horizontalOrientation;
    }

    public int getVerticalOrientation() {
        return this.verticalOrientation;
    }

    public int getScanType() {
        return this.scanType;
    }

    public int getIrisOcclusion() {
        return this.irisOcclusion;
    }

    public int getOcclusionFilling() {
        return this.occlusionFilling;
    }

    public int getBoundaryExtraction() {
        return this.boundaryExtraction;
    }

    public int getIrisDiameter() {
        return this.irisDiameter;
    }

    public int getImageFormat() {
        return this.imageFormat;
    }

    public int getRawImageWidth() {
        return this.rawImageWidth;
    }

    public int getRawImageHeight() {
        return this.rawImageHeight;
    }

    public int getIntensityDepth() {
        return this.intensityDepth;
    }

    public int getImageTransformation() {
        return this.imageTransformation;
    }

    public byte[] getDeviceUniqueId() {
        return this.deviceUniqueId;
    }

    @Override
    public StandardBiometricHeader getStandardBiometricHeader() {
        if (this.sbh == null) {
            TreeMap<Integer, byte[]> treeMap;
            byte[] byArray = new byte[1];
            byte[] byArray2 = byArray;
            byArray[0] = 8;
            byte[] byArray3 = new byte[1];
            byte[] byArray4 = byArray3;
            byArray3[0] = (byte)this.getBiometricSubtype();
            byte[] byArray5 = new byte[2];
            byte[] byArray6 = byArray5;
            byArray5[0] = 1;
            byArray5[1] = 1;
            byte[] byArray7 = new byte[2];
            byte[] byArray8 = byArray7;
            byArray7[0] = 0;
            byArray7[1] = 9;
            TreeMap<Integer, byte[]> treeMap2 = treeMap;
            new TreeMap<Integer, byte[]>().put(129, byArray2);
            treeMap2.put(130, byArray4);
            treeMap2.put(135, byArray6);
            treeMap2.put(136, byArray8);
            this.sbh = new StandardBiometricHeader(treeMap2);
        }
        return this.sbh;
    }

    @Override
    public int hashCode() {
        IrisInfo irisInfo = this;
        int n = ((super.hashCode() * 31 + this.boundaryExtraction) * 31 + this.captureDeviceId) * 31;
        long l = this.recordLength;
        n = (((((((((((Arrays.hashCode(irisInfo.deviceUniqueId) + n) * 31 + this.horizontalOrientation) * 31 + this.imageFormat) * 31 + this.imageTransformation) * 31 + this.intensityDepth) * 31 + this.irisDiameter) * 31 + this.irisOcclusion) * 31 + this.occlusionFilling) * 31 + this.rawImageHeight) * 31 + this.rawImageWidth) * 31 + (int)(l ^ l >>> 32)) * 31;
        StandardBiometricHeader standardBiometricHeader = irisInfo.sbh;
        int n2 = standardBiometricHeader == null ? 0 : standardBiometricHeader.hashCode();
        return ((n + n2) * 31 + this.scanType) * 31 + this.verticalOrientation;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (IrisInfo)object;
        StandardBiometricHeader standardBiometricHeader = this.sbh;
        if (standardBiometricHeader == null ? ((IrisInfo)object).sbh != null : !standardBiometricHeader.equals(((IrisInfo)object).sbh)) {
            return false;
        }
        if (this.boundaryExtraction != ((IrisInfo)object).boundaryExtraction) {
            return false;
        }
        if (this.captureDeviceId != ((IrisInfo)object).captureDeviceId) {
            return false;
        }
        if (!Arrays.equals(this.deviceUniqueId, ((IrisInfo)object).deviceUniqueId)) {
            return false;
        }
        if (this.horizontalOrientation != ((IrisInfo)object).horizontalOrientation) {
            return false;
        }
        if (this.imageFormat != ((IrisInfo)object).imageFormat) {
            return false;
        }
        if (this.imageTransformation != ((IrisInfo)object).imageTransformation) {
            return false;
        }
        if (this.intensityDepth != ((IrisInfo)object).intensityDepth) {
            return false;
        }
        if (this.irisDiameter != ((IrisInfo)object).irisDiameter) {
            return false;
        }
        if (this.irisOcclusion != ((IrisInfo)object).irisOcclusion) {
            return false;
        }
        if (this.occlusionFilling != ((IrisInfo)object).occlusionFilling) {
            return false;
        }
        if (this.rawImageHeight != ((IrisInfo)object).rawImageHeight) {
            return false;
        }
        if (this.rawImageWidth != ((IrisInfo)object).rawImageWidth) {
            return false;
        }
        if (this.recordLength != ((IrisInfo)object).recordLength) {
            return false;
        }
        if (this.scanType != ((IrisInfo)object).scanType) {
            return false;
        }
        return this.verticalOrientation == ((IrisInfo)object).verticalOrientation;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("IrisInfo [");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public List<IrisBiometricSubtypeInfo> getIrisBiometricSubtypeInfos() {
        return this.getSubRecords();
    }

    public void addIrisBiometricSubtypeInfo(IrisBiometricSubtypeInfo irisBiometricSubtypeInfo) {
        this.add(irisBiometricSubtypeInfo);
    }

    public void removeIrisBiometricSubtypeInfo(int n) {
        this.remove(n);
    }
}

