/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.scuba.smartcards;

import b.a;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class CommandAPDU
implements Serializable {
    private static final long serialVersionUID = 398698301286670877L;
    private static final int MAX_APDU_SIZE = 65544;
    private byte[] apdu;
    private transient int nc;
    private transient int ne;
    private transient int dataOffset;

    public CommandAPDU(byte[] byArray) {
        this.apdu = (byte[])byArray.clone();
        this.parse();
    }

    public CommandAPDU(byte[] byArray, int n, int n2) {
        CommandAPDU commandAPDU = object;
        CommandAPDU commandAPDU2 = object;
        CommandAPDU commandAPDU3 = object;
        commandAPDU3.checkArrayBounds(byArray, n, n2);
        byte[] byArray2 = new byte[n2];
        Object object = byArray2;
        commandAPDU2.apdu = byArray2;
        System.arraycopy(byArray, n, object, 0, n2);
        commandAPDU.parse();
    }

    private void checkArrayBounds(byte[] byArray, int n, int n2) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        if (n < 0 || n2 < 0) break block5;
                        if (byArray != null) break block6;
                        if (n != 0 && n2 != 0) {
                            throw new IllegalArgumentException("offset and length must be 0 if array is null");
                        }
                        break block7;
                    }
                    if (n > byArray.length - n2) break block8;
                }
                return;
            }
            throw new IllegalArgumentException("Offset plus length exceed array size");
        }
        throw new IllegalArgumentException("Offset and length must not be negative");
    }

    public CommandAPDU(ByteBuffer byteBuffer) {
        CommandAPDU commandAPDU = object;
        CommandAPDU commandAPDU2 = object;
        byte[] byArray = new byte[byteBuffer.remaining()];
        Object object = byArray;
        commandAPDU2.apdu = byArray;
        byteBuffer.get((byte[])object);
        commandAPDU.parse();
    }

    public CommandAPDU(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null, 0, 0, 0);
    }

    public CommandAPDU(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, null, 0, 0, n5);
    }

    public CommandAPDU(int n, int n2, int n3, int n4, byte[] byArray) {
        int n5 = CommandAPDU.arrayLength(byArray);
        this(n, n2, n3, n4, byArray, 0, n5, 0);
    }

    public CommandAPDU(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        this(n, n2, n3, n4, byArray, n5, n6, 0);
    }

    public CommandAPDU(int n, int n2, int n3, int n4, byte[] byArray, int n5) {
        int n6 = CommandAPDU.arrayLength(byArray);
        this(n, n2, n3, n4, byArray, 0, n6, n5);
    }

    private static int arrayLength(byte[] byArray) {
        return byArray != null ? byArray.length : 0;
    }

    private void parse() {
        byte[] byArray = this.apdu;
        if (this.apdu.length >= 4) {
            if (byArray.length == 4) {
                return;
            }
            int n = byArray[4] & 0xFF;
            if (byArray.length == 5) {
                if (n == 0) {
                    n = 256;
                }
                this.ne = n;
                return;
            }
            if (n != 0) {
                if (byArray.length == n + 5) {
                    CommandAPDU commandAPDU = this;
                    commandAPDU.nc = n;
                    commandAPDU.dataOffset = 5;
                    return;
                }
                if (byArray.length == n + 6) {
                    CommandAPDU commandAPDU = this;
                    commandAPDU.nc = n;
                    commandAPDU.dataOffset = 5;
                    int n2 = byArray[byArray.length - 1] & 0xFF;
                    if (n2 == 0) {
                        n2 = 256;
                    }
                    this.ne = n2;
                    return;
                }
                throw new IllegalArgumentException(a.a("Invalid APDU: length=").append(this.apdu.length).append(", b1=").append(n).toString());
            }
            if (byArray.length >= 7) {
                int n3 = (byArray[5] & 0xFF) << 8 | byArray[6] & 0xFF;
                if (byArray.length == 7) {
                    if (n3 == 0) {
                        n3 = 65536;
                    }
                    this.ne = n3;
                    return;
                }
                if (n3 != 0) {
                    if (byArray.length == n3 + 7) {
                        CommandAPDU commandAPDU = this;
                        commandAPDU.nc = n3;
                        commandAPDU.dataOffset = 7;
                        return;
                    }
                    if (byArray.length == n3 + 9) {
                        CommandAPDU commandAPDU = this;
                        commandAPDU.nc = n3;
                        commandAPDU.dataOffset = 7;
                        n = byArray.length - 2;
                        int n4 = (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
                        if (n4 == 0) {
                            n4 = 65536;
                        }
                        this.ne = n4;
                        return;
                    }
                    throw new IllegalArgumentException(a.a("Invalid APDU: length=").append(this.apdu.length).append(", b1=").append(n).append(", b2||b3=").append(n3).toString());
                }
                throw new IllegalArgumentException(a.a("Invalid APDU: length=").append(this.apdu.length).append(", b1=").append(n).append(", b2||b3=").append(n3).toString());
            }
            throw new IllegalArgumentException(a.a("Invalid APDU: length=").append(this.apdu.length).append(", b1=").append(n).toString());
        }
        throw new IllegalArgumentException("apdu must be at least 4 bytes long");
    }

    public CommandAPDU(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6, int n7) {
        CommandAPDU commandAPDU = object;
        commandAPDU.checkArrayBounds(byArray, n5, n6);
        if (n6 <= 65535) {
            if (n7 >= 0) {
                if (n7 <= 65536) {
                    Object object;
                    CommandAPDU commandAPDU2 = object;
                    commandAPDU2.ne = n7;
                    commandAPDU2.nc = n6;
                    if (n6 == 0) {
                        if (n7 == 0) {
                            ((CommandAPDU)object).apdu = new byte[4];
                            ((CommandAPDU)object).setHeader(n, n2, n3, n4);
                        } else if (n7 <= 256) {
                            byte by = n7 != 256 ? (byte)n7 : (byte)0;
                            CommandAPDU commandAPDU3 = object;
                            ((CommandAPDU)object).apdu = new byte[5];
                            commandAPDU3.setHeader(n, n2, n3, n4);
                            commandAPDU3.apdu[4] = by;
                        } else {
                            byte by;
                            if (n7 == 65536) {
                                by = 0;
                                n5 = 0;
                            } else {
                                int n8 = n7;
                                by = (byte)(n8 >> 8);
                                n5 = (byte)n8;
                            }
                            CommandAPDU commandAPDU4 = object;
                            ((CommandAPDU)object).apdu = new byte[7];
                            commandAPDU4.setHeader(n, n2, n3, n4);
                            commandAPDU4.apdu[5] = by;
                            commandAPDU4.apdu[6] = n5;
                        }
                    } else if (n7 == 0) {
                        if (n6 <= 255) {
                            CommandAPDU commandAPDU5 = object;
                            ((CommandAPDU)object).apdu = new byte[n6 + 5];
                            commandAPDU5.setHeader(n, n2, n3, n4);
                            object = commandAPDU5.apdu;
                            commandAPDU5.apdu[4] = (byte)n6;
                            commandAPDU5.dataOffset = 5;
                            System.arraycopy(byArray, n5, object, 5, n6);
                        } else {
                            CommandAPDU commandAPDU6 = object;
                            ((CommandAPDU)object).apdu = new byte[n6 + 7];
                            commandAPDU6.setHeader(n, n2, n3, n4);
                            object = commandAPDU6.apdu;
                            object[4] = false;
                            object[5] = (byte)(n6 >> 8);
                            commandAPDU6.apdu[6] = (byte)n6;
                            commandAPDU6.dataOffset = 7;
                            System.arraycopy(byArray, n5, object, 7, n6);
                        }
                    } else if (n6 <= 255 && n7 <= 256) {
                        CommandAPDU commandAPDU7 = object;
                        CommandAPDU commandAPDU8 = object;
                        ((CommandAPDU)object).apdu = new byte[n6 + 6];
                        commandAPDU8.setHeader(n, n2, n3, n4);
                        object = commandAPDU8.apdu;
                        commandAPDU8.apdu[4] = (byte)n6;
                        commandAPDU8.dataOffset = 5;
                        System.arraycopy(byArray, n5, object, 5, n6);
                        object = commandAPDU7.apdu;
                        n = commandAPDU7.apdu.length - 1;
                        n2 = n7 != 256 ? (int)((byte)n7) : 0;
                        object[n] = n2;
                    } else {
                        CommandAPDU commandAPDU9 = object;
                        ((CommandAPDU)object).apdu = new byte[n6 + 9];
                        commandAPDU9.setHeader(n, n2, n3, n4);
                        byte[] byArray2 = commandAPDU9.apdu;
                        byArray2[4] = 0;
                        byArray2[5] = (byte)(n6 >> 8);
                        commandAPDU9.apdu[6] = (byte)n6;
                        commandAPDU9.dataOffset = 7;
                        System.arraycopy(byArray, n5, byArray2, 7, n6);
                        if (n7 != 65536) {
                            object = ((CommandAPDU)object).apdu;
                            int n9 = ((Object)object).length - 2;
                            object[n9] = (byte)(n7 >> 8);
                            ((CommandAPDU)object).apdu[++n9] = (byte)n7;
                        }
                    }
                    return;
                }
                throw new IllegalArgumentException("ne is too large");
            }
            throw new IllegalArgumentException("ne must not be negative");
        }
        throw new IllegalArgumentException("dataLength is too large");
    }

    private void setHeader(int n, int n2, int n3, int n4) {
        Object object = ((CommandAPDU)object).apdu;
        object[0] = (byte)n;
        object[1] = (byte)n2;
        object[2] = (byte)n3;
        ((CommandAPDU)object).apdu[3] = (byte)n4;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        this.apdu = (byte[])objectInputStream.readUnshared();
        this.parse();
    }

    public int getCLA() {
        return this.apdu[0] & 0xFF;
    }

    public int getINS() {
        return this.apdu[1] & 0xFF;
    }

    public int getP1() {
        return this.apdu[2] & 0xFF;
    }

    public int getP2() {
        return this.apdu[3] & 0xFF;
    }

    public int getNc() {
        return this.nc;
    }

    public byte[] getData() {
        int n = this.nc;
        byte[] byArray = new byte[n];
        System.arraycopy(this.apdu, this.dataOffset, byArray, 0, n);
        return byArray;
    }

    public int getNe() {
        return this.ne;
    }

    public byte[] getBytes() {
        return (byte[])this.apdu.clone();
    }

    public String toString() {
        return a.a("CommmandAPDU: ").append(this.apdu.length).append(" bytes, nc=").append(this.nc).append(", ne=").append(this.ne).toString();
    }

    public boolean equals(Object object) {
        if (commandAPDU2 == object) {
            return true;
        }
        if (!(object instanceof CommandAPDU)) {
            return false;
        }
        CommandAPDU commandAPDU = commandAPDU2;
        CommandAPDU commandAPDU2 = (CommandAPDU)object;
        return Arrays.equals(commandAPDU.apdu, commandAPDU2.apdu);
    }

    public int hashCode() {
        return Arrays.hashCode(this.apdu);
    }
}

