/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.scuba.tlv;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Stack;

class TLVInputState
implements Cloneable {
    private Stack<TLStruct> state;
    private boolean isAtStartOfTag;
    private boolean isAtStartOfLength;
    private boolean isReadingValue;

    public TLVInputState() {
        Stack stack;
        Cloneable cloneable = stack;
        stack = new Stack();
        v1.state = cloneable;
        v1.isAtStartOfTag = true;
        v1.isAtStartOfLength = false;
        v1.isReadingValue = false;
    }

    private TLVInputState(Stack<TLStruct> stack, boolean bl, boolean bl2, boolean bl3) {
        this.state = stack;
        this.isAtStartOfTag = bl;
        this.isAtStartOfLength = bl2;
        this.isReadingValue = bl3;
    }

    public boolean isAtStartOfTag() {
        return this.isAtStartOfTag;
    }

    public boolean isAtStartOfLength() {
        return this.isAtStartOfLength;
    }

    public boolean isProcessingValue() {
        return this.isReadingValue;
    }

    public int getTag() {
        if (!((AbstractCollection)this.state).isEmpty()) {
            return this.state.peek().getTag();
        }
        throw new IllegalStateException("Tag not yet read.");
    }

    public int getLength() {
        if (!((AbstractCollection)this.state).isEmpty()) {
            return this.state.peek().getLength();
        }
        throw new IllegalStateException("Length not yet known.");
    }

    public int getValueBytesProcessed() {
        return this.state.peek().getValueBytesProcessed();
    }

    public int getValueBytesLeft() {
        if (!((AbstractCollection)((TLVInputState)cloneable).state).isEmpty()) {
            Cloneable cloneable = ((TLVInputState)cloneable).state.peek();
            return ((TLStruct)cloneable).getLength() - ((TLStruct)cloneable).getValueBytesProcessed();
        }
        throw new IllegalStateException("Length of value is unknown.");
    }

    public void setTagProcessed(int n, int n2) {
        TLStruct tLStruct;
        TLStruct tLStruct2 = tLStruct;
        tLStruct = new TLStruct(n);
        if (!((AbstractCollection)this.state).isEmpty()) {
            this.state.peek().updateValueBytesProcessed(n2);
        }
        this.state.push(tLStruct2);
        this.isAtStartOfTag = false;
        this.isAtStartOfLength = true;
        this.isReadingValue = false;
    }

    public void setDummyLengthProcessed() {
        TLVInputState tLVInputState = this;
        tLVInputState.isAtStartOfTag = false;
        tLVInputState.isAtStartOfLength = false;
        tLVInputState.isReadingValue = true;
    }

    public void setLengthProcessed(int n, int n2) {
        if (n >= 0) {
            TLVInputState tLVInputState = this;
            TLStruct tLStruct = tLVInputState.state.pop();
            if (!((AbstractCollection)tLVInputState.state).isEmpty()) {
                this.state.peek().updateValueBytesProcessed(n2);
            }
            tLStruct.setLength(n);
            this.state.push(tLStruct);
            this.isAtStartOfTag = false;
            this.isAtStartOfLength = false;
            this.isReadingValue = true;
            return;
        }
        throw new IllegalArgumentException(h.a.a(n, new StringBuilder().append("Cannot set negative length (length = ").append(n).append(", 0x"), " for tag ").append(Integer.toHexString(this.getTag())).append(").").toString());
    }

    public void updateValueBytesProcessed(int n) {
        if (((AbstractCollection)this.state).isEmpty()) {
            return;
        }
        TLStruct tLStruct = this.state.peek();
        int n2 = tLStruct.getLength() - tLStruct.getValueBytesProcessed();
        if (n <= n2) {
            TLStruct tLStruct2 = tLStruct;
            tLStruct2.updateValueBytesProcessed(n);
            n = tLStruct2.getLength();
            if (tLStruct2.getValueBytesProcessed() == n) {
                this.state.pop();
                this.updateValueBytesProcessed(n);
                this.isAtStartOfTag = true;
                this.isAtStartOfLength = false;
                this.isReadingValue = false;
            } else {
                TLVInputState tLVInputState = this;
                tLVInputState.isAtStartOfTag = false;
                tLVInputState.isAtStartOfLength = false;
                tLVInputState.isReadingValue = true;
            }
            return;
        }
        throw new IllegalArgumentException("Cannot process " + n + " bytes! Only " + n2 + " bytes left in this TLV object " + tLStruct);
    }

    public Object clone() {
        int n;
        Stack<TLStruct> stack;
        Stack<TLStruct> stack2 = stack;
        stack = new Stack<TLStruct>();
        for (n = 0; n < ((AbstractCollection)this.state).size(); n += 1) {
            ((AbstractCollection)stack2).add((TLStruct)((TLStruct)((AbstractList)this.state).get(n)).clone());
        }
        TLVInputState tLVInputState = this;
        boolean bl = tLVInputState.isAtStartOfTag;
        n = tLVInputState.isAtStartOfLength ? 1 : 0;
        boolean bl2 = tLVInputState.isReadingValue;
        return new TLVInputState(stack2, bl, n != 0, bl2);
    }

    public String toString() {
        return ((Object)this.state).toString();
    }

    public class TLStruct
    implements Cloneable {
        private int tag;
        private int length;
        private int valueBytesRead;

        public TLStruct(int n) {
            this.tag = n;
            this.length = Integer.MAX_VALUE;
            this.valueBytesRead = 0;
        }

        public void setLength(int n) {
            this.length = n;
        }

        public int getTag() {
            return this.tag;
        }

        public int getLength() {
            return this.length;
        }

        public int getValueBytesProcessed() {
            return this.valueBytesRead;
        }

        public void updateValueBytesProcessed(int n) {
            this.valueBytesRead += n;
        }

        public Object clone() {
            TLStruct tLStruct;
            TLStruct tLStruct2 = tLStruct;
            TLStruct tLStruct3 = cloneable;
            TLStruct tLStruct4 = cloneable;
            TLStruct tLStruct5 = cloneable;
            Cloneable cloneable = tLStruct5.TLVInputState.this;
            tLStruct2(tLStruct5.tag);
            tLStruct2.length = tLStruct4.length;
            tLStruct.valueBytesRead = tLStruct3.valueBytesRead;
            return tLStruct;
        }

        public String toString() {
            StringBuilder stringBuilder = a.a("[TLStruct ");
            return b.a(h.a.a(this.tag, stringBuilder, ", ").append(this.length).append(", "), this.valueBytesRead, "]");
        }
    }
}

