/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.capturesdk.tflite;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.ekyc.KalapaSDK;
import vn.kalapa.ekyc.capturesdk.tflite.BoundingBox;

@SourceDebugExtension(value={"SMAP\nOverlayView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverlayView.kt\nvn/kalapa/ekyc/capturesdk/tflite/OverlayView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1855#2,2:84\n*S KotlinDebug\n*F\n+ 1 OverlayView.kt\nvn/kalapa/ekyc/capturesdk/tflite/OverlayView\n*L\n51#1:84,2\n*E\n"})
public final class OverlayView
extends View {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int BOUNDING_RECT_TEXT_PADDING = 8;
    @NotNull
    private List<BoundingBox> results;
    @NotNull
    private Paint boxPaint;
    @NotNull
    private Paint textBackgroundPaint;
    @NotNull
    private Paint textPaint;
    @NotNull
    private Rect bounds;

    public OverlayView(@Nullable Context context, @Nullable AttributeSet attributeSet) {
        OverlayView overlayView = this;
        super(context, attributeSet);
        overlayView.results = CollectionsKt.emptyList();
        overlayView.boxPaint = new Paint();
        overlayView.textBackgroundPaint = new Paint();
        overlayView.textPaint = new Paint();
        overlayView.bounds = new Rect();
        overlayView.initPaints();
    }

    private final void initPaints() {
        OverlayView overlayView = this;
        overlayView.textBackgroundPaint.setColor(-16777216);
        overlayView.textBackgroundPaint.setStyle(Paint.Style.FILL);
        overlayView.textBackgroundPaint.setTextSize(50.0f);
        overlayView.textPaint.setColor(-1);
        overlayView.textPaint.setStyle(Paint.Style.FILL);
        overlayView.textPaint.setTextSize(50.0f);
        overlayView.boxPaint.setColor(Color.parseColor((String)KalapaSDK.Companion.getConfig$kalapa_release().getMainColor()));
        overlayView.boxPaint.setStrokeWidth(8.0f);
        overlayView.boxPaint.setStyle(Paint.Style.STROKE);
    }

    public final void clear() {
        OverlayView overlayView = this;
        overlayView.results = CollectionsKt.emptyList();
        overlayView.textPaint.reset();
        overlayView.textBackgroundPaint.reset();
        overlayView.boxPaint.reset();
        overlayView.invalidate();
        overlayView.initPaints();
    }

    public void draw(@NotNull Canvas canvas) {
        OverlayView overlayView = this;
        Canvas canvas2 = canvas;
        Intrinsics.checkNotNullParameter((Object)canvas2, (String)"canvas");
        super.draw(canvas2);
        for (BoundingBox f8 : overlayView.results) {
            float n;
            float f2 = f8.getX1() * (float)this.getWidth();
            float f3 = f8.getY1() * (float)this.getHeight();
            float f4 = n = f3;
            float f5 = n;
            OverlayView overlayView2 = this;
            float f6 = n;
            BoundingBox boundingBox = f8;
            float f7 = boundingBox.getX2() * (float)this.getWidth();
            n = boundingBox.getY2() * (float)this.getHeight();
            Paint f9 = this.boxPaint;
            canvas.drawRect(f2, f6, f7, n, f9);
            String object = f8.getClsName();
            int n2 = object.length();
            f9 = this.bounds;
            overlayView2.textBackgroundPaint.getTextBounds(object, 0, n2, (Rect)f9);
            n2 = this.bounds.height();
            float f10 = 8;
            float f11 = f2 + (float)overlayView2.bounds.width() + f10;
            n = f5 + (float)n2 + f10;
            f9 = this.textBackgroundPaint;
            canvas.drawRect(f2, f4, f11, n, f9);
            n = f3 + (float)this.bounds.height();
            f9 = this.textPaint;
            canvas.drawText(object, f2, n, f9);
        }
    }

    public final void setResults(@NotNull List<BoundingBox> list) {
        Intrinsics.checkNotNullParameter(list, (String)"boundingBoxes");
        this.results = list;
        this.invalidate();
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

