package vn.kalapa.ekyc.utils

import android.content.Context

interface KalapaLogger {

    fun logEvent(
        logLevel: KALAPA_LOG_LEVEL,
        action: KALAPA_LOG_ACTION,
        screenId: String,
        data: Map<String?, String?>? = null
    )

    fun endSession(
        data: Map<String?, String?>? = null
    )

}

object LogUtil{
    internal fun logEvent(
        context: Context,
        logLevel: KALAPA_LOG_LEVEL,
        action: KALAPA_LOG_ACTION,
        screenId: String,
        data: Map<String?, String?>? = null
    ) {
        val app = context.applicationContext as? KalapaLogger
        app?.logEvent(
            logLevel,
            action,
            screenId,
            data
        )
    }

    internal fun logEndSession(
        context: Context,
        data: Map<String?, String?>? = null
    ){
        val app = context.applicationContext as? KalapaLogger
        app?.endSession(data)
    }
}