/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.capturesdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.camera.core.ImageAnalysis;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.text.Text;
import com.google.mlkit.vision.text.TextRecognition;
import com.google.mlkit.vision.text.TextRecognizer;
import com.google.mlkit.vision.text.TextRecognizerOptionsInterface;
import com.google.mlkit.vision.text.latin.TextRecognizerOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.R;
import vn.kalapa.ekyc.DialogListener;
import vn.kalapa.ekyc.KalapaSDK;
import vn.kalapa.ekyc.KalapaSDKResultCode;
import vn.kalapa.ekyc.activity.BaseActivity;
import vn.kalapa.ekyc.activity.CameraXActivity;
import vn.kalapa.ekyc.activity.b;
import vn.kalapa.ekyc.activity.c;
import vn.kalapa.ekyc.capturesdk.CameraXMRZActivity;
import vn.kalapa.ekyc.capturesdk.MRZAnalyzer;
import vn.kalapa.ekyc.managers.KLPLanguageManager;
import vn.kalapa.ekyc.nfcsdk.activities.NFCActivity;
import vn.kalapa.ekyc.utils.BitmapUtil;
import vn.kalapa.ekyc.utils.Common;
import vn.kalapa.ekyc.utils.Helpers;
import vn.kalapa.ekyc.utils.KALAPA_LOG_ACTION;
import vn.kalapa.ekyc.utils.KALAPA_LOG_LEVEL;
import vn.kalapa.ekyc.utils.LogUtil;

public final class CameraXMRZActivity
extends CameraXActivity {
    private ImageView ivPreviewImage;
    private TextView tvTitle;
    private TextView tvGuide0;
    private TextView tvGuide1;
    private ImageView ivGuide;
    @NotNull
    private HashMap<String, Integer> idCardNumbersMap = new HashMap();
    private boolean enteredNFCActivity;
    private boolean isProcessingFrame;
    private boolean finishingActivity;

    public CameraXMRZActivity() {
        super(R.layout.activity_camera_x_mrz, null, false, 0, 14, null);
    }

    private final void returnToNFCActivity(String string2) {
        if (!this.enteredNFCActivity) {
            CameraXMRZActivity cameraXMRZActivity = this;
            cameraXMRZActivity.enteredNFCActivity = true;
            CameraXMRZActivity cameraXMRZActivity2 = this;
            KALAPA_LOG_LEVEL kALAPA_LOG_LEVEL = KALAPA_LOG_LEVEL.INFO;
            KALAPA_LOG_ACTION kALAPA_LOG_ACTION = KALAPA_LOG_ACTION.MRZ_SUCCESS;
            String string3 = cameraXMRZActivity2.getSCREEN_ID();
            Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"mrz", (Object)string2));
            LogUtil.INSTANCE.logEvent$kalapa_release((Context)cameraXMRZActivity2, kALAPA_LOG_LEVEL, kALAPA_LOG_ACTION, string3, map);
            Intent intent = new Intent((Context)this, NFCActivity.class);
            intent.putExtra("mrz", string2);
            cameraXMRZActivity.startActivity(intent);
            cameraXMRZActivity.finish();
        }
    }

    private final String processFrame(Bitmap bitmap, int n) {
        TextRecognizer textRecognizer = TextRecognition.getClient((TextRecognizerOptionsInterface)TextRecognizerOptions.DEFAULT_OPTIONS);
        Intrinsics.checkNotNullExpressionValue((Object)textRecognizer, (String)"getClient(TextRecognizerOptions.DEFAULT_OPTIONS)");
        BitmapUtil.Companion companion = BitmapUtil.Companion;
        Bitmap bitmap2 = BitmapUtil.Companion.rotateBitmapToStraight$default(companion, bitmap, n, false, 4, null);
        int n2 = bitmap2.getWidth();
        this.isProcessingFrame = true;
        textRecognizer.process(InputImage.fromBitmap((Bitmap)companion.crop(bitmap2, n2, bitmap2.getWidth() * 5 / 8, 0.5f, 0.5f), (int)0)).addOnSuccessListener(arg_0 -> CameraXMRZActivity.processFrame$lambda$0((Function1)new Function1<Text, Unit>(this){
            public final /* synthetic */ CameraXMRZActivity this$0;
            {
                this.this$0 = cameraXMRZActivity;
                super(1);
            }

            public final void invoke(Text object) {
                if (object.getTextBlocks().size() > 0) {
                    for (Text.TextBlock textBlock : object.getTextBlocks()) {
                        String string2 = textBlock.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"line.text");
                        if (!StringsKt.startsWith$default((String)string2, (String)"IDVNM", (boolean)false, (int)2, null)) continue;
                        Helpers.Companion.printLog("CameraXMRZActivity text blocks OK " + textBlock.getText());
                        String string3 = Common.Companion.getIdCardNumberFromMRZ(textBlock.getText());
                        if (string3 == null || string3.length() == 0 || Intrinsics.areEqual((Object)string3, (Object)"-1")) continue;
                        String string4 = textBlock.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"line.text");
                        CameraXMRZActivity.access$returnToNFCActivity(this.this$0, string4);
                    }
                }
                CameraXMRZActivity.access$setProcessingFrame$p(this.this$0, false);
            }
        }, arg_0)).addOnFailureListener(arg_0 -> CameraXMRZActivity.processFrame$lambda$1(this, arg_0));
        while (this.isProcessingFrame) {
            Thread.sleep(100L);
        }
        return "";
    }

    private final void renewSession() {
        this.idCardNumbersMap.clear();
    }

    private static final void processFrame$lambda$0(Function1 function1, Object object) {
        Function1 function12 = function1;
        Intrinsics.checkNotNullParameter((Object)function12, (String)"$tmp0");
        function12.invoke(object);
    }

    private static final void processFrame$lambda$1(CameraXMRZActivity object, Exception exception) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"it");
        LogUtil logUtil = LogUtil.INSTANCE;
        KALAPA_LOG_LEVEL kALAPA_LOG_LEVEL = KALAPA_LOG_LEVEL.ERROR;
        KALAPA_LOG_ACTION kALAPA_LOG_ACTION = KALAPA_LOG_ACTION.MRZ_FAIL;
        String string2 = ((BaseActivity)object).getSCREEN_ID();
        String string3 = "error";
        String string4 = exception.getMessage();
        if (string4 == null) {
            string4 = "";
        }
        CameraXMRZActivity cameraXMRZActivity = object;
        CameraXMRZActivity cameraXMRZActivity2 = object;
        object = MapsKt.mapOf((Pair)TuplesKt.to((Object)string3, (Object)string4));
        logUtil.logEvent$kalapa_release((Context)cameraXMRZActivity2, kALAPA_LOG_LEVEL, kALAPA_LOG_ACTION, string2, (Map<String, String>)object);
        cameraXMRZActivity.isProcessingFrame = false;
        Helpers.Companion.printLog("addOnFailureListener " + exception);
    }

    public static final /* synthetic */ void access$returnToNFCActivity(CameraXMRZActivity cameraXMRZActivity, String string2) {
        cameraXMRZActivity.returnToNFCActivity(string2);
    }

    public static final /* synthetic */ void access$setProcessingFrame$p(CameraXMRZActivity cameraXMRZActivity, boolean bl) {
        cameraXMRZActivity.isProcessingFrame = bl;
    }

    public static final /* synthetic */ void access$setFinishingActivity$p(CameraXMRZActivity cameraXMRZActivity, boolean bl) {
        cameraXMRZActivity.finishingActivity = bl;
    }

    public static final /* synthetic */ String access$processFrame(CameraXMRZActivity cameraXMRZActivity, Bitmap bitmap, int n) {
        return cameraXMRZActivity.processFrame(bitmap, n);
    }

    @Override
    public void setupCustomUI() {
        Object object;
        CameraXMRZActivity cameraXMRZActivity = cameraXMRZActivity5;
        View view = cameraXMRZActivity.findViewById(R.id.iv_action);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.iv_action)");
        cameraXMRZActivity.ivGuide = (ImageView)view;
        View view2 = cameraXMRZActivity.findViewById(R.id.iv_preview_image);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.iv_preview_image)");
        cameraXMRZActivity5.ivPreviewImage = object = (ImageView)view2;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ivPreviewImage");
            object = null;
        }
        CameraXMRZActivity cameraXMRZActivity2 = cameraXMRZActivity5;
        object.setDrawingCacheEnabled(false);
        View view3 = cameraXMRZActivity2.findViewById(R.id.tv_title);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(R.id.tv_title)");
        cameraXMRZActivity2.tvTitle = (TextView)view3;
        View view4 = cameraXMRZActivity2.findViewById(R.id.tv_guide_0);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(R.id.tv_guide_0)");
        cameraXMRZActivity2.tvGuide0 = (TextView)view4;
        View view5 = cameraXMRZActivity2.findViewById(R.id.tv_guide);
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"findViewById(R.id.tv_guide)");
        cameraXMRZActivity2.tvGuide1 = (TextView)view5;
        object = cameraXMRZActivity2.ivGuide;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ivGuide");
            object = null;
        }
        ImageView imageView = object;
        object = KalapaSDK.Companion;
        imageView.setColorFilter(Color.parseColor((String)object.getConfig$kalapa_release().getMainColor()));
        TextView textView = cameraXMRZActivity5.tvTitle;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tvTitle");
            textView = null;
        }
        CameraXMRZActivity cameraXMRZActivity3 = cameraXMRZActivity5;
        KLPLanguageManager kLPLanguageManager = KLPLanguageManager.INSTANCE;
        b.a(cameraXMRZActivity3.getResources(), R.string.klp_mrz_scan_title, "resources.getString(R.string.klp_mrz_scan_title)", kLPLanguageManager, textView);
        textView = cameraXMRZActivity3.tvTitle;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tvTitle");
            textView = null;
        }
        c.a((KalapaSDK.Companion)object, textView);
        textView = cameraXMRZActivity5.tvGuide1;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tvGuide1");
            textView = null;
        }
        CameraXMRZActivity cameraXMRZActivity4 = cameraXMRZActivity5;
        b.a(cameraXMRZActivity4.getResources(), R.string.klp_mrz_scan_note, "resources.getString(R.string.klp_mrz_scan_note)", kLPLanguageManager, textView);
        textView = cameraXMRZActivity4.tvGuide1;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tvGuide1");
            textView = null;
        }
        c.a((KalapaSDK.Companion)object, textView);
        CameraXMRZActivity cameraXMRZActivity5 = cameraXMRZActivity5.tvGuide0;
        if (cameraXMRZActivity5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tvGuide0");
            cameraXMRZActivity5 = null;
        }
        cameraXMRZActivity5.setVisibility(8);
    }

    @Override
    @Nullable
    public ImageAnalysis setupAnalyzer() {
        ImageAnalysis imageAnalysis = new ImageAnalysis.Builder().setBackpressureStrategy(0).build();
        imageAnalysis.setAnalyzer((Executor)this.getCameraExecutor(), (ImageAnalysis.Analyzer)new MRZAnalyzer((Function2<? super Bitmap, ? super Integer, Unit>)new Function2<Bitmap, Integer, Unit>(this){
            public final /* synthetic */ CameraXMRZActivity this$0;
            {
                this.this$0 = cameraXMRZActivity;
                super(2);
            }

            public final void invoke(@NotNull Bitmap bitmap, int n) {
                Intrinsics.checkNotNullParameter((Object)bitmap, (String)"inputImage");
                CameraXMRZActivity.access$processFrame(this.this$0, bitmap, n);
            }
        }));
        return imageAnalysis;
    }

    public void onPause() {
        CameraXMRZActivity cameraXMRZActivity = object;
        super.onPause();
        if (!cameraXMRZActivity.finishingActivity) {
            CameraXMRZActivity cameraXMRZActivity2 = object;
            Object object = KALAPA_LOG_LEVEL.WARN;
            KALAPA_LOG_ACTION kALAPA_LOG_ACTION = KALAPA_LOG_ACTION.SDK_IN_BACKGROUND;
            String string2 = cameraXMRZActivity2.getSCREEN_ID();
            LogUtil.logEvent$kalapa_release$default(LogUtil.INSTANCE, (Context)cameraXMRZActivity2, (KALAPA_LOG_LEVEL)((Object)object), kALAPA_LOG_ACTION, string2, null, 16, null);
        }
    }

    @Override
    public void showEndEkyc() {
        DialogListener dialogListener;
        DialogListener dialogListener2 = dialogListener;
        dialogListener = new DialogListener(this){
            public final /* synthetic */ CameraXMRZActivity this$0;
            {
                this.this$0 = cameraXMRZActivity;
            }

            public void onYes() {
                showEndEkyc.1 v0 = object;
                CameraXMRZActivity.access$setFinishingActivity$p(v0.this$0, true);
                LogUtil logUtil = LogUtil.INSTANCE;
                CameraXMRZActivity cameraXMRZActivity = object.this$0;
                Object object = KALAPA_LOG_LEVEL.WARN;
                KALAPA_LOG_ACTION kALAPA_LOG_ACTION = KALAPA_LOG_ACTION.MRZ_TAP_CANCEL;
                String string2 = cameraXMRZActivity.getSCREEN_ID();
                LogUtil.logEvent$kalapa_release$default(logUtil, (Context)cameraXMRZActivity, (KALAPA_LOG_LEVEL)((Object)object), kALAPA_LOG_ACTION, string2, null, 16, null);
                LogUtil.logEndSession$kalapa_release$default(logUtil, (Context)object.this$0, null, 2, null);
                KalapaSDK.Companion.getHandler$kalapa_release().onError(KalapaSDKResultCode.USER_LEAVE);
                v0.this$0.finish();
            }

            public void onNo() {
            }
        };
        Helpers.Companion.showEndKYC((Activity)this, dialogListener2);
    }

    @Override
    public void onCaptureSuccess(int n) {
    }

    @Override
    public void onResume() {
        CameraXMRZActivity cameraXMRZActivity = this;
        super.onResume();
        cameraXMRZActivity.renewSession();
    }

    @Override
    public void verifyImage() {
    }

    @Override
    public void onBackBtnClicked() {
        this.showEndEkyc();
    }

    @Override
    public void onInfoBtnClicked() {
    }

    @Override
    public void sendError(@Nullable String string2) {
        throw new NotImplementedError("An operation is not implemented: " + "Not yet implemented");
    }

    @Override
    public void sendDone(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"nextAction");
        throw new NotImplementedError("An operation is not implemented: " + "Not yet implemented");
    }
}

