/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.capturesdk.tflite;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.os.SystemClock;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.Delegate;
import org.tensorflow.lite.Interpreter;
import org.tensorflow.lite.gpu.CompatibilityList;
import org.tensorflow.lite.gpu.GpuDelegate;
import org.tensorflow.lite.support.common.FileUtil;
import org.tensorflow.lite.support.common.TensorOperator;
import org.tensorflow.lite.support.common.ops.CastOp;
import org.tensorflow.lite.support.common.ops.NormalizeOp;
import org.tensorflow.lite.support.image.ImageProcessor;
import org.tensorflow.lite.support.image.TensorImage;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;
import vn.kalapa.ekyc.capturesdk.tflite.BoundingBox;
import vn.kalapa.ekyc.capturesdk.tflite.KLPDetectorListener;
import vn.kalapa.ekyc.capturesdk.tflite.OnImageDetectedListener;
import vn.kalapa.ekyc.utils.Helpers;

@SourceDebugExtension(value={"SMAP\nDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Detector.kt\nvn/kalapa/ekyc/capturesdk/tflite/KLPDetector\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,394:1\n1295#2,2:395\n1#3:397\n766#4:398\n857#4,2:399\n1054#4:401\n*S KotlinDebug\n*F\n+ 1 Detector.kt\nvn/kalapa/ekyc/capturesdk/tflite/KLPDetector\n*L\n106#1:395,2\n205#1:398\n205#1:399,2\n264#1:401\n*E\n"})
public final class KLPDetector
implements KLPDetectorListener {
    @NotNull
    private final Context context;
    @NotNull
    private final String modelPath;
    private boolean isAutoCaptureOn;
    @NotNull
    private final OnImageDetectedListener onImageListener;
    private final float INPUT_MEAN;
    private final float INPUT_STANDARD_DEVIATION;
    @NotNull
    private final DataType INPUT_IMAGE_TYPE;
    @NotNull
    private final DataType OUTPUT_IMAGE_TYPE;
    private final float CONFIDENCE_THRESHOLD;
    private final float IOU_THRESHOLD;
    private final float CARD_CONF;
    private final float CORNER_CONF;
    private final long VERIFY_CAPTURING_DURATION;
    private final float MOVEMENT_THRESHOLD;
    @NotNull
    private Interpreter interpreter;
    @NotNull
    private final List<String> labels;
    private int tensorWidth;
    private int tensorHeight;
    private int numChannel;
    private int numElements;
    private long conditionStartTime;
    @Nullable
    private GpuDelegate gpuDelegate;
    @NotNull
    private final TensorImage tensorImage;
    private TensorBuffer outputBuffer;
    private final ImageProcessor imageProcessor;
    @NotNull
    private final Object interpreterLock;
    private boolean detected;
    @Nullable
    private BoundingBox previousBoundingBox;

    public KLPDetector(@NotNull Context object, @NotNull String object2, @NotNull String string2, boolean bl, @NotNull OnImageDetectedListener onImageDetectedListener) {
        Object object3;
        Interpreter interpreter;
        Interpreter.Options options;
        CompatibilityList compatibilityList;
        DataType dataType;
        KLPDetector kLPDetector = object6;
        Intrinsics.checkNotNullParameter((Object)object, (String)"context");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"modelPath");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"labelPath");
        Intrinsics.checkNotNullParameter((Object)onImageDetectedListener, (String)"onImageListener");
        ((KLPDetector)object6).context = object;
        ((KLPDetector)object6).modelPath = object2;
        ((KLPDetector)object6).isAutoCaptureOn = bl;
        kLPDetector.onImageListener = onImageDetectedListener;
        kLPDetector.INPUT_STANDARD_DEVIATION = 255.0f;
        kLPDetector.INPUT_IMAGE_TYPE = dataType = DataType.FLOAT32;
        kLPDetector.OUTPUT_IMAGE_TYPE = dataType;
        kLPDetector.CONFIDENCE_THRESHOLD = 0.3f;
        kLPDetector.IOU_THRESHOLD = 0.5f;
        kLPDetector.CARD_CONF = 0.9f;
        kLPDetector.CORNER_CONF = 0.6f;
        kLPDetector.VERIFY_CAPTURING_DURATION = 500L;
        kLPDetector.MOVEMENT_THRESHOLD = 0.4f;
        kLPDetector.labels = new ArrayList<String>();
        kLPDetector.tensorImage = new TensorImage(dataType);
        kLPDetector.imageProcessor = new ImageProcessor.Builder().add((TensorOperator)new NormalizeOp(((KLPDetector)object6).INPUT_MEAN, 255.0f)).add((TensorOperator)new CastOp(dataType)).build();
        dataType = compatibilityList;
        onImageDetectedListener = options;
        options = new Interpreter.Options();
        if (new CompatibilityList().isDelegateSupportedOnThisDevice()) {
            GpuDelegate gpuDelegate;
            dataType = dataType.getBestOptionsForThisDevice();
            GpuDelegate gpuDelegate2 = gpuDelegate;
            gpuDelegate = new GpuDelegate((GpuDelegate.Options)dataType);
            ((KLPDetector)object6).gpuDelegate = gpuDelegate2;
            onImageDetectedListener.addDelegate((Delegate)gpuDelegate2);
        } else {
            onImageDetectedListener.setNumThreads(4);
        }
        object = FileUtil.loadMappedFile((Context)object, (String)object2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"loadMappedFile(context, modelPath)");
        object2 = interpreter;
        try {
            interpreter = new Interpreter((ByteBuffer)object, (Interpreter.Options)onImageDetectedListener);
        }
        catch (Throwable throwable) {
            Interpreter interpreter2;
            object2 = interpreter2;
            interpreter2 = new Interpreter((MappedByteBuffer)object);
        }
        ((KLPDetector)object6).interpreter = object2;
        object = object2.getInputTensor(0);
        object = object != null ? (Object)object.shape() : null;
        object2 = ((KLPDetector)object6).interpreter.getOutputTensor(0);
        object2 = object2 != null ? (Object)object2.shape() : null;
        if (object != null) {
            Context context = object[1];
            Context context2 = context;
            ((KLPDetector)object6).tensorWidth = (int)context2;
            context2 = object[2];
            ((KLPDetector)object6).tensorHeight = (int)context2;
            if (context == 3) {
                ((KLPDetector)object6).tensorWidth = (int)context2;
                ((KLPDetector)object6).tensorHeight = (int)object[3];
            }
        }
        if (object2 != null) {
            KLPDetector kLPDetector2 = object6;
            Object object4 = object2[1];
            ((KLPDetector)object6).numChannel = (int)object4;
            Object object5 = object2[2];
            kLPDetector2.numElements = (int)object5;
            TensorBuffer tensorBuffer = TensorBuffer.createFixedSize((int[])new int[]{1, (int)object4, (int)object5}, (DataType)((KLPDetector)object6).OUTPUT_IMAGE_TYPE);
            Intrinsics.checkNotNullExpressionValue((Object)tensorBuffer, (String)"createFixedSize(\n       \u2026_IMAGE_TYPE\n            )");
            kLPDetector2.outputBuffer = tensorBuffer;
        }
        ((KLPDetector)object6).loadLabels(string2);
        Object object6 = object3;
        object3 = new Object();
        v11.interpreterLock = object6;
    }

    public /* synthetic */ KLPDetector(Context context, String string2, String string3, boolean bl, OnImageDetectedListener onImageDetectedListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(context, string2, string3, bl, onImageDetectedListener);
    }

    /*
     * Loose catch block
     */
    private final void loadLabels(String object) {
        BufferedReader bufferedReader;
        object = this.context.getAssets().open((String)object);
        Throwable throwable = null;
        BufferedReader bufferedReader2 = bufferedReader;
        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
        Throwable throwable2 = null;
        Iterator iterator = TextStreamsKt.lineSequence((BufferedReader)bufferedReader).iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            KLPDetector kLPDetector = this;
            String string2 = (String)iterator.next();
            kLPDetector.labels.add(string2);
        }
        Object object2 = object;
        BufferedReader bufferedReader3 = bufferedReader2;
        CloseableKt.closeFinally((Closeable)bufferedReader3, throwable2);
        CloseableKt.closeFinally((Closeable)object2, throwable);
        catch (Throwable throwable3) {
            try {
                throw throwable3;
            }
            catch (Throwable throwable4) {
                try {
                    CloseableKt.closeFinally((Closeable)bufferedReader2, (Throwable)throwable3);
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    try {
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        try {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable5);
                            throw throwable6;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private final List<BoundingBox> bestBox(float[] fArray) {
        ArrayList<BoundingBox> arrayList;
        ArrayList<BoundingBox> arrayList2 = arrayList;
        arrayList = new ArrayList<BoundingBox>();
        int n = this.numElements;
        for (int i = 0; i < n; ++i) {
            BoundingBox boundingBox;
            float f;
            KLPDetector kLPDetector = this;
            float f2 = kLPDetector.CONFIDENCE_THRESHOLD;
            int n2 = -1;
            int n3 = 4;
            int n4 = kLPDetector.numElements * n3 + i;
            while (n3 < this.numChannel) {
                float f3;
                f = fArray[n4];
                if (f3 > f2) {
                    int n5;
                    n2 = n5 = n3 - 4;
                    f2 = f;
                }
                ++n3;
                n4 += this.numElements;
            }
            if (!(f2 > this.CONFIDENCE_THRESHOLD)) continue;
            String string2 = this.labels.get(n2);
            float f4 = fArray[i];
            int n6 = this.numElements;
            float f5 = fArray[i + n6];
            float f6 = fArray[n6 * 2 + i];
            f = fArray[n6 * 3 + i];
            float f7 = f6 / 2.0f;
            float f8 = f4 - f7;
            float f9 = f7;
            f7 = f / 2.0f;
            float f10 = f5 - f7;
            float f11 = f4 + f9;
            f7 = f5 + f7;
            if (f8 < 0.0f || f8 > 1.0f || f10 < 0.0f || f10 > 1.0f || f11 < 0.0f || f11 > 1.0f || f7 < 0.0f || f7 > 1.0f) continue;
            BoundingBox boundingBox2 = boundingBox;
            boundingBox = new BoundingBox(f8, f10, f11, f7, f4, f5, f6, f, f2, n2, string2);
            arrayList2.add(boundingBox2);
        }
        return arrayList2.isEmpty() ? null : this.applyNMS(arrayList2);
    }

    private final List<BoundingBox> applyNMS(List<BoundingBox> list) {
        ArrayList<BoundingBox> arrayList;
        list = CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith(list, new Comparator(){

            public final int compare(T t, T t2) {
                return ComparisonsKt.compareValues((Comparable)Float.valueOf(((BoundingBox)t2).getCnf()), (Comparable)Float.valueOf(((BoundingBox)t).getCnf()));
            }
        }));
        ArrayList<BoundingBox> arrayList2 = arrayList;
        arrayList = new ArrayList<BoundingBox>();
        while (list.isEmpty() ^ true) {
            List list2 = list;
            BoundingBox boundingBox = (BoundingBox)CollectionsKt.first((List)list);
            arrayList2.add(boundingBox);
            list2.remove(boundingBox);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                if (!(this.calculateIoU(boundingBox, (BoundingBox)iterator.next()) > this.IOU_THRESHOLD)) continue;
                iterator.remove();
            }
        }
        return arrayList2;
    }

    private final float calculateIoU(BoundingBox boundingBox, BoundingBox boundingBox2) {
        BoundingBox boundingBox3 = boundingBox;
        float f = Math.max(boundingBox3.getX1(), boundingBox2.getX1());
        float f2 = Math.max(boundingBox3.getY1(), boundingBox2.getY1());
        float f3 = Math.min(boundingBox3.getX2(), boundingBox2.getX2());
        f = Math.max(0.0f, f3 - f);
        float f4 = Math.max(0.0f, Math.min(boundingBox3.getY2(), boundingBox2.getY2()) - f2) * f;
        BoundingBox boundingBox4 = boundingBox2;
        BoundingBox boundingBox5 = boundingBox;
        f = boundingBox5.getW();
        f = boundingBox5.getH() * f;
        float f5 = boundingBox4.getW();
        return f4 / (boundingBox4.getH() * f5 + f - f4);
    }

    private final float calculateDistance(BoundingBox boundingBox, BoundingBox boundingBox2) {
        BoundingBox boundingBox3 = boundingBox2;
        float f = boundingBox3.getX1();
        float f2 = boundingBox3.getX2() + f;
        f = 2;
        BoundingBox boundingBox4 = boundingBox;
        float f3 = boundingBox4.getX1();
        f3 = f2 / f - (boundingBox4.getX2() + f3) / f;
        float f4 = boundingBox3.getY1();
        BoundingBox boundingBox5 = boundingBox;
        float f5 = boundingBox5.getY1();
        float f6 = (boundingBox3.getY2() + f4) / f - (boundingBox5.getY2() + f5) / f;
        float f7 = f3;
        f = f7 * f7;
        return (float)Math.sqrt(f6 * f6 + f);
    }

    private final boolean hasMovedSignificantly(BoundingBox boundingBox, BoundingBox boundingBox2) {
        return this.calculateDistance(boundingBox, boundingBox2) > this.MOVEMENT_THRESHOLD;
    }

    public final boolean isAutoCaptureOn() {
        return this.isAutoCaptureOn;
    }

    public final void setAutoCaptureOn(boolean bl) {
        this.isAutoCaptureOn = bl;
    }

    public final void restart(boolean bl) {
        Interpreter.Options options;
        ((KLPDetector)((Object)mappedByteBuffer)).close();
        ((KLPDetector)((Object)mappedByteBuffer)).detected = false;
        if (bl) {
            Interpreter.Options options2;
            CompatibilityList compatibilityList;
            CompatibilityList compatibilityList2 = compatibilityList;
            options = options2;
            options2 = new Interpreter.Options();
            if (new CompatibilityList().isDelegateSupportedOnThisDevice()) {
                GpuDelegate gpuDelegate;
                compatibilityList2 = compatibilityList2.getBestOptionsForThisDevice();
                GpuDelegate gpuDelegate2 = gpuDelegate;
                gpuDelegate = new GpuDelegate((GpuDelegate.Options)compatibilityList2);
                options.addDelegate((Delegate)gpuDelegate2);
            } else {
                options.setNumThreads(4);
            }
        } else {
            Interpreter.Options options3;
            options = options3;
            new Interpreter.Options().setNumThreads(4);
        }
        MappedByteBuffer mappedByteBuffer = FileUtil.loadMappedFile((Context)((KLPDetector)((Object)mappedByteBuffer)).context, (String)((KLPDetector)((Object)mappedByteBuffer)).modelPath);
        Intrinsics.checkNotNullExpressionValue((Object)mappedByteBuffer, (String)"loadMappedFile(context, modelPath)");
        v4.interpreter = new Interpreter((ByteBuffer)mappedByteBuffer, options);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void close() {
        KLPDetector kLPDetector;
        KLPDetector kLPDetector2;
        try {
            KLPDetector kLPDetector3 = kLPDetector4;
            kLPDetector2 = kLPDetector3;
            Object object = kLPDetector3.interpreterLock;
            kLPDetector = kLPDetector4;
            // MONITORENTER : object
        }
        catch (Exception exception) {}
        kLPDetector.interpreter.close();
        // MONITOREXIT : object
        KLPDetector kLPDetector4 = kLPDetector2.gpuDelegate;
        if (kLPDetector4 == null) return;
        kLPDetector4.close();
        return;
        catch (Throwable throwable) {
            // MONITOREXIT : object
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    public final synchronized void detect(@NotNull Bitmap var1_4, @NotNull Function0<Unit> var2_7) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 15[TRYBLOCK] [23 : 243->252)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final synchronized List<BoundingBox> getCurrentBoundingBoxes(@NotNull Bitmap var1_5) {
        Intrinsics.checkNotNullParameter((Object)var1_5, (String)"frame");
        var2_6 = this.tensorWidth;
        if (var2_6 != 0 && (var3_10 = this.tensorHeight) != 0 && this.numChannel != 0 && this.numElements != 0) {
            block32: {
                block31: {
                    v0 = this;
                    v1 = v0;
                    v2 = v0;
                    var1_5 = Bitmap.createScaledBitmap((Bitmap)var1_5, (int)var2_6, (int)var3_10, (boolean)false);
                    var2_7 /* !! */  = v3;
                    var2_7 /* !! */ (this.INPUT_IMAGE_TYPE);
                    v3.load((Bitmap)var1_5);
                    var1_5 = (TensorImage)v1.imageProcessor.process((Object)var2_7 /* !! */ );
                    v4 = new int[3];
                    var2_7 /* !! */  = (TensorImage)v4;
                    v5 = this;
                    v6 /* !! */  = var2_7 /* !! */ ;
                    v7 = this;
                    v8 /* !! */  = var2_7 /* !! */ ;
                    v9 = this;
                    var2_7 /* !! */ [0] = (TensorImage)true;
                    var2_8 = 1;
                    v8 /* !! */ [var2_8] = (TensorImage)v9.numChannel;
                    var2_8 = 2;
                    v6 /* !! */ [var2_8] = (TensorImage)v7.numElements;
                    var2_9 = TensorBuffer.createFixedSize((int[])v4, (DataType)v5.OUTPUT_IMAGE_TYPE);
                    Intrinsics.checkNotNullExpressionValue((Object)var2_9, (String)"createFixedSize(\n       \u2026_IMAGE_TYPE\n            )");
                    var3_11 = this.interpreterLock;
                    v10 = this;
                    ** synchronized (var3_11)
lbl-1000:
                    // 1 sources

                    {
                        v11 = v10.interpreter;
                        v12 = var2_9;
                        var1_5 = var1_5.getBuffer();
                        v11.run(var1_5, (Object)v12.getBuffer());
                        // MONITOREXIT @DISABLED, blocks:[23, 11, 30] lbl45 : MonitorExitStatement: MONITOREXIT : var3_11
                        v13 = var2_9.getFloatArray();
                        Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"output.floatArray");
                        var1_5 = v2.bestBox(v13);
                        if (var1_5 == null) break block31;
                    }
                    v14 = var1_5;
                    var1_5 = v15;
                    v15 = new ArrayList<E>();
                    var2_9 = v14.iterator();
                    while (true) {
                        block34: {
                            block33: {
                                if (!var2_9.hasNext()) break block32;
                                var3_11 = var2_9.next();
                                var4_12 = (BoundingBox)var3_11;
                                if (!Intrinsics.areEqual((Object)var4_12.getClsName(), (Object)"corner")) break block33;
                                if (!(var4_12.getCnf() > this.CORNER_CONF)) break block33;
                                v16 = true;
                                break block34;
                            }
                            v16 = false;
                        }
                        if (!v16) continue;
                        var1_5.add(var3_11);
                    }
                }
                var1_5 = CollectionsKt.emptyList();
            }
            if (var1_5.size() != 4) {
                var1_5 = null;
            }
            {
                catch (Throwable var0_1) {
                    try {
                        throw var0_1;
                    }
                    catch (Exception var0_2) {
                        Helpers.Companion.printLog(new Object[]{"Error running interpreter: " + var0_2.getMessage()});
                        var1_5 = null;
                    }
                    catch (IllegalArgumentException var0_3) {
                        Helpers.Companion.printLog(new Object[]{"IllegalArgumentException: " + var0_3.getMessage()});
                        var1_5 = null;
                    }
                    catch (OutOfMemoryError var0_4) {
                        Helpers.Companion.printLog(new Object[]{"OutOfMemoryError: " + var0_4.getMessage()});
                        var1_5 = null;
                    }
                }
                return var1_5;
            }
        }
        Helpers.Companion.printLog(new Object[]{"Tensor dimensions are not initialized."});
        return null;
    }

    @Override
    public void onEmptyDetect() {
        this.onImageListener.onImageNotDetected();
    }

    @Override
    public void onDetect(int n, int n2, @NotNull List<BoundingBox> object, long l, @NotNull Function0<Unit> function0) {
        int n3;
        PointF pointF;
        PointF pointF2;
        ArrayList<BoundingBox> arrayList;
        ArrayList<BoundingBox> arrayList2;
        Intrinsics.checkNotNullParameter(object, (String)"boundingBoxes");
        Intrinsics.checkNotNullParameter(function0, (String)"doneProcessed");
        if (this.detected && this.isAutoCaptureOn) {
            return;
        }
        ArrayList<BoundingBox> arrayList3 = object;
        float f = (float)n * 0.75f;
        float f2 = n2;
        f = (f2 - f) / (float)2 / f2;
        f2 = 1.0f - f;
        object = arrayList2;
        arrayList2 = new ArrayList<BoundingBox>();
        Object object2 = arrayList;
        arrayList = new ArrayList<BoundingBox>();
        PointF pointF3 = pointF2;
        pointF2 = new PointF(Float.MAX_VALUE, Float.MAX_VALUE);
        PointF pointF4 = pointF;
        pointF = new PointF(Float.MIN_VALUE, Float.MIN_VALUE);
        for (BoundingBox boundingBox : arrayList3) {
            float f3;
            float f4 = boundingBox.getCnf();
            if (f4 < (f3 = Intrinsics.areEqual((Object)boundingBox.getClsName(), (Object)"card") ? this.CARD_CONF : this.CORNER_CONF)) continue;
            if (Intrinsics.areEqual((Object)boundingBox.getClsName(), (Object)"card")) {
                ((ArrayList)object2).add(boundingBox);
            } else if (Intrinsics.areEqual((Object)boundingBox.getClsName(), (Object)"corner")) {
                ((ArrayList)object).add(boundingBox);
            }
            if (boundingBox.getY1() < pointF3.y) {
                pointF3.y = boundingBox.getY1();
            }
            if (boundingBox.getX1() < pointF3.x) {
                pointF3.x = boundingBox.getX1();
            }
            if (boundingBox.getY2() > pointF4.y) {
                pointF4.y = boundingBox.getY2();
            }
            if (!(boundingBox.getX2() > pointF4.x)) continue;
            pointF4.x = boundingBox.getX2();
        }
        Helpers.Companion.printLog("onDetect ----------------------------");
        if (((ArrayList)object2).size() == 1 && 4 <= (n3 = ((ArrayList)object).size()) && n3 < 6 && pointF3.y > f && pointF4.y < f2) {
            KLPDetector kLPDetector = this;
            kLPDetector.onImageListener.onImageInMask();
            if (kLPDetector.conditionStartTime == 0L) {
                this.conditionStartTime = SystemClock.uptimeMillis();
                this.previousBoundingBox = (BoundingBox)((ArrayList)object).get(0);
            } else {
                long l2 = SystemClock.uptimeMillis() - this.conditionStartTime;
                Object e = ((ArrayList)object).get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"corners[0]");
                object = (BoundingBox)e;
                object2 = this.previousBoundingBox;
                if (object2 == null) {
                    return;
                }
                if (this.hasMovedSignificantly((BoundingBox)object2, (BoundingBox)object)) {
                    this.onImageListener.onImageOutOfMask();
                    this.conditionStartTime = 0L;
                } else if (l2 >= this.VERIFY_CAPTURING_DURATION && this.isAutoCaptureOn) {
                    this.onImageListener.onImageDetected();
                    this.detected = true;
                }
                this.previousBoundingBox = object;
            }
        } else {
            this.conditionStartTime = 0L;
            if (object2.isEmpty() ^ true) {
                this.onImageListener.onImageOutOfMask();
            }
        }
        function0.invoke();
    }
}

