/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.capturesdk.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.media.Image;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicYuvToRGB;
import android.renderscript.Type;
import java.nio.ByteBuffer;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nYuvToRgbConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YuvToRgbConverter.kt\nvn/kalapa/ekyc/capturesdk/utils/YuvToRgbConverter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,205:1\n13644#2,3:206\n*S KotlinDebug\n*F\n+ 1 YuvToRgbConverter.kt\nvn/kalapa/ekyc/capturesdk/utils/YuvToRgbConverter\n*L\n96#1:206,3\n*E\n"})
public final class YuvToRgbConverter {
    private final RenderScript rs;
    private final ScriptIntrinsicYuvToRGB scriptYuvToRgb;
    private int pixelCount;
    private ByteBuffer yuvBuffer;
    private Allocation inputAllocation;
    private Allocation outputAllocation;

    public YuvToRgbConverter(@NotNull Context context) {
        YuvToRgbConverter yuvToRgbConverter = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.rs = RenderScript.create((Context)context);
        yuvToRgbConverter.scriptYuvToRgb = ScriptIntrinsicYuvToRGB.create((RenderScript)this.rs, (Element)Element.U8_4((RenderScript)this.rs));
        yuvToRgbConverter.pixelCount = -1;
    }

    private final void imageToByteBuffer(Image image, byte[] byArray) {
        block6: {
            if (image.getFormat() != 35) break block6;
            Image image2 = image;
            image = image2.getCropRect();
            Image.Plane[] planeArray = image2.getPlanes();
            Intrinsics.checkNotNullExpressionValue((Object)planeArray, (String)"imagePlanes");
            int n = 0;
            for (Image.Plane plane : planeArray) {
                int n2;
                block9: {
                    int n3;
                    int n4;
                    Image image3;
                    int n5;
                    int n6;
                    block10: {
                        block7: {
                            block8: {
                                n2 = n + 1;
                                if (n == 0) break block7;
                                if (n == 1) break block8;
                                if (n != 2) break block9;
                                n6 = 2;
                                n5 = this.pixelCount;
                                break block10;
                            }
                            n6 = 2;
                            n5 = this.pixelCount + 1;
                            break block10;
                        }
                        n6 = 1;
                        n5 = 0;
                    }
                    Image.Plane plane2 = plane;
                    ByteBuffer byteBuffer = plane2.getBuffer();
                    int n7 = plane2.getRowStride();
                    int n8 = plane2.getPixelStride();
                    if (n == 0) {
                        image3 = image;
                    } else {
                        Rect rect;
                        image3 = rect;
                        Image image4 = image;
                        n4 = image4.top / 2;
                        int n9 = image4.right / 2;
                        n3 = image4.bottom / 2;
                        rect = new Rect(image.left / 2, n4, n9, n3);
                    }
                    Image image5 = image3;
                    int n10 = image5.width();
                    n4 = image5.height();
                    byte[] byArray2 = new byte[plane.getRowStride()];
                    n3 = n8 == 1 && n6 == 1 ? n10 : (n10 - 1) * n8 + 1;
                    for (int i = 0; i < n4; ++i) {
                        int n11 = (i + image3.top) * n7;
                        byteBuffer.position(image3.left * n8 + n11);
                        if (n8 == 1 && n6 == 1) {
                            byteBuffer.get(byArray, n5, n3);
                            n5 += n3;
                            continue;
                        }
                        byteBuffer.get(byArray2, 0, n3);
                        for (n11 = 0; n11 < n10; ++n11) {
                            byArray[n5] = byArray2[n11 * n8];
                            n5 += n6;
                        }
                    }
                }
                n = n2;
            }
            return;
        }
        throw new IllegalStateException("Assertion failed".toString());
    }

    public final synchronized void yuvToRgb(@NotNull Image object, @NotNull Bitmap bitmap) {
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter((Object)object, (String)"image");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"output");
        if (yuvToRgbConverter4.yuvBuffer == null) {
            Image image = object;
            int n = image.getCropRect().width();
            yuvToRgbConverter4.pixelCount = image.getCropRect().height() * n;
            n = ImageFormat.getBitsPerPixel((int)35);
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(yuvToRgbConverter4.pixelCount * n / 8);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"allocateDirect(pixelCount * pixelSizeBits / 8)");
            yuvToRgbConverter4.yuvBuffer = byteBuffer2;
        }
        if ((byteBuffer = yuvToRgbConverter4.yuvBuffer) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"yuvBuffer");
            byteBuffer = null;
        }
        byteBuffer.rewind();
        byteBuffer = yuvToRgbConverter4.yuvBuffer;
        if (byteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"yuvBuffer");
            byteBuffer = null;
        }
        YuvToRgbConverter yuvToRgbConverter = yuvToRgbConverter4;
        Image image = object;
        byte[] byArray = byteBuffer.array();
        object = byArray;
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"yuvBuffer.array()");
        yuvToRgbConverter.imageToByteBuffer(image, (byte[])object);
        if (yuvToRgbConverter.inputAllocation == null) {
            object = yuvToRgbConverter4.rs;
            RenderScript renderScript = object;
            byteBuffer = new Type.Builder(renderScript, Element.YUV((RenderScript)renderScript)).setYuvFormat(17).create().getElement();
            ByteBuffer byteBuffer3 = yuvToRgbConverter4.yuvBuffer;
            if (byteBuffer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"yuvBuffer");
                byteBuffer3 = null;
            }
            Allocation allocation = Allocation.createSized((RenderScript)object, (Element)byteBuffer, (int)byteBuffer3.array().length);
            Intrinsics.checkNotNullExpressionValue((Object)allocation, (String)"createSized(rs, elemType\u2026, yuvBuffer.array().size)");
            yuvToRgbConverter4.inputAllocation = allocation;
        }
        if (yuvToRgbConverter4.outputAllocation == null) {
            Allocation allocation = Allocation.createFromBitmap((RenderScript)yuvToRgbConverter4.rs, (Bitmap)bitmap);
            Intrinsics.checkNotNullExpressionValue((Object)allocation, (String)"createFromBitmap(rs, output)");
            yuvToRgbConverter4.outputAllocation = allocation;
        }
        if ((object = yuvToRgbConverter4.inputAllocation) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputAllocation");
            object = null;
        }
        if ((byteBuffer = yuvToRgbConverter4.yuvBuffer) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"yuvBuffer");
            byteBuffer = null;
        }
        YuvToRgbConverter yuvToRgbConverter2 = yuvToRgbConverter4;
        object.copyFrom(byteBuffer.array());
        object = yuvToRgbConverter2.scriptYuvToRgb;
        byteBuffer = yuvToRgbConverter2.inputAllocation;
        if (byteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputAllocation");
            byteBuffer = null;
        }
        YuvToRgbConverter yuvToRgbConverter3 = yuvToRgbConverter4;
        object.setInput((Allocation)byteBuffer);
        object = yuvToRgbConverter3.scriptYuvToRgb;
        byteBuffer = yuvToRgbConverter3.outputAllocation;
        if (byteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputAllocation");
            byteBuffer = null;
        }
        object.forEach((Allocation)byteBuffer);
        YuvToRgbConverter yuvToRgbConverter4 = yuvToRgbConverter4.outputAllocation;
        if (yuvToRgbConverter4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputAllocation");
            yuvToRgbConverter4 = null;
        }
        yuvToRgbConverter4.copyTo(bitmap);
    }
}

