/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.liveness;

import android.graphics.Bitmap;
import androidx.collection.LruCache;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.face.Face;
import com.google.mlkit.vision.face.FaceDetection;
import com.google.mlkit.vision.face.FaceDetector;
import com.google.mlkit.vision.face.FaceDetectorOptions;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.ekyc.KalapaSDK;
import vn.kalapa.ekyc.liveness.InputFace;
import vn.kalapa.ekyc.liveness.LivenessSession;
import vn.kalapa.ekyc.liveness.LivenessSessionStatus;
import vn.kalapa.ekyc.liveness.models.ComeClose;
import vn.kalapa.ekyc.liveness.models.GoFar;
import vn.kalapa.ekyc.liveness.models.HoldSteady2Seconds;
import vn.kalapa.ekyc.liveness.models.LivenessAction;
import vn.kalapa.ekyc.liveness.models.LivenessActionStatus;
import vn.kalapa.ekyc.liveness.models.Processing;
import vn.kalapa.ekyc.liveness.models.Success;
import vn.kalapa.ekyc.liveness.models.TiltLeft;
import vn.kalapa.ekyc.liveness.models.TiltRight;
import vn.kalapa.ekyc.liveness.models.TurnDown;
import vn.kalapa.ekyc.liveness.models.TurnLeft;
import vn.kalapa.ekyc.liveness.models.TurnRight;
import vn.kalapa.ekyc.liveness.models.TurnUp;
import vn.kalapa.ekyc.managers.KLPFaceDetectorListener;
import vn.kalapa.ekyc.utils.Common;
import vn.kalapa.ekyc.utils.Helpers;

@SourceDebugExtension(value={"SMAP\nLivenessSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LivenessSession.kt\nvn/kalapa/ekyc/liveness/LivenessSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,295:1\n1#2:296\n*E\n"})
public final class LivenessSession {
    @NotNull
    private Common.LIVENESS_VERSION livenessSessionType;
    @NotNull
    private LivenessSessionStatus sessionStatus;
    private final int MAX_N_FRAME;
    @NotNull
    private final ConcurrentLinkedQueue<InputFace> faceList;
    private final List<LivenessAction> actionList;
    private int currActionIdx;
    @Nullable
    private LivenessAction currAction;
    private Map<Integer, ? extends LivenessAction> index2Action;
    @NotNull
    private final String TAG;
    public Bitmap typicalFace;
    public Bitmap typicalFrame;
    private boolean gotTypicalFace;
    private final int CACHE_SIZE;
    @NotNull
    private final LruCache<Long, Face> recentDetections;
    @NotNull
    private final CoroutineScope processingScope;
    @NotNull
    private final FaceDetector faceDetector;

    public LivenessSession(@NotNull Common.LIVENESS_VERSION lIVENESS_VERSION) {
        Intrinsics.checkNotNullParameter((Object)((Object)lIVENESS_VERSION), (String)"livenessSessionType");
        this.livenessSessionType = lIVENESS_VERSION;
        this.sessionStatus = LivenessSessionStatus.UNVERIFIED;
        this.MAX_N_FRAME = 600;
        this.faceList = new ConcurrentLinkedQueue();
        this.actionList = Collections.synchronizedList(new ArrayList());
        this.currActionIdx = -1;
        this.TAG = "OptimizedLivenessSession";
        this.CACHE_SIZE = 10;
        this.recentDetections = new LruCache(10);
        this.processingScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getDefault().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        FaceDetector faceDetector = FaceDetection.getClient((FaceDetectorOptions)new FaceDetectorOptions.Builder().setPerformanceMode(1).setClassificationMode(2).setMinFaceSize(0.25f).enableTracking().build());
        Intrinsics.checkNotNullExpressionValue((Object)faceDetector, (String)"getClient(\n        FaceD\u2026           .build()\n    )");
        this.faceDetector = faceDetector;
        this.genActionList();
    }

    public /* synthetic */ LivenessSession(Common.LIVENESS_VERSION lIVENESS_VERSION, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            lIVENESS_VERSION = Common.LIVENESS_VERSION.PASSIVE;
        }
        this(lIVENESS_VERSION);
    }

    private final void refreshFaceList() {
        LivenessSession livenessSession = this;
        livenessSession.faceList.clear();
        livenessSession.recentDetections.evictAll();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void genActionList() {
        void var1_6;
        Helpers.Companion.printLog("genActionList " + this.livenessSessionType.name());
        int n = WhenMappings.$EnumSwitchMapping$0[this.livenessSessionType.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n != 3) throw new NoWhenBranchMatchedException();
                Map map = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)1, (Object)new HoldSteady2Seconds(1500)), TuplesKt.to((Object)2, (Object)new GoFar()), TuplesKt.to((Object)3, (Object)new ComeClose()), TuplesKt.to((Object)4, (Object)new Processing())});
            } else {
                void var4_17;
                void var4_14;
                void var4_11;
                Pair[] pairArray = new Pair[5];
                Pair[] pairArray2 = pairArray;
                pairArray[0] = TuplesKt.to((Object)1, (Object)new HoldSteady2Seconds(1500));
                int n2 = 1;
                Integer n3 = 2;
                if (Random.Default.nextInt(2) % 2 == 0) {
                    TurnLeft turnLeft;
                    TurnLeft turnLeft2 = turnLeft;
                    turnLeft = new TurnLeft();
                } else {
                    TurnRight turnRight;
                    TurnRight turnRight2 = turnRight;
                    turnRight = new TurnRight();
                }
                pairArray2[n2] = TuplesKt.to((Object)n3, (Object)var4_11);
                n2 = 2;
                n3 = 3;
                if (Random.Default.nextInt(2) % 2 == 0) {
                    TurnUp turnUp;
                    TurnUp turnUp2 = turnUp;
                    turnUp = new TurnUp();
                } else {
                    TurnDown turnDown;
                    TurnDown turnDown2 = turnDown;
                    turnDown = new TurnDown();
                }
                pairArray2[n2] = TuplesKt.to((Object)n3, (Object)var4_14);
                n2 = 3;
                n3 = 4;
                if (Random.Default.nextInt(2) % 2 == 0) {
                    TiltLeft tiltLeft;
                    TiltLeft tiltLeft2 = tiltLeft;
                    tiltLeft = new TiltLeft();
                } else {
                    TiltRight tiltRight;
                    TiltRight tiltRight2 = tiltRight;
                    tiltRight = new TiltRight();
                }
                Pair[] pairArray3 = pairArray2;
                pairArray3[n2] = TuplesKt.to((Object)n3, (Object)var4_17);
                pairArray3[4] = TuplesKt.to((Object)5, (Object)new Processing());
                Map map = MapsKt.mapOf((Pair[])pairArray2);
            }
        } else {
            Map map = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)1, (Object)new HoldSteady2Seconds(1500)), TuplesKt.to((Object)2, (Object)new Processing())});
        }
        this.index2Action = var1_6;
        this.currActionIdx = 0;
        this.currAction = null;
        this.actionList.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void handleDetectionResult(List<? extends Face> list, Bitmap object, Bitmap objectArray, KLPFaceDetectorListener kLPFaceDetectorListener) {
        void var7_17;
        Object object3;
        int n = 0;
        if (list.isEmpty()) {
            object3.sessionStatus = LivenessSessionStatus.NO_FACE;
        } else {
            for (Face object22 : list) {
                InputFace inputFace;
                InputFace inputFace2 = inputFace;
                long l = System.currentTimeMillis();
                int n2 = objectArray.getWidth();
                int n3 = objectArray.getHeight();
                inputFace = new InputFace(l, object22, n2, n3);
                if (!LivenessAction.x.isFaceSizeJustBiggerThanTooSmall(inputFace2)) continue;
                ++n;
            }
            if (list.size() > 1 && n > 1) {
                object3.sessionStatus = LivenessSessionStatus.TOO_MANY_FACES;
                object3.refreshFaceList();
            } else {
                long l = System.currentTimeMillis();
                Face face = list.get(0);
                int n4 = objectArray.getWidth();
                int n5 = objectArray.getHeight();
                object3.processFaceDetection(new InputFace(l, face, n4, n5), (Bitmap)object, (Bitmap)objectArray);
            }
        }
        LivenessSession livenessSession = object3;
        object = Helpers.Companion;
        objectArray = new Object[1];
        n = 0;
        String string2 = livenessSession.TAG;
        LivenessAction livenessAction = livenessSession.currAction;
        if (livenessAction != null) {
            String string3 = livenessAction.getTAG();
        } else {
            Object var7_16 = null;
        }
        LivenessSession livenessSession2 = object3;
        LivenessSession livenessSession3 = object3;
        object3 = object3.sessionStatus;
        int n6 = list.size();
        int n7 = livenessSession3.faceList.size();
        objectArray[n] = (String)string2 + " Processing: " + (String)var7_17 + " - Status " + (LivenessSessionStatus)((Object)object3) + " " + n6 + " - faceList " + n7;
        ((Helpers.Companion)object).printLog(objectArray);
        object3 = livenessSession2.sessionStatus;
        Object object4 = livenessSession2.currAction;
        object4 = object4 != null ? ((LivenessAction)object4).getTAG() : null;
        kLPFaceDetectorListener.onMessage((LivenessSessionStatus)((Object)object3), (String)object4);
    }

    private final void processFaceDetection(InputFace inputFace, Bitmap bitmap, Bitmap bitmap2) {
        LivenessAction.x x2 = LivenessAction.x;
        if (x2.isFaceTooSmall(inputFace)) {
            this.sessionStatus = LivenessSessionStatus.TOO_SMALL;
        } else if (x2.isFaceTooBig(inputFace)) {
            this.sessionStatus = LivenessSessionStatus.TOO_LARGE;
        } else {
            int n;
            int n2;
            Bitmap bitmap3 = bitmap2;
            Face face = inputFace.getFace();
            if (!x2.isFaceMarginRight(face, n2 = bitmap3.getWidth(), n = bitmap3.getHeight())) {
                this.sessionStatus = LivenessSessionStatus.OFF_CENTER;
                this.refreshFaceList();
            } else if (KalapaSDK.Companion.getConfig$kalapa_release().getLivenessVersion() != Common.LIVENESS_VERSION.ACTIVE.getVersion() && !x2.isFaceLookStraight(inputFace.getFace())) {
                this.sessionStatus = LivenessSessionStatus.ANGLE_NOT_CORRECT;
                this.refreshFaceList();
            } else {
                LivenessSession livenessSession = this;
                livenessSession.faceList.add(inputFace);
                if (livenessSession.faceList.size() > this.MAX_N_FRAME) {
                    this.sessionStatus = LivenessSessionStatus.EXPIRED;
                } else {
                    this.handleAction(bitmap, bitmap2);
                }
            }
        }
    }

    private final void addAction(int n, LivenessAction livenessAction) {
        int n2;
        int n3;
        LivenessSession livenessSession = this;
        livenessSession.currActionIdx = n3 = livenessSession.currActionIdx + n;
        Map<Integer, ? extends LivenessAction> map = livenessSession.index2Action;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"index2Action");
            map = null;
        }
        if (n3 > (n2 = (map = (Integer)CollectionsKt.maxOrNull(map.keySet())) != null ? (Integer)((Object)map) : 0)) {
            this.sessionStatus = LivenessSessionStatus.VERIFIED;
            return;
        }
        if (n == 0) {
            if (livenessAction != null) {
                this.actionList.add(livenessAction);
            }
        } else {
            Map<Integer, ? extends LivenessAction> map2 = this.index2Action;
            if (map2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"index2Action");
                map2 = null;
            }
            if ((map2 = map2.get(this.currActionIdx)) != null) {
                this.actionList.add((LivenessAction)((Object)map2));
            }
        }
    }

    public static /* synthetic */ void addAction$default(LivenessSession livenessSession, int n, LivenessAction livenessAction, int n2, Object object) {
        if ((n2 & 2) != 0) {
            livenessAction = null;
        }
        livenessSession.addAction(n, livenessAction);
    }

    private final void handleAction(Bitmap bitmap, Bitmap bitmap2) {
        int n;
        if (((LivenessSession)((Object)success3)).currActionIdx == 0) {
            LivenessSession.addAction$default((LivenessSession)((Object)success3), 1, null, 2, null);
        }
        LivenessSession livenessSession = success3;
        int n2 = livenessSession.currActionIdx;
        Map<Integer, ? extends LivenessAction> map = livenessSession.index2Action;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"index2Action");
            map = null;
        }
        if (n2 <= (n = (map = (Integer)CollectionsKt.maxOrNull(map.keySet())) != null ? (Integer)((Object)map) : 0)) {
            int n3;
            LivenessAction livenessAction;
            List<LivenessAction> list = ((LivenessSession)((Object)success3)).actionList;
            Intrinsics.checkNotNullExpressionValue(list, (String)"actionList");
            Object object = (LivenessAction)CollectionsKt.last(list);
            ((LivenessSession)((Object)success3)).currAction = object;
            Intrinsics.checkNotNull((Object)object);
            object = ((LivenessAction)object).process((LivenessSession)((Object)success3));
            if (object == LivenessActionStatus.SUCCESS && (Intrinsics.areEqual((Object)((livenessAction = ((LivenessSession)((Object)success3)).currAction) != null ? livenessAction.getTAG() : null), (Object)"HoldSteady2Seconds") || Intrinsics.areEqual((Object)((livenessAction = ((LivenessSession)((Object)success3)).currAction) != null ? livenessAction.getTAG() : null), (Object)"ComeClose"))) {
                if (!((LivenessSession)((Object)success3)).gotTypicalFace) {
                    Helpers.Companion.printLog(((LivenessSession)((Object)success3)).TAG + " Found typical frame!");
                    ((LivenessSession)((Object)success3)).setTypicalFrame(bitmap);
                    ((LivenessSession)((Object)success3)).setTypicalFace(bitmap2);
                }
                ((LivenessSession)((Object)success3)).gotTypicalFace = true;
            }
            if ((n3 = WhenMappings.$EnumSwitchMapping$1[((Enum)object).ordinal()]) != 1) {
                if (n3 != 2) {
                    if (n3 == 3) {
                        ((LivenessSession)((Object)success3)).sessionStatus = LivenessSessionStatus.PROCESSING;
                    }
                } else {
                    ((LivenessSession)((Object)success3)).genActionList();
                }
            } else {
                LivenessAction livenessAction2 = ((LivenessSession)((Object)success3)).currAction;
                Intrinsics.checkNotNull((Object)livenessAction2);
                if (livenessAction2.isBreakAction()) {
                    LivenessSession.addAction$default((LivenessSession)((Object)success3), 1, null, 2, null);
                } else {
                    Success success2;
                    LivenessSession livenessSession2 = success3;
                    Success success3 = success2;
                    success2 = new Success();
                    livenessSession2.addAction(0, success3);
                }
            }
        }
    }

    private final InputImage optimizeImageForDetection(Bitmap bitmap, int n) {
        InputImage inputImage;
        int n2 = 1024;
        float f = bitmap.getWidth() <= n2 && bitmap.getHeight() <= n2 ? 1.0f : (float)n2 / (float)Math.max(bitmap.getWidth(), bitmap.getHeight());
        if (f < 1.0f) {
            Bitmap bitmap2 = bitmap;
            inputImage = InputImage.fromBitmap((Bitmap)Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)((int)((float)bitmap2.getWidth() * f)), (int)((int)((float)bitmap.getHeight() * f)), (boolean)true), (int)n);
            Intrinsics.checkNotNullExpressionValue((Object)inputImage, (String)"{\n            val scaled\u2026 rotationAngle)\n        }");
        } else {
            inputImage = InputImage.fromBitmap((Bitmap)bitmap, (int)n);
            Intrinsics.checkNotNullExpressionValue((Object)inputImage, (String)"{\n            InputImage\u2026 rotationAngle)\n        }");
        }
        return inputImage;
    }

    public LivenessSession() {
        this(null, 1, null);
    }

    public static final /* synthetic */ LruCache access$getRecentDetections$p(LivenessSession livenessSession) {
        return livenessSession.recentDetections;
    }

    public static final /* synthetic */ InputImage access$optimizeImageForDetection(LivenessSession livenessSession, Bitmap bitmap, int n) {
        return livenessSession.optimizeImageForDetection(bitmap, n);
    }

    public static final /* synthetic */ FaceDetector access$getFaceDetector$p(LivenessSession livenessSession) {
        return livenessSession.faceDetector;
    }

    public static final /* synthetic */ void access$handleDetectionResult(LivenessSession livenessSession, List list, Bitmap bitmap, Bitmap bitmap2, KLPFaceDetectorListener kLPFaceDetectorListener) {
        livenessSession.handleDetectionResult(list, bitmap, bitmap2, kLPFaceDetectorListener);
    }

    public static final /* synthetic */ String access$getTAG$p(LivenessSession livenessSession) {
        return livenessSession.TAG;
    }

    public static final /* synthetic */ LivenessAction access$getCurrAction$p(LivenessSession livenessSession) {
        return livenessSession.currAction;
    }

    @NotNull
    public final LivenessSessionStatus getSessionStatus() {
        return this.sessionStatus;
    }

    public final void setSessionStatus(@NotNull LivenessSessionStatus livenessSessionStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)livenessSessionStatus), (String)"<set-?>");
        this.sessionStatus = livenessSessionStatus;
    }

    @NotNull
    public final ConcurrentLinkedQueue<InputFace> getFaceList() {
        return this.faceList;
    }

    @NotNull
    public final List<InputFace> getFaceList() {
        return CollectionsKt.toList(this.faceList);
    }

    @NotNull
    public final Bitmap getTypicalFace() {
        LivenessSession livenessSession = livenessSession.typicalFace;
        if (livenessSession != null) {
            return livenessSession;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"typicalFace");
        return null;
    }

    public final void setTypicalFace(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"<set-?>");
        this.typicalFace = bitmap;
    }

    @NotNull
    public final Bitmap getTypicalFrame() {
        LivenessSession livenessSession = livenessSession.typicalFrame;
        if (livenessSession != null) {
            return livenessSession;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"typicalFrame");
        return null;
    }

    public final void setTypicalFrame(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"<set-?>");
        this.typicalFrame = bitmap;
    }

    public final boolean getGotTypicalFace() {
        return this.gotTypicalFace;
    }

    public final void setGotTypicalFace(boolean bl) {
        this.gotTypicalFace = bl;
    }

    public final void renewSession(@NotNull Common.LIVENESS_VERSION lIVENESS_VERSION) {
        LivenessSession livenessSession = this;
        Common.LIVENESS_VERSION lIVENESS_VERSION2 = lIVENESS_VERSION;
        Intrinsics.checkNotNullParameter((Object)((Object)lIVENESS_VERSION2), (String)"livenessSessionType");
        livenessSession.livenessSessionType = lIVENESS_VERSION2;
        livenessSession.sessionStatus = LivenessSessionStatus.UNVERIFIED;
        livenessSession.gotTypicalFace = false;
        livenessSession.refreshFaceList();
        livenessSession.genActionList();
    }

    public final void process(@NotNull Bitmap bitmap, @NotNull Bitmap bitmap2, int n, @NotNull KLPFaceDetectorListener kLPFaceDetectorListener) {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)bitmap2, (String)"cropImage");
        Intrinsics.checkNotNullParameter((Object)kLPFaceDetectorListener, (String)"faceDetectorListener");
        if (this.isFinished()) {
            return;
        }
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, kLPFaceDetectorListener, bitmap, bitmap2, n, null){
            public long J$0;
            public int label;
            public final /* synthetic */ LivenessSession this$0;
            public final /* synthetic */ KLPFaceDetectorListener $faceDetectorListener;
            public final /* synthetic */ Bitmap $frame;
            public final /* synthetic */ Bitmap $cropImage;
            public final /* synthetic */ int $rotationAngle;
            {
                this.this$0 = livenessSession;
                this.$faceDetectorListener = kLPFaceDetectorListener;
                this.$frame = bitmap;
                this.$cropImage = bitmap2;
                this.$rotationAngle = n;
                super(2, continuation);
            }

            private static final void invokeSuspend$lambda$1(Function1 function1, Object object) {
                function1.invoke(object);
            }

            private static final void invokeSuspend$lambda$2(LivenessSession object, KLPFaceDetectorListener kLPFaceDetectorListener, Exception object2) {
                LivenessSession livenessSession = object;
                Helpers.Companion.printLog(LivenessSession.access$getTAG$p(object) + " Detection failed: " + ((Throwable)object2).getMessage());
                livenessSession.setSessionStatus(LivenessSessionStatus.FAILED);
                object = livenessSession.getSessionStatus();
                object2 = LivenessSession.access$getCurrAction$p(livenessSession);
                object2 = object2 != null ? ((LivenessAction)object2).getTAG() : null;
                kLPFaceDetectorListener.onMessage((LivenessSessionStatus)((Object)object), (String)object2);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block21: {
                    var2_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    var3_7 = this.label;
                    if (var3_7 != 0) {
                        if (var3_7 == 1) {
                            var2_5 = this.J$0;
                            ResultKt.throwOnFailure((Object)var1_1 /* !! */ );
                            break block21;
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    ResultKt.throwOnFailure((Object)var1_1 /* !! */ );
                    var3_8 = System.currentTimeMillis();
                    var1_1 /* !! */  = (Face)LivenessSession.access$getRecentDetections$p(this.this$0).get((Object)Boxing.boxLong((long)var3_8));
                    if (var1_1 /* !! */  == null) ** GOTO lbl29
                    v0 = this.this$0;
                    v1 = var1_1 /* !! */ ;
                    v2 = this;
                    v3 = v2;
                    v4 = v2;
                    var1_1 /* !! */  = v2.$frame;
                    var5_9 /* !! */  = v4.$cropImage;
                    var6_10 = v3.$faceDetectorListener;
                    LivenessSession.access$handleDetectionResult(v0, CollectionsKt.listOf((Object)v1), (Bitmap)var1_1 /* !! */ , var5_9 /* !! */ , var6_10);
lbl29:
                    // 2 sources

                    v5 = Dispatchers.getDefault();
                    v6 = this;
                    v7 = v6;
                    v8 = v6;
                    v9 = var3_8;
                    var1_1 /* !! */  = v10;
                    v11 = this;
                    v12 = v11;
                    v13 = v11;
                    var5_9 /* !! */  = v11.this$0;
                    var6_10 = v13.$cropImage;
                    var7_11 = v12.$rotationAngle;
                    v10 = new Function2<CoroutineScope, Continuation<? super InputImage>, Object>((LivenessSession)var5_9 /* !! */ , (Bitmap)var6_10, var7_11, null){
                        public int label;
                        public final /* synthetic */ LivenessSession this$0;
                        public final /* synthetic */ Bitmap $cropImage;
                        public final /* synthetic */ int $rotationAngle;
                        {
                            this.this$0 = livenessSession;
                            this.$cropImage = bitmap;
                            this.$rotationAngle = n;
                            super(2, continuation);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            if (this_.label == 0) {
                                ResultKt.throwOnFailure((Object)object);
                                process.optimizedImage.1 v0 = this_;
                                process.optimizedImage.1 this_ = v0.$cropImage;
                                return LivenessSession.access$optimizeImageForDetection(this_.this$0, (Bitmap)this_, v0.$rotationAngle);
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                            var v0 = object2;
                            Object object2 = v0.this$0;
                            object = v0.$cropImage;
                            int n = v0.$rotationAngle;
                            return new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super InputImage> continuation) {
                            return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                        }
                    };
                    v7.J$0 = v9;
                    v8.label = 1;
                    var1_1 /* !! */  = BuildersKt.withContext((CoroutineContext)v5, (Function2)var1_1 /* !! */ , (Continuation)this);
                    if (var1_1 /* !! */  == var2_4) {
                        return var2_4;
                    }
                    var2_5 = var3_8;
                }
                v14 = this;
                var1_1 /* !! */  = (InputImage)var1_1 /* !! */ ;
                v15 = LivenessSession.access$getFaceDetector$p(v14.this$0).process((InputImage)var1_1 /* !! */ );
                v16 = v17;
                v18 = v17;
                v19 = this;
                v20 = v19;
                v21 = v19;
                v22 = v19;
                var1_1 /* !! */  = v19.this$0;
                var4_12 = v20.$frame;
                var5_9 /* !! */  = v21.$cropImage;
                var6_10 = v22.$faceDetectorListener;
                try {
                    v16((LivenessSession)var1_1 /* !! */ , var4_12, var5_9 /* !! */ , var6_10, var2_5);
                    v15.addOnSuccessListener((OnSuccessListener)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, invokeSuspend$lambda$1(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)V)((Function1)v18)).addOnFailureListener((OnFailureListener)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Exception;)V, invokeSuspend$lambda$2(vn.kalapa.ekyc.liveness.LivenessSession vn.kalapa.ekyc.managers.KLPFaceDetectorListener java.lang.Exception ), (Ljava/lang/Exception;)V)((LivenessSession)this.this$0, (KLPFaceDetectorListener)this.$faceDetectorListener));
                }
                catch (Exception var1_2) {
                    v23 = this;
                    Helpers.Companion.printLog(new Object[]{LivenessSession.access$getTAG$p(this.this$0) + " Processing error: " + var1_2.getMessage()});
                    v23.this$0.setSessionStatus(LivenessSessionStatus.FAILED);
                    this = v23.$faceDetectorListener;
                    var1_3 = v23.this$0.getSessionStatus();
                    var2_6 = LivenessSession.access$getCurrAction$p(v23.this$0);
                    var2_6 = var2_6 != null ? var2_6.getTAG() : null;
                    this.onMessage(var1_3, (String)var2_6);
                }
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                var v0 = object2;
                Object object2 = v0.this$0;
                object = v0.$faceDetectorListener;
                Bitmap bitmap = v0.$frame;
                Bitmap bitmap2 = v0.$cropImage;
                int n = v0.$rotationAngle;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)this.processingScope, null, null, (Function2)function22, (int)3, null);
    }

    @NotNull
    public final String getCurrentAction() {
        String string2;
        int n = this.currActionIdx;
        if (n > 0 && n < this.actionList.size()) {
            List<LivenessAction> list = this.actionList;
            Intrinsics.checkNotNullExpressionValue(list, (String)"actionList");
            string2 = ((LivenessAction)CollectionsKt.last(list)).getTAG();
        } else {
            string2 = "";
        }
        return string2;
    }

    public final boolean isFinished() {
        Object object = object.sessionStatus;
        return object == LivenessSessionStatus.FAILED || object == LivenessSessionStatus.VERIFIED;
    }

    public final void cleanup() {
        LivenessSession livenessSession = this;
        CoroutineScopeKt.cancel$default((CoroutineScope)livenessSession.processingScope, null, (int)1, null);
        livenessSession.faceDetector.close();
        livenessSession.refreshFaceList();
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Common.LIVENESS_VERSION.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[Common.LIVENESS_VERSION.PASSIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Common.LIVENESS_VERSION.ACTIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Common.LIVENESS_VERSION.SEMI_ACTIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
            int[] nArray3 = new int[LivenessActionStatus.values().length];
            nArray2 = nArray3;
            try {
                nArray3[LivenessActionStatus.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[LivenessActionStatus.TIMEOUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[LivenessActionStatus.FAILED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$1 = nArray2;
        }
    }
}

