/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ContextWrapper;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.media.Image;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Base64;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageProxy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.UUID;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.ekyc.capturesdk.utils.YuvToRgbConverter;
import vn.kalapa.ekyc.utils.Helpers;

public final class BitmapUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TU_BASE64 = new StringBuilder(198155).append("data:image/jpeg;base64,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").append("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").append("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").append("9XX6FMA+s5rH6CSo21fL0B37pDVaH+rWVIwNmTEKOCbEqPD6RHNDjeAFO9upDdkyRT5SpCyLSY/JcSRy+Sc4eonqk3BQTY06HTfumO77p5JCY77wMaJrJEby5J7hAkbLtTyTgd+vWVNi2NaJ3CY9wzbaJc0jRNcUE2I4gGOS4wEjhmhLEbiUBY17iBASE6JXCRpolo6ySNQgEMAJ3Xa9FK6ImEwuDTHVBIyIO6UEO5QpOUxCaHNbII/wA/RACTIkgp1s91CuKjRtqmFwnWUjagBOkFFAejcGcQNq1A1+gmN16fhzmVG6QQea+c7LFH2DpYQ3Veu+HvEzL5oZUdDm9Tus+SHFnPzQrk9Dp+iANUNiFD4unUplsgiCEbTDSZ7JlSQZEaqhGJOmfOnFmBvwXFq9LKQwnM0nosvceh5EL3fxHwelidgajKc1qeocPxC8LxBhp1y0jVdLHO0dnFPfEW3f11R9N0sBVXRdkeArCidNBAWuLLWSO1lQyGmYKIUL2iSN1NogcDOqeOXNMaRCePZSA4QR3SgSdkgMiYTgZagBuUESAVwHNSHX9UgOuqlMBIkbQnDdKBA0CXmpsBumZI7dOLhrokJlKAkf6rgSAkkA7apuaNSosCUP8A8hNc7mml0mEwnlzU2A/NH9EoM6xBTANP6pw5aIAc12qcHazCYTHRKHD21QBIHT2TwQN0xpnTqng6aJkA8OgJwMnaUwa7ynDTknAdm7brp001SA8gNPddm7IAUaDqnA6BNB5QE6Y5aIIY4H/D/dSAkKMHTaITs2s6oFHTG+8JhPNcXCE0mNkMBXOgHkmEpHO02UZclsccTB/qml2sDZJmSTyhAg0mBso6jgWGBBTzInb3UTiCwnolbHBTzCJsP+INNEMSJ2ROHuirr1Sx7IZr8LJY0RsjblpfbvDRogcPfLGq0EGg+ei0lbMzU/dkgkSkzkkDknXbpru00nQqBr4GiVsYLp1A3QKWlUklBtqe2nRSsraKEwDPMBXF/P8AVDeZKQ1euxU2ASa5jfUoarVzPlMfUbPOUw1dJ/BFgPe8HUj5oK7AgwES6qCdSAhrgz7dlWwKi8EnZDNEckXdt10G6FaYO0qocfRcQ/bdXdm4BzZVG12V0QrWzqeppKaLFZdA5h/VRukHTYapTqnt1a6dArbEKO6qQ92nNDZ+cSiLyPMO8ITMB7KhsYkOkmUoPzURfB2lcHwQosAhrteyfReTU21UAd1AU1J/71ohMmBe27v3YJB2UxBe1wOghD0HhzByAU7XAO20V18ClPU1c4DSFW1/XW05I67IbVfGyr6bi57idSFnYwpqZWFhA12UIac2ymqbFMADQSd+SgmyMu9MnZEYSSKuaJCHqD0gRoVZWFLLTblG6mPYN8F6KsNEcwmmrGhKiDoaBqlL9fyV9lJK12YTCXOHabH3TWunlCVxnfl0U2MxYIPsmVKgcdPzSh8d0zcyhCi0n+qAFdYaHCmczQOhKprWl5laI1KvKfpY1vMKQC2ug+ooevWymBEJKtTyqZzDkqupXDtdx0lAH//Z").toString();

    public static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ Bitmap rotateBitmapToStraight$default(Companion companion, Bitmap bitmap, int n, boolean bl, int n2, Object object) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            return companion.rotateBitmapToStraight(bitmap, n, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @SuppressLint(value={"UnsafeExperimentalUsageError"})
        @ExperimentalGetImage
        @Nullable
        public final Bitmap toBitmap(@NotNull YuvToRgbConverter yuvToRgbConverter, @NotNull ImageProxy imageProxy) {
            Matrix matrix;
            ImageProxy imageProxy2 = imageProxy;
            Intrinsics.checkNotNullParameter((Object)yuvToRgbConverter, (String)"yuvToRgbConverter");
            Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"imageProxy");
            Companion companion = imageProxy2.getImage();
            if (companion == null) {
                return null;
            }
            Helpers.Companion.printLog("Initalize toBitmap()");
            Matrix matrix2 = matrix;
            matrix2();
            matrix.postRotate((float)imageProxy.getImageInfo().getRotationDegrees());
            ImageProxy imageProxy3 = imageProxy = Bitmap.createBitmap((int)imageProxy.getWidth(), (int)imageProxy.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNullExpressionValue((Object)imageProxy3, (String)"bitmapBuffer");
            yuvToRgbConverter.yuvToRgb((Image)companion, (Bitmap)imageProxy3);
            int n = imageProxy.getWidth();
            int n2 = imageProxy.getHeight();
            return Bitmap.createBitmap((Bitmap)imageProxy, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix2, (boolean)false);
        }

        public final boolean isImageUri(@NotNull Context context, @NotNull String string2) {
            boolean bl;
            block4: {
                String string3 = string2;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)string3, (String)"uriString");
                Object object = Uri.parse((String)string3);
                object = context.getContentResolver().getType((Uri)object);
                if (object == null) break block4;
                try {
                    if (!StringsKt.startsWith$default((String)object, (String)"image/", (boolean)false, (int)2, null)) break block4;
                    bl = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    bl = false;
                }
            }
            bl = false;
            return bl;
        }

        @Nullable
        public final String getRealPathFromUri(@NotNull Uri uri, @NotNull ContentResolver contentResolver) {
            ContentResolver contentResolver2 = contentResolver;
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)contentResolver2, (String)"contentResolver");
            Cursor cursor = new String[1];
            Cursor cursor2 = cursor;
            cursor[0] = "_data";
            cursor2 = contentResolver2.query(uri, (String[])cursor2, null, null, null);
            if (cursor2 != null) {
                block7: {
                    uri = null;
                    try {
                        if (!cursor2.moveToFirst()) break block7;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            CloseableKt.closeFinally((Closeable)cursor2, (Throwable)throwable);
                            throw throwable2;
                        }
                    }
                    Cursor cursor3 = cursor2;
                    String string2 = cursor3.getString(cursor3.getColumnIndexOrThrow("_data"));
                    CloseableKt.closeFinally((Closeable)cursor2, (Throwable)uri);
                    return string2;
                }
                Cursor cursor4 = cursor2;
                CloseableKt.closeFinally((Closeable)cursor4, (Throwable)uri);
            }
            return null;
        }

        @NotNull
        public final File convertBitmapToFile(@NotNull Context object, @NotNull Bitmap bitmap) {
            FileOutputStream fileOutputStream;
            File file;
            Intrinsics.checkNotNullParameter((Object)object, (String)"context");
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"srcBmp");
            Object object2 = new ContextWrapper(object).getDir("Images", 0);
            object = file;
            file = new File((File)object2, UUID.randomUUID() + ".jpg");
            object2 = fileOutputStream;
            ((FileOutputStream)object2)((File)object);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)object2);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            return file;
        }

        @NotNull
        public final Bitmap resizeBitmapToBitmap(@NotNull Bitmap bitmap) {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"srcBmp");
            byte[] byArray = this.convertBitmapToBytes(bitmap);
            Bitmap bitmap2 = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"decodeByteArray(image, 0, image.size)");
            return bitmap2;
        }

        @NotNull
        public final Bitmap resizeImageFromGallery(@NotNull Bitmap bitmap) {
            Bitmap bitmap2 = bitmap;
            Intrinsics.checkNotNullParameter((Object)bitmap2, (String)"bitmap");
            float f = bitmap2.getWidth() > 6479 ? 6.0f : (bitmap.getWidth() > 5399 ? 5.0f : (bitmap.getWidth() > 4319 ? 4.0f : (bitmap.getWidth() > 3240 ? 3.0f : (bitmap.getWidth() > 2159 ? 2.0f : (bitmap.getWidth() >= 1619 ? 1.5f : (bitmap.getWidth() >= 1400 ? 1.3f : 1.0f))))));
            float f2 = bitmap.getHeight() > 6479 ? 6.0f : (bitmap.getHeight() > 5399 ? 5.0f : (bitmap.getHeight() > 4319 ? 4.0f : (bitmap.getHeight() > 3240 ? 3.0f : (bitmap.getHeight() > 2159 ? 2.0f : (bitmap.getHeight() > 1619 ? 1.5f : (bitmap.getHeight() > 1400 ? 1.3f : 1.0f))))));
            Bitmap bitmap3 = bitmap;
            f = Math.min(f, f2);
            Bitmap bitmap4 = Bitmap.createScaledBitmap((Bitmap)bitmap3, (int)((int)((float)bitmap3.getWidth() / f)), (int)((int)((float)bitmap.getHeight() / f)), (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap4, (String)"scaledBitmap");
            return bitmap4;
        }

        @NotNull
        public final byte[] convertBitmapToBytes(@NotNull Bitmap bitmap) {
            ByteArrayOutputStream byteArrayOutputStream;
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"srcBmp");
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream2();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)byteArrayOutputStream2);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"stream.toByteArray()");
            return byArray;
        }

        @NotNull
        public final Bitmap compressBitmapToJpeg(@NotNull Bitmap bitmap, int n) {
            ByteArrayOutputStream byteArrayOutputStream;
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            Helpers.Companion.printLog("Original Bitmap: " + (float)(bitmap.getByteCount() / 1024) / 1024.0f);
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream2();
            bitmap.compress(Bitmap.CompressFormat.JPEG, n, (OutputStream)byteArrayOutputStream2);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Bitmap bitmap2 = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"decodeByteArray(image, 0, image.size)");
            return bitmap2;
        }

        @NotNull
        public final byte[] convertBase64ToBytes(@NotNull String string2) {
            String string3 = string2;
            Intrinsics.checkNotNullParameter((Object)string3, (String)"base64");
            byte[] byArray = Base64.decode((String)string3, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(base64, Base64.DEFAULT)");
            return byArray;
        }

        @NotNull
        public final byte[] convertToByteArray(@NotNull Bitmap bitmap) {
            ByteArrayOutputStream byteArrayOutputStream;
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"<this>");
            long l = System.currentTimeMillis();
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream2();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)byteArrayOutputStream2);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Helpers.Companion.printLog("Exceed time convertToByteArray " + (System.currentTimeMillis() - l));
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bytes");
            return byArray;
        }

        @NotNull
        public final String convertBitmapToBase64(@NotNull Bitmap bitmap) {
            Bitmap bitmap2 = bitmap;
            Intrinsics.checkNotNullParameter((Object)bitmap2, (String)"srcBmp");
            String string2 = Base64.encodeToString((byte[])this.convertToByteArray(bitmap2), (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(byteArray, Base64.DEFAULT)");
            return string2;
        }

        @Nullable
        public final Bitmap convert(@NotNull String string2) {
            String string3 = string2;
            Intrinsics.checkNotNullParameter((Object)string3, (String)"base64Str");
            String string4 = string3.substring(StringsKt.indexOf$default((CharSequence)string3, (String)",", (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            byte[] byArray = Base64.decode((String)string4, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(\n                \u2026e64.DEFAULT\n            )");
            return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
        }

        @Nullable
        public final String convert(@NotNull Bitmap bitmap) {
            ByteArrayOutputStream byteArrayOutputStream;
            Bitmap bitmap2 = bitmap;
            Intrinsics.checkNotNullParameter((Object)bitmap2, (String)"bitmap");
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap2.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)byteArrayOutputStream2);
            return Base64.encodeToString((byte[])byteArrayOutputStream2.toByteArray(), (int)0);
        }

        @NotNull
        public final Bitmap crop(@NotNull Bitmap bitmap, int n, int n2, float f, float f2) {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"src");
            if (!(f < 0.0f || f > 1.0f || f2 < 0.0f || f2 > 1.0f)) {
                Matrix matrix;
                Bitmap bitmap2 = bitmap;
                int n3 = bitmap2.getWidth();
                int n4 = bitmap2.getHeight();
                if (n == n3 && n2 == n4) {
                    return bitmap;
                }
                Bitmap bitmap3 = bitmap;
                bitmap = matrix;
                matrix = new Matrix();
                float f3 = n;
                float f4 = n3;
                float f5 = f3 / f4;
                float f6 = n2;
                float f7 = n4;
                float f8 = f3;
                f3 = Math.max(f5, f6 / f7);
                bitmap.setScale(f3, f3);
                int n5 = Math.round(f8 / f3);
                int n6 = Math.round(f6 / f3);
                int n7 = (int)(f4 * f - (float)(n5 / 2));
                n3 = Math.max(Math.min(n7, n3 - n5), 0);
                Bitmap bitmap4 = Bitmap.createBitmap((Bitmap)bitmap3, (int)n3, (int)Math.max(Math.min((int)(f7 * f2 - (float)(n6 / 2)), n4 - n6), 0), (int)n5, (int)n6, (Matrix)bitmap, (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap4, (String)"cropped");
                return bitmap4;
            }
            throw new IllegalArgumentException("horizontalCenterPercent and verticalCenterPercent must be between 0.0f and 1.0f, inclusive.".toString());
        }

        @NotNull
        public final Bitmap base64ToBitmap(@NotNull String string2) {
            String string3 = string2;
            Intrinsics.checkNotNullParameter((Object)string3, (String)"base64");
            byte[] byArray = Base64.decode((String)StringsKt.replace$default((String)string3, (String)"data:image/jpeg;base64,", (String)"", (boolean)false, (int)4, null), (int)0);
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"decodeByteArray(decodedB\u2026es, 0, decodedBytes.size)");
            return bitmap;
        }

        public final float dpToPx(int n, int n2) {
            return (float)(n2 * n) / 160.0f;
        }

        public final float pxToDp(int n, int n2) {
            return (float)n * 160.0f / (float)n2;
        }

        @NotNull
        public final Bitmap rotateBitmapToStraight(@NotNull Bitmap bitmap, int n, boolean bl) {
            Matrix matrix;
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"srcBmp");
            Companion companion = matrix;
            matrix = new Matrix();
            float f = 1.0f;
            float f2 = bl ? -1.0f : 1.0f;
            Bitmap bitmap2 = bitmap;
            companion.setScale(f, f2);
            companion.postRotate(n);
            int n2 = bitmap2.getWidth();
            n = bitmap2.getHeight();
            Bitmap bitmap3 = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n2, (int)n, (Matrix)companion, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"createBitmap(\n          \u2026      false\n            )");
            return bitmap3;
        }

        @Nullable
        public final Bitmap getBitmapFromUri(@NotNull ContentResolver contentResolver, @Nullable Uri uri) {
            InputStream inputStream;
            Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
            if (uri != null && (inputStream = contentResolver.openInputStream(uri)) != null) {
                Helpers.Companion companion = Helpers.Companion;
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = "Picked image from inputStream " + uri;
                companion.printLog(objectArray2);
                int n = new androidx.exifinterface.media.ExifInterface(inputStream).getAttributeInt("Orientation", 1);
                n = n != 3 ? (n != 6 ? (n != 8 ? 0 : 270) : 90) : 180;
                Companion companion2 = companion3;
                Bitmap bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)contentResolver, (Uri)uri);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"getBitmap(contentResolver, imgUri)");
                Companion companion3 = vn.kalapa.ekyc.utils.BitmapUtil$Companion.rotateBitmapToStraight$default(companion3, bitmap, n, false, 4, null);
                Object[] objectArray3 = new Object[1];
                int n2 = n;
                Companion companion4 = companion3;
                Intrinsics.checkNotNull((Object)companion4);
                int n3 = companion4.getWidth();
                int n4 = companion4.getHeight();
                n = companion4.getByteCount();
                objectArray3[0] = "Picked image: " + uri + " with Rotation " + n2 + " " + n3 + " " + n4 + " " + n;
                companion.printLog(objectArray3);
                companion3 = companion2.resizeImageFromGallery((Bitmap)companion3);
                Object[] objectArray4 = new Object[1];
                Companion companion5 = companion3;
                Intrinsics.checkNotNull((Object)companion5);
                Companion companion6 = companion3;
                int n5 = companion6.getWidth();
                objectArray4[0] = "Picked image: Compress " + companion5.getByteCount() + " " + n5 + " " + companion6.getHeight();
                companion.printLog(objectArray4);
                return companion3;
            }
            return null;
        }

        @NotNull
        public final Bitmap imageProxyToBitmap(@NotNull ImageProxy object) {
            Matrix matrix;
            ImageProxy imageProxy = object;
            Intrinsics.checkNotNullParameter((Object)imageProxy, (String)"image");
            Companion companion = matrix;
            matrix = new Matrix();
            object = imageProxy.getPlanes()[0].getBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"planeProxy.buffer");
            int n = ((Buffer)object).remaining();
            byte[] byArray = new byte[n];
            int n2 = new ExifInterface((InputStream)new ByteArrayInputStream(byArray)).getAttributeInt("Orientation", 1);
            ((ByteBuffer)object).get(byArray);
            object = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)n);
            if (n2 != 3) {
                if (n2 != 6) {
                    if (n2 == 8) {
                        Object object2 = object;
                        companion.postRotate(270.0f);
                        int n3 = object2.getWidth();
                        n = object2.getHeight();
                        object = Bitmap.createBitmap((Bitmap)object2, (int)0, (int)0, (int)n3, (int)n, (Matrix)companion, (boolean)true);
                    }
                } else {
                    Object object3 = object;
                    companion.postRotate(90.0f);
                    int n4 = object3.getWidth();
                    n = object3.getHeight();
                    object = Bitmap.createBitmap((Bitmap)object3, (int)0, (int)0, (int)n4, (int)n, (Matrix)companion, (boolean)true);
                }
            } else {
                Object object4 = object;
                companion.postRotate(180.0f);
                int n5 = object4.getWidth();
                n = object4.getHeight();
                object = Bitmap.createBitmap((Bitmap)object4, (int)0, (int)0, (int)n5, (int)n, (Matrix)companion, (boolean)true);
            }
            Object object5 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"bitmap");
            return object5;
        }

        @NotNull
        public final String getTU_BASE64() {
            return TU_BASE64;
        }
    }
}

