/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import vn.kalapa.R;

public class CircleView
extends View {
    private static final int START_ANGLE_POINT = 270;
    private static Float frameWidth = Float.valueOf(0.0f);
    private static Float frameHeight = Float.valueOf(0.0f);
    private static Integer frameAngle = 0;
    private static Float strokeWidth = Float.valueOf(0.0f);
    private final Paint paint;
    private final RectF rect;
    private float angle;

    public CircleView(Context context, AttributeSet attributeSet) {
        CircleView circleView = this;
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.CircleView);
        frameWidth = Float.valueOf(typedArray.getDimension(R.styleable.CircleView_frameWidth, 0.0f));
        frameHeight = Float.valueOf(typedArray.getDimension(R.styleable.CircleView_frameHeight, 0.0f));
        frameAngle = typedArray.getInteger(R.styleable.CircleView_viewAngle, 0);
        strokeWidth = Float.valueOf(typedArray.getDimension(R.styleable.CircleView_viewStroke, 20.0f));
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(strokeWidth.floatValue());
        this.paint.setColor(-16776961);
        circleView.rect = new RectF(strokeWidth.floatValue(), strokeWidth.floatValue(), strokeWidth.floatValue() + frameWidth.floatValue(), strokeWidth.floatValue() + frameHeight.floatValue());
        circleView.angle = frameAngle.intValue();
    }

    public void setPaintColor(int n) {
        CircleView circleView = circleView.paint;
        if (circleView != null) {
            circleView.setColor(n);
        }
    }

    public void onDraw(Canvas canvas) {
        CircleView circleView = circleView2;
        super.onDraw(canvas);
        CircleView circleView2 = circleView.rect;
        float f = circleView.angle;
        Paint paint = circleView.paint;
        canvas.drawArc((RectF)circleView2, 270.0f, f, true, paint);
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float f) {
        this.angle = f;
    }
}

