/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.Gost2814789EncryptedKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.GostR3410TransportParameters;

public class GostR3410KeyTransport
extends ASN1Object {
    private final Gost2814789EncryptedKey sessionEncryptedKey;
    private final GostR3410TransportParameters transportParameters;

    private GostR3410KeyTransport(ASN1Sequence aSN1Sequence) {
        this.sessionEncryptedKey = Gost2814789EncryptedKey.getInstance(aSN1Sequence.getObjectAt(0));
        this.transportParameters = GostR3410TransportParameters.getInstance(ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(1)), false);
    }

    public GostR3410KeyTransport(Gost2814789EncryptedKey gost2814789EncryptedKey, GostR3410TransportParameters gostR3410TransportParameters) {
        this.sessionEncryptedKey = gost2814789EncryptedKey;
        this.transportParameters = gostR3410TransportParameters;
    }

    public static GostR3410KeyTransport getInstance(Object object) {
        if (object instanceof GostR3410KeyTransport) {
            return (GostR3410KeyTransport)object;
        }
        if (object != null) {
            return new GostR3410KeyTransport(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public Gost2814789EncryptedKey getSessionEncryptedKey() {
        return this.sessionEncryptedKey;
    }

    public GostR3410TransportParameters getTransportParameters() {
        return this.transportParameters;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(2);
        aSN1EncodableVector.add(aSN1Object.sessionEncryptedKey);
        ASN1Object aSN1Object = aSN1Object.transportParameters;
        if (aSN1Object != null) {
            DERTaggedObject dERTaggedObject;
            DERTaggedObject dERTaggedObject2 = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(false, 0, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject2);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

