/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Boolean;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Extension;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class X509Extensions
extends ASN1Object {
    public static final ASN1ObjectIdentifier SubjectDirectoryAttributes = new ASN1ObjectIdentifier("2.5.29.9");
    public static final ASN1ObjectIdentifier SubjectKeyIdentifier = new ASN1ObjectIdentifier("2.5.29.14");
    public static final ASN1ObjectIdentifier KeyUsage = new ASN1ObjectIdentifier("2.5.29.15");
    public static final ASN1ObjectIdentifier PrivateKeyUsagePeriod = new ASN1ObjectIdentifier("2.5.29.16");
    public static final ASN1ObjectIdentifier SubjectAlternativeName = new ASN1ObjectIdentifier("2.5.29.17");
    public static final ASN1ObjectIdentifier IssuerAlternativeName = new ASN1ObjectIdentifier("2.5.29.18");
    public static final ASN1ObjectIdentifier BasicConstraints = new ASN1ObjectIdentifier("2.5.29.19");
    public static final ASN1ObjectIdentifier CRLNumber = new ASN1ObjectIdentifier("2.5.29.20");
    public static final ASN1ObjectIdentifier ReasonCode = new ASN1ObjectIdentifier("2.5.29.21");
    public static final ASN1ObjectIdentifier InstructionCode = new ASN1ObjectIdentifier("2.5.29.23");
    public static final ASN1ObjectIdentifier InvalidityDate = new ASN1ObjectIdentifier("2.5.29.24");
    public static final ASN1ObjectIdentifier DeltaCRLIndicator = new ASN1ObjectIdentifier("2.5.29.27");
    public static final ASN1ObjectIdentifier IssuingDistributionPoint = new ASN1ObjectIdentifier("2.5.29.28");
    public static final ASN1ObjectIdentifier CertificateIssuer = new ASN1ObjectIdentifier("2.5.29.29");
    public static final ASN1ObjectIdentifier NameConstraints = new ASN1ObjectIdentifier("2.5.29.30");
    public static final ASN1ObjectIdentifier CRLDistributionPoints = new ASN1ObjectIdentifier("2.5.29.31");
    public static final ASN1ObjectIdentifier CertificatePolicies = new ASN1ObjectIdentifier("2.5.29.32");
    public static final ASN1ObjectIdentifier PolicyMappings = new ASN1ObjectIdentifier("2.5.29.33");
    public static final ASN1ObjectIdentifier AuthorityKeyIdentifier = new ASN1ObjectIdentifier("2.5.29.35");
    public static final ASN1ObjectIdentifier PolicyConstraints = new ASN1ObjectIdentifier("2.5.29.36");
    public static final ASN1ObjectIdentifier ExtendedKeyUsage = new ASN1ObjectIdentifier("2.5.29.37");
    public static final ASN1ObjectIdentifier FreshestCRL = new ASN1ObjectIdentifier("2.5.29.46");
    public static final ASN1ObjectIdentifier InhibitAnyPolicy = new ASN1ObjectIdentifier("2.5.29.54");
    public static final ASN1ObjectIdentifier AuthorityInfoAccess = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.1.1");
    public static final ASN1ObjectIdentifier SubjectInfoAccess = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.1.11");
    public static final ASN1ObjectIdentifier LogoType = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.1.12");
    public static final ASN1ObjectIdentifier BiometricInfo = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.1.2");
    public static final ASN1ObjectIdentifier QCStatements = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.1.3");
    public static final ASN1ObjectIdentifier AuditIdentity = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.1.4");
    public static final ASN1ObjectIdentifier NoRevAvail = new ASN1ObjectIdentifier("2.5.29.56");
    public static final ASN1ObjectIdentifier TargetInformation = new ASN1ObjectIdentifier("2.5.29.55");
    private Hashtable extensions;
    private Vector ordering;

    public static X509Extensions getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return X509Extensions.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static X509Extensions getInstance(Object object) {
        if (object != null && !(object instanceof X509Extensions)) {
            if (object instanceof ASN1Sequence) {
                return new X509Extensions((ASN1Sequence)object);
            }
            if (object instanceof Extensions) {
                return new X509Extensions((ASN1Sequence)((Extensions)object).toASN1Primitive());
            }
            if (object instanceof ASN1TaggedObject) {
                return X509Extensions.getInstance(((ASN1TaggedObject)object).getObject());
            }
            throw new IllegalArgumentException(c.a(object, b.b.a("illegal object in getInstance: ")));
        }
        return (X509Extensions)object;
    }

    public X509Extensions(ASN1Sequence object) {
        Vector vector;
        Hashtable hashtable;
        ASN1Sequence aSN1Sequence = object;
        object = hashtable;
        hashtable = new Hashtable();
        this.extensions = object;
        object = vector;
        vector = new Vector();
        this.ordering = object;
        object = aSN1Sequence.getObjects();
        while (object.hasMoreElements()) {
            ASN1Sequence aSN1Sequence2;
            block5: {
                block4: {
                    block3: {
                        aSN1Sequence2 = ASN1Sequence.getInstance(object.nextElement());
                        if (aSN1Sequence2.size() != 3) break block3;
                        ASN1Sequence aSN1Sequence3 = aSN1Sequence2;
                        ASN1Boolean aSN1Boolean = ASN1Boolean.getInstance(aSN1Sequence3.getObjectAt(1));
                        this.extensions.put(aSN1Sequence2.getObjectAt(0), new X509Extension(aSN1Boolean, ASN1OctetString.getInstance(aSN1Sequence3.getObjectAt(2))));
                        break block4;
                    }
                    if (aSN1Sequence2.size() != 2) break block5;
                    this.extensions.put(aSN1Sequence2.getObjectAt(0), new X509Extension(false, ASN1OctetString.getInstance(aSN1Sequence2.getObjectAt(1))));
                }
                this.ordering.addElement(aSN1Sequence2.getObjectAt(0));
                continue;
            }
            throw new IllegalArgumentException(b.a(aSN1Sequence2, b.b.a("Bad sequence size: ")));
        }
    }

    public X509Extensions(Hashtable hashtable) {
        this(null, hashtable);
    }

    public X509Extensions(Vector enumeration, Hashtable hashtable) {
        Vector vector;
        Hashtable hashtable2;
        Object object = hashtable2;
        hashtable2 = new Hashtable();
        this.extensions = object;
        object = vector;
        vector = new Vector();
        this.ordering = object;
        enumeration = enumeration == null ? hashtable.keys() : ((Vector)((Object)enumeration)).elements();
        while (enumeration.hasMoreElements()) {
            this.ordering.addElement(ASN1ObjectIdentifier.getInstance(enumeration.nextElement()));
        }
        enumeration = this.ordering.elements();
        while (enumeration.hasMoreElements()) {
            object = ASN1ObjectIdentifier.getInstance(enumeration.nextElement());
            X509Extension x509Extension = (X509Extension)hashtable.get(object);
            this.extensions.put(object, x509Extension);
        }
    }

    public X509Extensions(Vector object, Vector vector) {
        Vector vector2;
        Hashtable hashtable;
        Vector vector3 = object;
        object = hashtable;
        hashtable = new Hashtable();
        this.extensions = object;
        object = vector2;
        vector2 = new Vector();
        this.ordering = object;
        object = vector3.elements();
        while (object.hasMoreElements()) {
            this.ordering.addElement(object.nextElement());
        }
        int n = 0;
        Enumeration enumeration = this.ordering.elements();
        while (enumeration.hasMoreElements()) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
            X509Extension x509Extension = (X509Extension)vector.elementAt(n);
            this.extensions.put(aSN1ObjectIdentifier, x509Extension);
            ++n;
        }
    }

    private ASN1ObjectIdentifier[] getExtensionOIDs(boolean bl) {
        Vector vector;
        Vector vector2 = vector;
        vector = new Vector();
        for (int k = 0; k != this.ordering.size(); ++k) {
            X509Extensions x509Extensions = this;
            Object e2 = x509Extensions.ordering.elementAt(k);
            if (((X509Extension)x509Extensions.extensions.get(e2)).isCritical() != bl) continue;
            vector2.addElement(e2);
        }
        return this.toOidArray(vector2);
    }

    private ASN1ObjectIdentifier[] toOidArray(Vector vector) {
        int n = vector.size();
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray = new ASN1ObjectIdentifier[n];
        for (int k = 0; k != n; ++k) {
            aSN1ObjectIdentifierArray[k] = (ASN1ObjectIdentifier)vector.elementAt(k);
        }
        return aSN1ObjectIdentifierArray;
    }

    public Enumeration oids() {
        return this.ordering.elements();
    }

    public X509Extension getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return (X509Extension)this.extensions.get(aSN1ObjectIdentifier);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(this.ordering.size());
        Enumeration enumeration = this.ordering.elements();
        while (enumeration.hasMoreElements()) {
            ASN1EncodableVector aSN1EncodableVector3;
            ASN1EncodableVector aSN1EncodableVector4 = aSN1EncodableVector3;
            aSN1EncodableVector4(3);
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
            X509Extension x509Extension = (X509Extension)this.extensions.get(aSN1ObjectIdentifier);
            aSN1EncodableVector3.add(aSN1ObjectIdentifier);
            if (x509Extension.isCritical()) {
                aSN1EncodableVector4.add(ASN1Boolean.TRUE);
            }
            aSN1EncodableVector4.add(x509Extension.getValue());
            aSN1EncodableVector2.add(new DERSequence(aSN1EncodableVector4));
        }
        return new DERSequence(aSN1EncodableVector2);
    }

    public boolean equivalent(X509Extensions x509Extensions) {
        if (this.extensions.size() != x509Extensions.extensions.size()) {
            return false;
        }
        Enumeration enumeration = this.extensions.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (this.extensions.get(k).equals(x509Extensions.extensions.get(k))) continue;
            return false;
        }
        return true;
    }

    public ASN1ObjectIdentifier[] getExtensionOIDs() {
        X509Extensions x509Extensions = this;
        return x509Extensions.toOidArray(x509Extensions.ordering);
    }

    public ASN1ObjectIdentifier[] getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public ASN1ObjectIdentifier[] getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }
}

