/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.qualified;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Choice;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERPrintableString;

public class Iso4217CurrencyCode
extends ASN1Object
implements ASN1Choice {
    public final int ALPHABETIC_MAXSIZE;
    public final int NUMERIC_MINSIZE;
    public final int NUMERIC_MAXSIZE;
    public ASN1Encodable obj;
    public int numeric;

    public static Iso4217CurrencyCode getInstance(Object object) {
        if (object != null && !(object instanceof Iso4217CurrencyCode)) {
            if (object instanceof ASN1Integer) {
                int n = ASN1Integer.getInstance(object).intValueExact();
                return new Iso4217CurrencyCode(n);
            }
            if (object instanceof DERPrintableString) {
                object = DERPrintableString.getInstance(object);
                return new Iso4217CurrencyCode(((DERPrintableString)object).getString());
            }
            throw new IllegalArgumentException("unknown object in getInstance");
        }
        return (Iso4217CurrencyCode)object;
    }

    public Iso4217CurrencyCode(int n) {
        this.ALPHABETIC_MAXSIZE = 3;
        this.NUMERIC_MINSIZE = 1;
        this.NUMERIC_MAXSIZE = 999;
        if (n <= 999 && n >= 1) {
            this.obj = new ASN1Integer(n);
            return;
        }
        throw new IllegalArgumentException("wrong size in numeric code : not in (1..999)");
    }

    public Iso4217CurrencyCode(String string) {
        aSN1Object.ALPHABETIC_MAXSIZE = 3;
        aSN1Object.NUMERIC_MINSIZE = 1;
        aSN1Object.NUMERIC_MAXSIZE = 999;
        if (string.length() <= 3) {
            DERPrintableString dERPrintableString;
            Iso4217CurrencyCode iso4217CurrencyCode = aSN1Object;
            ASN1Object aSN1Object = dERPrintableString;
            dERPrintableString = new DERPrintableString(string);
            iso4217CurrencyCode.obj = aSN1Object;
            return;
        }
        throw new IllegalArgumentException("wrong size in alphabetic code : max size is 3");
    }

    public boolean isAlphabetic() {
        return this.obj instanceof DERPrintableString;
    }

    public String getAlphabetic() {
        return ((DERPrintableString)this.obj).getString();
    }

    public int getNumeric() {
        return ((ASN1Integer)this.obj).intValueExact();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.obj.toASN1Primitive();
    }
}

