/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.SkippingStreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class SICBlockCipher
extends StreamBlockCipher
implements SkippingStreamCipher {
    private final BlockCipher cipher;
    private final int blockSize;
    private byte[] IV;
    private byte[] counter;
    private byte[] counterOut;
    private int byteCount;

    public SICBlockCipher(BlockCipher blockCipher) {
        int n;
        SICBlockCipher sICBlockCipher = this;
        super(blockCipher);
        this.cipher = blockCipher;
        sICBlockCipher.blockSize = n = blockCipher.getBlockSize();
        sICBlockCipher.IV = new byte[n];
        sICBlockCipher.counter = new byte[n];
        sICBlockCipher.counterOut = new byte[n];
        sICBlockCipher.byteCount = 0;
    }

    private void checkCounter() {
        block2: {
            if (this.IV.length < this.blockSize) {
                int n = 0;
                while (true) {
                    byte[] byArray = this.IV;
                    if (n == this.IV.length) break block2;
                    if (this.counter[n] != byArray[n]) break;
                    ++n;
                }
                throw new IllegalStateException("Counter in CTR/SIC mode out of range.");
            }
        }
    }

    private void incrementCounterAt(int n) {
        n = this.counter.length - n;
        while ((n += -1) >= 0) {
            byte by;
            byte[] byArray = this.counter;
            byArray[n] = by = (byte)(this.counter[n] + 1);
            if (by == 0) continue;
        }
    }

    private void incrementCounter(int n) {
        byte[] byArray = this.counter;
        byte by = this.counter[byArray.length - 1];
        int n2 = byArray.length - 1;
        byArray[n2] = (byte)(byArray[n2] + n);
        if (by != 0 && byArray[byArray.length - 1] < by) {
            this.incrementCounterAt(1);
        }
    }

    private void decrementCounterAt(int n) {
        n = this.counter.length - n;
        while ((n += -1) >= 0) {
            byte by;
            byte[] byArray = this.counter;
            byArray[n] = by = (byte)(this.counter[n] - 1);
            if (by == -1) continue;
            return;
        }
    }

    private void adjustCounter(long l) {
        if (l >= 0L) {
            long l2;
            long l3 = (l + (long)this.byteCount) / (long)this.blockSize;
            if (l3 > 255L) {
                l2 = l3;
                for (int k = 5; k >= 1; --k) {
                    int n = k * 8;
                    long l4 = 1L << n;
                    while (l2 >= l4) {
                        this.incrementCounterAt(k);
                        l2 -= l4;
                    }
                }
            } else {
                l2 = l3;
            }
            SICBlockCipher sICBlockCipher = this;
            sICBlockCipher.incrementCounter((int)l2);
            this.byteCount = (int)(l + (long)sICBlockCipher.byteCount - (long)this.blockSize * l3);
        } else {
            long l5;
            long l6;
            long l7 = (-l - (long)this.byteCount) / (long)this.blockSize;
            if (l7 > 255L) {
                l6 = l7;
                for (int k = 5; k >= 1; --k) {
                    int n = k * 8;
                    l5 = 1L << n;
                    while (l6 > l5) {
                        this.decrementCounterAt(k);
                        l6 -= l5;
                    }
                }
            } else {
                l6 = l7;
            }
            for (l5 = 0L; l5 != l6; ++l5) {
                this.decrementCounterAt(0);
            }
            SICBlockCipher sICBlockCipher = this;
            int n = (int)((long)sICBlockCipher.blockSize * l7 + (l = (long)sICBlockCipher.byteCount + l));
            if (n >= 0) {
                this.byteCount = 0;
            } else {
                SICBlockCipher sICBlockCipher2 = this;
                sICBlockCipher2.decrementCounterAt(0);
                sICBlockCipher2.byteCount = sICBlockCipher2.blockSize + n;
            }
        }
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        if (object instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)object;
            byte[] byArray = Arrays.clone(parametersWithIV.getIV());
            object = byArray;
            this.IV = byArray;
            int n = this.blockSize;
            if (n >= ((Object)object).length) {
                int n2 = 8 > n / 2 ? n / 2 : 8;
                if (n - ((Object)object).length <= n2) {
                    if (parametersWithIV.getParameters() != null) {
                        this.cipher.init(true, parametersWithIV.getParameters());
                    }
                    this.reset();
                    return;
                }
                throw new IllegalArgumentException(b.b.a("CTR/SIC mode requires IV of at least: ").append(this.blockSize - n2).append(" bytes.").toString());
            }
            throw new IllegalArgumentException(b.a(b.b.a("CTR/SIC mode requires IV no greater than: "), this.blockSize, " bytes."));
        }
        throw new IllegalArgumentException("CTR/SIC mode requires ParametersWithIV");
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/SIC";
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        SICBlockCipher sICBlockCipher = this;
        sICBlockCipher.processBytes(byArray, n, this.blockSize, byArray2, n2);
        return sICBlockCipher.blockSize;
    }

    @Override
    public byte calculateByte(byte by) {
        int n;
        int n2 = this.byteCount;
        if (n2 == 0) {
            SICBlockCipher sICBlockCipher = this;
            SICBlockCipher sICBlockCipher2 = this;
            byte[] byArray = sICBlockCipher2.counter;
            byte[] byArray2 = sICBlockCipher2.counterOut;
            sICBlockCipher.cipher.processBlock(byArray, 0, byArray2, 0);
            int n3 = this.byteCount;
            this.byteCount = n3 + 1;
            return (byte)(sICBlockCipher.counterOut[n3] ^ by);
        }
        byte[] byArray = this.counterOut;
        this.byteCount = n = n2 + 1;
        by = (byte)(byArray[n2] ^ by);
        if (n == this.counter.length) {
            SICBlockCipher sICBlockCipher = this;
            sICBlockCipher.byteCount = 0;
            sICBlockCipher.incrementCounterAt(0);
            sICBlockCipher.checkCounter();
        }
        return by;
    }

    @Override
    public void reset() {
        SICBlockCipher sICBlockCipher = object;
        Arrays.fill(sICBlockCipher.counter, (byte)0);
        Object object = ((SICBlockCipher)object).counter;
        int n = sICBlockCipher.IV.length;
        System.arraycopy(sICBlockCipher.IV, 0, object, 0, n);
        sICBlockCipher.cipher.reset();
        sICBlockCipher.byteCount = 0;
    }

    @Override
    public long skip(long l) {
        SICBlockCipher sICBlockCipher = object;
        sICBlockCipher.adjustCounter(l);
        sICBlockCipher.checkCounter();
        SICBlockCipher sICBlockCipher2 = object;
        Object object = sICBlockCipher2.counter;
        byte[] byArray = sICBlockCipher2.counterOut;
        sICBlockCipher.cipher.processBlock((byte[])object, 0, byArray, 0);
        return l;
    }

    @Override
    public long seekTo(long l) {
        this.reset();
        return this.skip(l);
    }

    @Override
    public long getPosition() {
        byte[] byArray = this.counter;
        int n = this.counter.length;
        byte[] byArray2 = byArray;
        byArray = new byte[n];
        System.arraycopy(byArray2, 0, byArray, 0, n);
        for (int k = n - 1; k >= 1; --k) {
            byte[] byArray3 = this.IV;
            int n2 = k < this.IV.length ? (byArray[k] & 0xFF) - (byArray3[k] & 0xFF) : byArray[k] & 0xFF;
            if (n2 < 0) {
                int n3 = n2;
                n2 = k - 1;
                byArray[n2] = (byte)(byArray[n2] - 1);
                n2 = n3 + 256;
            }
            byArray[k] = (byte)n2;
        }
        return Pack.bigEndianToLong(byArray, n - 8) * (long)this.blockSize + (long)this.byteCount;
    }
}

