/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm.GCMUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class Tables8kGCMMultiplier
implements GCMMultiplier {
    private byte[] H;
    private long[][][] T;

    @Override
    public void init(byte[] byArray) {
        if (this.T == null) {
            this.T = new long[32][16][2];
        } else if (Arrays.areEqual(this.H, byArray)) {
            return;
        }
        this.H = Arrays.clone(byArray);
        for (int k = 0; k < 32; ++k) {
            long[][][] lArray = this.T;
            long[][] lArray2 = this.T[k];
            if (k == 0) {
                GCMUtil.asLongs(this.H, lArray2[1]);
                long[] lArray3 = lArray2[1];
                GCMUtil.multiplyP3(lArray3, lArray3);
            } else {
                GCMUtil.multiplyP4(lArray[k - 1][1], lArray2[1]);
            }
            for (int i2 = 2; i2 < 16; i2 += 2) {
                GCMUtil.divideP(lArray2[i2 >> 1], lArray2[i2]);
                long[] lArray4 = lArray2[1];
                GCMUtil.xor(lArray2[i2], lArray4, lArray2[i2 + 1]);
            }
        }
    }

    @Override
    public void multiplyH(byte[] byArray) {
        long l = 0L;
        long l2 = 0L;
        for (int k = 15; k >= 0; --k) {
            long[][][] lArray = this.T;
            int n = k;
            int n2 = n + n;
            byte by = byArray[k];
            long[] lArray2 = this.T[n2 + 1][by & 0xF];
            long[] lArray3 = lArray[n2][(by & 0xF0) >>> 4];
            long l3 = l ^ (lArray2[0] ^ lArray3[0]);
            long l4 = l2 ^ (lArray2[1] ^ lArray3[1]);
            l2 = l4;
            l = l3;
        }
        Pack.longToBigEndian(l, byArray, 0);
        Pack.longToBigEndian(l2, byArray, 8);
    }
}

