/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class GenericSigner
implements Signer {
    private final AsymmetricBlockCipher engine;
    private final Digest digest;
    private boolean forSigning;

    public GenericSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this.engine = asymmetricBlockCipher;
        this.digest = digest;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forSigning = bl;
        AsymmetricKeyParameter asymmetricKeyParameter = cipherParameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)cipherParameters).getParameters() : (AsymmetricKeyParameter)cipherParameters;
        if (bl && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("signing requires private key");
        }
        if (!bl && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("verification requires public key");
        }
        GenericSigner genericSigner = this;
        genericSigner.reset();
        genericSigner.engine.init(bl, cipherParameters);
    }

    @Override
    public void update(byte by) {
        this.digest.update(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    @Override
    public byte[] generateSignature() {
        if (this.forSigning) {
            GenericSigner genericSigner = this;
            int n = genericSigner.digest.getDigestSize();
            byte[] byArray = new byte[n];
            genericSigner.digest.doFinal(byArray, 0);
            return genericSigner.engine.processBlock(byArray, 0, n);
        }
        throw new IllegalStateException("GenericSigner not initialised for signature generation.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean verifySignature(byte[] byArray) {
        int n;
        AsymmetricBlockCipher asymmetricBlockCipher;
        if (this.forSigning) throw new IllegalStateException("GenericSigner not initialised for verification");
        GenericSigner genericSigner = this;
        int n2 = genericSigner.digest.getDigestSize();
        byte[] byArray2 = new byte[n2];
        genericSigner.digest.doFinal(byArray2, 0);
        try {
            asymmetricBlockCipher = genericSigner.engine;
            n = 0;
        }
        catch (Exception exception) {
            return false;
        }
        byte[] byArray3 = asymmetricBlockCipher.processBlock(byArray, n, byArray.length);
        if (byArray3.length >= n2) return Arrays.constantTimeAreEqual(byArray3, byArray2);
        byte[] byArray4 = byArray3;
        byte[] byArray5 = byArray3;
        int n3 = n2;
        byte[] byArray6 = byArray3;
        byArray3 = new byte[n2];
        n2 = 0;
        int n4 = n3 - byArray6.length;
        int n5 = byArray4.length;
        System.arraycopy(byArray5, n2, byArray3, n4, n5);
        return Arrays.constantTimeAreEqual(byArray3, byArray2);
    }

    @Override
    public void reset() {
        this.digest.reset();
    }
}

