/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X962Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;

class ECUtils {
    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey publicKey) {
        return publicKey instanceof BCECPublicKey ? ((BCECPublicKey)publicKey).engineGetKeyParameters() : ECUtil.generatePublicKeyParameter(publicKey);
    }

    public static X9ECParameters getDomainParametersFromGenSpec(ECGenParameterSpec eCGenParameterSpec) {
        return ECUtils.getDomainParametersFromName(eCGenParameterSpec.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X9ECParameters getDomainParametersFromName(String object) {
        X9ECParameters x9ECParameters;
        block5: {
            try {
                if (((String)object).charAt(0) >= '0' && ((String)object).charAt(0) <= '2') {
                    x9ECParameters = ECUtil.getNamedCurveByOid(new ASN1ObjectIdentifier((String)object));
                    return x9ECParameters;
                }
                if (((String)object).indexOf(32) <= 0) break block5;
                Object object2 = object;
                object = ((String)object2).substring(((String)object2).indexOf(32) + 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return ECUtil.getNamedCurveByName((String)object);
            }
            x9ECParameters = ECUtil.getNamedCurveByName((String)object);
            return x9ECParameters;
        }
        x9ECParameters = ECUtil.getNamedCurveByName((String)object);
        return x9ECParameters;
    }

    public static X962Parameters getDomainParametersFromName(ECParameterSpec object, boolean bl) {
        if (object instanceof ECNamedCurveSpec) {
            X962Parameters x962Parameters;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ECUtil.getNamedCurveOid(((ECNamedCurveSpec)(object = (ECNamedCurveSpec)object)).getName());
            if (aSN1ObjectIdentifier == null) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier2;
                aSN1ObjectIdentifier = aSN1ObjectIdentifier2;
                aSN1ObjectIdentifier2 = new ASN1ObjectIdentifier(((ECNamedCurveSpec)object).getName());
            }
            object = x962Parameters;
            x962Parameters = new X962Parameters(aSN1ObjectIdentifier);
        } else if (object == null) {
            X962Parameters x962Parameters;
            object = x962Parameters;
            x962Parameters = new X962Parameters(DERNull.INSTANCE);
        } else {
            X962Parameters x962Parameters;
            X9ECPoint x9ECPoint;
            X9ECParameters x9ECParameters;
            Object object2 = EC5Util.convertCurve(((ECParameterSpec)object).getCurve());
            X9ECParameters x9ECParameters2 = x9ECParameters;
            ECCurve eCCurve = object2;
            Object object3 = object;
            X9ECPoint x9ECPoint2 = x9ECPoint;
            x9ECPoint = new X9ECPoint(EC5Util.convertPoint((ECCurve)object2, ((ECParameterSpec)object).getGenerator()), bl);
            object = ((ECParameterSpec)object3).getOrder();
            BigInteger bigInteger = BigInteger.valueOf(((ECParameterSpec)object3).getCofactor());
            object2 = ((ECParameterSpec)object3).getCurve().getSeed();
            x9ECParameters = new X9ECParameters(eCCurve, x9ECPoint2, (BigInteger)object, bigInteger, (byte[])object2);
            object = x962Parameters;
            x962Parameters = new X962Parameters(x9ECParameters2);
        }
        return object;
    }
}

