/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSAESOAEPparams;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.DigestFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.MessageDigestUtils;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public abstract class AlgorithmParametersSpi
extends java.security.AlgorithmParametersSpi {
    public boolean isASN1FormatString(String string) {
        return string == null || string.equals("ASN.1");
    }

    public AlgorithmParameterSpec engineGetParameterSpec(Class clazz) {
        if (clazz != null) {
            return this.localEngineGetParameterSpec(clazz);
        }
        throw new NullPointerException("argument to getParameterSpec must not be null");
    }

    public abstract AlgorithmParameterSpec localEngineGetParameterSpec(Class var1);

    public static class PSS
    extends AlgorithmParametersSpi {
        public PSSParameterSpec currentSpec;

        @Override
        public byte[] engineGetEncoded() {
            ASN1Integer aSN1Integer;
            ASN1Integer aSN1Integer2;
            AlgorithmIdentifier algorithmIdentifier;
            AlgorithmIdentifier algorithmIdentifier2;
            PSSParameterSpec pSSParameterSpec = ((PSS)((Object)pSSParameterSpec)).currentSpec;
            ASN1Object aSN1Object = algorithmIdentifier2;
            ASN1Primitive aSN1Primitive = DERNull.INSTANCE;
            algorithmIdentifier2 = new AlgorithmIdentifier(DigestFactory.getOID(pSSParameterSpec.getDigestAlgorithm()), aSN1Primitive);
            MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)pSSParameterSpec.getMGFParameters();
            AlgorithmIdentifier algorithmIdentifier3 = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, new AlgorithmIdentifier(DigestFactory.getOID(mGF1ParameterSpec.getDigestAlgorithm()), aSN1Primitive));
            AlgorithmIdentifier algorithmIdentifier4 = aSN1Object;
            aSN1Object = aSN1Integer2;
            aSN1Integer2 = new ASN1Integer(pSSParameterSpec.getSaltLength());
            aSN1Primitive = aSN1Integer;
            aSN1Integer = new ASN1Integer(pSSParameterSpec.getTrailerField());
            return new RSASSAPSSparams(algorithmIdentifier4, algorithmIdentifier3, (ASN1Integer)aSN1Object, (ASN1Integer)aSN1Primitive).getEncoded("DER");
        }

        @Override
        public byte[] engineGetEncoded(String string) {
            if (!string.equalsIgnoreCase("X.509") && !string.equalsIgnoreCase("ASN.1")) {
                return null;
            }
            return this.engineGetEncoded();
        }

        @Override
        public AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) {
            if (clazz != PSSParameterSpec.class && clazz != AlgorithmParameterSpec.class) {
                throw new InvalidParameterSpecException("unknown parameter spec passed to PSS parameters object.");
            }
            return this.currentSpec;
        }

        @Override
        public void engineInit(AlgorithmParameterSpec algorithmParameterSpec) {
            if (algorithmParameterSpec instanceof PSSParameterSpec) {
                this.currentSpec = (PSSParameterSpec)algorithmParameterSpec;
                return;
            }
            throw new InvalidParameterSpecException("PSSParameterSpec required to initialise an PSS algorithm parameters object");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void engineInit(byte[] object) {
            MGF1ParameterSpec mGF1ParameterSpec;
            PSSParameterSpec pSSParameterSpec;
            object = RSASSAPSSparams.getInstance(object);
            if (!((RSASSAPSSparams)object).getMaskGenAlgorithm().getAlgorithm().equals(PKCSObjectIdentifiers.id_mgf1)) throw new IOException("unknown mask generation function: " + ((RSASSAPSSparams)object).getMaskGenAlgorithm().getAlgorithm());
            PSS pSS = string2;
            PSSParameterSpec pSSParameterSpec2 = pSSParameterSpec;
            PSSParameterSpec pSSParameterSpec3 = pSSParameterSpec;
            String string = MessageDigestUtils.getDigestName(((RSASSAPSSparams)object).getHashAlgorithm().getAlgorithm());
            Object object2 = object;
            Object object3 = object2;
            Object object4 = object2;
            String string2 = PSSParameterSpec.DEFAULT.getMGFAlgorithm();
            MGF1ParameterSpec mGF1ParameterSpec2 = mGF1ParameterSpec;
            mGF1ParameterSpec = new MGF1ParameterSpec(MessageDigestUtils.getDigestName(AlgorithmIdentifier.getInstance(((RSASSAPSSparams)object).getMaskGenAlgorithm().getParameters()).getAlgorithm()));
            int n = ((RSASSAPSSparams)object3).getSaltLength().intValue();
            int n2 = ((RSASSAPSSparams)object4).getTrailerField().intValue();
            try {
                pSSParameterSpec2(string, string2, mGF1ParameterSpec2, n, n2);
                pSS.currentSpec = pSSParameterSpec3;
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("Not a valid PSS Parameter encoding.");
            }
            catch (ClassCastException classCastException) {
                throw new IOException("Not a valid PSS Parameter encoding.");
            }
        }

        @Override
        public void engineInit(byte[] byArray, String string) {
            if (!this.isASN1FormatString(string) && !string.equalsIgnoreCase("X.509")) {
                throw new IOException(i.a("Unknown parameter format ", string));
            }
            this.engineInit(byArray);
        }

        @Override
        public String engineToString() {
            return "PSS Parameters";
        }
    }

    public static class OAEP
    extends AlgorithmParametersSpi {
        public OAEPParameterSpec currentSpec;

        @Override
        public byte[] engineGetEncoded() {
            AlgorithmIdentifier algorithmIdentifier;
            AlgorithmIdentifier algorithmIdentifier2;
            AlgorithmIdentifier algorithmIdentifier3;
            OAEP oAEP = object;
            AlgorithmIdentifier algorithmIdentifier4 = algorithmIdentifier3;
            Object object = DERNull.INSTANCE;
            algorithmIdentifier3 = new AlgorithmIdentifier(DigestFactory.getOID(((OAEP)object).currentSpec.getDigestAlgorithm()), (ASN1Encodable)object);
            Object object2 = (MGF1ParameterSpec)oAEP.currentSpec.getMGFParameters();
            AlgorithmIdentifier algorithmIdentifier5 = algorithmIdentifier2;
            algorithmIdentifier2 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, new AlgorithmIdentifier(DigestFactory.getOID(((MGF1ParameterSpec)object2).getDigestAlgorithm()), (ASN1Encodable)object));
            object = (PSource.PSpecified)oAEP.currentSpec.getPSource();
            object2 = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_pSpecified, new DEROctetString(((PSource.PSpecified)object).getValue()));
            try {
                return new RSAESOAEPparams(algorithmIdentifier4, algorithmIdentifier5, (AlgorithmIdentifier)object2).getEncoded("DER");
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error encoding OAEPParameters");
            }
        }

        @Override
        public byte[] engineGetEncoded(String string) {
            if (!this.isASN1FormatString(string) && !string.equalsIgnoreCase("X.509")) {
                return null;
            }
            return this.engineGetEncoded();
        }

        @Override
        public AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) {
            if (clazz != OAEPParameterSpec.class && clazz != AlgorithmParameterSpec.class) {
                throw new InvalidParameterSpecException("unknown parameter spec passed to OAEP parameters object.");
            }
            return this.currentSpec;
        }

        @Override
        public void engineInit(AlgorithmParameterSpec algorithmParameterSpec) {
            if (algorithmParameterSpec instanceof OAEPParameterSpec) {
                this.currentSpec = (OAEPParameterSpec)algorithmParameterSpec;
                return;
            }
            throw new InvalidParameterSpecException("OAEPParameterSpec required to initialise an OAEP algorithm parameters object");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void engineInit(byte[] object) {
            PSource.PSpecified pSpecified;
            OAEPParameterSpec oAEPParameterSpec;
            object = RSAESOAEPparams.getInstance(object);
            if (!((RSAESOAEPparams)object).getMaskGenAlgorithm().getAlgorithm().equals(PKCSObjectIdentifiers.id_mgf1)) throw new IOException("unknown mask generation function: " + ((RSAESOAEPparams)object).getMaskGenAlgorithm().getAlgorithm());
            OAEP oAEP = pSpecified2;
            OAEPParameterSpec oAEPParameterSpec2 = oAEPParameterSpec;
            OAEPParameterSpec oAEPParameterSpec3 = oAEPParameterSpec;
            String string = MessageDigestUtils.getDigestName(((RSAESOAEPparams)object).getHashAlgorithm().getAlgorithm());
            String string2 = OAEPParameterSpec.DEFAULT.getMGFAlgorithm();
            MGF1ParameterSpec mGF1ParameterSpec = new MGF1ParameterSpec(MessageDigestUtils.getDigestName(AlgorithmIdentifier.getInstance(((RSAESOAEPparams)object).getMaskGenAlgorithm().getParameters()).getAlgorithm()));
            PSource.PSpecified pSpecified2 = pSpecified;
            try {
                pSpecified = new PSource.PSpecified(ASN1OctetString.getInstance(((RSAESOAEPparams)object).getPSourceAlgorithm().getParameters()).getOctets());
                oAEPParameterSpec2(string, string2, mGF1ParameterSpec, pSpecified2);
                oAEP.currentSpec = oAEPParameterSpec3;
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("Not a valid OAEP Parameter encoding.");
            }
            catch (ClassCastException classCastException) {
                throw new IOException("Not a valid OAEP Parameter encoding.");
            }
        }

        @Override
        public void engineInit(byte[] byArray, String string) {
            if (!string.equalsIgnoreCase("X.509") && !string.equalsIgnoreCase("ASN.1")) {
                throw new IOException(i.a("Unknown parameter format ", string));
            }
            this.engineInit(byArray);
        }

        @Override
        public String engineToString() {
            return "OAEP Parameters";
        }
    }
}

