/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McElieceKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McElieceParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GoppaCode;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Matrix;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2m;
import java.security.SecureRandom;

public class McElieceKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.1";
    private McElieceKeyGenerationParameters mcElieceParams;
    private int m;
    private int n;
    private int t;
    private int fieldPoly;
    private SecureRandom random;
    private boolean initialized = false;

    private void initializeDefault() {
        McElieceParameters mcElieceParameters;
        McElieceKeyGenerationParameters mcElieceKeyGenerationParameters;
        McElieceKeyPairGenerator mcElieceKeyPairGenerator = mcElieceKeyGenerationParameters2;
        McElieceKeyGenerationParameters mcElieceKeyGenerationParameters2 = mcElieceKeyGenerationParameters;
        McElieceParameters mcElieceParameters2 = mcElieceParameters;
        mcElieceParameters = new McElieceParameters();
        mcElieceKeyGenerationParameters = new McElieceKeyGenerationParameters(null, mcElieceParameters2);
        mcElieceKeyPairGenerator.initialize(mcElieceKeyGenerationParameters2);
    }

    private void initialize(KeyGenerationParameters keyGenerationParameters) {
        McElieceKeyPairGenerator mcElieceKeyPairGenerator = this;
        this.mcElieceParams = (McElieceKeyGenerationParameters)keyGenerationParameters;
        mcElieceKeyPairGenerator.random = keyGenerationParameters.getRandom();
        mcElieceKeyPairGenerator.m = mcElieceKeyPairGenerator.mcElieceParams.getParameters().getM();
        mcElieceKeyPairGenerator.n = mcElieceKeyPairGenerator.mcElieceParams.getParameters().getN();
        mcElieceKeyPairGenerator.t = mcElieceKeyPairGenerator.mcElieceParams.getParameters().getT();
        mcElieceKeyPairGenerator.fieldPoly = mcElieceKeyPairGenerator.mcElieceParams.getParameters().getFieldPoly();
        mcElieceKeyPairGenerator.initialized = true;
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        McEliecePrivateKeyParameters mcEliecePrivateKeyParameters;
        McEliecePublicKeyParameters mcEliecePublicKeyParameters;
        Permutation permutation;
        PolynomialGF2mSmallM polynomialGF2mSmallM;
        GF2mField gF2mField;
        if (!this.initialized) {
            this.initializeDefault();
        }
        GF2mField gF2mField2 = gF2mField;
        McElieceKeyPairGenerator mcElieceKeyPairGenerator = this;
        int n = mcElieceKeyPairGenerator.m;
        gF2mField = new GF2mField(n, mcElieceKeyPairGenerator.fieldPoly);
        PolynomialGF2mSmallM polynomialGF2mSmallM2 = polynomialGF2mSmallM;
        McElieceKeyPairGenerator mcElieceKeyPairGenerator2 = this;
        int n2 = mcElieceKeyPairGenerator2.t;
        Object object = mcElieceKeyPairGenerator2.random;
        polynomialGF2mSmallM = new PolynomialGF2mSmallM(gF2mField2, n2, 'I', (SecureRandom)object);
        new PolynomialRingGF2m(gF2mField2, polynomialGF2mSmallM2).getSquareRootMatrix();
        GoppaCode.MaMaPe maMaPe = GoppaCode.computeSystematicForm(GoppaCode.createCanonicalCheckMatrix(gF2mField, polynomialGF2mSmallM), this.random);
        Object object2 = maMaPe.getSecondMatrix();
        object = maMaPe.getPermutation();
        GF2Matrix gF2Matrix = (GF2Matrix)((GF2Matrix)object2).computeTranspose();
        object2 = gF2Matrix.extendLeftCompactForm();
        int n3 = gF2Matrix.getNumRows();
        Object object3 = GF2Matrix.createRandomRegularMatrixAndItsInverse(n3, this.random);
        Permutation permutation2 = permutation;
        McElieceKeyPairGenerator mcElieceKeyPairGenerator3 = this;
        int n4 = mcElieceKeyPairGenerator3.n;
        permutation = new Permutation(n4, mcElieceKeyPairGenerator3.random);
        object2 = (GF2Matrix)((GF2Matrix)object3[0].rightMultiply((Matrix)object2)).rightMultiply(permutation2);
        McEliecePublicKeyParameters mcEliecePublicKeyParameters2 = mcEliecePublicKeyParameters;
        McElieceKeyPairGenerator mcElieceKeyPairGenerator4 = this;
        int n5 = mcElieceKeyPairGenerator4.n;
        mcEliecePublicKeyParameters = new McEliecePublicKeyParameters(n5, mcElieceKeyPairGenerator4.t, (GF2Matrix)object2);
        object2 = mcEliecePrivateKeyParameters;
        int n6 = this.n;
        object3 = object3[1];
        mcEliecePrivateKeyParameters = new McEliecePrivateKeyParameters(n6, n3, gF2mField2, polynomialGF2mSmallM2, (Permutation)object, permutation2, (GF2Matrix)object3);
        return new AsymmetricCipherKeyPair(mcEliecePublicKeyParameters2, (AsymmetricKeyParameter)object2);
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.initialize(keyGenerationParameters);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

