/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.eidparser.lds.SecurityInfo;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChipAuthenticationInfo
extends SecurityInfo {
    private static final long serialVersionUID = 5591988305059068535L;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    private String oid;
    private int version;
    private BigInteger keyId;

    public ChipAuthenticationInfo(String string2, int n) {
        this(string2, n, null);
    }

    public ChipAuthenticationInfo(String string2, int n, BigInteger bigInteger) {
        ChipAuthenticationInfo chipAuthenticationInfo = this;
        chipAuthenticationInfo.oid = string2;
        chipAuthenticationInfo.version = n;
        chipAuthenticationInfo.keyId = bigInteger;
        chipAuthenticationInfo.checkFields();
    }

    public static boolean checkRequiredIdentifier(String string2) {
        return SecurityInfo.ID_CA_DH_3DES_CBC_CBC.equals(string2) || SecurityInfo.ID_CA_ECDH_3DES_CBC_CBC.equals(string2) || "0.4.0.127.0.7.2.2.3.1.2".equals(string2) || "0.4.0.127.0.7.2.2.3.1.3".equals(string2) || "0.4.0.127.0.7.2.2.3.1.4".equals(string2) || "0.4.0.127.0.7.2.2.3.2.2".equals(string2) || "0.4.0.127.0.7.2.2.3.2.3".equals(string2) || "0.4.0.127.0.7.2.2.3.2.4".equals(string2);
    }

    public static String toKeyAgreementAlgorithm(String string2) {
        if (string2 != null) {
            if (!(SecurityInfo.ID_CA_DH_3DES_CBC_CBC.equals(string2) || "0.4.0.127.0.7.2.2.3.1.2".equals(string2) || "0.4.0.127.0.7.2.2.3.1.3".equals(string2) || "0.4.0.127.0.7.2.2.3.1.4".equals(string2))) {
                if (!(SecurityInfo.ID_CA_ECDH_3DES_CBC_CBC.equals(string2) || "0.4.0.127.0.7.2.2.3.2.2".equals(string2) || "0.4.0.127.0.7.2.2.3.2.3".equals(string2) || "0.4.0.127.0.7.2.2.3.2.4".equals(string2))) {
                    throw new NumberFormatException(g.a("Unknown OID: \"", string2, "\""));
                }
                return "ECDH";
            }
            return "DH";
        }
        throw new NumberFormatException("Unknown OID: null");
    }

    public static String toCipherAlgorithm(String string2) {
        if (!SecurityInfo.ID_CA_DH_3DES_CBC_CBC.equals(string2) && !SecurityInfo.ID_CA_ECDH_3DES_CBC_CBC.equals(string2)) {
            if (!("0.4.0.127.0.7.2.2.3.1.2".equals(string2) || "0.4.0.127.0.7.2.2.3.1.3".equals(string2) || "0.4.0.127.0.7.2.2.3.1.4".equals(string2) || "0.4.0.127.0.7.2.2.3.2.2".equals(string2) || "0.4.0.127.0.7.2.2.3.2.3".equals(string2) || "0.4.0.127.0.7.2.2.3.2.4".equals(string2))) {
                throw new NumberFormatException(g.a("Unknown OID: \"", string2, "\""));
            }
            return "AES";
        }
        return "DESede";
    }

    public static String toDigestAlgorithm(String string2) {
        if (!(SecurityInfo.ID_CA_DH_3DES_CBC_CBC.equals(string2) || SecurityInfo.ID_CA_ECDH_3DES_CBC_CBC.equals(string2) || "0.4.0.127.0.7.2.2.3.1.2".equals(string2) || "0.4.0.127.0.7.2.2.3.2.2".equals(string2))) {
            if (!("0.4.0.127.0.7.2.2.3.1.3".equals(string2) || "0.4.0.127.0.7.2.2.3.2.3".equals(string2) || "0.4.0.127.0.7.2.2.3.1.4".equals(string2) || "0.4.0.127.0.7.2.2.3.2.4".equals(string2))) {
                throw new NumberFormatException(g.a("Unknown OID: \"", string2, "\""));
            }
            return "SHA-256";
        }
        return "SHA-1";
    }

    public static int toKeyLength(String string2) {
        if (!(SecurityInfo.ID_CA_DH_3DES_CBC_CBC.equals(string2) || SecurityInfo.ID_CA_ECDH_3DES_CBC_CBC.equals(string2) || "0.4.0.127.0.7.2.2.3.1.2".equals(string2) || "0.4.0.127.0.7.2.2.3.2.2".equals(string2))) {
            if (!"0.4.0.127.0.7.2.2.3.1.3".equals(string2) && !"0.4.0.127.0.7.2.2.3.2.3".equals(string2)) {
                if (!"0.4.0.127.0.7.2.2.3.1.4".equals(string2) && !"0.4.0.127.0.7.2.2.3.2.4".equals(string2)) {
                    throw new NumberFormatException(g.a("Unknown OID: \"", string2, "\""));
                }
                return 256;
            }
            return 192;
        }
        return 128;
    }

    private static String toProtocolOIDString(String string2) {
        if (SecurityInfo.ID_CA_DH_3DES_CBC_CBC.equals(string2)) {
            return "id-CA-DH-3DES-CBC-CBC";
        }
        if ("0.4.0.127.0.7.2.2.3.1.2".equals(string2)) {
            return "id-CA-DH-AES-CBC-CMAC-128";
        }
        if ("0.4.0.127.0.7.2.2.3.1.3".equals(string2)) {
            return "id-CA-DH-AES-CBC-CMAC-192";
        }
        if ("0.4.0.127.0.7.2.2.3.1.4".equals(string2)) {
            return "id-CA-DH-AES-CBC-CMAC-256";
        }
        if (SecurityInfo.ID_CA_ECDH_3DES_CBC_CBC.equals(string2)) {
            return "id-CA-ECDH-3DES-CBC-CBC";
        }
        if ("0.4.0.127.0.7.2.2.3.2.2".equals(string2)) {
            return "id-CA-ECDH-AES-CBC-CMAC-128";
        }
        if ("0.4.0.127.0.7.2.2.3.2.3".equals(string2)) {
            return "id-CA-ECDH-AES-CBC-CMAC-192";
        }
        if ("0.4.0.127.0.7.2.2.3.2.4".equals(string2)) {
            string2 = "id-CA-ECDH-AES-CBC-CMAC-256";
        }
        return string2;
    }

    @Override
    @Deprecated
    public ASN1Primitive getDERObject() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        new ASN1EncodableVector().add(new ASN1ObjectIdentifier(serializable.oid));
        aSN1EncodableVector2.add(new ASN1Integer(serializable.version));
        Serializable serializable = serializable.keyId;
        if (serializable != null) {
            ASN1Integer aSN1Integer;
            ASN1Integer aSN1Integer2 = aSN1Integer;
            aSN1Integer = new ASN1Integer((BigInteger)serializable);
            aSN1EncodableVector2.add(aSN1Integer2);
        }
        return new DLSequence(aSN1EncodableVector2);
    }

    @Override
    public String getObjectIdentifier() {
        return this.oid;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public String getProtocolOIDString() {
        return ChipAuthenticationInfo.toProtocolOIDString(this.oid);
    }

    public BigInteger getKeyId() {
        return this.keyId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkFields() {
        try {
            if (!ChipAuthenticationInfo.checkRequiredIdentifier(this.oid)) throw new IllegalArgumentException("Wrong identifier: " + this.oid);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Unexpected exception", exception);
            throw new IllegalArgumentException("Malformed ChipAuthenticationInfo.");
        }
        int n = this.version;
        if (n == 1 || n == 2) return;
        LOGGER.warning("Wrong version. Was expecting 1 or 2, found " + this.version);
    }

    public String toString() {
        ChipAuthenticationInfo chipAuthenticationInfo = serializable;
        Serializable serializable = b.a("ChipAuthenticationInfo [protocol: ").append(ChipAuthenticationInfo.toProtocolOIDString(((ChipAuthenticationInfo)serializable).oid)).append(", version: ").append(((ChipAuthenticationInfo)serializable).version).append(", keyId: ");
        Object object = chipAuthenticationInfo.keyId;
        if (object == null) {
            object = "-";
        }
        return ((StringBuilder)serializable).append(object).append("]").toString();
    }

    public int hashCode() {
        int n = 3;
        int n2 = 11;
        String string2 = this.oid;
        n2 = (string2 == null ? 0 : string2.hashCode()) * n2;
        ChipAuthenticationInfo chipAuthenticationInfo = this;
        int n3 = n2 + n;
        n3 = chipAuthenticationInfo.version * 61 + n3;
        n = 1991;
        BigInteger bigInteger = chipAuthenticationInfo.keyId;
        return (bigInteger == null ? 111 : bigInteger.hashCode()) * n + n3;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!ChipAuthenticationInfo.class.equals(object.getClass())) {
            return false;
        }
        object = (ChipAuthenticationInfo)object;
        return ((ChipAuthenticationInfo)this).oid.equals(((ChipAuthenticationInfo)object).oid) && ((ChipAuthenticationInfo)this).version == ((ChipAuthenticationInfo)object).version && ((this = ((ChipAuthenticationInfo)this).keyId) == null && ((ChipAuthenticationInfo)object).keyId == null || this != null && ((BigInteger)this).equals(((ChipAuthenticationInfo)object).keyId));
    }
}

