/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.crmf;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class DhSigStatic
extends ASN1Object {
    private final IssuerAndSerialNumber issuerAndSerial;
    private final ASN1OctetString hashValue;

    public DhSigStatic(byte[] byArray) {
        this(null, byArray);
    }

    public DhSigStatic(IssuerAndSerialNumber issuerAndSerialNumber, byte[] byArray) {
        DhSigStatic dhSigStatic = this;
        dhSigStatic.issuerAndSerial = issuerAndSerialNumber;
        dhSigStatic.hashValue = new DEROctetString(Arrays.clone(byArray));
    }

    public static DhSigStatic getInstance(Object object) {
        if (object instanceof DhSigStatic) {
            return (DhSigStatic)object;
        }
        if (object != null) {
            return new DhSigStatic(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private DhSigStatic(ASN1Sequence aSN1Sequence) {
        block4: {
            block3: {
                block2: {
                    if (aSN1Sequence.size() != 1) break block2;
                    this.issuerAndSerial = null;
                    this.hashValue = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0));
                    break block3;
                }
                if (aSN1Sequence.size() != 2) break block4;
                this.issuerAndSerial = IssuerAndSerialNumber.getInstance(aSN1Sequence.getObjectAt(0));
                this.hashValue = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1));
            }
            return;
        }
        throw new IllegalArgumentException("sequence wrong length for DhSigStatic");
    }

    public IssuerAndSerialNumber getIssuerAndSerial() {
        return this.issuerAndSerial;
    }

    public byte[] getHashValue() {
        return Arrays.clone(this.hashValue.getOctets());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(2);
        IssuerAndSerialNumber issuerAndSerialNumber = this.issuerAndSerial;
        if (issuerAndSerialNumber != null) {
            aSN1EncodableVector2.add(issuerAndSerialNumber);
        }
        aSN1EncodableVector2.add(this.hashValue);
        return new DERSequence(aSN1EncodableVector2);
    }
}

