/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class HC256Engine
implements StreamCipher {
    private int[] p = new int[1024];
    private int[] q = new int[1024];
    private int cnt = 0;
    private byte[] key;
    private byte[] iv;
    private boolean initialised;
    private byte[] buf = new byte[4];
    private int idx = 0;

    private int step() {
        int n;
        int n2 = this.cnt;
        int n3 = n2 & 0x3FF;
        if (n2 < 1024) {
            HC256Engine hC256Engine = this;
            int[] nArray = hC256Engine.p;
            int n4 = nArray[n3 - 3 & 0x3FF];
            int n5 = nArray[n3 - 1023 & 0x3FF];
            int n6 = nArray[n3];
            int n7 = hC256Engine.p[n3 - 10 & 0x3FF] + (HC256Engine.rotateRight(n4, 10) ^ HC256Engine.rotateRight(n5, 23));
            int[] nArray2 = hC256Engine.q;
            nArray[n3] = n7 + nArray2[(n4 ^ n5) & 0x3FF] + n6;
            nArray = this.p;
            n4 = this.p[n3 - 12 & 0x3FF];
            n = hC256Engine.q[n4 & 0xFF] + nArray2[(n4 >> 8 & 0xFF) + 256] + nArray2[(n4 >> 16 & 0xFF) + 512] + nArray2[(n4 >> 24 & 0xFF) + 768] ^ nArray[n3];
        } else {
            HC256Engine hC256Engine = this;
            int[] nArray = hC256Engine.q;
            int n8 = nArray[n3 - 3 & 0x3FF];
            int n9 = nArray[n3 - 1023 & 0x3FF];
            int n10 = nArray[n3];
            int n11 = hC256Engine.q[n3 - 10 & 0x3FF] + (HC256Engine.rotateRight(n8, 10) ^ HC256Engine.rotateRight(n9, 23));
            int[] nArray3 = hC256Engine.p;
            nArray[n3] = n11 + nArray3[(n8 ^ n9) & 0x3FF] + n10;
            nArray = this.q;
            n8 = this.q[n3 - 12 & 0x3FF];
            n = hC256Engine.p[n8 & 0xFF] + nArray3[(n8 >> 8 & 0xFF) + 256] + nArray3[(n8 >> 16 & 0xFF) + 512] + nArray3[(n8 >> 24 & 0xFF) + 768] ^ nArray[n3];
        }
        this.cnt = this.cnt + 1 & 0x7FF;
        return n;
    }

    private void init() {
        Object[] objectArray = this.key;
        if (this.key.length != 32 && objectArray.length != 16) {
            throw new IllegalArgumentException("The key must be 128/256 bits long");
        }
        if (this.iv.length >= 16) {
            int n;
            int n2;
            if (objectArray.length != 32) {
                HC256Engine hC256Engine = this;
                objectArray = new byte[32];
                n2 = objectArray.length;
                System.arraycopy(objectArray, 0, objectArray, 0, n2);
                n2 = hC256Engine.key.length;
                System.arraycopy(hC256Engine.key, 0, objectArray, 16, n2);
                hC256Engine.key = objectArray;
            }
            objectArray = this.iv;
            if (this.iv.length < 32) {
                HC256Engine hC256Engine = this;
                objectArray = new byte[32];
                n2 = objectArray.length;
                System.arraycopy(objectArray, 0, objectArray, 0, n2);
                n2 = hC256Engine.iv.length;
                n = 32 - hC256Engine.iv.length;
                System.arraycopy(hC256Engine.iv, 0, objectArray, n2, n);
                hC256Engine.iv = objectArray;
            }
            HC256Engine hC256Engine = this;
            hC256Engine.idx = 0;
            hC256Engine.cnt = 0;
            objectArray = new int[2560];
            for (n2 = 0; n2 < 32; ++n2) {
                n = n2 >> 2;
                objectArray[n] = objectArray[n] | (this.key[n2] & 0xFF) << (n2 & 3) * 8;
            }
            for (n2 = 0; n2 < 32; ++n2) {
                n = (n2 >> 2) + 8;
                objectArray[n] = objectArray[n] | (this.iv[n2] & 0xFF) << (n2 & 3) * 8;
            }
            for (n2 = 16; n2 < 2560; ++n2) {
                n = objectArray[n2 - 2];
                byte by = objectArray[n2 - 15];
                objectArray[n2] = (HC256Engine.rotateRight(n, 17) ^ HC256Engine.rotateRight(n, 19) ^ n >>> 10) + objectArray[n2 - 7] + (HC256Engine.rotateRight(by, 7) ^ HC256Engine.rotateRight(by, 18) ^ by >>> 3) + objectArray[n2 - 16] + n2;
            }
            System.arraycopy(objectArray, 512, this.p, 0, 1024);
            System.arraycopy(objectArray, 1536, this.q, 0, 1024);
            for (int k = 0; k < 4096; ++k) {
                this.step();
            }
            this.cnt = 0;
            return;
        }
        throw new IllegalArgumentException("The IV must be at least 128 bits long");
    }

    private byte getByte() {
        int n;
        if (this.idx == 0) {
            HC256Engine hC256Engine = this;
            n = hC256Engine.step();
            byte[] byArray = hC256Engine.buf;
            byArray[0] = (byte)(n & 0xFF);
            int n2 = n >> 8;
            byArray[1] = (byte)(n2 & 0xFF);
            int n3 = n2 >> 8;
            byArray[2] = (byte)(n3 & 0xFF);
            hC256Engine.buf[3] = (byte)(n3 >> 8 & 0xFF);
        }
        n = this.idx;
        this.idx = n + 1 & 3;
        return this.buf[n];
    }

    private static int rotateRight(int n, int n2) {
        return n >>> n2 | n << -n2;
    }

    @Override
    public String getAlgorithmName() {
        return "HC-256";
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        CipherParameters cipherParameters2;
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            this.iv = parametersWithIV.getIV();
            cipherParameters2 = parametersWithIV.getParameters();
        } else {
            this.iv = new byte[0];
            cipherParameters2 = cipherParameters;
        }
        if (cipherParameters2 instanceof KeyParameter) {
            this.key = ((KeyParameter)cipherParameters2).getKey();
            this.init();
            this.initialised = true;
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("Invalid parameter passed to HC256 init - ")));
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (this.initialised) {
            if (n + n2 <= byArray.length) {
                if (n3 + n2 <= byArray2.length) {
                    for (int k = 0; k < n2; ++k) {
                        int n4 = n3 + k;
                        byArray2[n4] = (byte)(byArray[n + k] ^ this.getByte());
                    }
                    return n2;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public void reset() {
        this.init();
    }

    @Override
    public byte returnByte(byte by) {
        return (byte)(by ^ this.getByte());
    }
}

