/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.NaccacheSternKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.NaccacheSternPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Vector;

public class NaccacheSternEngine
implements AsymmetricBlockCipher {
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private static BigInteger ONE = BigInteger.valueOf(1L);
    private boolean forEncryption;
    private NaccacheSternKeyParameters key;
    private Vector[] lookup = null;
    private boolean debug = false;

    private static BigInteger chineseRemainder(Vector vector, Vector vector2) {
        int n;
        BigInteger bigInteger = ZERO;
        BigInteger bigInteger2 = ONE;
        for (n = 0; n < vector2.size(); ++n) {
            bigInteger2 = bigInteger2.multiply((BigInteger)vector2.elementAt(n));
        }
        for (n = 0; n < vector2.size(); ++n) {
            BigInteger bigInteger3 = bigInteger;
            bigInteger = (BigInteger)vector2.elementAt(n);
            BigInteger bigInteger4 = bigInteger2.divide(bigInteger);
            bigInteger = bigInteger3.add(bigInteger4.multiply(bigInteger4.modInverse(bigInteger)).multiply((BigInteger)vector.elementAt(n)));
        }
        return bigInteger.mod(bigInteger2);
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        this.forEncryption = bl;
        if (object instanceof ParametersWithRandom) {
            object = ((ParametersWithRandom)object).getParameters();
        }
        this.key = (NaccacheSternKeyParameters)object;
        if (!this.forEncryption) {
            if (this.debug) {
                System.out.println("Constructing lookup Array");
            }
            NaccacheSternPrivateKeyParameters naccacheSternPrivateKeyParameters = (NaccacheSternPrivateKeyParameters)this.key;
            object = naccacheSternPrivateKeyParameters.getSmallPrimes();
            this.lookup = new Vector[((Vector)object).size()];
            for (int k = 0; k < ((Vector)object).size(); ++k) {
                Vector vector;
                NaccacheSternEngine naccacheSternEngine = this;
                BigInteger bigInteger = (BigInteger)((Vector)object).elementAt(k);
                int n = bigInteger.intValue();
                Serializable serializable = vector;
                vector = new Vector();
                naccacheSternEngine.lookup[k] = serializable;
                naccacheSternEngine.lookup[k].addElement(ONE);
                if (naccacheSternEngine.debug) {
                    System.out.println("Constructing lookup ArrayList for " + n);
                }
                serializable = ZERO;
                for (int i2 = 1; i2 < n; ++i2) {
                    serializable = ((BigInteger)serializable).add(naccacheSternPrivateKeyParameters.getPhi_n());
                    BigInteger bigInteger2 = ((BigInteger)serializable).divide(bigInteger);
                    this.lookup[k].addElement(naccacheSternPrivateKeyParameters.getG().modPow(bigInteger2, naccacheSternPrivateKeyParameters.getModulus()));
                }
            }
        }
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public int getInputBlockSize() {
        if (this.forEncryption) {
            return (this.key.getLowerSigmaBound() + 7) / 8 - 1;
        }
        return this.key.getModulus().toByteArray().length;
    }

    @Override
    public int getOutputBlockSize() {
        if (this.forEncryption) {
            return this.key.getModulus().toByteArray().length;
        }
        return (this.key.getLowerSigmaBound() + 7) / 8 - 1;
    }

    @Override
    public byte[] processBlock(byte[] object, int n, int n2) {
        if (this.key != null) {
            if (n2 <= this.getInputBlockSize() + 1) {
                byte[] byArray;
                BigInteger bigInteger;
                if (!this.forEncryption && n2 < this.getInputBlockSize()) {
                    throw new InvalidCipherTextException("BlockLength does not match modulus for Naccache-Stern cipher.\n");
                }
                if (n != 0 || n2 != ((byte[])object).length) {
                    byte[] byArray2 = object;
                    object = new byte[n2];
                    System.arraycopy(byArray2, n, object, 0, n2);
                }
                BigInteger bigInteger2 = bigInteger;
                bigInteger = new BigInteger(1, (byte[])object);
                if (this.debug) {
                    System.out.println("input as BigInteger: " + bigInteger2);
                }
                if (this.forEncryption) {
                    byArray = this.encrypt(bigInteger2);
                } else {
                    Vector vector;
                    object = vector;
                    vector = new Vector();
                    NaccacheSternPrivateKeyParameters naccacheSternPrivateKeyParameters = (NaccacheSternPrivateKeyParameters)this.key;
                    Vector vector2 = naccacheSternPrivateKeyParameters.getSmallPrimes();
                    for (int k = 0; k < vector2.size(); ++k) {
                        NaccacheSternPrivateKeyParameters naccacheSternPrivateKeyParameters2 = naccacheSternPrivateKeyParameters;
                        BigInteger bigInteger3 = naccacheSternPrivateKeyParameters2.getPhi_n().divide((BigInteger)vector2.elementAt(k));
                        bigInteger3 = bigInteger2.modPow(bigInteger3, naccacheSternPrivateKeyParameters2.getModulus());
                        Vector vector3 = this.lookup[k];
                        if (vector3.size() != ((BigInteger)vector2.elementAt(k)).intValue()) {
                            if (this.debug) {
                                System.out.println(b.a("Prime is ").append(vector2.elementAt(k)).append(", lookup table has size ").append(vector3.size()).toString());
                            }
                            throw new InvalidCipherTextException(b.a("Error in lookup Array for ").append(((BigInteger)vector2.elementAt(k)).intValue()).append(": Size mismatch. Expected ArrayList with length ").append(((BigInteger)vector2.elementAt(k)).intValue()).append(" but found ArrayList of length ").append(this.lookup[k].size()).toString());
                        }
                        int n3 = vector3.indexOf(bigInteger3);
                        if (n3 == -1) {
                            if (this.debug) {
                                System.out.println(b.a("Actual prime is ").append(vector2.elementAt(k)).toString());
                                System.out.println("Decrypted value is " + bigInteger3);
                                System.out.println(b.a("LookupList for ").append(vector2.elementAt(k)).append(" with size ").append(this.lookup[k].size()).append(" is: ").toString());
                                for (int i2 = 0; i2 < this.lookup[k].size(); ++i2) {
                                    System.out.println(this.lookup[k].elementAt(i2));
                                }
                            }
                            throw new InvalidCipherTextException("Lookup failed");
                        }
                        ((Vector)object).addElement(BigInteger.valueOf(n3));
                    }
                    byArray = NaccacheSternEngine.chineseRemainder((Vector)object, vector2).toByteArray();
                }
                return byArray;
            }
            throw new DataLengthException("input too large for Naccache-Stern cipher.\n");
        }
        throw new IllegalStateException("NaccacheStern engine not initialised");
    }

    public byte[] encrypt(BigInteger bigInteger) {
        NaccacheSternEngine naccacheSternEngine = this;
        byte[] byArray = naccacheSternEngine.key.getModulus().toByteArray();
        Arrays.fill(byArray, (byte)0);
        byte[] byArray2 = naccacheSternEngine.key.getG().modPow(bigInteger, this.key.getModulus()).toByteArray();
        int n = byArray.length - byArray2.length;
        int n2 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray, n, n2);
        if (naccacheSternEngine.debug) {
            System.out.println(b.a("Encrypted value is:  ").append(new BigInteger(byArray)).toString());
        }
        return byArray;
    }

    public byte[] addCryptedBlocks(byte[] object, byte[] object2) {
        block8: {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            block7: {
                block6: {
                    if (!((NaccacheSternEngine)object3).forEncryption) break block6;
                    if (((byte[])object).length > ((NaccacheSternEngine)object3).getOutputBlockSize() || ((byte[])object2).length > ((NaccacheSternEngine)object3).getOutputBlockSize()) {
                        throw new InvalidCipherTextException("BlockLength too large for simple addition.\n");
                    }
                    break block7;
                }
                if (((byte[])object).length > ((NaccacheSternEngine)object3).getInputBlockSize() || ((byte[])object2).length > ((NaccacheSternEngine)object3).getInputBlockSize()) break block8;
            }
            BigInteger bigInteger3 = bigInteger2;
            bigInteger2 = new BigInteger(1, (byte[])object);
            object = bigInteger;
            bigInteger = new BigInteger(1, (byte[])object2);
            object2 = bigInteger2.multiply(bigInteger).mod(((NaccacheSternEngine)object3).key.getModulus());
            if (((NaccacheSternEngine)object3).debug) {
                System.out.println("c(m1) as BigInteger:....... " + bigInteger3);
                System.out.println("c(m2) as BigInteger:....... " + object);
                System.out.println("c(m1)*c(m2)%n = c(m1+m2)%n: " + object2);
            }
            byte[] byArray = ((NaccacheSternEngine)object3).key.getModulus().toByteArray();
            Object object3 = byArray;
            Arrays.fill((byte[])object3, (byte)0);
            int n = ((Object)object3).length - ((BigInteger)object2).toByteArray().length;
            int n2 = ((BigInteger)object2).toByteArray().length;
            System.arraycopy(((BigInteger)object2).toByteArray(), 0, object3, n, n2);
            return byArray;
        }
        throw new InvalidCipherTextException("BlockLength too large for simple addition.\n");
    }

    public byte[] processData(byte[] byArray) {
        if (((NaccacheSternEngine)object).debug) {
            System.out.println();
        }
        if (byArray.length > ((NaccacheSternEngine)object).getInputBlockSize()) {
            NaccacheSternEngine naccacheSternEngine = object;
            int n = naccacheSternEngine.getInputBlockSize();
            int n2 = naccacheSternEngine.getOutputBlockSize();
            if (naccacheSternEngine.debug) {
                System.out.println("Input blocksize is:  " + n + " bytes");
                System.out.println("Output blocksize is: " + n2 + " bytes");
                System.out.println(b.a("Data has length:.... ").append(byArray.length).append(" bytes").toString());
            }
            int n3 = 0;
            int n4 = 0;
            byte[] byArray2 = new byte[(byArray.length / n + 1) * n2];
            while (n3 < byArray.length) {
                byte[] byArray3;
                int n5 = n3 + n;
                if (n5 < byArray.length) {
                    byte[] byArray4;
                    byArray3 = byArray4 = ((NaccacheSternEngine)object).processBlock(byArray, n3, n);
                    n3 = n5;
                } else {
                    byArray3 = ((NaccacheSternEngine)object).processBlock(byArray, n3, byArray.length - n3);
                    n3 = byArray.length - n3 + n3;
                }
                if (((NaccacheSternEngine)object).debug) {
                    System.out.println("new datapos is " + n3);
                }
                if (byArray3 != null) {
                    n5 = byArray3.length;
                    System.arraycopy(byArray3, 0, byArray2, n4, n5);
                    n4 += byArray3.length;
                    continue;
                }
                if (((NaccacheSternEngine)object).debug) {
                    System.out.println("cipher returned null");
                }
                throw new InvalidCipherTextException("cipher returned null");
            }
            NaccacheSternEngine naccacheSternEngine2 = object;
            Object object = new byte[n4];
            System.arraycopy(byArray2, 0, object, 0, n4);
            if (naccacheSternEngine2.debug) {
                System.out.println("returning " + n4 + " bytes");
            }
            return object;
        }
        if (((NaccacheSternEngine)object).debug) {
            System.out.println("data size is less then input block size, processing directly");
        }
        return ((NaccacheSternEngine)object).processBlock(byArray, 0, byArray.length);
    }
}

