/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DSAExt;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSAKCalculator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.RandomDSAKCalculator;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSASigner
implements DSAExt {
    private final DSAKCalculator kCalculator;
    private DSAKeyParameters key;
    private SecureRandom random;

    public DSASigner() {
        RandomDSAKCalculator randomDSAKCalculator;
        RandomDSAKCalculator randomDSAKCalculator2 = randomDSAKCalculator;
        randomDSAKCalculator = new RandomDSAKCalculator();
        v1.kCalculator = randomDSAKCalculator2;
    }

    public DSASigner(DSAKCalculator dSAKCalculator) {
        this.kCalculator = dSAKCalculator;
    }

    private BigInteger calculateE(BigInteger object, byte[] byArray) {
        if (((BigInteger)object).bitLength() >= byArray.length * 8) {
            return new BigInteger(1, byArray);
        }
        int n = ((BigInteger)object).bitLength() / 8;
        object = new byte[n];
        System.arraycopy(byArray, 0, object, 0, n);
        return new BigInteger(1, (byte[])object);
    }

    private BigInteger getRandomizer(BigInteger bigInteger, SecureRandom secureRandom) {
        return BigIntegers.createRandomBigInteger(7, CryptoServicesRegistrar.getSecureRandom(secureRandom)).add(BigInteger.valueOf(128L)).multiply(bigInteger);
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        SecureRandom secureRandom = null;
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.key = (DSAPrivateKeyParameters)parametersWithRandom.getParameters();
                secureRandom = parametersWithRandom.getRandom();
            } else {
                this.key = (DSAPrivateKeyParameters)cipherParameters;
            }
        } else {
            this.key = (DSAPublicKeyParameters)cipherParameters;
        }
        bl = bl && !this.kCalculator.isDeterministic();
        this.random = this.initSecureRandom(bl, secureRandom);
    }

    @Override
    public BigInteger getOrder() {
        return this.key.getParameters().getQ();
    }

    @Override
    public BigInteger[] generateSignature(byte[] object) {
        DSASigner dSASigner = object2;
        DSAParameters dSAParameters = dSASigner.key.getParameters();
        BigInteger bigInteger = dSAParameters.getQ();
        BigInteger bigInteger2 = dSASigner.calculateE(bigInteger, (byte[])object);
        BigInteger bigInteger3 = ((DSAPrivateKeyParameters)dSASigner.key).getX();
        if (dSASigner.kCalculator.isDeterministic()) {
            ((DSASigner)object2).kCalculator.init(bigInteger, bigInteger3, (byte[])object);
        } else {
            ((DSASigner)object2).kCalculator.init(bigInteger, ((DSASigner)object2).random);
        }
        BigInteger bigInteger4 = ((DSASigner)object2).kCalculator.nextK();
        object = bigInteger4;
        Object object2 = ((BigInteger)object).add(((DSASigner)object2).getRandomizer(bigInteger, ((DSASigner)object2).random));
        object2 = dSAParameters.getG().modPow((BigInteger)object2, dSAParameters.getP()).mod(bigInteger);
        object = BigIntegers.modOddInverse(bigInteger, bigInteger4).multiply(bigInteger2.add(bigInteger3.multiply((BigInteger)object2))).mod(bigInteger);
        return new BigInteger[]{object2, object};
    }

    @Override
    public boolean verifySignature(byte[] object, BigInteger bigInteger, BigInteger bigInteger2) {
        DSASigner dSASigner = this;
        Object object2 = dSASigner.key.getParameters();
        BigInteger bigInteger3 = ((DSAParameters)object2).getQ();
        object = dSASigner.calculateE(bigInteger3, (byte[])object);
        BigInteger bigInteger4 = BigInteger.valueOf(0L);
        if (bigInteger4.compareTo(bigInteger) < 0 && bigInteger3.compareTo(bigInteger) > 0) {
            if (bigInteger4.compareTo(bigInteger2) < 0 && bigInteger3.compareTo(bigInteger2) > 0) {
                DSAParameters dSAParameters = object2;
                byte[] byArray = object;
                BigInteger bigInteger5 = BigIntegers.modOddInverseVar(bigInteger3, bigInteger2);
                object = bigInteger5;
                bigInteger2 = byArray.multiply(bigInteger5).mod(bigInteger3);
                object = bigInteger.multiply((BigInteger)object).mod(bigInteger3);
                object2 = dSAParameters.getP();
                return dSAParameters.getG().modPow(bigInteger2, (BigInteger)object2).multiply(((DSAPublicKeyParameters)this.key).getY().modPow((BigInteger)object, (BigInteger)object2)).mod((BigInteger)object2).mod(bigInteger3).equals(bigInteger);
            }
            return false;
        }
        return false;
    }

    public SecureRandom initSecureRandom(boolean bl, SecureRandom secureRandom) {
        return bl ? CryptoServicesRegistrar.getSecureRandom(secureRandom) : null;
    }
}

