/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DSAExt;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSAKCalculator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.RandomDSAKCalculator;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECDSASigner
implements ECConstants,
DSAExt {
    private final DSAKCalculator kCalculator;
    private ECKeyParameters key;
    private SecureRandom random;

    public ECDSASigner() {
        RandomDSAKCalculator randomDSAKCalculator;
        RandomDSAKCalculator randomDSAKCalculator2 = randomDSAKCalculator;
        randomDSAKCalculator = new RandomDSAKCalculator();
        v1.kCalculator = randomDSAKCalculator2;
    }

    public ECDSASigner(DSAKCalculator dSAKCalculator) {
        this.kCalculator = dSAKCalculator;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        SecureRandom secureRandom = null;
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.key = (ECPrivateKeyParameters)parametersWithRandom.getParameters();
                secureRandom = parametersWithRandom.getRandom();
            } else {
                this.key = (ECPrivateKeyParameters)cipherParameters;
            }
        } else {
            this.key = (ECPublicKeyParameters)cipherParameters;
        }
        bl = bl && !this.kCalculator.isDeterministic();
        this.random = this.initSecureRandom(bl, secureRandom);
    }

    @Override
    public BigInteger getOrder() {
        return this.key.getParameters().getN();
    }

    @Override
    public BigInteger[] generateSignature(byte[] object) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        ECDSASigner eCDSASigner = this;
        ECDomainParameters eCDomainParameters = eCDSASigner.key.getParameters();
        BigInteger bigInteger4 = eCDomainParameters.getN();
        BigInteger bigInteger5 = eCDSASigner.calculateE(bigInteger4, (byte[])object);
        BigInteger bigInteger6 = ((ECPrivateKeyParameters)eCDSASigner.key).getD();
        if (eCDSASigner.kCalculator.isDeterministic()) {
            this.kCalculator.init(bigInteger4, bigInteger6, (byte[])object);
        } else {
            this.kCalculator.init(bigInteger4, this.random);
        }
        object = this.createBasePointMultiplier();
        do {
            bigInteger2 = this.kCalculator.nextK();
        } while ((bigInteger3 = object.multiply(eCDomainParameters.getG(), bigInteger2).normalize().getAffineXCoord().toBigInteger().mod(bigInteger4)).equals(bigInteger = ECConstants.ZERO) || (bigInteger2 = BigIntegers.modOddInverse(bigInteger4, bigInteger2).multiply(bigInteger5.add(bigInteger6.multiply(bigInteger3))).mod(bigInteger4)).equals(bigInteger));
        return new BigInteger[]{bigInteger3, bigInteger2};
    }

    @Override
    public boolean verifySignature(byte[] object, BigInteger bigInteger, BigInteger object2) {
        ECDSASigner eCDSASigner = this;
        Object object3 = eCDSASigner.key.getParameters();
        BigInteger bigInteger2 = ((ECDomainParameters)object3).getN();
        object = eCDSASigner.calculateE(bigInteger2, (byte[])object);
        BigInteger bigInteger3 = ECConstants.ONE;
        if (bigInteger.compareTo(bigInteger3) >= 0 && bigInteger.compareTo(bigInteger2) < 0) {
            if (((BigInteger)object2).compareTo(bigInteger3) >= 0 && ((BigInteger)object2).compareTo(bigInteger2) < 0) {
                Object object4 = object;
                BigInteger bigInteger4 = BigIntegers.modOddInverseVar(bigInteger2, (BigInteger)object2);
                object = bigInteger4;
                object2 = ((BigInteger)object4).multiply(bigInteger4).mod(bigInteger2);
                object = bigInteger.multiply((BigInteger)object).mod(bigInteger2);
                ECPoint eCPoint = ECAlgorithms.sumOfTwoMultiplies(((ECDomainParameters)object3).getG(), (BigInteger)object2, ((ECPublicKeyParameters)((ECDSASigner)this).key).getQ(), (BigInteger)object);
                object = eCPoint;
                if (eCPoint.isInfinity()) {
                    return false;
                }
                object2 = ((ECPoint)object).getCurve();
                if (object2 != null && (object3 = ((ECCurve)object2).getCofactor()) != null && ((BigInteger)object3).compareTo(ECConstants.EIGHT) <= 0 && (this = ((ECDSASigner)this).getDenominator(((ECCurve)object2).getCoordinateSystem(), (ECPoint)object)) != null && !((ECFieldElement)this).isZero()) {
                    object = ((ECPoint)object).getXCoord();
                    while (((ECCurve)object2).isValidFieldElement(bigInteger)) {
                        if (((ECCurve)object2).fromBigInteger(bigInteger).multiply((ECFieldElement)this).equals(object)) {
                            return true;
                        }
                        bigInteger = bigInteger.add(bigInteger2);
                    }
                    return false;
                }
                return ((ECPoint)object).normalize().getAffineXCoord().toBigInteger().mod(bigInteger2).equals(bigInteger);
            }
            return false;
        }
        return false;
    }

    public BigInteger calculateE(BigInteger bigInteger, byte[] byArray) {
        BigInteger bigInteger2;
        int n = bigInteger.bitLength();
        int n2 = byArray.length * 8;
        BigInteger bigInteger3 = bigInteger2;
        bigInteger2 = new BigInteger(1, byArray);
        if (n < n2) {
            bigInteger3 = bigInteger3.shiftRight(n2 - n);
        }
        return bigInteger3;
    }

    public ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    public ECFieldElement getDenominator(int n, ECPoint eCPoint) {
        switch (n) {
            default: {
                return null;
            }
            case 2: 
            case 3: 
            case 4: {
                return eCPoint.getZCoord(0).square();
            }
            case 1: 
            case 6: 
            case 7: 
        }
        return eCPoint.getZCoord(0);
    }

    public SecureRandom initSecureRandom(boolean bl, SecureRandom secureRandom) {
        return bl ? CryptoServicesRegistrar.getSecureRandom(secureRandom) : null;
    }
}

