/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dh;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.DHParameter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHParameterSpec;

public class AlgorithmParametersSpi
extends java.security.AlgorithmParametersSpi {
    public DHParameterSpec currentSpec;

    public boolean isASN1FormatString(String string) {
        return string == null || string.equals("ASN.1");
    }

    public AlgorithmParameterSpec engineGetParameterSpec(Class clazz) {
        if (clazz != null) {
            return this.localEngineGetParameterSpec(clazz);
        }
        throw new NullPointerException("argument to getParameterSpec must not be null");
    }

    @Override
    public byte[] engineGetEncoded() {
        AlgorithmParametersSpi algorithmParametersSpi = bigInteger;
        BigInteger bigInteger = algorithmParametersSpi.currentSpec.getG();
        try {
            return new DHParameter(((AlgorithmParametersSpi)((Object)bigInteger)).currentSpec.getP(), bigInteger, algorithmParametersSpi.currentSpec.getL()).getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error encoding DHParameters");
        }
    }

    @Override
    public byte[] engineGetEncoded(String string) {
        if (this.isASN1FormatString(string)) {
            return this.engineGetEncoded();
        }
        return null;
    }

    public AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) {
        if (clazz != DHParameterSpec.class && clazz != AlgorithmParameterSpec.class) {
            throw new InvalidParameterSpecException("unknown parameter spec passed to DH parameters object.");
        }
        return this.currentSpec;
    }

    @Override
    public void engineInit(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec instanceof DHParameterSpec) {
            this.currentSpec = (DHParameterSpec)algorithmParameterSpec;
            return;
        }
        throw new InvalidParameterSpecException("DHParameterSpec required to initialise a Diffie-Hellman algorithm parameters object");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void engineInit(byte[] object) {
        DHParameterSpec dHParameterSpec;
        Object object2;
        try {
            object = DHParameter.getInstance(object);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("Not a valid DH Parameter encoding.");
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Not a valid DH Parameter encoding.");
        }
        {
            if (((DHParameter)object).getL() != null) {
                AlgorithmParametersSpi algorithmParametersSpi = object2;
                Object object3 = object;
                object2 = ((DHParameter)object3).getP();
                BigInteger bigInteger = ((DHParameter)object3).getG();
                algorithmParametersSpi.currentSpec = new DHParameterSpec((BigInteger)object2, bigInteger, ((DHParameter)object).getL().intValue());
                return;
            }
            AlgorithmParametersSpi algorithmParametersSpi = object2;
        }
        object2 = dHParameterSpec;
        {
            Object object4 = object;
            object = ((DHParameter)object4).getP();
            dHParameterSpec = new DHParameterSpec((BigInteger)object, ((DHParameter)object4).getG());
            algorithmParametersSpi.currentSpec = object2;
            return;
        }
    }

    @Override
    public void engineInit(byte[] byArray, String string) {
        if (this.isASN1FormatString(string)) {
            this.engineInit(byArray);
            return;
        }
        throw new IOException(i.a("Unknown parameter format ", string));
    }

    @Override
    public String engineToString() {
        return "Diffie-Hellman Parameters";
    }
}

