/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BouncyCastleProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPrivateKeySpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public class KeyFactorySpi
extends BaseKeyFactorySpi {
    public String algorithm;
    public ProviderConfiguration configuration;

    public KeyFactorySpi(String string, ProviderConfiguration providerConfiguration) {
        this.algorithm = string;
        this.configuration = providerConfiguration;
    }

    @Override
    public Key engineTranslateKey(Key key) {
        Object object;
        if (key instanceof ECPublicKey) {
            KeyFactorySpi keyFactorySpi = object;
            object = (ECPublicKey)key;
            return new BCECPublicKey((ECPublicKey)object, keyFactorySpi.configuration);
        }
        if (key instanceof java.security.interfaces.ECPrivateKey) {
            Object object2 = object;
            object = (java.security.interfaces.ECPrivateKey)key;
            return new BCECPrivateKey((java.security.interfaces.ECPrivateKey)object, ((KeyFactorySpi)object2).configuration);
        }
        throw new InvalidKeyException("key type unknown");
    }

    @Override
    public KeySpec engineGetKeySpec(Key object, Class serializable) {
        Object object2;
        if ((serializable.isAssignableFrom(KeySpec.class) || serializable.isAssignableFrom(ECPublicKeySpec.class)) && object instanceof ECPublicKey) {
            object2 = (ECPublicKey)object;
            if (object2.getParams() != null) {
                Object object3 = object2;
                object2 = object3.getW();
                return new ECPublicKeySpec((java.security.spec.ECPoint)object2, object3.getParams());
            }
            object = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            return new ECPublicKeySpec(object2.getW(), EC5Util.convertSpec(EC5Util.convertCurve(((ECParameterSpec)object).getCurve(), ((ECParameterSpec)object).getSeed()), (ECParameterSpec)object));
        }
        if ((serializable.isAssignableFrom(KeySpec.class) || serializable.isAssignableFrom(java.security.spec.ECPrivateKeySpec.class)) && object instanceof java.security.interfaces.ECPrivateKey) {
            object2 = (java.security.interfaces.ECPrivateKey)object;
            if (object2.getParams() != null) {
                Object object4 = object2;
                object2 = object4.getS();
                return new java.security.spec.ECPrivateKeySpec((BigInteger)object2, object4.getParams());
            }
            object = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            return new java.security.spec.ECPrivateKeySpec(object2.getS(), EC5Util.convertSpec(EC5Util.convertCurve(((ECParameterSpec)object).getCurve(), ((ECParameterSpec)object).getSeed()), (ECParameterSpec)object));
        }
        if (serializable.isAssignableFrom(com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPublicKeySpec.class) && object instanceof ECPublicKey) {
            object2 = (ECPublicKey)object;
            if (object2.getParams() != null) {
                return new com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPublicKeySpec(EC5Util.convertPoint(object2.getParams(), object2.getW()), EC5Util.convertSpec(object2.getParams()));
            }
            object = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            return new com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPublicKeySpec(EC5Util.convertPoint(object2.getParams(), object2.getW()), (ECParameterSpec)object);
        }
        if (serializable.isAssignableFrom(ECPrivateKeySpec.class) && object instanceof java.security.interfaces.ECPrivateKey) {
            object2 = (java.security.interfaces.ECPrivateKey)object;
            if (object2.getParams() != null) {
                return new ECPrivateKeySpec(object2.getS(), EC5Util.convertSpec(object2.getParams()));
            }
            object = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            return new ECPrivateKeySpec(object2.getS(), (ECParameterSpec)object);
        }
        if (serializable.isAssignableFrom(OpenSSHPublicKeySpec.class) && object instanceof ECPublicKey) {
            if (object instanceof BCECPublicKey) {
                Object object5;
                Object object6;
                Object object7;
                Object object8;
                ECDomainParameters eCDomainParameters;
                ECDomainParameters eCDomainParameters2;
                ECPoint eCPoint;
                ECPublicKeyParameters eCPublicKeyParameters;
                ECPublicKeyParameters eCPublicKeyParameters2;
                OpenSSHPublicKeySpec openSSHPublicKeySpec;
                OpenSSHPublicKeySpec openSSHPublicKeySpec2;
                object2 = (BCECPublicKey)object;
                object = ((BCECPublicKey)object2).getParameters();
                try {
                    ECDomainParameters eCDomainParameters3;
                    ECPublicKeyParameters eCPublicKeyParameters3;
                    OpenSSHPublicKeySpec openSSHPublicKeySpec3;
                    openSSHPublicKeySpec2 = openSSHPublicKeySpec3;
                    openSSHPublicKeySpec = openSSHPublicKeySpec3;
                    eCPublicKeyParameters2 = eCPublicKeyParameters3;
                    eCPublicKeyParameters = eCPublicKeyParameters3;
                    eCPoint = ((BCECPublicKey)object2).getQ();
                    eCDomainParameters2 = eCDomainParameters3;
                    eCDomainParameters = eCDomainParameters3;
                    Object object9 = object;
                    object8 = object9;
                    object7 = object9;
                    object6 = object9;
                    object5 = object9;
                    object2 = ((ECParameterSpec)object9).getCurve();
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException(b.a(iOException, b.b.a("unable to produce encoding: ")));
                }
                object = ((ECParameterSpec)object7).getG();
                serializable = ((ECParameterSpec)object6).getN();
                BigInteger bigInteger = ((ECParameterSpec)object5).getH();
                byte[] byArray = ((ECParameterSpec)object8).getSeed();
                eCDomainParameters2((ECCurve)object2, (ECPoint)object, (BigInteger)serializable, bigInteger, byArray);
                eCPublicKeyParameters2(eCPoint, eCDomainParameters);
                openSSHPublicKeySpec2(OpenSSHPublicKeyUtil.encodePublicKey(eCPublicKeyParameters));
                return openSSHPublicKeySpec;
            }
            throw new IllegalArgumentException(b.b.a("invalid key type: ").append(object.getClass().getName()).toString());
        }
        if (serializable.isAssignableFrom(OpenSSHPrivateKeySpec.class) && object instanceof java.security.interfaces.ECPrivateKey) {
            if (object instanceof BCECPrivateKey) {
                try {
                    return new OpenSSHPrivateKeySpec(PrivateKeyInfo.getInstance(object.getEncoded()).parsePrivateKey().toASN1Primitive().getEncoded());
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException(b.a(iOException, b.b.a("cannot encoded key: ")));
                }
            }
            throw new IllegalArgumentException(b.b.a("invalid key type: ").append(object.getClass().getName()).toString());
        }
        if (serializable.isAssignableFrom(com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.OpenSSHPublicKeySpec.class) && object instanceof ECPublicKey) {
            if (object instanceof BCECPublicKey) {
                Object object10;
                Object object11;
                Object object12;
                Object object13;
                ECDomainParameters eCDomainParameters;
                ECDomainParameters eCDomainParameters4;
                ECPoint eCPoint;
                ECPublicKeyParameters eCPublicKeyParameters;
                ECPublicKeyParameters eCPublicKeyParameters4;
                com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.OpenSSHPublicKeySpec openSSHPublicKeySpec;
                com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.OpenSSHPublicKeySpec openSSHPublicKeySpec4;
                object2 = (BCECPublicKey)object;
                object = ((BCECPublicKey)object2).getParameters();
                try {
                    ECDomainParameters eCDomainParameters5;
                    ECPublicKeyParameters eCPublicKeyParameters5;
                    com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.OpenSSHPublicKeySpec openSSHPublicKeySpec5;
                    openSSHPublicKeySpec4 = openSSHPublicKeySpec5;
                    openSSHPublicKeySpec = openSSHPublicKeySpec5;
                    eCPublicKeyParameters4 = eCPublicKeyParameters5;
                    eCPublicKeyParameters = eCPublicKeyParameters5;
                    eCPoint = ((BCECPublicKey)object2).getQ();
                    eCDomainParameters4 = eCDomainParameters5;
                    eCDomainParameters = eCDomainParameters5;
                    Object object14 = object;
                    object13 = object14;
                    object12 = object14;
                    object11 = object14;
                    object10 = object14;
                    object2 = ((ECParameterSpec)object14).getCurve();
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException(b.a(iOException, b.b.a("unable to produce encoding: ")));
                }
                object = ((ECParameterSpec)object12).getG();
                serializable = ((ECParameterSpec)object11).getN();
                BigInteger bigInteger = ((ECParameterSpec)object10).getH();
                byte[] byArray = ((ECParameterSpec)object13).getSeed();
                eCDomainParameters4((ECCurve)object2, (ECPoint)object, (BigInteger)serializable, bigInteger, byArray);
                eCPublicKeyParameters4(eCPoint, eCDomainParameters);
                openSSHPublicKeySpec4(OpenSSHPublicKeyUtil.encodePublicKey(eCPublicKeyParameters));
                return openSSHPublicKeySpec;
            }
            throw new IllegalArgumentException(b.b.a("invalid key type: ").append(object.getClass().getName()).toString());
        }
        if (serializable.isAssignableFrom(com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.OpenSSHPrivateKeySpec.class) && object instanceof java.security.interfaces.ECPrivateKey) {
            if (object instanceof BCECPrivateKey) {
                try {
                    return new com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.OpenSSHPrivateKeySpec(PrivateKeyInfo.getInstance(object.getEncoded()).parsePrivateKey().toASN1Primitive().getEncoded());
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException(b.a(iOException, b.b.a("cannot encoded key: ")));
                }
            }
            throw new IllegalArgumentException(b.b.a("invalid key type: ").append(object.getClass().getName()).toString());
        }
        return super.engineGetKeySpec((Key)object, (Class)serializable);
    }

    @Override
    public PrivateKey engineGeneratePrivate(KeySpec object) {
        Object object2;
        if (object instanceof ECPrivateKeySpec) {
            KeyFactorySpi keyFactorySpi = object2;
            object2 = ((KeyFactorySpi)object2).algorithm;
            object = (ECPrivateKeySpec)object;
            ProviderConfiguration providerConfiguration = keyFactorySpi.configuration;
            return new BCECPrivateKey((String)object2, (ECPrivateKeySpec)object, providerConfiguration);
        }
        if (object instanceof java.security.spec.ECPrivateKeySpec) {
            KeyFactorySpi keyFactorySpi = object2;
            object2 = ((KeyFactorySpi)object2).algorithm;
            object = (java.security.spec.ECPrivateKeySpec)object;
            ProviderConfiguration providerConfiguration = keyFactorySpi.configuration;
            return new BCECPrivateKey((String)object2, (java.security.spec.ECPrivateKeySpec)object, providerConfiguration);
        }
        if (object instanceof OpenSSHPrivateKeySpec) {
            AlgorithmIdentifier algorithmIdentifier;
            PrivateKeyInfo privateKeyInfo;
            Object object3;
            BCECPrivateKey bCECPrivateKey;
            BCECPrivateKey bCECPrivateKey2;
            object = ECPrivateKey.getInstance(((OpenSSHPrivateKeySpec)object).getEncoded());
            try {
                BCECPrivateKey bCECPrivateKey3;
                bCECPrivateKey2 = bCECPrivateKey3;
                bCECPrivateKey = bCECPrivateKey3;
                Object object4 = object2;
                object3 = object4;
                object2 = ((KeyFactorySpi)object4).algorithm;
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException(b.a(iOException, b.b.a("bad encoding: ")));
            }
            PrivateKeyInfo privateKeyInfo2 = privateKeyInfo;
            AlgorithmIdentifier algorithmIdentifier2 = algorithmIdentifier;
            AlgorithmIdentifier algorithmIdentifier3 = algorithmIdentifier;
            Object object5 = object;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = X9ObjectIdentifiers.id_ecPublicKey;
            algorithmIdentifier2(aSN1ObjectIdentifier, ((ECPrivateKey)object5).getParameters());
            privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier3, (ASN1Encodable)object);
            object = ((KeyFactorySpi)object3).configuration;
            bCECPrivateKey2((String)object2, privateKeyInfo2, (ProviderConfiguration)object);
            return bCECPrivateKey;
        }
        return super.engineGeneratePrivate((KeySpec)object);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PublicKey engineGeneratePublic(KeySpec object) {
        block6: {
            Object object2;
            try {
                if (object instanceof com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPublicKeySpec) {
                    KeyFactorySpi keyFactorySpi = object2;
                    object2 = ((KeyFactorySpi)object2).algorithm;
                    object = (com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPublicKeySpec)object;
                    ProviderConfiguration providerConfiguration = keyFactorySpi.configuration;
                    return new BCECPublicKey((String)object2, (com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPublicKeySpec)object, providerConfiguration);
                }
                if (object instanceof ECPublicKeySpec) {
                    KeyFactorySpi keyFactorySpi = object2;
                    object2 = ((KeyFactorySpi)object2).algorithm;
                    object = (ECPublicKeySpec)object;
                    ProviderConfiguration providerConfiguration = keyFactorySpi.configuration;
                    return new BCECPublicKey((String)object2, (ECPublicKeySpec)object, providerConfiguration);
                }
                if (!(object instanceof OpenSSHPublicKeySpec)) break block6;
                object = OpenSSHPublicKeyUtil.parsePublicKey(((OpenSSHPublicKeySpec)object).getEncoded());
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.a.a(exception, b.b.a("invalid KeySpec: ")), exception);
            }
            {
                if (object instanceof ECPublicKeyParameters) {
                    Object object3 = object2;
                    object2 = ((ECPublicKeyParameters)object).getParameters();
                    ECPoint eCPoint = ((ECPublicKeyParameters)object).getQ();
                    Object object4 = object2;
                    object2 = ((ECDomainParameters)object4).getCurve();
                    object = ((ECDomainParameters)object4).getG();
                    BigInteger bigInteger = ((ECDomainParameters)object4).getN();
                    BigInteger bigInteger2 = ((ECDomainParameters)object4).getH();
                    byte[] byArray = ((ECDomainParameters)object4).getSeed();
                    return ((KeyFactorySpi)object3).engineGeneratePublic(new com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPublicKeySpec(eCPoint, new ECParameterSpec((ECCurve)object2, (ECPoint)object, bigInteger, bigInteger2, byArray)));
                }
                throw new IllegalArgumentException("openssh key is not ec public key");
            }
        }
        return super.engineGeneratePublic((KeySpec)object);
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) {
        Object object = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        if (((ASN1Primitive)object).equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            KeyFactorySpi keyFactorySpi = string;
            String string = keyFactorySpi.algorithm;
            object = keyFactorySpi.configuration;
            return new BCECPrivateKey(string, privateKeyInfo, (ProviderConfiguration)object);
        }
        throw new IOException(a.a("algorithm identifier ", (ASN1ObjectIdentifier)object, " in key not recognised"));
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        Object object = subjectPublicKeyInfo.getAlgorithm().getAlgorithm();
        if (((ASN1Primitive)object).equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            KeyFactorySpi keyFactorySpi = string;
            String string = keyFactorySpi.algorithm;
            object = keyFactorySpi.configuration;
            return new BCECPublicKey(string, subjectPublicKeyInfo, (ProviderConfiguration)object);
        }
        throw new IOException(a.a("algorithm identifier ", (ASN1ObjectIdentifier)object, " in key not recognised"));
    }

    public static class ECMQV
    extends KeyFactorySpi {
        public ECMQV() {
            super("ECMQV", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECDHC
    extends KeyFactorySpi {
        public ECDHC() {
            super("ECDHC", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECDH
    extends KeyFactorySpi {
        public ECDH() {
            super("ECDH", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECGOST3410_2012
    extends KeyFactorySpi {
        public ECGOST3410_2012() {
            super("ECGOST3410-2012", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECGOST3410
    extends KeyFactorySpi {
        public ECGOST3410() {
            super("ECGOST3410", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECDSA
    extends KeyFactorySpi {
        public ECDSA() {
            super("ECDSA", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class EC
    extends KeyFactorySpi {
        public EC() {
            super("EC", BouncyCastleProvider.CONFIGURATION);
        }
    }
}

