/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X25519PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X448PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.interfaces.XDHPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;

public class BCXDHPublicKey
implements XDHPublicKey {
    public static final long serialVersionUID = 1L;
    public transient AsymmetricKeyParameter xdhPublicKey;

    public BCXDHPublicKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        this.xdhPublicKey = asymmetricKeyParameter;
    }

    public BCXDHPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        BCXDHPublicKey bCXDHPublicKey = this;
        bCXDHPublicKey.populateFromPubKeyInfo(subjectPublicKeyInfo);
    }

    public BCXDHPublicKey(byte[] byArray, byte[] byArray2) {
        block2: {
            block5: {
                block4: {
                    X25519PublicKeyParameters x25519PublicKeyParameters;
                    Object object;
                    int n;
                    block3: {
                        X448PublicKeyParameters x448PublicKeyParameters;
                        n = byArray.length;
                        if (!Utils.isValidPrefix(byArray, byArray2)) break block2;
                        if (byArray2.length - n != 56) break block3;
                        BCXDHPublicKey bCXDHPublicKey = object;
                        object = x448PublicKeyParameters;
                        x448PublicKeyParameters = new X448PublicKeyParameters(byArray2, n);
                        bCXDHPublicKey.xdhPublicKey = object;
                        break block4;
                    }
                    if (byArray2.length - n != 32) break block5;
                    Object object2 = object;
                    object = x25519PublicKeyParameters;
                    x25519PublicKeyParameters = new X25519PublicKeyParameters(byArray2, n);
                    ((BCXDHPublicKey)object2).xdhPublicKey = object;
                }
                return;
            }
            throw new InvalidKeySpecException("raw key data not recognised");
        }
        throw new InvalidKeySpecException("raw key data not recognised");
    }

    private void populateFromPubKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.xdhPublicKey = EdECObjectIdentifiers.id_X448.equals(subjectPublicKeyInfo.getAlgorithm().getAlgorithm()) ? new X448PublicKeyParameters(subjectPublicKeyInfo.getPublicKeyData().getOctets(), 0) : new X25519PublicKeyParameters(subjectPublicKeyInfo.getPublicKeyData().getOctets(), 0);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.populateFromPubKeyInfo(SubjectPublicKeyInfo.getInstance((byte[])objectInputStream2.readObject()));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    @Override
    public String getAlgorithm() {
        return this.xdhPublicKey instanceof X448PublicKeyParameters ? "X448" : "X25519";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        if (this.xdhPublicKey instanceof X448PublicKeyParameters) {
            byte[] byArray = KeyFactorySpi.x448Prefix;
            byte[] byArray2 = new byte[KeyFactorySpi.x448Prefix.length + 56];
            int n = byArray.length;
            System.arraycopy(byArray, 0, byArray2, 0, n);
            ((X448PublicKeyParameters)this.xdhPublicKey).encode(byArray2, byArray.length);
            return byArray2;
        }
        byte[] byArray = KeyFactorySpi.x25519Prefix;
        byte[] byArray3 = new byte[KeyFactorySpi.x25519Prefix.length + 32];
        int n = byArray.length;
        System.arraycopy(byArray, 0, byArray3, 0, n);
        ((X25519PublicKeyParameters)this.xdhPublicKey).encode(byArray3, byArray.length);
        return byArray3;
    }

    public AsymmetricKeyParameter engineGetKeyParameters() {
        return this.xdhPublicKey;
    }

    public String toString() {
        BCXDHPublicKey bCXDHPublicKey = string;
        String string = bCXDHPublicKey.getAlgorithm();
        AsymmetricKeyParameter asymmetricKeyParameter = bCXDHPublicKey.xdhPublicKey;
        return Utils.keyToString("Public Key", string, asymmetricKeyParameter);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PublicKey)) {
            return false;
        }
        return Arrays.areEqual(((PublicKey)object).getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }
}

