/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.PKIXCRLStore;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.CollectionStore;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Iterable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Selector;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Store;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URI;
import java.security.cert.CRL;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

class CrlCache {
    private static final int DEFAULT_TIMEOUT = 15000;
    private static Map<URI, WeakReference<PKIXCRLStore>> cache = Collections.synchronizedMap(new WeakHashMap());

    public static synchronized PKIXCRLStore getCrl(CertificateFactory object, Date object2, URI uRI) {
        WeakReference<Object> weakReference;
        LocalCRLStore localCRLStore;
        PKIXCRLStore pKIXCRLStore = null;
        WeakReference<PKIXCRLStore> weakReference2 = cache.get(uRI);
        if (weakReference2 != null) {
            pKIXCRLStore = (PKIXCRLStore)weakReference2.get();
        }
        if (pKIXCRLStore != null) {
            boolean bl = false;
            Iterator iterator = pKIXCRLStore.getMatches(null).iterator();
            while (iterator.hasNext()) {
                Date date = ((X509CRL)iterator.next()).getNextUpdate();
                if (date == null || !date.before((Date)object2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return pKIXCRLStore;
            }
        }
        object = uRI.getScheme().equals("ldap") ? CrlCache.getCrlsFromLDAP((CertificateFactory)object, uRI) : CrlCache.getCrls((CertificateFactory)object, uRI);
        object2 = localCRLStore;
        localCRLStore = new LocalCRLStore(new CollectionStore<CRL>((Collection<CRL>)object));
        object = weakReference;
        weakReference = new WeakReference<Object>(object2);
        cache.put(uRI, (WeakReference<PKIXCRLStore>)object);
        return localCRLStore;
    }

    private static Collection getCrlsFromLDAP(CertificateFactory certificateFactory, URI uRI) {
        return null;
    }

    private static Collection getCrls(CertificateFactory object, URI uRI) {
        CertificateFactory certificateFactory = object;
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRI.toURL().openConnection();
        httpURLConnection.setConnectTimeout(15000);
        httpURLConnection.setReadTimeout(15000);
        object = httpURLConnection.getInputStream();
        Collection<? extends CRL> collection = certificateFactory.generateCRLs((InputStream)object);
        ((InputStream)object).close();
        return collection;
    }

    public static class LocalCRLStore<T extends CRL>
    implements PKIXCRLStore,
    Iterable<CRL> {
        private Collection<CRL> _local;

        public LocalCRLStore(Store<CRL> store) {
            this._local = new ArrayList<CRL>(store.getMatches(null));
        }

        @Override
        public Collection getMatches(Selector selector) {
            ArrayList arrayList;
            if (selector == null) {
                return new ArrayList<CRL>(((LocalCRLStore)iterable)._local);
            }
            LocalCRLStore localCRLStore = iterable;
            java.lang.Iterable<CRL> iterable = arrayList;
            arrayList = new ArrayList();
            for (CRL cRL : localCRLStore._local) {
                if (!selector.match(cRL)) continue;
                ((ArrayList)iterable).add(cRL);
            }
            return iterable;
        }

        @Override
        public Iterator<CRL> iterator() {
            return this.getMatches((Selector)null).iterator();
        }
    }
}

