/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPointMap;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.FixedPointPreCompInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.FixedPointUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.WNafPreCompInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.WNafUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.endo.ECEndomorphism;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.endo.EndoUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.endo.GLVEndomorphism;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.field.FiniteField;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.field.PolynomialExtensionField;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import java.math.BigInteger;

public class ECAlgorithms {
    public static boolean isF2mCurve(ECCurve eCCurve) {
        return ECAlgorithms.isF2mField(eCCurve.getField());
    }

    public static boolean isF2mField(FiniteField finiteField) {
        return finiteField.getDimension() > 1 && finiteField.getCharacteristic().equals(ECConstants.TWO) && finiteField instanceof PolynomialExtensionField;
    }

    public static boolean isFpCurve(ECCurve eCCurve) {
        return ECAlgorithms.isFpField(eCCurve.getField());
    }

    public static boolean isFpField(FiniteField finiteField) {
        return finiteField.getDimension() == 1;
    }

    public static ECPoint sumOfMultiplies(ECPoint[] object, BigInteger[] bigIntegerArray) {
        if (object != null && bigIntegerArray != null && ((ECPoint[])object).length == bigIntegerArray.length && ((ECPoint[])object).length >= 1) {
            int n = ((ECPoint[])object).length;
            if (n != 1) {
                if (n != 2) {
                    ECPoint eCPoint = object[0];
                    ECCurve eCCurve = eCPoint.getCurve();
                    ECPoint[] eCPointArray = new ECPoint[n];
                    ECPoint[] eCPointArray2 = eCPointArray;
                    eCPointArray[0] = eCPoint;
                    for (int k = 1; k < n; ++k) {
                        eCPointArray2[k] = ECAlgorithms.importPoint(eCCurve, object[k]);
                    }
                    object = eCCurve.getEndomorphism();
                    if (object instanceof GLVEndomorphism) {
                        return ECAlgorithms.implCheckResult(ECAlgorithms.implSumOfMultipliesGLV(eCPointArray2, bigIntegerArray, (GLVEndomorphism)object));
                    }
                    return ECAlgorithms.implCheckResult(ECAlgorithms.implSumOfMultiplies(eCPointArray2, bigIntegerArray));
                }
                ECPoint eCPoint = object[0];
                BigInteger[] bigIntegerArray2 = bigIntegerArray;
                ECPoint[] eCPointArray = object;
                object = bigIntegerArray[0];
                bigIntegerArray = eCPointArray[1];
                BigInteger bigInteger = bigIntegerArray2[1];
                return ECAlgorithms.sumOfTwoMultiplies(eCPoint, (BigInteger)object, (ECPoint)bigIntegerArray, bigInteger);
            }
            return object[0].multiply(bigIntegerArray[0]);
        }
        throw new IllegalArgumentException("point and scalar arrays should be non-null, and of equal, non-zero, length");
    }

    public static ECPoint sumOfTwoMultiplies(ECPoint bigIntegerArray, BigInteger bigInteger, ECPoint eCPoint, BigInteger bigInteger2) {
        Object object = bigIntegerArray.getCurve();
        eCPoint = ECAlgorithms.importPoint((ECCurve)object, eCPoint);
        if (object instanceof ECCurve.AbstractF2m && ((ECCurve.AbstractF2m)object).isKoblitz()) {
            return ECAlgorithms.implCheckResult(bigIntegerArray.multiply(bigInteger).add(eCPoint.multiply(bigInteger2)));
        }
        if ((object = ((ECCurve)object).getEndomorphism()) instanceof GLVEndomorphism) {
            ECPoint[] eCPointArray = new ECPoint[]{bigIntegerArray, eCPoint};
            BigInteger[] bigIntegerArray2 = new BigInteger[2];
            bigIntegerArray = bigIntegerArray2;
            bigIntegerArray2[0] = bigInteger;
            bigIntegerArray2[1] = bigInteger2;
            return ECAlgorithms.implCheckResult(ECAlgorithms.implSumOfMultipliesGLV(eCPointArray, bigIntegerArray, (GLVEndomorphism)object));
        }
        return ECAlgorithms.implCheckResult(ECAlgorithms.implShamirsTrickWNaf((ECPoint)bigIntegerArray, bigInteger, eCPoint, bigInteger2));
    }

    public static ECPoint shamirsTrick(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        return ECAlgorithms.implCheckResult(ECAlgorithms.implShamirsTrickJsf(eCPoint, bigInteger, ECAlgorithms.importPoint(eCPoint.getCurve(), eCPoint2), bigInteger2));
    }

    public static ECPoint importPoint(ECCurve eCCurve, ECPoint eCPoint) {
        if (eCCurve.equals(eCPoint.getCurve())) {
            return eCCurve.importPoint(eCPoint);
        }
        throw new IllegalArgumentException("Point must be on the same curve");
    }

    public static void montgomeryTrick(ECFieldElement[] eCFieldElementArray, int n, int n2) {
        ECAlgorithms.montgomeryTrick(eCFieldElementArray, n, n2, null);
    }

    public static void montgomeryTrick(ECFieldElement[] eCFieldElementArray, int n, int n2, ECFieldElement eCFieldElement) {
        ECFieldElement[] eCFieldElementArray2 = new ECFieldElement[n2];
        ECFieldElement[] eCFieldElementArray3 = eCFieldElementArray2;
        eCFieldElementArray2[0] = eCFieldElementArray[n];
        int n3 = 0;
        while (++n3 < n2) {
            eCFieldElementArray3[n3] = eCFieldElementArray3[n3 - 1].multiply(eCFieldElementArray[n + n3]);
        }
        n2 = n3 + -1;
        if (eCFieldElement != null) {
            eCFieldElementArray3[n2] = eCFieldElementArray3[n2].multiply(eCFieldElement);
        }
        eCFieldElement = eCFieldElementArray3[n2].invert();
        while (n2 > 0) {
            int n4 = n2;
            n2 = n4 + -1;
            n3 = n + n4;
            ECFieldElement eCFieldElement2 = eCFieldElementArray[n3];
            eCFieldElementArray[n3] = eCFieldElementArray3[n2].multiply(eCFieldElement);
            eCFieldElement = eCFieldElement.multiply(eCFieldElement2);
        }
        eCFieldElementArray[n] = eCFieldElement;
    }

    public static ECPoint referenceMultiply(ECPoint eCPoint, BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger.abs();
        ECPoint eCPoint2 = eCPoint.getCurve().getInfinity();
        int n = bigInteger2.bitLength();
        if (n > 0) {
            if (bigInteger2.testBit(0)) {
                eCPoint2 = eCPoint;
            }
            for (int k = 1; k < n; ++k) {
                eCPoint = eCPoint.twice();
                if (!bigInteger2.testBit(k)) continue;
                eCPoint2 = eCPoint2.add(eCPoint);
            }
        }
        if (bigInteger.signum() < 0) {
            eCPoint2 = eCPoint2.negate();
        }
        return eCPoint2;
    }

    public static ECPoint validatePoint(ECPoint eCPoint) {
        if (eCPoint.isValid()) {
            return eCPoint;
        }
        throw new IllegalStateException("Invalid point");
    }

    public static ECPoint cleanPoint(ECCurve eCCurve, ECPoint eCPoint) {
        if (eCCurve.equals(eCPoint.getCurve())) {
            return eCCurve.decodePoint(eCPoint.getEncoded(false));
        }
        throw new IllegalArgumentException("Point must be on the same curve");
    }

    public static ECPoint implCheckResult(ECPoint eCPoint) {
        if (eCPoint.isValidPartial()) {
            return eCPoint;
        }
        throw new IllegalStateException("Invalid result");
    }

    /*
     * WARNING - void declaration
     */
    public static ECPoint implShamirsTrickJsf(ECPoint eCPointArray, BigInteger object, ECPoint object2, BigInteger object3) {
        void var1_4;
        byte[] byArray;
        ECPoint eCPoint;
        void v0 = eCPoint;
        ECCurve eCCurve = eCPointArray.getCurve();
        ECPoint eCPoint2 = eCCurve.getInfinity();
        eCPoint = eCPointArray.add((ECPoint)byArray);
        ECPoint eCPoint3 = eCPointArray.subtract((ECPoint)byArray);
        ECPoint[] eCPointArray2 = new ECPoint[4];
        ECPoint[] eCPointArray3 = eCPointArray2;
        eCPointArray2[0] = byArray;
        eCPointArray2[1] = eCPoint3;
        eCPointArray2[2] = eCPointArray;
        eCPointArray2[3] = eCPoint;
        eCCurve.normalizeAll(eCPointArray2);
        ECPoint[] eCPointArray4 = new ECPoint[9];
        eCPointArray = eCPointArray4;
        eCPointArray[0] = eCPointArray3[3].negate();
        eCPointArray[1] = eCPointArray3[2].negate();
        eCPointArray[2] = eCPointArray3[1].negate();
        eCPointArray[3] = eCPointArray3[0].negate();
        eCPointArray[4] = eCPoint2;
        eCPointArray[5] = eCPointArray3[0];
        eCPointArray[6] = eCPointArray3[1];
        eCPointArray[7] = eCPointArray3[2];
        eCPointArray4[8] = eCPointArray3[3];
        byArray = WNafUtil.generateJSF((BigInteger)object, (BigInteger)v0);
        int n = byArray.length;
        while ((n += -1) >= 0) {
            byte by = byArray[n];
            int n2 = by << 28 >> 28;
            ECPoint eCPoint4 = var1_4.twicePlus(eCPointArray[(by << 24 >> 28) * 3 + 4 + n2]);
        }
        return var1_4;
    }

    public static ECPoint implShamirsTrickWNaf(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPointArray, BigInteger eCPointArray2) {
        boolean bl = bigInteger.signum() < 0;
        boolean bl2 = eCPointArray2.signum() < 0;
        BigInteger bigInteger2 = bigInteger.abs();
        BigInteger bigInteger3 = eCPointArray2.abs();
        int n = WNafUtil.getWindowSize(bigInteger3.bitLength(), 8);
        WNafPreCompInfo wNafPreCompInfo = WNafUtil.precompute(eCPoint, WNafUtil.getWindowSize(bigInteger2.bitLength(), 8), true);
        WNafPreCompInfo wNafPreCompInfo2 = WNafUtil.precompute((ECPoint)eCPointArray, n, true);
        int n2 = FixedPointUtil.getCombSize(eCPoint.getCurve());
        if (!bl && !bl2 && bigInteger.bitLength() <= n2 && eCPointArray2.bitLength() <= n2 && wNafPreCompInfo.isPromoted() && wNafPreCompInfo2.isPromoted()) {
            return ECAlgorithms.implShamirsTrickFixedPoint(eCPoint, bigInteger, (ECPoint)eCPointArray, (BigInteger)eCPointArray2);
        }
        int n3 = Math.min(8, wNafPreCompInfo.getWidth());
        int n4 = Math.min(8, wNafPreCompInfo2.getWidth());
        eCPointArray = bl ? wNafPreCompInfo.getPreCompNeg() : wNafPreCompInfo.getPreComp();
        eCPointArray2 = bl2 ? wNafPreCompInfo2.getPreCompNeg() : wNafPreCompInfo2.getPreComp();
        ECPoint[] eCPointArray3 = bl ? wNafPreCompInfo.getPreComp() : wNafPreCompInfo.getPreCompNeg();
        ECPoint[] eCPointArray4 = bl2 ? wNafPreCompInfo2.getPreComp() : wNafPreCompInfo2.getPreCompNeg();
        byte[] byArray = WNafUtil.generateWindowNaf(n3, bigInteger2);
        byte[] byArray2 = WNafUtil.generateWindowNaf(n4, bigInteger3);
        return ECAlgorithms.implShamirsTrickWNaf(eCPointArray, eCPointArray3, byArray, eCPointArray2, eCPointArray4, byArray2);
    }

    public static ECPoint implShamirsTrickWNaf(ECEndomorphism eCPointArray, ECPoint object, BigInteger object2, BigInteger eCPointArray2) {
        boolean bl = ((BigInteger)object2).signum() < 0;
        boolean bl2 = eCPointArray2.signum() < 0;
        ECPoint eCPoint = object;
        object = ((BigInteger)object2).abs();
        object2 = eCPointArray2.abs();
        eCPointArray2 = WNafUtil.precompute(eCPoint, WNafUtil.getWindowSize(Math.max(((BigInteger)object).bitLength(), ((BigInteger)object2).bitLength()), 8), true);
        eCPointArray = WNafUtil.precomputeWithPointMap(EndoUtil.mapPoint((ECEndomorphism)eCPointArray, eCPoint), eCPointArray.getPointMap(), (WNafPreCompInfo)eCPointArray2, true);
        int n = Math.min(8, eCPointArray2.getWidth());
        int n2 = Math.min(8, eCPointArray.getWidth());
        ECPoint[] eCPointArray3 = bl ? eCPointArray2.getPreCompNeg() : eCPointArray2.getPreComp();
        ECPoint[] eCPointArray4 = bl2 ? eCPointArray.getPreCompNeg() : eCPointArray.getPreComp();
        eCPointArray2 = bl ? eCPointArray2.getPreComp() : eCPointArray2.getPreCompNeg();
        eCPointArray = bl2 ? eCPointArray.getPreComp() : eCPointArray.getPreCompNeg();
        object = WNafUtil.generateWindowNaf(n, (BigInteger)object);
        object2 = WNafUtil.generateWindowNaf(n2, (BigInteger)object2);
        return ECAlgorithms.implShamirsTrickWNaf(eCPointArray3, eCPointArray2, (byte[])object, eCPointArray4, eCPointArray, (byte[])object2);
    }

    private static ECPoint implShamirsTrickWNaf(ECPoint[] eCPointArray, ECPoint[] eCPointArray2, byte[] byArray, ECPoint[] eCPointArray3, ECPoint[] eCPointArray4, byte[] byArray2) {
        ECPoint eCPoint = eCPointArray[0].getCurve().getInfinity();
        int n = 0;
        ECPoint eCPoint2 = eCPoint;
        for (int k = Math.max(byArray.length, byArray2.length) - 1; k >= 0; --k) {
            ECPoint eCPoint3;
            ECPoint[] eCPointArray5;
            int n2;
            int n3 = k < byArray.length ? byArray[k] : 0;
            if ((n3 | (n2 = k < byArray2.length ? byArray2[k] : 0)) == 0) {
                ++n;
                continue;
            }
            if (n3 != 0) {
                int n4 = n3;
                n3 = Math.abs(n4);
                eCPointArray5 = n4 < 0 ? eCPointArray2 : eCPointArray;
                eCPoint3 = eCPoint.add(eCPointArray5[n3 >>> 1]);
            } else {
                eCPoint3 = eCPoint;
            }
            if (n2 != 0) {
                int n5 = n2;
                n2 = Math.abs(n5);
                eCPointArray5 = n5 < 0 ? eCPointArray4 : eCPointArray3;
                eCPoint3 = eCPoint3.add(eCPointArray5[n2 >>> 1]);
            }
            if (n > 0) {
                eCPoint2 = eCPoint2.timesPow2(n);
                n = 0;
            }
            eCPoint2 = eCPoint2.twicePlus(eCPoint3);
        }
        if (n > 0) {
            eCPoint2 = eCPoint2.timesPow2(n);
        }
        return eCPoint2;
    }

    public static ECPoint implSumOfMultiplies(ECPoint[] eCPointArray, BigInteger[] bigIntegerArray) {
        int n = eCPointArray.length;
        boolean[] blArray = new boolean[n];
        WNafPreCompInfo[] wNafPreCompInfoArray = new WNafPreCompInfo[n];
        byte[][] byArrayArray = new byte[n][];
        for (int k = 0; k < n; ++k) {
            WNafPreCompInfo wNafPreCompInfo;
            BigInteger bigInteger = bigIntegerArray[k];
            int n2 = bigInteger.signum() < 0 ? 1 : 0;
            blArray[k] = n2;
            bigInteger = bigInteger.abs();
            n2 = WNafUtil.getWindowSize(bigInteger.bitLength(), 8);
            wNafPreCompInfoArray[k] = wNafPreCompInfo = WNafUtil.precompute(eCPointArray[k], n2, true);
            byArrayArray[k] = WNafUtil.generateWindowNaf(Math.min(8, wNafPreCompInfo.getWidth()), bigInteger);
        }
        return ECAlgorithms.implSumOfMultiplies(blArray, wNafPreCompInfoArray, byArrayArray);
    }

    public static ECPoint implSumOfMultipliesGLV(ECPoint[] eCPointArray, BigInteger[] objectArray, GLVEndomorphism gLVEndomorphism) {
        int n;
        BigInteger bigInteger = eCPointArray[0].getCurve().getOrder();
        int n2 = eCPointArray.length;
        int n3 = n2 << 1;
        BigInteger[] bigIntegerArray = new BigInteger[n3];
        int n4 = 0;
        for (int k = 0; k < n2; ++k) {
            BigInteger[] bigIntegerArray2 = gLVEndomorphism.decomposeScalar(objectArray[k].mod(bigInteger));
            bigIntegerArray[n4++] = bigIntegerArray2[0];
            n = n4 + 1;
            bigIntegerArray[n4] = bigIntegerArray2[1];
            n4 = n;
        }
        if (gLVEndomorphism.hasEfficientPointMap()) {
            return ECAlgorithms.implSumOfMultiplies(gLVEndomorphism, eCPointArray, bigIntegerArray);
        }
        objectArray = new ECPoint[n3];
        n3 = 0;
        for (int k = 0; k < n2; ++k) {
            ECPoint eCPoint = eCPointArray[k];
            ECPoint eCPoint2 = EndoUtil.mapPoint(gLVEndomorphism, eCPoint);
            n = n3 + 1;
            objectArray[n3] = eCPoint;
            n3 = n + 1;
            objectArray[n] = eCPoint2;
        }
        return ECAlgorithms.implSumOfMultiplies((ECPoint[])objectArray, bigIntegerArray);
    }

    public static ECPoint implSumOfMultiplies(ECEndomorphism eCEndomorphism, ECPoint[] eCPointArray, BigInteger[] bigIntegerArray) {
        int n = eCPointArray.length;
        int n2 = n << 1;
        boolean[] blArray = new boolean[n2];
        WNafPreCompInfo[] wNafPreCompInfoArray = new WNafPreCompInfo[n2];
        byte[][] byArrayArray = new byte[n2][];
        ECPointMap eCPointMap = eCEndomorphism.getPointMap();
        for (int k = 0; k < n; ++k) {
            int n3 = k << 1;
            int n4 = n3 + 1;
            BigInteger bigInteger = bigIntegerArray[n3];
            boolean bl = bigInteger.signum() < 0;
            blArray[n3] = bl;
            bigInteger = bigInteger.abs();
            BigInteger bigInteger2 = bigIntegerArray[n4];
            int n5 = bigInteger2.signum() < 0 ? 1 : 0;
            blArray[n4] = n5;
            bigInteger2 = bigInteger2.abs();
            n5 = WNafUtil.getWindowSize(Math.max(bigInteger.bitLength(), bigInteger2.bitLength()), 8);
            ECPoint eCPoint = eCPointArray[k];
            WNafPreCompInfo wNafPreCompInfo = WNafUtil.precompute(eCPoint, n5, true);
            WNafPreCompInfo wNafPreCompInfo2 = WNafUtil.precomputeWithPointMap(EndoUtil.mapPoint(eCEndomorphism, eCPoint), eCPointMap, wNafPreCompInfo, true);
            int n6 = Math.min(8, wNafPreCompInfo.getWidth());
            wNafPreCompInfoArray[n3] = wNafPreCompInfo;
            wNafPreCompInfoArray[n4] = wNafPreCompInfo2;
            byArrayArray[n3] = WNafUtil.generateWindowNaf(n6, bigInteger);
            byArrayArray[n4] = WNafUtil.generateWindowNaf(Math.min(8, wNafPreCompInfo2.getWidth()), bigInteger2);
        }
        return ECAlgorithms.implSumOfMultiplies(blArray, wNafPreCompInfoArray, byArrayArray);
    }

    private static ECPoint implSumOfMultiplies(boolean[] blArray, WNafPreCompInfo[] wNafPreCompInfoArray, byte[][] byArray) {
        int n;
        int n2 = 0;
        int n3 = byArray.length;
        for (n = 0; n < n3; ++n) {
            n2 = Math.max(n2, byArray[n].length);
        }
        ECPoint eCPoint = wNafPreCompInfoArray[0].getPreComp()[0].getCurve().getInfinity();
        n = 0;
        ECPoint eCPoint2 = eCPoint;
        for (int k = n2 - 1; k >= 0; --k) {
            ECPoint eCPoint3 = eCPoint;
            for (int i2 = 0; i2 < n3; ++i2) {
                byte[] byArray2 = byArray[i2];
                int n4 = k < byArray2.length ? byArray2[k] : 0;
                if (n4 == 0) continue;
                int n5 = n4;
                n4 = Math.abs(n4);
                ECPoint[] eCPointArray = wNafPreCompInfoArray[i2];
                eCPointArray = n5 < 0 == blArray[i2] ? eCPointArray.getPreComp() : eCPointArray.getPreCompNeg();
                eCPoint3 = eCPoint3.add(eCPointArray[n4 >>> 1]);
            }
            if (eCPoint3 == eCPoint) {
                ++n;
                continue;
            }
            if (n > 0) {
                eCPoint2 = eCPoint2.timesPow2(n);
                n = 0;
            }
            eCPoint2 = eCPoint2.twicePlus(eCPoint3);
        }
        if (n > 0) {
            eCPoint2 = eCPoint2.timesPow2(n);
        }
        return eCPoint2;
    }

    private static ECPoint implShamirsTrickFixedPoint(ECPoint eCPoint, BigInteger object, ECPoint eCPoint2, BigInteger object2) {
        Object object3 = eCPoint.getCurve();
        int n = FixedPointUtil.getCombSize((ECCurve)object3);
        if (((BigInteger)object).bitLength() <= n && ((BigInteger)object2).bitLength() <= n) {
            FixedPointPreCompInfo fixedPointPreCompInfo = FixedPointUtil.precompute(eCPoint);
            FixedPointPreCompInfo fixedPointPreCompInfo2 = FixedPointUtil.precompute(eCPoint2);
            ECLookupTable eCLookupTable = fixedPointPreCompInfo.getLookupTable();
            ECLookupTable eCLookupTable2 = fixedPointPreCompInfo2.getLookupTable();
            Object object4 = fixedPointPreCompInfo.getWidth();
            if (object4 != fixedPointPreCompInfo2.getWidth()) {
                FixedPointCombMultiplier fixedPointCombMultiplier;
                object3 = fixedPointCombMultiplier;
                ((FixedPointCombMultiplier)object3)();
                return fixedPointCombMultiplier.multiply(eCPoint, (BigInteger)object).add(((AbstractECMultiplier)object3).multiply(eCPoint2, (BigInteger)object2));
            }
            int n2 = (n + object4 - 1) / object4;
            eCPoint2 = ((ECCurve)object3).getInfinity();
            int n3 = n2 * object4;
            object = Nat.fromBigInteger(n3, (BigInteger)object);
            object2 = Nat.fromBigInteger(n3, (BigInteger)object2);
            int n4 = n3 - 1;
            for (n = 0; n < n2; ++n) {
                object4 = 0;
                int n5 = 0;
                Object object5 = n4 - n;
                while (object5 >= 0) {
                    int n8 = object5;
                    n8 = n5;
                    n8 = object4;
                    object4 = object5 >>> 5;
                    n5 = object5 & 0x1F;
                    reference v5 = object[object4] >>> n5;
                    object5 = v5;
                    object5 = (n8 ^ v5 >>> 1) << 1 ^ object5;
                    reference v6 = object2[object4] >>> n5;
                    object4 = v6;
                    n5 = (n7 ^ v6 >>> 1) << 1 ^ object4;
                    Object object6 = object4 = n6 - n2;
                    object4 = object5;
                    object5 = object6;
                }
                eCPoint2 = eCPoint2.twicePlus(eCLookupTable.lookupVar((int)object4).add(eCLookupTable2.lookupVar(n5)));
            }
            return eCPoint2.add(fixedPointPreCompInfo.getOffset()).add(fixedPointPreCompInfo2.getOffset());
        }
        throw new IllegalStateException("fixed-point comb doesn't support scalars larger than the curve order");
    }
}

