/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT283Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat320;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class SecT283FieldElement
extends ECFieldElement.AbstractF2m {
    public long[] x;

    public SecT283FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.bitLength() <= 283) {
            this.x = SecT283Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecT283FieldElement");
    }

    public SecT283FieldElement() {
        this.x = Nat320.create64();
    }

    public SecT283FieldElement(long[] lArray) {
        this.x = lArray;
    }

    @Override
    public boolean isOne() {
        return Nat320.isOne64(this.x);
    }

    @Override
    public boolean isZero() {
        return Nat320.isZero64(this.x);
    }

    @Override
    public boolean testBitZero() {
        return (this.x[0] & 1L) != 0L;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat320.toBigInteger64(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecT283Field";
    }

    @Override
    public int getFieldSize() {
        return 283;
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecT283FieldElement secT283FieldElement = object;
        Object object = Nat320.create64();
        SecT283Field.add(secT283FieldElement.x, ((SecT283FieldElement)eCFieldElement).x, (long[])object);
        return new SecT283FieldElement((long[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecT283FieldElement secT283FieldElement = object;
        Object object = Nat320.create64();
        SecT283Field.addOne(secT283FieldElement.x, (long[])object);
        return new SecT283FieldElement((long[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        return this.add(eCFieldElement);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecT283FieldElement secT283FieldElement = object;
        Object object = Nat320.create64();
        SecT283Field.multiply(secT283FieldElement.x, ((SecT283FieldElement)eCFieldElement).x, (long[])object);
        return new SecT283FieldElement((long[])object);
    }

    @Override
    public ECFieldElement multiplyMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        return this.multiplyPlusProduct(eCFieldElement, eCFieldElement2, eCFieldElement3);
    }

    @Override
    public ECFieldElement multiplyPlusProduct(ECFieldElement object, ECFieldElement object2, ECFieldElement object3) {
        Object object4 = ((SecT283FieldElement)object4).x;
        object = ((SecT283FieldElement)object).x;
        object2 = ((SecT283FieldElement)object2).x;
        object3 = ((SecT283FieldElement)object3).x;
        long[] lArray = Nat.create64(9);
        SecT283Field.multiplyAddToExt((long[])object4, (long[])object, lArray);
        SecT283Field.multiplyAddToExt((long[])object2, (long[])object3, lArray);
        long[] lArray2 = Nat320.create64();
        object4 = lArray2;
        SecT283Field.reduce(lArray, lArray2);
        return new SecT283FieldElement((long[])object4);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        return this.multiply(eCFieldElement.invert());
    }

    @Override
    public ECFieldElement negate() {
        return this;
    }

    @Override
    public ECFieldElement square() {
        SecT283FieldElement secT283FieldElement = object;
        Object object = Nat320.create64();
        SecT283Field.square(secT283FieldElement.x, (long[])object);
        return new SecT283FieldElement((long[])object);
    }

    @Override
    public ECFieldElement squareMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.squarePlusProduct(eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECFieldElement squarePlusProduct(ECFieldElement object, ECFieldElement object2) {
        Object object3 = ((SecT283FieldElement)object3).x;
        object = ((SecT283FieldElement)object).x;
        object2 = ((SecT283FieldElement)object2).x;
        long[] lArray = Nat.create64(9);
        SecT283Field.squareAddToExt((long[])object3, lArray);
        SecT283Field.multiplyAddToExt((long[])object, (long[])object2, lArray);
        long[] lArray2 = Nat320.create64();
        object3 = lArray2;
        SecT283Field.reduce(lArray, lArray2);
        return new SecT283FieldElement((long[])object3);
    }

    @Override
    public ECFieldElement squarePow(int n) {
        if (n < 1) {
            return object;
        }
        SecT283FieldElement secT283FieldElement = object;
        Object object = Nat320.create64();
        SecT283Field.squareN(secT283FieldElement.x, n, (long[])object);
        return new SecT283FieldElement((long[])object);
    }

    @Override
    public ECFieldElement halfTrace() {
        SecT283FieldElement secT283FieldElement = object;
        Object object = Nat320.create64();
        SecT283Field.halfTrace(secT283FieldElement.x, (long[])object);
        return new SecT283FieldElement((long[])object);
    }

    @Override
    public boolean hasFastTrace() {
        return true;
    }

    @Override
    public int trace() {
        return SecT283Field.trace(this.x);
    }

    @Override
    public ECFieldElement invert() {
        SecT283FieldElement secT283FieldElement = object;
        Object object = Nat320.create64();
        SecT283Field.invert(secT283FieldElement.x, (long[])object);
        return new SecT283FieldElement((long[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        SecT283FieldElement secT283FieldElement = object;
        Object object = Nat320.create64();
        SecT283Field.sqrt(secT283FieldElement.x, (long[])object);
        return new SecT283FieldElement((long[])object);
    }

    public int getRepresentation() {
        return 3;
    }

    public int getM() {
        return 283;
    }

    public int getK1() {
        return 5;
    }

    public int getK2() {
        return 7;
    }

    public int getK3() {
        return 12;
    }

    public boolean equals(Object object) {
        if (object == secT283FieldElement2) {
            return true;
        }
        if (!(object instanceof SecT283FieldElement)) {
            return false;
        }
        SecT283FieldElement secT283FieldElement = secT283FieldElement2;
        SecT283FieldElement secT283FieldElement2 = (SecT283FieldElement)object;
        return Nat320.eq64(secT283FieldElement.x, secT283FieldElement2.x);
    }

    public int hashCode() {
        return Arrays.hashCode(this.x, 0, 5) ^ 0x2B33AB;
    }
}

