/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.DefaultXMSSOid;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.DigestUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlus;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlusParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSOid;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class XMSSParameters {
    private static final Map<Integer, XMSSParameters> paramsLookupTable;
    private final XMSSOid oid;
    private final int height;
    private final int k;
    private final ASN1ObjectIdentifier treeDigestOID;
    private final int winternitzParameter;
    private final String treeDigest;
    private final int treeDigestSize;
    private final WOTSPlusParameters wotsPlusParams;

    public XMSSParameters(int n, Digest digest) {
        this(n, DigestUtil.getDigestOID(digest.getAlgorithmName()));
    }

    public XMSSParameters(int n, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (n >= 2) {
            if (aSN1ObjectIdentifier != null) {
                int n2;
                int n3;
                WOTSPlusParameters wOTSPlusParameters;
                this.height = n;
                this.k = this.determineMinK();
                String string = DigestUtil.getDigestName(aSN1ObjectIdentifier);
                Object object = string;
                this.treeDigest = object;
                this.treeDigestOID = aSN1ObjectIdentifier;
                Object object2 = object = wOTSPlusParameters;
                ((WOTSPlusParameters)object2)(aSN1ObjectIdentifier);
                this.wotsPlusParams = object2;
                this.treeDigestSize = n3 = ((WOTSPlusParameters)object).getTreeDigestSize();
                this.winternitzParameter = n2 = ((WOTSPlusParameters)object).getWinternitzParameter();
                int n4 = wOTSPlusParameters.getLen();
                this.oid = DefaultXMSSOid.lookup(string, n3, n2, n4, n);
                return;
            }
            throw new NullPointerException("digest == null");
        }
        throw new IllegalArgumentException("height must be >= 2");
    }

    private int determineMinK() {
        int n;
        for (int k = 2; k <= (n = this.height); ++k) {
            if ((n - k) % 2 != 0) continue;
            return k;
        }
        throw new IllegalStateException("should never happen...");
    }

    public static XMSSParameters lookupByOID(int n) {
        return paramsLookupTable.get(Integers.valueOf(n));
    }

    static {
        HashMap<Integer, XMSSParameters> hashMap = new HashMap<Integer, XMSSParameters>();
        ASN1ObjectIdentifier aSN1ObjectIdentifier = NISTObjectIdentifiers.id_sha256;
        hashMap.put(Integers.valueOf(1), new XMSSParameters(10, aSN1ObjectIdentifier));
        hashMap.put(Integers.valueOf(2), new XMSSParameters(16, aSN1ObjectIdentifier));
        hashMap.put(Integers.valueOf(3), new XMSSParameters(20, aSN1ObjectIdentifier));
        aSN1ObjectIdentifier = NISTObjectIdentifiers.id_sha512;
        hashMap.put(Integers.valueOf(4), new XMSSParameters(10, aSN1ObjectIdentifier));
        hashMap.put(Integers.valueOf(5), new XMSSParameters(16, aSN1ObjectIdentifier));
        hashMap.put(Integers.valueOf(6), new XMSSParameters(20, aSN1ObjectIdentifier));
        aSN1ObjectIdentifier = NISTObjectIdentifiers.id_shake128;
        hashMap.put(Integers.valueOf(7), new XMSSParameters(10, aSN1ObjectIdentifier));
        hashMap.put(Integers.valueOf(8), new XMSSParameters(16, aSN1ObjectIdentifier));
        hashMap.put(Integers.valueOf(9), new XMSSParameters(20, aSN1ObjectIdentifier));
        aSN1ObjectIdentifier = NISTObjectIdentifiers.id_shake256;
        hashMap.put(Integers.valueOf(10), new XMSSParameters(10, aSN1ObjectIdentifier));
        hashMap.put(Integers.valueOf(11), new XMSSParameters(16, aSN1ObjectIdentifier));
        hashMap.put(Integers.valueOf(12), new XMSSParameters(20, aSN1ObjectIdentifier));
        paramsLookupTable = Collections.unmodifiableMap(hashMap);
    }

    public int getTreeDigestSize() {
        return this.treeDigestSize;
    }

    public ASN1ObjectIdentifier getTreeDigestOID() {
        return this.treeDigestOID;
    }

    public int getHeight() {
        return this.height;
    }

    public String getTreeDigest() {
        return this.treeDigest;
    }

    public int getLen() {
        return this.wotsPlusParams.getLen();
    }

    public int getWinternitzParameter() {
        return this.winternitzParameter;
    }

    public WOTSPlus getWOTSPlus() {
        return new WOTSPlus(this.wotsPlusParams);
    }

    public XMSSOid getOid() {
        return this.oid;
    }

    public int getK() {
        return this.k;
    }
}

