/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.euclid.BigIntEuclidean;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.BigIntPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.Constants;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.LongPolynomial2;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.ModularResultant;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.Resultant;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.util.ArrayEncoder;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.util.Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;

public class IntegerPolynomial
implements Polynomial {
    private static final int NUM_EQUAL_RESULTANTS = 3;
    private static final int[] PRIMES = new int[]{4507, 4513, 4517, 4519, 4523, 4547, 4549, 4561, 4567, 4583, 4591, 4597, 4603, 4621, 4637, 4639, 4643, 4649, 4651, 4657, 4663, 4673, 4679, 4691, 4703, 4721, 4723, 4729, 4733, 4751, 4759, 4783, 4787, 4789, 4793, 4799, 4801, 4813, 4817, 4831, 4861, 4871, 4877, 4889, 4903, 4909, 4919, 4931, 4933, 4937, 4943, 4951, 4957, 4967, 4969, 4973, 4987, 4993, 4999, 5003, 5009, 5011, 5021, 5023, 5039, 5051, 5059, 5077, 5081, 5087, 5099, 5101, 5107, 5113, 5119, 5147, 5153, 5167, 5171, 5179, 5189, 5197, 5209, 5227, 5231, 5233, 5237, 5261, 5273, 5279, 5281, 5297, 5303, 5309, 5323, 5333, 5347, 5351, 5381, 5387, 5393, 5399, 5407, 5413, 5417, 5419, 5431, 5437, 5441, 5443, 5449, 5471, 5477, 5479, 5483, 5501, 5503, 5507, 5519, 5521, 5527, 5531, 5557, 5563, 5569, 5573, 5581, 5591, 5623, 5639, 5641, 5647, 5651, 5653, 5657, 5659, 5669, 5683, 5689, 5693, 5701, 5711, 5717, 5737, 5741, 5743, 5749, 5779, 5783, 5791, 5801, 5807, 5813, 5821, 5827, 5839, 5843, 5849, 5851, 5857, 5861, 5867, 5869, 5879, 5881, 5897, 5903, 5923, 5927, 5939, 5953, 5981, 5987, 6007, 6011, 6029, 6037, 6043, 6047, 6053, 6067, 6073, 6079, 6089, 6091, 6101, 6113, 6121, 6131, 6133, 6143, 6151, 6163, 6173, 6197, 6199, 6203, 6211, 6217, 6221, 6229, 6247, 6257, 6263, 6269, 6271, 6277, 6287, 6299, 6301, 6311, 6317, 6323, 6329, 6337, 6343, 6353, 6359, 6361, 6367, 6373, 6379, 6389, 6397, 6421, 6427, 6449, 6451, 6469, 6473, 6481, 6491, 6521, 6529, 6547, 6551, 6553, 6563, 6569, 6571, 6577, 6581, 6599, 6607, 6619, 6637, 6653, 6659, 6661, 6673, 6679, 6689, 6691, 6701, 6703, 6709, 6719, 6733, 6737, 6761, 6763, 6779, 6781, 6791, 6793, 6803, 6823, 6827, 6829, 6833, 6841, 6857, 6863, 6869, 6871, 6883, 6899, 6907, 6911, 6917, 6947, 6949, 6959, 6961, 6967, 6971, 6977, 6983, 6991, 6997, 7001, 7013, 7019, 7027, 7039, 7043, 7057, 7069, 7079, 7103, 7109, 7121, 7127, 7129, 7151, 7159, 7177, 7187, 7193, 7207, 7211, 7213, 7219, 7229, 7237, 7243, 7247, 7253, 7283, 7297, 7307, 7309, 7321, 7331, 7333, 7349, 7351, 7369, 7393, 7411, 7417, 7433, 7451, 7457, 7459, 7477, 7481, 7487, 7489, 7499, 7507, 7517, 7523, 7529, 7537, 7541, 7547, 7549, 7559, 7561, 7573, 7577, 7583, 7589, 7591, 7603, 7607, 7621, 7639, 7643, 7649, 7669, 7673, 7681, 7687, 7691, 7699, 7703, 7717, 7723, 7727, 7741, 7753, 7757, 7759, 7789, 7793, 7817, 7823, 7829, 7841, 7853, 7867, 7873, 7877, 7879, 7883, 7901, 7907, 7919, 7927, 7933, 7937, 7949, 7951, 7963, 7993, 8009, 8011, 8017, 8039, 8053, 8059, 8069, 8081, 8087, 8089, 8093, 8101, 8111, 8117, 8123, 8147, 8161, 8167, 8171, 8179, 8191, 8209, 8219, 8221, 8231, 8233, 8237, 8243, 8263, 8269, 8273, 8287, 8291, 8293, 8297, 8311, 8317, 8329, 8353, 8363, 8369, 8377, 8387, 8389, 8419, 8423, 8429, 8431, 8443, 8447, 8461, 8467, 8501, 8513, 8521, 8527, 8537, 8539, 8543, 8563, 8573, 8581, 8597, 8599, 8609, 8623, 8627, 8629, 8641, 8647, 8663, 8669, 8677, 8681, 8689, 8693, 8699, 8707, 8713, 8719, 8731, 8737, 8741, 8747, 8753, 8761, 8779, 8783, 8803, 8807, 8819, 8821, 8831, 8837, 8839, 8849, 8861, 8863, 8867, 8887, 8893, 8923, 8929, 8933, 8941, 8951, 8963, 8969, 8971, 8999, 9001, 9007, 9011, 9013, 9029, 9041, 9043, 9049, 9059, 9067, 9091, 9103, 9109, 9127, 9133, 9137, 9151, 9157, 9161, 9173, 9181, 9187, 9199, 9203, 9209, 9221, 9227, 9239, 9241, 9257, 9277, 9281, 9283, 9293, 9311, 9319, 9323, 9337, 9341, 9343, 9349, 9371, 9377, 9391, 9397, 9403, 9413, 9419, 9421, 9431, 9433, 9437, 9439, 9461, 9463, 9467, 9473, 9479, 9491, 9497, 9511, 9521, 9533, 9539, 9547, 9551, 9587, 9601, 9613, 9619, 9623, 9629, 9631, 9643, 9649, 9661, 9677, 9679, 9689, 9697, 9719, 9721, 9733, 9739, 9743, 9749, 9767, 9769, 9781, 9787, 9791, 9803, 9811, 9817, 9829, 9833, 9839, 9851, 9857, 9859, 9871, 9883, 9887, 9901, 9907, 9923, 9929, 9931, 9941, 9949, 9967, 9973};
    private static final List BIGINT_PRIMES = new ArrayList();
    public int[] coeffs;

    public IntegerPolynomial(int n) {
        this.coeffs = new int[n];
    }

    public IntegerPolynomial(int[] nArray) {
        this.coeffs = nArray;
    }

    public IntegerPolynomial(BigIntPolynomial bigIntPolynomial) {
        this.coeffs = new int[bigIntPolynomial.coeffs.length];
        int n = 0;
        while (true) {
            BigInteger[] bigIntegerArray = bigIntPolynomial.coeffs;
            if (n >= bigIntPolynomial.coeffs.length) break;
            this.coeffs[n] = bigIntegerArray[n].intValue();
            ++n;
        }
    }

    public static IntegerPolynomial fromBinary3Sves(byte[] byArray, int n) {
        return new IntegerPolynomial(ArrayEncoder.decodeMod3Sves(byArray, n));
    }

    public static IntegerPolynomial fromBinary3Tight(byte[] byArray, int n) {
        return new IntegerPolynomial(ArrayEncoder.decodeMod3Tight(byArray, n));
    }

    public static IntegerPolynomial fromBinary3Tight(InputStream inputStream, int n) {
        return new IntegerPolynomial(ArrayEncoder.decodeMod3Tight(inputStream, n));
    }

    public static IntegerPolynomial fromBinary(byte[] byArray, int n, int n2) {
        return new IntegerPolynomial(ArrayEncoder.decodeModQ(byArray, n, n2));
    }

    public static IntegerPolynomial fromBinary(InputStream inputStream, int n, int n2) {
        return new IntegerPolynomial(ArrayEncoder.decodeModQ(inputStream, n, n2));
    }

    private IntegerPolynomial multRecursive(IntegerPolynomial object) {
        IntegerPolynomial integerPolynomial;
        IntegerPolynomial integerPolynomial2;
        IntegerPolynomial integerPolynomial3;
        IntegerPolynomial integerPolynomial4;
        IntegerPolynomial integerPolynomial5;
        Object object2 = ((IntegerPolynomial)object2).coeffs;
        object = ((IntegerPolynomial)object).coeffs;
        int n = ((IntegerPolynomial)object).coeffs.length;
        if (n <= 32) {
            IntegerPolynomial integerPolynomial6;
            int n2 = n * 2 - 1;
            IntegerPolynomial integerPolynomial7 = integerPolynomial6;
            integerPolynomial6 = new IntegerPolynomial(new int[n2]);
            for (int k = 0; k < n2; ++k) {
                for (int i2 = Math.max(0, k - n + 1); i2 <= Math.min(k, n - 1); ++i2) {
                    int[] nArray = integerPolynomial7.coeffs;
                    int n3 = nArray[k];
                    integerPolynomial7.coeffs[k] = (int)(object[i2] * object2[k - i2] + n3);
                }
            }
            return integerPolynomial7;
        }
        int n4 = n / 2;
        IntegerPolynomial integerPolynomial8 = integerPolynomial5;
        integerPolynomial5 = new IntegerPolynomial(Arrays.copyOf((int[])object2, n4));
        IntegerPolynomial integerPolynomial9 = integerPolynomial4;
        integerPolynomial4 = new IntegerPolynomial(Arrays.copyOfRange((int[])object2, n4, n));
        object2 = integerPolynomial3;
        integerPolynomial3 = new IntegerPolynomial(Arrays.copyOf((int[])object, n4));
        Object object3 = integerPolynomial2;
        integerPolynomial2 = new IntegerPolynomial(Arrays.copyOfRange((int[])object, n4, n));
        IntegerPolynomial integerPolynomial10 = (IntegerPolynomial)integerPolynomial5.clone();
        object = integerPolynomial10;
        Object object4 = object2;
        ((IntegerPolynomial)object).add(integerPolynomial9);
        object2 = (IntegerPolynomial)((IntegerPolynomial)object4).clone();
        ((IntegerPolynomial)object2).add((IntegerPolynomial)object3);
        object = integerPolynomial8.multRecursive((IntegerPolynomial)object4);
        integerPolynomial8 = integerPolynomial9.multRecursive((IntegerPolynomial)object3);
        object2 = integerPolynomial10.multRecursive((IntegerPolynomial)object2);
        ((IntegerPolynomial)object2).sub((IntegerPolynomial)object);
        ((IntegerPolynomial)object2).sub(integerPolynomial8);
        integerPolynomial9 = integerPolynomial;
        integerPolynomial = new IntegerPolynomial(n * 2 - 1);
        n = 0;
        while (true) {
            object3 = ((IntegerPolynomial)object).coeffs;
            if (n >= ((IntegerPolynomial)object).coeffs.length) break;
            integerPolynomial9.coeffs[n] = (int)object3[n];
            ++n;
        }
        int n5 = 0;
        while (true) {
            int[] nArray = ((IntegerPolynomial)object2).coeffs;
            if (n5 >= ((IntegerPolynomial)object2).coeffs.length) break;
            int n6 = n4 + n5;
            integerPolynomial9.coeffs[n6] = integerPolynomial9.coeffs[n6] + nArray[n5];
            ++n5;
        }
        int n7 = 0;
        while (true) {
            int[] nArray = integerPolynomial8.coeffs;
            if (n7 >= integerPolynomial8.coeffs.length) break;
            int n8 = n4 * 2 + n7;
            integerPolynomial9.coeffs[n8] = integerPolynomial9.coeffs[n8] + nArray[n7];
            ++n7;
        }
        return integerPolynomial9;
    }

    private IntegerPolynomial mod2ToModq(IntegerPolynomial integerPolynomial, int n) {
        if (Util.is64BitJVM() && n == 2048) {
            LongPolynomial2 longPolynomial2;
            LongPolynomial2 longPolynomial22;
            LongPolynomial2 longPolynomial23 = longPolynomial22;
            longPolynomial22 = new LongPolynomial2((IntegerPolynomial)object);
            Object object = longPolynomial2;
            longPolynomial2 = new LongPolynomial2(integerPolynomial);
            int n2 = 2;
            while (n2 < n) {
                LongPolynomial2 longPolynomial24 = (LongPolynomial2)((LongPolynomial2)object).clone();
                int n3 = (n2 *= 2) - 1;
                longPolynomial24.mult2And(n3);
                longPolynomial24.subAnd(longPolynomial23.mult((LongPolynomial2)object).mult((LongPolynomial2)object), n3);
                object = longPolynomial24;
            }
            return ((LongPolynomial2)object).toIntegerPolynomial();
        }
        int n4 = 2;
        while (n4 < n) {
            IntegerPolynomial integerPolynomial2;
            IntegerPolynomial integerPolynomial3 = integerPolynomial2;
            integerPolynomial3(Arrays.copyOf(integerPolynomial.coeffs, integerPolynomial.coeffs.length));
            integerPolynomial3.mult2(n4 *= 2);
            integerPolynomial2.sub(((IntegerPolynomial)object).mult(integerPolynomial, n4).mult(integerPolynomial, n4), n4);
            integerPolynomial = integerPolynomial3;
        }
        return integerPolynomial;
    }

    private void multShiftSub(IntegerPolynomial integerPolynomial, int n, int n2, int n3) {
        int n4 = this.coeffs.length;
        for (int k = n2; k < n4; ++k) {
            this.coeffs[k] = (this.coeffs[k] - integerPolynomial.coeffs[k - n2] * n) % n3;
        }
    }

    private BigInteger squareSum() {
        BigInteger bigInteger = Constants.BIGINT_ZERO;
        int n = 0;
        while (true) {
            int[] nArray = this.coeffs;
            if (n >= this.coeffs.length) break;
            int n2 = nArray[n];
            bigInteger = bigInteger.add(BigInteger.valueOf(n2 * n2));
            ++n;
        }
        return bigInteger;
    }

    private void mult2(int n) {
        int n2 = 0;
        while (true) {
            int n3;
            int[] nArray = this.coeffs;
            if (n2 >= this.coeffs.length) break;
            nArray[n2] = n3 = nArray[n2] * 2;
            nArray[n2] = n3 % n;
            ++n2;
        }
    }

    private void sort(int[] nArray) {
        boolean bl = true;
        while (bl) {
            bl = false;
            int n = 0;
            while (n != nArray.length - 1) {
                int n2 = nArray[n];
                int n3 = n + 1;
                int n4 = nArray[n3];
                if (n2 > n4) {
                    nArray[n] = n4;
                    nArray[n3] = n2;
                    bl = true;
                }
                n = n3;
            }
        }
    }

    private boolean equalsZero() {
        int n = 0;
        while (true) {
            int[] nArray = this.coeffs;
            if (n >= this.coeffs.length) break;
            if (nArray[n] != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean equalsAbsOne() {
        int[] nArray;
        int n = 1;
        while (true) {
            nArray = this.coeffs;
            if (n >= this.coeffs.length) break;
            if (nArray[n] != 0) {
                return false;
            }
            ++n;
        }
        return Math.abs(nArray[0]) == 1;
    }

    static {
        int n = 0;
        while (true) {
            int[] nArray = PRIMES;
            if (n == PRIMES.length) break;
            BIGINT_PRIMES.add(BigInteger.valueOf(nArray[n]));
            ++n;
        }
    }

    public byte[] toBinary3Sves() {
        return ArrayEncoder.encodeMod3Sves(this.coeffs);
    }

    public byte[] toBinary3Tight() {
        Object object = Constants.BIGINT_ZERO;
        for (int k = this.coeffs.length - 1; k >= 0; --k) {
            object = ((BigInteger)object).multiply(BigInteger.valueOf(3L)).add(BigInteger.valueOf(this.coeffs[k] + 1));
        }
        int n = (BigInteger.valueOf(3L).pow(this.coeffs.length).bitLength() + 7) / 8;
        byte[] byArray = ((BigInteger)object).toByteArray();
        object = byArray;
        if (byArray.length < n) {
            byte[] byArray2 = new byte[n];
            Object object2 = object;
            int n2 = ((Object)object2).length;
            System.arraycopy(object2, 0, byArray2, n -= ((Object)object).length, n2);
            return byArray2;
        }
        if (((Object)object).length > n) {
            Object object3 = object;
            object = Arrays.copyOfRange((byte[])object3, 1, ((Object)object3).length);
        }
        return object;
    }

    public byte[] toBinary(int n) {
        return ArrayEncoder.encodeModQ(this.coeffs, n);
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial integerPolynomial, int n) {
        IntegerPolynomial integerPolynomial2 = this.mult(integerPolynomial);
        integerPolynomial2.mod(n);
        return integerPolynomial2;
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial integerPolynomial) {
        int n = integerPolynomial2.coeffs.length;
        if (integerPolynomial.coeffs.length == n) {
            IntegerPolynomial integerPolynomial2 = integerPolynomial2.multRecursive(integerPolynomial);
            if (integerPolynomial2.coeffs.length > n) {
                int[] nArray;
                int n2 = n;
                while (true) {
                    nArray = integerPolynomial2.coeffs;
                    if (n2 >= integerPolynomial2.coeffs.length) break;
                    int n3 = n2 - n;
                    nArray[n3] = nArray[n3] + nArray[n2];
                    ++n2;
                }
                integerPolynomial2.coeffs = Arrays.copyOf(nArray, n);
            }
            return integerPolynomial2;
        }
        throw new IllegalArgumentException("Number of coefficients must be the same");
    }

    @Override
    public BigIntPolynomial mult(BigIntPolynomial bigIntPolynomial) {
        return new BigIntPolynomial(this).mult(bigIntPolynomial);
    }

    public IntegerPolynomial invertFq(int n) {
        IntegerPolynomial integerPolynomial;
        IntegerPolynomial integerPolynomial2;
        IntegerPolynomial integerPolynomial3;
        IntegerPolynomial integerPolynomial4;
        int n2 = this.coeffs.length;
        int n3 = 0;
        IntegerPolynomial integerPolynomial5 = integerPolynomial4;
        int n4 = n2 + 1;
        new IntegerPolynomial((int)n4).coeffs[0] = 1;
        IntegerPolynomial integerPolynomial6 = integerPolynomial3;
        integerPolynomial3 = new IntegerPolynomial(n4);
        IntegerPolynomial integerPolynomial7 = integerPolynomial2;
        integerPolynomial7(n4);
        integerPolynomial2.coeffs = Arrays.copyOf(this.coeffs, n4);
        integerPolynomial2.modPositive(2);
        IntegerPolynomial integerPolynomial8 = integerPolynomial;
        new IntegerPolynomial((int)n4).coeffs[0] = 1;
        new IntegerPolynomial((int)n4).coeffs[n2] = 1;
        while (true) {
            if (integerPolynomial7.coeffs[0] == 0) {
                for (int k = 1; k <= n2; ++k) {
                    int n5 = k;
                    int n6 = n5 - 1;
                    integerPolynomial7.coeffs[n6] = integerPolynomial7.coeffs[n5];
                    n6 = n4 - k;
                    integerPolynomial6.coeffs[n6] = integerPolynomial6.coeffs[n2 - k];
                }
                integerPolynomial7.coeffs[n2] = 0;
                integerPolynomial6.coeffs[0] = 0;
                ++n3;
                if (!integerPolynomial7.equalsZero()) continue;
                return null;
            }
            if (integerPolynomial7.equalsOne()) {
                IntegerPolynomial integerPolynomial9;
                if (integerPolynomial5.coeffs[n2] != 0) {
                    return null;
                }
                IntegerPolynomial integerPolynomial10 = integerPolynomial9;
                integerPolynomial9 = new IntegerPolynomial(n2);
                n4 = n3 % n2;
                for (int k = n2 - 1; k >= 0; --k) {
                    int n7 = k - n4;
                    if (n7 < 0) {
                        n7 += n2;
                    }
                    integerPolynomial10.coeffs[n7] = integerPolynomial5.coeffs[k];
                }
                return this.mod2ToModq(integerPolynomial10, n);
            }
            if (integerPolynomial7.degree() < integerPolynomial8.degree()) {
                IntegerPolynomial integerPolynomial11 = integerPolynomial8;
                IntegerPolynomial integerPolynomial12 = integerPolynomial6;
                integerPolynomial6 = integerPolynomial5;
                integerPolynomial5 = integerPolynomial12;
                integerPolynomial8 = integerPolynomial7;
                integerPolynomial7 = integerPolynomial11;
            }
            integerPolynomial7.add(integerPolynomial8, 2);
            integerPolynomial5.add(integerPolynomial6, 2);
        }
    }

    public IntegerPolynomial invertF3() {
        IntegerPolynomial integerPolynomial;
        IntegerPolynomial integerPolynomial2;
        IntegerPolynomial integerPolynomial3;
        IntegerPolynomial integerPolynomial4;
        int n = integerPolynomial8.coeffs.length;
        int n2 = 0;
        IntegerPolynomial integerPolynomial5 = integerPolynomial4;
        int n3 = n + 1;
        new IntegerPolynomial((int)n3).coeffs[0] = 1;
        IntegerPolynomial integerPolynomial6 = integerPolynomial3;
        integerPolynomial3 = new IntegerPolynomial(n3);
        IntegerPolynomial integerPolynomial7 = integerPolynomial2;
        integerPolynomial7(n3);
        integerPolynomial2.coeffs = Arrays.copyOf(integerPolynomial8.coeffs, n3);
        integerPolynomial2.modPositive(3);
        IntegerPolynomial integerPolynomial8 = integerPolynomial;
        new IntegerPolynomial((int)n3).coeffs[0] = -1;
        new IntegerPolynomial((int)n3).coeffs[n] = 1;
        while (true) {
            if (integerPolynomial7.coeffs[0] == 0) {
                for (int k = 1; k <= n; ++k) {
                    int n4 = k;
                    int n5 = n4 - 1;
                    integerPolynomial7.coeffs[n5] = integerPolynomial7.coeffs[n4];
                    n5 = n3 - k;
                    integerPolynomial6.coeffs[n5] = integerPolynomial6.coeffs[n - k];
                }
                integerPolynomial7.coeffs[n] = 0;
                integerPolynomial6.coeffs[0] = 0;
                ++n2;
                if (!integerPolynomial7.equalsZero()) continue;
                return null;
            }
            if (integerPolynomial7.equalsAbsOne()) {
                IntegerPolynomial integerPolynomial9;
                if (integerPolynomial5.coeffs[n] != 0) {
                    return null;
                }
                integerPolynomial8 = integerPolynomial9;
                integerPolynomial9 = new IntegerPolynomial(n);
                n2 %= n;
                for (n3 = n - 1; n3 >= 0; --n3) {
                    int n6 = n3 - n2;
                    if (n6 < 0) {
                        n6 += n;
                    }
                    integerPolynomial8.coeffs[n6] = integerPolynomial7.coeffs[0] * integerPolynomial5.coeffs[n3];
                }
                IntegerPolynomial integerPolynomial10 = integerPolynomial8;
                integerPolynomial10.ensurePositive(3);
                return integerPolynomial10;
            }
            if (integerPolynomial7.degree() < integerPolynomial8.degree()) {
                IntegerPolynomial integerPolynomial11 = integerPolynomial8;
                IntegerPolynomial integerPolynomial12 = integerPolynomial6;
                integerPolynomial6 = integerPolynomial5;
                integerPolynomial5 = integerPolynomial12;
                integerPolynomial8 = integerPolynomial7;
                integerPolynomial7 = integerPolynomial11;
            }
            if (integerPolynomial7.coeffs[0] == integerPolynomial8.coeffs[0]) {
                integerPolynomial7.sub(integerPolynomial8, 3);
                integerPolynomial5.sub(integerPolynomial6, 3);
                continue;
            }
            integerPolynomial7.add(integerPolynomial8, 3);
            integerPolynomial5.add(integerPolynomial6, 3);
        }
    }

    public Resultant resultant() {
        PrimeGenerator primeGenerator;
        LinkedList<ModularResultant> linkedList;
        int n = ((IntegerPolynomial)((Object)bigIntPolynomial)).coeffs.length;
        Serializable serializable = linkedList;
        linkedList = new LinkedList<ModularResultant>();
        BigInteger bigInteger = Constants.BIGINT_ONE;
        int n2 = 1;
        PrimeGenerator primeGenerator2 = primeGenerator;
        primeGenerator = (IntegerPolynomial)((Object)bigIntPolynomial).new PrimeGenerator(null);
        int n3 = n2;
        BigInteger bigInteger2 = bigInteger;
        while (true) {
            int n4;
            BigInteger bigInteger3 = primeGenerator2.nextPrime();
            BigInteger bigInteger4 = bigInteger;
            ModularResultant modularResultant = ((IntegerPolynomial)((Object)bigIntPolynomial)).resultant(bigInteger3.intValue());
            serializable.add(modularResultant);
            BigInteger bigInteger5 = bigInteger4.multiply(bigInteger3);
            BigIntEuclidean bigIntEuclidean = BigIntEuclidean.calculate(bigInteger3, bigInteger4);
            bigInteger = bigInteger2.multiply(bigIntEuclidean.x.multiply(bigInteger3)).add(modularResultant.res.multiply(bigIntEuclidean.y.multiply(bigInteger))).mod(bigInteger5);
            BigInteger bigInteger6 = bigInteger5.divide(BigInteger.valueOf(2L));
            bigInteger3 = bigInteger6.negate();
            if (bigInteger.compareTo(bigInteger6) > 0) {
                bigInteger = bigInteger.subtract(bigInteger5);
            } else if (bigInteger.compareTo(bigInteger3) < 0) {
                bigInteger = bigInteger.add(bigInteger5);
            }
            if (bigInteger.equals(bigInteger2)) {
                n4 = n3 + 1;
                if (n4 >= 3) {
                    while (serializable.size() > 1) {
                        LinkedList<ModularResultant> linkedList2 = serializable;
                        linkedList2.addLast(ModularResultant.combineRho((ModularResultant)linkedList2.removeFirst(), (ModularResultant)serializable.removeFirst()));
                    }
                    BigIntPolynomial bigIntPolynomial = ((ModularResultant)serializable.getFirst()).rho;
                    serializable = bigInteger5.divide(BigInteger.valueOf(2L));
                    BigInteger bigInteger7 = ((BigInteger)serializable).negate();
                    if (bigInteger.compareTo((BigInteger)serializable) > 0) {
                        bigInteger = bigInteger.subtract(bigInteger5);
                    }
                    if (bigInteger.compareTo(bigInteger7) < 0) {
                        bigInteger = bigInteger.add(bigInteger5);
                    }
                    for (int k = 0; k < n; ++k) {
                        BigInteger bigInteger8 = bigIntPolynomial.coeffs[k];
                        if (bigInteger8.compareTo((BigInteger)serializable) > 0) {
                            bigIntPolynomial.coeffs[k] = bigInteger8.subtract(bigInteger5);
                        }
                        if (bigInteger8.compareTo(bigInteger7) >= 0) continue;
                        bigIntPolynomial.coeffs[k] = bigInteger8.add(bigInteger5);
                    }
                    return new Resultant(bigIntPolynomial, bigInteger);
                }
            } else {
                n4 = 1;
            }
            n3 = n4;
            bigInteger2 = bigInteger;
            bigInteger = bigInteger5;
        }
    }

    public Resultant resultantMultiThread() {
        LinkedBlockingQueue<Future<ModularResultant>> linkedBlockingQueue;
        IntegerPolynomial integerPolynomial = object7;
        int n = integerPolynomial.coeffs.length;
        Object object = integerPolynomial.squareSum().pow((n + 1) / 2).multiply(BigInteger.valueOf(2L).pow((((IntegerPolynomial)object7).degree() + 1) / 2)).multiply(BigInteger.valueOf(2L));
        Object object2 = BigInteger.valueOf(10000L);
        BigInteger bigInteger = Constants.BIGINT_ONE;
        Serializable serializable = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Future<ModularResultant>>();
        Object object3 = BIGINT_PRIMES.iterator();
        Object object4 = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        while (bigInteger.compareTo((BigInteger)object) < 0) {
            object2 = object3.hasNext() ? (BigInteger)object3.next() : ((BigInteger)object2).nextProbablePrime();
            ((AbstractCollection)((Object)serializable)).add(object4.submit((IntegerPolynomial)object7.new ModResultantTask(((BigInteger)object2).intValue(), null)));
            bigInteger = bigInteger.multiply((BigInteger)object2);
        }
        object = null;
        while (!serializable.isEmpty()) {
            CombineTask combineTask;
            block12: {
                LinkedBlockingQueue<Future<ModularResultant>> linkedBlockingQueue2;
                try {
                    LinkedBlockingQueue<Future<ModularResultant>> linkedBlockingQueue3 = serializable;
                    linkedBlockingQueue2 = linkedBlockingQueue3;
                    object2 = (Future)linkedBlockingQueue3.take();
                }
                catch (Exception exception) {
                    throw new IllegalStateException(((Object)exception).toString());
                }
                object3 = (Future)linkedBlockingQueue2.poll();
                if (object3 != null) break block12;
                object = (ModularResultant)object2.get();
                break;
            }
            LinkedBlockingQueue<Future<ModularResultant>> linkedBlockingQueue4 = serializable;
            ExecutorService executorService = object4;
            CombineTask combineTask2 = combineTask;
            CombineTask combineTask3 = combineTask;
            Object object5 = object7;
            Object object6 = object3;
            object2 = (ModularResultant)object2.get();
            combineTask2((ModularResultant)object2, (ModularResultant)object6.get(), null);
            ((AbstractCollection)linkedBlockingQueue4).add(executorService.submit(combineTask3));
        }
        object4.shutdown();
        Object object7 = ((Resultant)object).res;
        object = ((Resultant)object).rho;
        object2 = bigInteger.divide(BigInteger.valueOf(2L));
        serializable = ((BigInteger)object2).negate();
        if (((BigInteger)object7).compareTo((BigInteger)object2) > 0) {
            object7 = ((BigInteger)object7).subtract(bigInteger);
        }
        if (((BigInteger)object7).compareTo((BigInteger)serializable) < 0) {
            object7 = ((BigInteger)object7).add(bigInteger);
        }
        for (int k = 0; k < n; ++k) {
            object4 = ((BigIntPolynomial)object).coeffs[k];
            if (((BigInteger)object4).compareTo((BigInteger)object2) > 0) {
                ((BigIntPolynomial)object).coeffs[k] = ((BigInteger)object4).subtract(bigInteger);
            }
            if (((BigInteger)object4).compareTo((BigInteger)serializable) >= 0) continue;
            ((BigIntPolynomial)object).coeffs[k] = ((BigInteger)object4).add(bigInteger);
        }
        return new Resultant((BigIntPolynomial)object, (BigInteger)object7);
    }

    public ModularResultant resultant(int n) {
        BigIntPolynomial bigIntPolynomial;
        int n2;
        IntegerPolynomial integerPolynomial;
        IntegerPolynomial integerPolynomial2;
        IntegerPolynomial integerPolynomial3;
        IntegerPolynomial integerPolynomial4;
        IntegerPolynomial integerPolynomial5;
        int[] nArray = Arrays.copyOf(((IntegerPolynomial)object).coeffs, ((IntegerPolynomial)object).coeffs.length + 1);
        Object object = nArray;
        IntegerPolynomial integerPolynomial6 = integerPolynomial5;
        integerPolynomial5 = new IntegerPolynomial((int[])object);
        int n3 = nArray.length;
        Object object2 = integerPolynomial4;
        new IntegerPolynomial((int)n3).coeffs[0] = -1;
        int n4 = n3 - 1;
        new IntegerPolynomial((int)n3).coeffs[n4] = 1;
        IntegerPolynomial integerPolynomial7 = integerPolynomial3;
        integerPolynomial6 = integerPolynomial2;
        integerPolynomial2 = new IntegerPolynomial(n3);
        IntegerPolynomial integerPolynomial8 = integerPolynomial;
        new IntegerPolynomial((int)n3).coeffs[0] = 1;
        n3 = new IntegerPolynomial(integerPolynomial6.coeffs).degree();
        int n5 = n2 = 1;
        n2 = n4;
        IntegerPolynomial integerPolynomial9 = integerPolynomial6;
        Object object3 = object2;
        integerPolynomial6 = integerPolynomial8;
        int n6 = n4;
        object2 = integerPolynomial7;
        int n7 = n5;
        int n8 = n3;
        while (n8 > 0) {
            int n9 = n6;
            n6 = Util.invert(((IntegerPolynomial)object2).coeffs[n8], n) * ((IntegerPolynomial)object3).coeffs[n6] % n;
            int n10 = n9 - n8;
            ((IntegerPolynomial)object3).multShiftSub((IntegerPolynomial)object2, n6, n10, n);
            integerPolynomial9.multShiftSub(integerPolynomial6, n6, n10, n);
            n6 = ((IntegerPolynomial)object3).degree();
            if (n6 >= n8) continue;
            int n11 = n2;
            n2 = Util.pow(((IntegerPolynomial)object2).coeffs[n8], n2 - n6, n) * n7 % n;
            if (n11 % 2 == 1 && n8 % 2 == 1) {
                n2 = -n2 % n;
            }
            int n12 = n6;
            int n13 = n2;
            IntegerPolynomial integerPolynomial10 = object3;
            IntegerPolynomial integerPolynomial11 = integerPolynomial9;
            n2 = n8;
            integerPolynomial9 = integerPolynomial6;
            object3 = object2;
            integerPolynomial6 = integerPolynomial11;
            n6 = n8;
            object2 = integerPolynomial10;
            n7 = n13;
            n8 = n12;
        }
        IntegerPolynomial integerPolynomial12 = integerPolynomial6;
        IntegerPolynomial integerPolynomial13 = integerPolynomial6;
        IntegerPolynomial integerPolynomial14 = object2;
        int n14 = Util.pow(integerPolynomial14.coeffs[0], n6, n) * n7 % n;
        integerPolynomial6.mult(Util.invert(integerPolynomial14.coeffs[0], n));
        integerPolynomial13.mod(n);
        integerPolynomial13.mult(n14);
        integerPolynomial12.mod(n);
        integerPolynomial12.coeffs = Arrays.copyOf(integerPolynomial12.coeffs, integerPolynomial12.coeffs.length - 1);
        object2 = bigIntPolynomial;
        ((BigIntPolynomial)object2)(integerPolynomial6);
        BigInteger bigInteger = BigInteger.valueOf(n14);
        return new ModularResultant(bigIntPolynomial, bigInteger, BigInteger.valueOf(n));
    }

    public int degree() {
        int n;
        for (n = this.coeffs.length - 1; n > 0 && this.coeffs[n] == 0; --n) {
        }
        return n;
    }

    public void add(IntegerPolynomial integerPolynomial, int n) {
        IntegerPolynomial integerPolynomial2 = this;
        integerPolynomial2.add(integerPolynomial);
        integerPolynomial2.mod(n);
    }

    public void add(IntegerPolynomial integerPolynomial) {
        int[] nArray = integerPolynomial.coeffs;
        int[] nArray2 = this.coeffs;
        if (integerPolynomial.coeffs.length > this.coeffs.length) {
            this.coeffs = Arrays.copyOf(nArray2, nArray.length);
        }
        int n = 0;
        while (true) {
            nArray2 = integerPolynomial.coeffs;
            if (n >= integerPolynomial.coeffs.length) break;
            this.coeffs[n] = this.coeffs[n] + nArray2[n];
            ++n;
        }
    }

    public void sub(IntegerPolynomial integerPolynomial, int n) {
        IntegerPolynomial integerPolynomial2 = this;
        integerPolynomial2.sub(integerPolynomial);
        integerPolynomial2.mod(n);
    }

    public void sub(IntegerPolynomial integerPolynomial) {
        int[] nArray = integerPolynomial.coeffs;
        int[] nArray2 = this.coeffs;
        if (integerPolynomial.coeffs.length > this.coeffs.length) {
            this.coeffs = Arrays.copyOf(nArray2, nArray.length);
        }
        int n = 0;
        while (true) {
            nArray2 = integerPolynomial.coeffs;
            if (n >= integerPolynomial.coeffs.length) break;
            this.coeffs[n] = this.coeffs[n] - nArray2[n];
            ++n;
        }
    }

    public void sub(int n) {
        int n2 = 0;
        while (true) {
            int[] nArray = this.coeffs;
            if (n2 >= this.coeffs.length) break;
            nArray[n2] = nArray[n2] - n;
            ++n2;
        }
    }

    public void mult(int n) {
        int n2 = 0;
        while (true) {
            int[] nArray = this.coeffs;
            if (n2 >= this.coeffs.length) break;
            nArray[n2] = nArray[n2] * n;
            ++n2;
        }
    }

    public void mult3(int n) {
        int n2 = 0;
        while (true) {
            int n3;
            int[] nArray = this.coeffs;
            if (n2 >= this.coeffs.length) break;
            nArray[n2] = n3 = nArray[n2] * 3;
            nArray[n2] = n3 % n;
            ++n2;
        }
    }

    public void div(int n) {
        int n2 = (n + 1) / 2;
        int n3 = 0;
        while (true) {
            int[] nArray = this.coeffs;
            if (n3 >= this.coeffs.length) break;
            int n4 = nArray[n3];
            int n5 = n4 > 0 ? n2 : -n2;
            nArray[n3] = n4 += n5;
            nArray[n3] = n4 / n;
            ++n3;
        }
    }

    public void mod3() {
        int n = 0;
        while (true) {
            int n2;
            int[] nArray = this.coeffs;
            if (n >= this.coeffs.length) break;
            nArray[n] = n2 = nArray[n] % 3;
            if (n2 > 1) {
                nArray[n] = n2 - 3;
            }
            if ((n2 = nArray[n]) < -1) {
                nArray[n] = n2 + 3;
            }
            ++n;
        }
    }

    public void modPositive(int n) {
        IntegerPolynomial integerPolynomial = this;
        integerPolynomial.mod(n);
        integerPolynomial.ensurePositive(n);
    }

    public void modCenter(int n) {
        this.mod(n);
        block0: for (int k = 0; k < this.coeffs.length; ++k) {
            int n2;
            int n3;
            int[] nArray;
            while (true) {
                nArray = this.coeffs;
                n3 = this.coeffs[k];
                n2 = n / 2;
                if (n3 >= n2) break;
                nArray[k] = n3 + n;
            }
            while (true) {
                nArray = this.coeffs;
                n3 = this.coeffs[k];
                if (n3 < n2) continue block0;
                nArray[k] = n3 - n;
            }
        }
    }

    public void mod(int n) {
        int n2 = 0;
        while (true) {
            int[] nArray = this.coeffs;
            if (n2 >= this.coeffs.length) break;
            nArray[n2] = nArray[n2] % n;
            ++n2;
        }
    }

    public void ensurePositive(int n) {
        block0: for (int k = 0; k < this.coeffs.length; ++k) {
            while (true) {
                int[] nArray = this.coeffs;
                int n2 = this.coeffs[k];
                if (n2 >= 0) continue block0;
                nArray[k] = n2 + n;
            }
        }
    }

    public long centeredNormSq(int n) {
        IntegerPolynomial integerPolynomial = this;
        int n2 = integerPolynomial.coeffs.length;
        IntegerPolynomial integerPolynomial2 = (IntegerPolynomial)integerPolynomial.clone();
        integerPolynomial2.shiftGap(n);
        long l = 0L;
        long l2 = 0L;
        n = 0;
        while (true) {
            int[] nArray = integerPolynomial2.coeffs;
            if (n == integerPolynomial2.coeffs.length) break;
            int n3 = nArray[n];
            l += (long)n3;
            l2 += (long)(n3 * n3);
            ++n;
        }
        long l3 = l;
        return l2 - l3 * l3 / (long)n2;
    }

    public void shiftGap(int n) {
        IntegerPolynomial integerPolynomial = this;
        integerPolynomial.modCenter(n);
        int[] nArray = Arrays.clone(integerPolynomial.coeffs);
        integerPolynomial.sort(nArray);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length - 1) {
            int n5 = n4 + 1;
            int n6 = nArray[n5] - (n4 = nArray[n4]);
            if (n6 > n2) {
                n3 = n4;
                n2 = n6;
            }
            n4 = n5;
        }
        n4 = nArray[nArray.length - 1];
        int n7 = nArray[0];
        if (n - n4 + n7 > n2) {
            n = (n4 + n7) / 2;
        } else {
            int n8 = n;
            n = n2 / 2 + n3;
            n = n8 / 2 + n;
        }
        this.sub(n);
    }

    public void center0(int n) {
        block0: for (int k = 0; k < this.coeffs.length; ++k) {
            int n2;
            int[] nArray;
            while (true) {
                nArray = this.coeffs;
                n2 = this.coeffs[k];
                if (n2 >= -n / 2) break;
                nArray[k] = n2 + n;
            }
            while (true) {
                nArray = this.coeffs;
                n2 = this.coeffs[k];
                if (n2 <= n / 2) continue block0;
                nArray[k] = n2 - n;
            }
        }
    }

    public int sumCoeffs() {
        int n = 0;
        int n2 = 0;
        while (true) {
            int[] nArray = this.coeffs;
            if (n2 >= this.coeffs.length) break;
            n += nArray[n2];
            ++n2;
        }
        return n;
    }

    public boolean equalsOne() {
        int[] nArray;
        int n = 1;
        while (true) {
            nArray = this.coeffs;
            if (n >= this.coeffs.length) break;
            if (nArray[n] != 0) {
                return false;
            }
            ++n;
        }
        return nArray[0] == 1;
    }

    public int count(int n) {
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int[] nArray = this.coeffs;
            if (n3 == this.coeffs.length) break;
            if (nArray[n3] == n) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public void rotate1() {
        int n = this.coeffs[this.coeffs.length - 1];
        for (int k = this.coeffs.length - 1; k > 0; --k) {
            this.coeffs[k] = this.coeffs[k - 1];
        }
        this.coeffs[0] = n;
    }

    public void clear() {
        int n = 0;
        while (true) {
            int[] nArray = this.coeffs;
            if (n >= this.coeffs.length) break;
            nArray[n] = 0;
            ++n;
        }
    }

    @Override
    public IntegerPolynomial toIntegerPolynomial() {
        return (IntegerPolynomial)this.clone();
    }

    public Object clone() {
        return new IntegerPolynomial((int[])this.coeffs.clone());
    }

    public boolean equals(Object object) {
        if (object instanceof IntegerPolynomial) {
            return Arrays.areEqual(this.coeffs, ((IntegerPolynomial)object).coeffs);
        }
        return false;
    }

    public class PrimeGenerator {
        private int index = 0;
        private BigInteger prime;

        private PrimeGenerator() {
        }

        public /* synthetic */ PrimeGenerator(1 var2_2) {
            this();
        }

        public BigInteger nextPrime() {
            if (this.index < BIGINT_PRIMES.size()) {
                int n = this.index;
                this.index = n + 1;
                this.prime = (BigInteger)BIGINT_PRIMES.get(n);
            } else {
                this.prime = this.prime.nextProbablePrime();
            }
            return this.prime;
        }
    }

    public class CombineTask
    implements Callable<ModularResultant> {
        private ModularResultant modRes1;
        private ModularResultant modRes2;

        private CombineTask(ModularResultant modularResultant, ModularResultant modularResultant2) {
            this.modRes1 = modularResultant;
            this.modRes2 = modularResultant2;
        }

        public /* synthetic */ CombineTask(ModularResultant modularResultant, ModularResultant modularResultant2, 1 var4_4) {
            this(modularResultant, modularResultant2);
        }

        @Override
        public ModularResultant call() {
            return ModularResultant.combineRho(this.modRes1, this.modRes2);
        }
    }

    public class ModResultantTask
    implements Callable<ModularResultant> {
        private int modulus;

        private ModResultantTask(int n) {
            this.modulus = n;
        }

        public /* synthetic */ ModResultantTask(int n, 1 var3_3) {
            this(n);
        }

        @Override
        public ModularResultant call() {
            return IntegerPolynomial.this.resultant(this.modulus);
        }
    }
}

