/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.Selector;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Store;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.NoSuchStoreException;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509StoreParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509StoreSpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509Util;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Collection;

public class X509Store
implements Store {
    private Provider _provider;
    private X509StoreSpi _spi;

    public static X509Store getInstance(String string, X509StoreParameters x509StoreParameters) {
        try {
            return X509Store.createStore(X509Util.getImplementation("X509Store", string), x509StoreParameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchStoreException(noSuchAlgorithmException.getMessage());
        }
    }

    public static X509Store getInstance(String string, X509StoreParameters x509StoreParameters, String string2) {
        return X509Store.getInstance(string, x509StoreParameters, X509Util.getProvider(string2));
    }

    public static X509Store getInstance(String string, X509StoreParameters x509StoreParameters, Provider provider) {
        try {
            return X509Store.createStore(X509Util.getImplementation("X509Store", string, provider), x509StoreParameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchStoreException(noSuchAlgorithmException.getMessage());
        }
    }

    private static X509Store createStore(X509Util.Implementation implementation, X509StoreParameters x509StoreParameters) {
        X509StoreSpi x509StoreSpi = (X509StoreSpi)implementation.getEngine();
        x509StoreSpi.engineInit(x509StoreParameters);
        return new X509Store(implementation.getProvider(), x509StoreSpi);
    }

    private X509Store(Provider provider, X509StoreSpi x509StoreSpi) {
        this._provider = provider;
        this._spi = x509StoreSpi;
    }

    public Provider getProvider() {
        return this._provider;
    }

    public Collection getMatches(Selector selector) {
        return this._spi.engineGetMatches(selector);
    }
}

