/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.managers;

import android.content.Context;
import android.content.res.Resources;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import vn.kalapa.R;
import vn.kalapa.ekyc.handlers.GetAllLanguageHandler;
import vn.kalapa.ekyc.models.KalapaAllLanguageModel;
import vn.kalapa.ekyc.models.LanguageModelContent;
import vn.kalapa.ekyc.models.LanguageModelData;
import vn.kalapa.ekyc.utils.Helpers;

@SourceDebugExtension(value={"SMAP\nKLPLanguageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KLPLanguageManager.kt\nvn/kalapa/ekyc/managers/KLPLanguageManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,101:1\n8676#2,2:102\n9358#2,4:104\n13579#2,2:110\n13579#2,2:112\n215#3,2:108\n*S KotlinDebug\n*F\n+ 1 KLPLanguageManager.kt\nvn/kalapa/ekyc/managers/KLPLanguageManager\n*L\n33#1:102,2\n33#1:104,4\n52#1:110,2\n63#1:112,2\n38#1:108,2\n*E\n"})
public final class KLPLanguageManager {
    @NotNull
    public static final KLPLanguageManager INSTANCE = new KLPLanguageManager();
    @NotNull
    private static final HashMap<String, HashMap<String, String>> languageMap = new HashMap();
    private static KLPLanguage language;

    private KLPLanguageManager() {
    }

    private final void loadResourcesMap(Context object) {
        LinkedHashMap<Object, Object> linkedHashMap;
        Resources resources = object.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        String string2 = object.getPackageName();
        resources.getIdentifier("string", "values", string2);
        Field[] fieldArray = R.string.class.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"fields");
        int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)fieldArray.length), (int)16);
        LinkedHashMap<Object, Object> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<Object, Object>(n);
        for (Field field : fieldArray) {
            int n2 = field.getInt(null);
            Pair pair = TuplesKt.to((Object)field.getName(), (Object)resources.getString(n2));
            Object object2 = pair.getFirst();
            linkedHashMap2.put(object2, pair.getSecond());
        }
        for (Map.Entry entry : linkedHashMap2.entrySet()) {
            String string3 = (String)entry.getKey();
            String string4 = (String)entry.getValue();
            Helpers.Companion.printLog("Resources: " + string3 + ": " + string4);
        }
    }

    private final void setDictionary(KLPLanguage kLPLanguage, Map<String, String> ... mapArray) {
        HashMap<String, String> hashMap = languageMap.get(kLPLanguage.name());
        if (hashMap == null) {
            HashMap hashMap2;
            hashMap = hashMap2;
            hashMap2 = new HashMap();
        }
        for (Map<String, String> map : mapArray) {
            for (String string2 : map.keySet()) {
                String string3 = map.get(string2);
                if (string3 == null) {
                    string3 = string2;
                }
                hashMap.put(string2, string3);
            }
        }
        languageMap.put(kLPLanguage.name(), hashMap);
    }

    @NotNull
    public final String get(@NotNull String object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"key");
        Object object2 = language;
        if (object2 != null) {
            HashMap<String, HashMap<String, String>> hashMap = languageMap;
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"language");
                object2 = null;
            }
            if ((object2 = (object2 = hashMap.get(((Enum)object2).name())) != null ? (String)((HashMap)object2).get(object) : null) != null) {
                object = object2;
            }
            return object;
        }
        return object;
    }

    public final void pullLanguage(@NotNull String object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"baseURL");
        Helpers.Companion companion = Helpers.Companion;
        companion.printLog(languageModelDataArray, "Start Pulling Language");
        object = (String)new GetAllLanguageHandler().execute(new String[]{object}).get();
        companion.printLog(languageModelDataArray, "End Pulling Language - " + (String)object);
        if (!(object == null || object.length() == 0) && !Intrinsics.areEqual((Object)object, (Object)"-1")) {
            String string2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"languageJsonBody");
            LanguageModelData[] languageModelDataArray = KalapaAllLanguageModel.Companion.fromJson(string2);
            if (languageModelDataArray.getError() != null) {
                object = languageModelDataArray.getError().getCode();
                int n = 200;
                if (object != null && (Integer)object == n && languageModelDataArray.getData() != null) {
                    for (LanguageModelData languageModelData : languageModelDataArray.getData()) {
                        Object object2 = languageModelData.getContent();
                        if (!(object2 != null && (object2 = ((LanguageModelContent)object2).getSDK()) != null && object2.isEmpty() ^ true)) continue;
                        INSTANCE.setDictionary(KLPLanguage.Companion.fromCountryCode(languageModelData.getCode()), languageModelData.getContent().getSDK(), languageModelData.getContent().getAPP_DEMO());
                    }
                }
            }
        }
    }

    @NotNull
    public final KLPLanguageManager setLanguage(@NotNull KLPLanguage kLPLanguage) {
        KLPLanguage kLPLanguage2 = kLPLanguage;
        Intrinsics.checkNotNullParameter((Object)((Object)kLPLanguage2), (String)"language");
        language = kLPLanguage2;
        return this;
    }

    @NotNull
    public final KLPLanguageManager setLanguage(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"language");
        Helpers.Companion companion = Helpers.Companion;
        Object[] objectArray = new Object[1];
        int n = 0;
        Object object = language;
        if (object != null) {
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"language");
                object = null;
            }
        } else {
            object = "null";
        }
        KLPLanguageManager kLPLanguageManager = companion2;
        KLPLanguage.Companion companion2 = KLPLanguage.Companion;
        objectArray[n] = "setLanguage from " + (Object)object + " to " + companion2.fromCountryCode(string2);
        companion.printLog(objectArray);
        language = companion2.fromCountryCode(string2);
        return kLPLanguageManager;
    }

    public static enum KLPLanguage {
        ENGLISH,
        VIETNAMESE,
        KOREAN;

        @NotNull
        public static final Companion Companion = new Companion(null);

        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }

            @NotNull
            public final KLPLanguage fromCountryCode(@NotNull String string2) {
                KLPLanguage kLPLanguage;
                block3: {
                    block2: {
                        block0: {
                            block1: {
                                String string3 = string2;
                                Intrinsics.checkNotNullParameter((Object)string3, (String)"code");
                                int n = string3.hashCode();
                                if (n == 3241) break block0;
                                if (n == 3428) break block1;
                                if (n != 3763 || !string2.equals("vi")) break block2;
                                kLPLanguage = VIETNAMESE;
                                break block3;
                            }
                            if (!string2.equals("ko")) break block2;
                            kLPLanguage = KOREAN;
                            break block3;
                        }
                        string2.equals("en");
                    }
                    kLPLanguage = ENGLISH;
                }
                return kLPLanguage;
            }
        }
    }
}

