/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;

public class ASN1EncodableVector {
    public static final ASN1Encodable[] EMPTY_ELEMENTS = new ASN1Encodable[0];
    private static final int DEFAULT_CAPACITY = 10;
    private ASN1Encodable[] elements;
    private int elementCount;
    private boolean copyOnWrite;

    public ASN1EncodableVector() {
        this(10);
    }

    public ASN1EncodableVector(int n) {
        if (n >= 0) {
            ASN1Encodable[] aSN1EncodableArray = n == 0 ? EMPTY_ELEMENTS : new ASN1Encodable[n];
            ASN1EncodableVector aSN1EncodableVector = this;
            aSN1EncodableVector.elements = aSN1EncodableArray;
            aSN1EncodableVector.elementCount = 0;
            aSN1EncodableVector.copyOnWrite = false;
            return;
        }
        throw new IllegalArgumentException("'initialCapacity' must not be negative");
    }

    private void reallocate(int n) {
        int n2 = n;
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[Math.max(this.elements.length, n2 + (n2 >> 1))];
        int n3 = this.elementCount;
        System.arraycopy(this.elements, 0, aSN1EncodableArray, 0, n3);
        this.elements = aSN1EncodableArray;
        this.copyOnWrite = false;
    }

    public static ASN1Encodable[] cloneElements(ASN1Encodable[] aSN1EncodableArray) {
        return aSN1EncodableArray.length < 1 ? EMPTY_ELEMENTS : (ASN1Encodable[])aSN1EncodableArray.clone();
    }

    public void add(ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            ASN1EncodableVector aSN1EncodableVector = this;
            int n = aSN1EncodableVector.elementCount + 1;
            int n2 = aSN1EncodableVector.elements.length;
            if (n > n2 | this.copyOnWrite) {
                this.reallocate(n);
            }
            this.elements[this.elementCount] = aSN1Encodable;
            this.elementCount = n;
            return;
        }
        throw new NullPointerException("'element' cannot be null");
    }

    public void addAll(ASN1EncodableVector aSN1EncodableVector) {
        if (aSN1EncodableVector != null) {
            ASN1Encodable aSN1Encodable;
            int n = aSN1EncodableVector.size();
            if (n < 1) {
                return;
            }
            ASN1EncodableVector aSN1EncodableVector2 = this;
            int n2 = aSN1EncodableVector2.elementCount + n;
            int n3 = aSN1EncodableVector2.elements.length;
            if (n2 > n3 | this.copyOnWrite) {
                this.reallocate(n2);
            }
            n3 = 0;
            while ((aSN1Encodable = aSN1EncodableVector.get(n3)) != null) {
                this.elements[this.elementCount + n3] = aSN1Encodable;
                if (++n3 < n) continue;
                this.elementCount = n2;
                return;
            }
            throw new NullPointerException("'other' elements cannot be null");
        }
        throw new NullPointerException("'other' cannot be null");
    }

    public ASN1Encodable get(int n) {
        if (n < this.elementCount) {
            return this.elements[n];
        }
        throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
    }

    public int size() {
        return this.elementCount;
    }

    public ASN1Encodable[] copyElements() {
        int n = this.elementCount;
        if (n == 0) {
            return EMPTY_ELEMENTS;
        }
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[n];
        System.arraycopy(this.elements, 0, aSN1EncodableArray, 0, n);
        return aSN1EncodableArray;
    }

    public ASN1Encodable[] takeElements() {
        int n = aSN1EncodableArray2.elementCount;
        if (n == 0) {
            return EMPTY_ELEMENTS;
        }
        ASN1Encodable[] aSN1EncodableArray = aSN1EncodableArray2.elements;
        if (aSN1EncodableArray2.elements.length == n) {
            aSN1EncodableArray2.copyOnWrite = true;
            return aSN1EncodableArray;
        }
        ASN1Encodable[] aSN1EncodableArray2 = new ASN1Encodable[n];
        System.arraycopy(aSN1EncodableArray, 0, aSN1EncodableArray2, 0, n);
        return aSN1EncodableArray2;
    }
}

