/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.crmf;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class EncryptedValue
extends ASN1Object {
    private AlgorithmIdentifier intendedAlg;
    private AlgorithmIdentifier symmAlg;
    private DERBitString encSymmKey;
    private AlgorithmIdentifier keyAlg;
    private ASN1OctetString valueHint;
    private DERBitString encValue;

    private EncryptedValue(ASN1Sequence aSN1Sequence) {
        int n = 0;
        while (aSN1Sequence.getObjectAt(n) instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(n);
            switch (aSN1TaggedObject.getTagNo()) {
                default: {
                    throw new IllegalArgumentException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.b.a(aSN1TaggedObject, b.a("Unknown tag encountered: ")));
                }
                case 4: {
                    this.valueHint = ASN1OctetString.getInstance(aSN1TaggedObject, false);
                    break;
                }
                case 3: {
                    this.keyAlg = AlgorithmIdentifier.getInstance(aSN1TaggedObject, false);
                    break;
                }
                case 2: {
                    this.encSymmKey = DERBitString.getInstance(aSN1TaggedObject, false);
                    break;
                }
                case 1: {
                    this.symmAlg = AlgorithmIdentifier.getInstance(aSN1TaggedObject, false);
                    break;
                }
                case 0: {
                    this.intendedAlg = AlgorithmIdentifier.getInstance(aSN1TaggedObject, false);
                }
            }
            ++n;
        }
        this.encValue = DERBitString.getInstance(aSN1Sequence.getObjectAt(n));
    }

    public static EncryptedValue getInstance(Object object) {
        if (object instanceof EncryptedValue) {
            return (EncryptedValue)object;
        }
        if (object != null) {
            return new EncryptedValue(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public EncryptedValue(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, DERBitString dERBitString, AlgorithmIdentifier algorithmIdentifier3, ASN1OctetString aSN1OctetString, DERBitString dERBitString2) {
        if (dERBitString2 != null) {
            EncryptedValue encryptedValue = this;
            encryptedValue.intendedAlg = algorithmIdentifier;
            encryptedValue.symmAlg = algorithmIdentifier2;
            encryptedValue.encSymmKey = dERBitString;
            encryptedValue.keyAlg = algorithmIdentifier3;
            encryptedValue.valueHint = aSN1OctetString;
            encryptedValue.encValue = dERBitString2;
            return;
        }
        throw new IllegalArgumentException("'encValue' cannot be null");
    }

    private void addOptional(ASN1EncodableVector aSN1EncodableVector, int n, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            DERTaggedObject dERTaggedObject;
            ASN1Object aSN1Object = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(false, n, aSN1Encodable);
            aSN1EncodableVector.add(aSN1Object);
        }
    }

    public AlgorithmIdentifier getIntendedAlg() {
        return this.intendedAlg;
    }

    public AlgorithmIdentifier getSymmAlg() {
        return this.symmAlg;
    }

    public DERBitString getEncSymmKey() {
        return this.encSymmKey;
    }

    public AlgorithmIdentifier getKeyAlg() {
        return this.keyAlg;
    }

    public ASN1OctetString getValueHint() {
        return this.valueHint;
    }

    public DERBitString getEncValue() {
        return this.encValue;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        EncryptedValue encryptedValue = this;
        EncryptedValue encryptedValue2 = this;
        EncryptedValue encryptedValue3 = this;
        EncryptedValue encryptedValue4 = this;
        EncryptedValue encryptedValue5 = this;
        aSN1EncodableVector2(6);
        encryptedValue5.addOptional(aSN1EncodableVector2, 0, this.intendedAlg);
        encryptedValue4.addOptional(aSN1EncodableVector2, 1, encryptedValue5.symmAlg);
        encryptedValue3.addOptional(aSN1EncodableVector2, 2, encryptedValue4.encSymmKey);
        encryptedValue2.addOptional(aSN1EncodableVector2, 3, encryptedValue3.keyAlg);
        encryptedValue.addOptional(aSN1EncodableVector2, 4, encryptedValue2.valueHint);
        aSN1EncodableVector.add(encryptedValue.encValue);
        return new DERSequence(aSN1EncodableVector2);
    }
}

