/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Choice;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.PKIStatusInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.ContentInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ess.ESSCertID;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ocsp.CertID;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ocsp.CertStatus;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ocsp.OCSPResponse;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.smime.SMIMECapabilities;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Certificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.CertificateList;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;

public class CertEtcToken
extends ASN1Object
implements ASN1Choice {
    public static final int TAG_CERTIFICATE = 0;
    public static final int TAG_ESSCERTID = 1;
    public static final int TAG_PKISTATUS = 2;
    public static final int TAG_ASSERTION = 3;
    public static final int TAG_CRL = 4;
    public static final int TAG_OCSPCERTSTATUS = 5;
    public static final int TAG_OCSPCERTID = 6;
    public static final int TAG_OCSPRESPONSE = 7;
    public static final int TAG_CAPABILITIES = 8;
    private static final boolean[] explicit = new boolean[]{false, true, false, true, false, true, false, false, true};
    private int tagNo;
    private ASN1Encodable value;
    private Extension extension;

    public CertEtcToken(int n, ASN1Encodable aSN1Encodable) {
        this.tagNo = n;
        this.value = aSN1Encodable;
    }

    public CertEtcToken(Extension extension) {
        this.tagNo = -1;
        this.extension = extension;
    }

    private CertEtcToken(ASN1TaggedObject aSN1TaggedObject) {
        this.tagNo = aSN1TaggedObject.getTagNo();
        switch (this.tagNo) {
            default: {
                throw new IllegalArgumentException(b.a("Unknown tag: ").append(this.tagNo).toString());
            }
            case 8: {
                this.value = SMIMECapabilities.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 7: {
                this.value = OCSPResponse.getInstance(aSN1TaggedObject, false);
                break;
            }
            case 6: {
                this.value = CertID.getInstance(aSN1TaggedObject, false);
                break;
            }
            case 5: {
                this.value = CertStatus.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 4: {
                this.value = CertificateList.getInstance(aSN1TaggedObject, false);
                break;
            }
            case 3: {
                this.value = ContentInfo.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 2: {
                this.value = PKIStatusInfo.getInstance(aSN1TaggedObject, false);
                break;
            }
            case 1: {
                this.value = ESSCertID.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 0: {
                this.value = Certificate.getInstance(aSN1TaggedObject, false);
            }
        }
    }

    public static CertEtcToken getInstance(Object object) {
        if (object instanceof CertEtcToken) {
            return (CertEtcToken)object;
        }
        if (object instanceof ASN1TaggedObject) {
            return new CertEtcToken((ASN1TaggedObject)object);
        }
        if (object != null) {
            return new CertEtcToken(Extension.getInstance(object));
        }
        return null;
    }

    public static CertEtcToken[] arrayFromSequence(ASN1Sequence aSN1Sequence) {
        int n = aSN1Sequence.size();
        CertEtcToken[] certEtcTokenArray = new CertEtcToken[n];
        for (int k = 0; k != n; ++k) {
            certEtcTokenArray[k] = CertEtcToken.getInstance(aSN1Sequence.getObjectAt(k));
        }
        return certEtcTokenArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        Extension extension = this.extension;
        if (extension == null) {
            int n = this.tagNo;
            boolean bl = explicit[n];
            ASN1Encodable aSN1Encodable = this.value;
            return new DERTaggedObject(bl, n, aSN1Encodable);
        }
        return extension.toASN1Primitive();
    }

    public int getTagNo() {
        return this.tagNo;
    }

    public ASN1Encodable getValue() {
        return this.value;
    }

    public Extension getExtension() {
        return this.extension;
    }

    public String toString() {
        return b.a("CertEtcToken {\n").append(this.value).append("}\n").toString();
    }
}

