/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1UTCTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.TBSCertificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Time;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Name;

public class V1TBSCertificateGenerator {
    public DERTaggedObject version;
    public ASN1Integer serialNumber;
    public AlgorithmIdentifier signature;
    public X500Name issuer;
    public Time startDate;
    public Time endDate;
    public X500Name subject;
    public SubjectPublicKeyInfo subjectPublicKeyInfo;

    public V1TBSCertificateGenerator() {
        ASN1Integer aSN1Integer;
        DERTaggedObject dERTaggedObject;
        DERTaggedObject dERTaggedObject2 = dERTaggedObject;
        ASN1Integer aSN1Integer2 = aSN1Integer;
        aSN1Integer = new ASN1Integer(0L);
        dERTaggedObject = new DERTaggedObject(true, 0, aSN1Integer2);
        v2.version = dERTaggedObject2;
    }

    public void setSerialNumber(ASN1Integer aSN1Integer) {
        this.serialNumber = aSN1Integer;
    }

    public void setSignature(AlgorithmIdentifier algorithmIdentifier) {
        this.signature = algorithmIdentifier;
    }

    public void setIssuer(X509Name x509Name) {
        this.issuer = X500Name.getInstance(x509Name.toASN1Primitive());
    }

    public void setIssuer(X500Name x500Name) {
        this.issuer = x500Name;
    }

    public void setStartDate(Time time) {
        this.startDate = time;
    }

    public void setStartDate(ASN1UTCTime aSN1UTCTime) {
        Time time;
        V1TBSCertificateGenerator v1TBSCertificateGenerator = time2;
        Time time2 = time;
        time = new Time(aSN1UTCTime);
        v1TBSCertificateGenerator.startDate = time2;
    }

    public void setEndDate(Time time) {
        this.endDate = time;
    }

    public void setEndDate(ASN1UTCTime aSN1UTCTime) {
        Time time;
        V1TBSCertificateGenerator v1TBSCertificateGenerator = time2;
        Time time2 = time;
        time = new Time(aSN1UTCTime);
        v1TBSCertificateGenerator.endDate = time2;
    }

    public void setSubject(X509Name x509Name) {
        this.subject = X500Name.getInstance(x509Name.toASN1Primitive());
    }

    public void setSubject(X500Name x500Name) {
        this.subject = x500Name;
    }

    public void setSubjectPublicKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
    }

    public TBSCertificate generateTBSCertificate() {
        if (this.serialNumber != null && this.signature != null && this.issuer != null && this.startDate != null && this.endDate != null && this.subject != null && this.subjectPublicKeyInfo != null) {
            ASN1EncodableVector aSN1EncodableVector;
            ASN1EncodableVector aSN1EncodableVector2;
            ASN1EncodableVector aSN1EncodableVector3;
            ASN1EncodableVector aSN1EncodableVector4 = aSN1EncodableVector3 = aSN1EncodableVector2;
            aSN1EncodableVector3(6);
            aSN1EncodableVector3.add(this.serialNumber);
            aSN1EncodableVector3.add(this.signature);
            aSN1EncodableVector4.add(this.issuer);
            ASN1EncodableVector aSN1EncodableVector5 = aSN1EncodableVector;
            aSN1EncodableVector5(2);
            aSN1EncodableVector5.add(this.startDate);
            aSN1EncodableVector.add(this.endDate);
            aSN1EncodableVector4.add(new DERSequence(aSN1EncodableVector5));
            aSN1EncodableVector3.add(this.subject);
            aSN1EncodableVector2.add(this.subjectPublicKeyInfo);
            return TBSCertificate.getInstance(new DERSequence(aSN1EncodableVector3));
        }
        throw new IllegalStateException("not all mandatory fields set in V1 TBScertificate generator");
    }
}

