/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.GeneralDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;

public class RIPEMD320Digest
extends GeneralDigest {
    private static final int DIGEST_LENGTH = 40;
    private int H0;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int H5;
    private int H6;
    private int H7;
    private int H8;
    private int H9;
    private int[] X;
    private int xOff;

    public RIPEMD320Digest() {
        RIPEMD320Digest rIPEMD320Digest = this;
        rIPEMD320Digest.X = new int[16];
        rIPEMD320Digest.reset();
    }

    public RIPEMD320Digest(RIPEMD320Digest rIPEMD320Digest) {
        super(rIPEMD320Digest);
        this.X = new int[16];
        this.doCopy(rIPEMD320Digest);
    }

    private void doCopy(RIPEMD320Digest rIPEMD320Digest) {
        RIPEMD320Digest rIPEMD320Digest2 = object;
        RIPEMD320Digest rIPEMD320Digest3 = rIPEMD320Digest;
        super.copyIn(rIPEMD320Digest);
        ((RIPEMD320Digest)object).H0 = rIPEMD320Digest.H0;
        ((RIPEMD320Digest)object).H1 = rIPEMD320Digest.H1;
        ((RIPEMD320Digest)object).H2 = rIPEMD320Digest.H2;
        ((RIPEMD320Digest)object).H3 = rIPEMD320Digest.H3;
        ((RIPEMD320Digest)object).H4 = rIPEMD320Digest.H4;
        ((RIPEMD320Digest)object).H5 = rIPEMD320Digest.H5;
        ((RIPEMD320Digest)object).H6 = rIPEMD320Digest.H6;
        ((RIPEMD320Digest)object).H7 = rIPEMD320Digest.H7;
        ((RIPEMD320Digest)object).H8 = rIPEMD320Digest.H8;
        ((RIPEMD320Digest)object).H9 = rIPEMD320Digest.H9;
        Object object = ((RIPEMD320Digest)object).X;
        int n = rIPEMD320Digest3.X.length;
        System.arraycopy(rIPEMD320Digest3.X, 0, object, 0, n);
        rIPEMD320Digest2.xOff = rIPEMD320Digest3.xOff;
    }

    private void unpackWord(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        int n3 = n2 + 1;
        byArray[n3] = (byte)(n >>> 8);
        n3 = n2 + 2;
        byArray[n3] = (byte)(n >>> 16);
        n3 = n2 + 3;
        byArray[n3] = (byte)(n >>> 24);
    }

    private int RL(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    private int f1(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private int f2(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    private int f3(int n, int n2, int n3) {
        return (n | ~n2) ^ n3;
    }

    private int f4(int n, int n2, int n3) {
        return n & n3 | n2 & ~n3;
    }

    private int f5(int n, int n2, int n3) {
        return n ^ (n2 | ~n3);
    }

    @Override
    public String getAlgorithmName() {
        return "RIPEMD320";
    }

    @Override
    public int getDigestSize() {
        return 40;
    }

    @Override
    public void processWord(byte[] byArray, int n) {
        int n2;
        RIPEMD320Digest rIPEMD320Digest = this;
        int[] nArray = rIPEMD320Digest.X;
        int n3 = rIPEMD320Digest.xOff;
        this.xOff = n2 = n3 + 1;
        nArray[n3] = byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
        if (n2 == 16) {
            this.processBlock();
        }
    }

    @Override
    public void processLength(long l) {
        if (((RIPEMD320Digest)object).xOff > 14) {
            ((RIPEMD320Digest)object).processBlock();
        }
        Object object = ((RIPEMD320Digest)object).X;
        object[14] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        ((RIPEMD320Digest)object).X[15] = (int)(l >>> 32);
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        RIPEMD320Digest rIPEMD320Digest = this;
        rIPEMD320Digest.finish();
        rIPEMD320Digest.unpackWord(rIPEMD320Digest.H0, byArray, n);
        rIPEMD320Digest.unpackWord(rIPEMD320Digest.H1, byArray, n + 4);
        rIPEMD320Digest.unpackWord(rIPEMD320Digest.H2, byArray, n + 8);
        rIPEMD320Digest.unpackWord(rIPEMD320Digest.H3, byArray, n + 12);
        rIPEMD320Digest.unpackWord(rIPEMD320Digest.H4, byArray, n + 16);
        rIPEMD320Digest.unpackWord(rIPEMD320Digest.H5, byArray, n + 20);
        rIPEMD320Digest.unpackWord(rIPEMD320Digest.H6, byArray, n + 24);
        rIPEMD320Digest.unpackWord(rIPEMD320Digest.H7, byArray, n + 28);
        rIPEMD320Digest.unpackWord(rIPEMD320Digest.H8, byArray, n + 32);
        rIPEMD320Digest.unpackWord(rIPEMD320Digest.H9, byArray, n + 36);
        rIPEMD320Digest.reset();
        return 40;
    }

    @Override
    public void reset() {
        super.reset();
        this.H0 = 1732584193;
        this.H1 = -271733879;
        this.H2 = -1732584194;
        this.H3 = 271733878;
        this.H4 = -1009589776;
        this.H5 = 1985229328;
        this.H6 = -19088744;
        this.H7 = -1985229329;
        this.H8 = 19088743;
        this.H9 = 1009589775;
        this.xOff = 0;
        int n = 0;
        while (true) {
            int[] nArray = this.X;
            if (n == this.X.length) break;
            nArray[n] = 0;
            ++n;
        }
    }

    @Override
    public void processBlock() {
        RIPEMD320Digest rIPEMD320Digest = this;
        int n = rIPEMD320Digest.H0;
        int n2 = rIPEMD320Digest.H1;
        int n3 = rIPEMD320Digest.H2;
        int n4 = rIPEMD320Digest.H3;
        int n5 = rIPEMD320Digest.H4;
        int n6 = n5;
        RIPEMD320Digest rIPEMD320Digest2 = this;
        int n7 = n3;
        int n8 = n;
        RIPEMD320Digest rIPEMD320Digest3 = this;
        n = rIPEMD320Digest3.H5;
        int n9 = rIPEMD320Digest3.H6;
        int n10 = rIPEMD320Digest3.H7;
        int n11 = rIPEMD320Digest3.H8;
        int n12 = rIPEMD320Digest3.H9;
        n3 = this.RL(n8 + this.f1(n2, n3, n4) + this.X[0], 11) + n6;
        n6 = rIPEMD320Digest2.RL(n7, 10);
        int n13 = rIPEMD320Digest.RL(n5 + rIPEMD320Digest2.f1(n3, n2, n6) + this.X[1], 14) + n4;
        int n14 = rIPEMD320Digest.RL(n2, 10);
        n2 = n14;
        RIPEMD320Digest rIPEMD320Digest4 = this;
        RIPEMD320Digest rIPEMD320Digest5 = this;
        int n15 = n3;
        n3 = this.RL(n4 + this.f1(n13, n3, n2) + this.X[2], 15) + n6;
        n4 = rIPEMD320Digest5.RL(n15, 10);
        n2 = this.RL(n6 + rIPEMD320Digest5.f1(n3, n13, n4) + this.X[3], 12) + n2;
        n6 = rIPEMD320Digest4.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n14 + rIPEMD320Digest4.f1(n2, n3, n6) + this.X[4], 5) + n4;
        int n16 = rIPEMD320Digest.RL(n3, 10);
        n3 = n16;
        RIPEMD320Digest rIPEMD320Digest6 = this;
        RIPEMD320Digest rIPEMD320Digest7 = this;
        int n17 = n2;
        n2 = this.RL(n4 + this.f1(n13, n2, n3) + this.X[5], 8) + n6;
        n4 = rIPEMD320Digest7.RL(n17, 10);
        n3 = this.RL(n6 + rIPEMD320Digest7.f1(n2, n13, n4) + this.X[6], 7) + n3;
        n6 = rIPEMD320Digest6.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n16 + rIPEMD320Digest6.f1(n3, n2, n6) + this.X[7], 9) + n4;
        int n18 = rIPEMD320Digest.RL(n2, 10);
        n2 = n18;
        RIPEMD320Digest rIPEMD320Digest8 = this;
        RIPEMD320Digest rIPEMD320Digest9 = this;
        int n19 = n3;
        n3 = this.RL(n4 + this.f1(n13, n3, n2) + this.X[8], 11) + n6;
        n4 = rIPEMD320Digest9.RL(n19, 10);
        n2 = this.RL(n6 + rIPEMD320Digest9.f1(n3, n13, n4) + this.X[9], 13) + n2;
        n6 = rIPEMD320Digest8.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n18 + rIPEMD320Digest8.f1(n2, n3, n6) + this.X[10], 14) + n4;
        int n20 = rIPEMD320Digest.RL(n3, 10);
        n3 = n20;
        RIPEMD320Digest rIPEMD320Digest10 = this;
        RIPEMD320Digest rIPEMD320Digest11 = this;
        int n21 = n2;
        n2 = this.RL(n4 + this.f1(n13, n2, n3) + this.X[11], 15) + n6;
        n4 = rIPEMD320Digest11.RL(n21, 10);
        n3 = this.RL(n6 + rIPEMD320Digest11.f1(n2, n13, n4) + this.X[12], 6) + n3;
        n6 = rIPEMD320Digest10.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n20 + rIPEMD320Digest10.f1(n3, n2, n6) + this.X[13], 7) + n4;
        int n22 = rIPEMD320Digest.RL(n2, 10);
        n2 = n22;
        RIPEMD320Digest rIPEMD320Digest12 = this;
        int n23 = n;
        RIPEMD320Digest rIPEMD320Digest13 = this;
        n = this.RL(n4 + this.f1(n13, n3, n2) + this.X[14], 9) + n6;
        n3 = rIPEMD320Digest13.RL(n3, 10);
        n2 = this.RL(n6 + rIPEMD320Digest13.f1(n, n13, n3) + this.X[15], 8) + n2;
        n4 = this.RL(n13, 10);
        n6 = this.RL(n23 + this.f5(n9, n10, n11) + this.X[5] + 1352829926, 8) + n12;
        int n24 = rIPEMD320Digest12.RL(n10, 10);
        n10 = n24;
        RIPEMD320Digest rIPEMD320Digest14 = this;
        int n25 = n6;
        int n26 = n11;
        RIPEMD320Digest rIPEMD320Digest15 = this;
        int n27 = n9;
        n9 = this.RL(n12 + this.f5(n6, n9, n10) + this.X[14] + 1352829926, 9) + n11;
        n11 = rIPEMD320Digest15.RL(n27, 10);
        n6 = this.RL(n26 + rIPEMD320Digest15.f5(n9, n6, n11) + this.X[7] + 1352829926, 9) + n10;
        n10 = rIPEMD320Digest14.RL(n25, 10);
        n12 = rIPEMD320Digest12.RL(n24 + rIPEMD320Digest14.f5(n6, n9, n10) + this.X[0] + 1352829926, 11) + n11;
        int n28 = rIPEMD320Digest12.RL(n9, 10);
        n9 = n28;
        RIPEMD320Digest rIPEMD320Digest16 = this;
        int n29 = n10;
        RIPEMD320Digest rIPEMD320Digest17 = this;
        int n30 = n6;
        n6 = this.RL(n11 + this.f5(n12, n6, n9) + this.X[9] + 1352829926, 13) + n10;
        n10 = rIPEMD320Digest17.RL(n30, 10);
        n9 = this.RL(n29 + rIPEMD320Digest17.f5(n6, n12, n10) + this.X[2] + 1352829926, 15) + n9;
        n11 = rIPEMD320Digest16.RL(n12, 10);
        n12 = rIPEMD320Digest12.RL(n28 + rIPEMD320Digest16.f5(n9, n6, n11) + this.X[11] + 1352829926, 15) + n10;
        int n31 = rIPEMD320Digest12.RL(n6, 10);
        n6 = n31;
        RIPEMD320Digest rIPEMD320Digest18 = this;
        RIPEMD320Digest rIPEMD320Digest19 = this;
        int n32 = n9;
        n9 = this.RL(n10 + this.f5(n12, n9, n6) + this.X[4] + 1352829926, 5) + n11;
        n10 = rIPEMD320Digest19.RL(n32, 10);
        n6 = this.RL(n11 + rIPEMD320Digest19.f5(n9, n12, n10) + this.X[13] + 1352829926, 7) + n6;
        n11 = rIPEMD320Digest18.RL(n12, 10);
        n12 = rIPEMD320Digest12.RL(n31 + rIPEMD320Digest18.f5(n6, n9, n11) + this.X[6] + 1352829926, 7) + n10;
        int n33 = rIPEMD320Digest12.RL(n9, 10);
        n9 = n33;
        RIPEMD320Digest rIPEMD320Digest20 = this;
        RIPEMD320Digest rIPEMD320Digest21 = this;
        int n34 = n6;
        n6 = this.RL(n10 + this.f5(n12, n6, n9) + this.X[15] + 1352829926, 8) + n11;
        n10 = rIPEMD320Digest21.RL(n34, 10);
        n9 = this.RL(n11 + rIPEMD320Digest21.f5(n6, n12, n10) + this.X[8] + 1352829926, 11) + n9;
        n11 = rIPEMD320Digest20.RL(n12, 10);
        n12 = rIPEMD320Digest12.RL(n33 + rIPEMD320Digest20.f5(n9, n6, n11) + this.X[1] + 1352829926, 14) + n10;
        int n35 = rIPEMD320Digest12.RL(n6, 10);
        n6 = n35;
        RIPEMD320Digest rIPEMD320Digest22 = this;
        RIPEMD320Digest rIPEMD320Digest23 = this;
        int n36 = n9;
        n9 = this.RL(n10 + this.f5(n12, n9, n6) + this.X[10] + 1352829926, 14) + n11;
        n10 = rIPEMD320Digest23.RL(n36, 10);
        n6 = this.RL(n11 + rIPEMD320Digest23.f5(n9, n12, n10) + this.X[3] + 1352829926, 12) + n6;
        n11 = rIPEMD320Digest22.RL(n12, 10);
        n12 = rIPEMD320Digest12.RL(n35 + rIPEMD320Digest22.f5(n6, n9, n11) + this.X[12] + 1352829926, 6) + n10;
        n9 = rIPEMD320Digest12.RL(n9, 10);
        n13 = rIPEMD320Digest.RL(n22 + rIPEMD320Digest12.f2(n12, n, n4) + this.X[7] + 1518500249, 7) + n3;
        int n37 = rIPEMD320Digest.RL(n, 10);
        n = n37;
        RIPEMD320Digest rIPEMD320Digest24 = this;
        int n38 = n4;
        RIPEMD320Digest rIPEMD320Digest25 = this;
        n3 = this.RL(n3 + this.f2(n13, n12, n) + this.X[4] + 1518500249, 6) + n4;
        n4 = rIPEMD320Digest25.RL(n12, 10);
        n = this.RL(n38 + rIPEMD320Digest25.f2(n3, n13, n4) + this.X[13] + 1518500249, 8) + n;
        n12 = rIPEMD320Digest24.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n37 + rIPEMD320Digest24.f2(n, n3, n12) + this.X[1] + 1518500249, 13) + n4;
        int n39 = rIPEMD320Digest.RL(n3, 10);
        n3 = n39;
        RIPEMD320Digest rIPEMD320Digest26 = this;
        RIPEMD320Digest rIPEMD320Digest27 = this;
        int n40 = n;
        n = this.RL(n4 + this.f2(n13, n, n3) + this.X[10] + 1518500249, 11) + n12;
        n4 = rIPEMD320Digest27.RL(n40, 10);
        n3 = this.RL(n12 + rIPEMD320Digest27.f2(n, n13, n4) + this.X[6] + 1518500249, 9) + n3;
        n12 = rIPEMD320Digest26.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n39 + rIPEMD320Digest26.f2(n3, n, n12) + this.X[15] + 1518500249, 7) + n4;
        int n41 = rIPEMD320Digest.RL(n, 10);
        n = n41;
        RIPEMD320Digest rIPEMD320Digest28 = this;
        RIPEMD320Digest rIPEMD320Digest29 = this;
        int n42 = n3;
        n3 = this.RL(n4 + this.f2(n13, n3, n) + this.X[3] + 1518500249, 15) + n12;
        n4 = rIPEMD320Digest29.RL(n42, 10);
        n = this.RL(n12 + rIPEMD320Digest29.f2(n3, n13, n4) + this.X[12] + 1518500249, 7) + n;
        n12 = rIPEMD320Digest28.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n41 + rIPEMD320Digest28.f2(n, n3, n12) + this.X[0] + 1518500249, 12) + n4;
        int n43 = rIPEMD320Digest.RL(n3, 10);
        n3 = n43;
        RIPEMD320Digest rIPEMD320Digest30 = this;
        RIPEMD320Digest rIPEMD320Digest31 = this;
        int n44 = n;
        n = this.RL(n4 + this.f2(n13, n, n3) + this.X[9] + 1518500249, 15) + n12;
        n4 = rIPEMD320Digest31.RL(n44, 10);
        n3 = this.RL(n12 + rIPEMD320Digest31.f2(n, n13, n4) + this.X[5] + 1518500249, 9) + n3;
        n12 = rIPEMD320Digest30.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n43 + rIPEMD320Digest30.f2(n3, n, n12) + this.X[2] + 1518500249, 11) + n4;
        int n45 = rIPEMD320Digest.RL(n, 10);
        n = n45;
        RIPEMD320Digest rIPEMD320Digest32 = this;
        RIPEMD320Digest rIPEMD320Digest33 = this;
        int n46 = n3;
        n3 = this.RL(n4 + this.f2(n13, n3, n) + this.X[14] + 1518500249, 7) + n12;
        n4 = rIPEMD320Digest33.RL(n46, 10);
        n = this.RL(n12 + rIPEMD320Digest33.f2(n3, n13, n4) + this.X[11] + 1518500249, 13) + n;
        n12 = rIPEMD320Digest32.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n45 + rIPEMD320Digest32.f2(n, n3, n12) + this.X[8] + 1518500249, 12) + n4;
        int n47 = rIPEMD320Digest.RL(n3, 10);
        n3 = n47;
        RIPEMD320Digest rIPEMD320Digest34 = this;
        int n48 = n9;
        RIPEMD320Digest rIPEMD320Digest35 = this;
        int n49 = n2;
        RIPEMD320Digest rIPEMD320Digest36 = this;
        int n50 = n6;
        n6 = this.RL(n10 + this.f4(n2, n6, n9) + this.X[6] + 1548603684, 9) + n11;
        n10 = rIPEMD320Digest36.RL(n50, 10);
        n2 = this.RL(n11 + rIPEMD320Digest36.f4(n6, n2, n10) + this.X[11] + 1548603684, 13) + n9;
        n9 = rIPEMD320Digest35.RL(n49, 10);
        n11 = rIPEMD320Digest34.RL(n48 + rIPEMD320Digest35.f4(n2, n6, n9) + this.X[3] + 1548603684, 15) + n10;
        int n51 = rIPEMD320Digest34.RL(n6, 10);
        n6 = n51;
        RIPEMD320Digest rIPEMD320Digest37 = this;
        int n52 = n9;
        RIPEMD320Digest rIPEMD320Digest38 = this;
        int n53 = n2;
        n2 = this.RL(n10 + this.f4(n11, n2, n6) + this.X[7] + 1548603684, 7) + n9;
        n9 = rIPEMD320Digest38.RL(n53, 10);
        n6 = this.RL(n52 + rIPEMD320Digest38.f4(n2, n11, n9) + this.X[0] + 1548603684, 12) + n6;
        n10 = rIPEMD320Digest37.RL(n11, 10);
        n11 = rIPEMD320Digest34.RL(n51 + rIPEMD320Digest37.f4(n6, n2, n10) + this.X[13] + 1548603684, 8) + n9;
        int n54 = rIPEMD320Digest34.RL(n2, 10);
        n2 = n54;
        RIPEMD320Digest rIPEMD320Digest39 = this;
        RIPEMD320Digest rIPEMD320Digest40 = this;
        int n55 = n6;
        n6 = this.RL(n9 + this.f4(n11, n6, n2) + this.X[5] + 1548603684, 9) + n10;
        n9 = rIPEMD320Digest40.RL(n55, 10);
        n2 = this.RL(n10 + rIPEMD320Digest40.f4(n6, n11, n9) + this.X[10] + 1548603684, 11) + n2;
        n10 = rIPEMD320Digest39.RL(n11, 10);
        n11 = rIPEMD320Digest34.RL(n54 + rIPEMD320Digest39.f4(n2, n6, n10) + this.X[14] + 1548603684, 7) + n9;
        int n56 = rIPEMD320Digest34.RL(n6, 10);
        n6 = n56;
        RIPEMD320Digest rIPEMD320Digest41 = this;
        RIPEMD320Digest rIPEMD320Digest42 = this;
        int n57 = n2;
        n2 = this.RL(n9 + this.f4(n11, n2, n6) + this.X[15] + 1548603684, 7) + n10;
        n9 = rIPEMD320Digest42.RL(n57, 10);
        n6 = this.RL(n10 + rIPEMD320Digest42.f4(n2, n11, n9) + this.X[8] + 1548603684, 12) + n6;
        n10 = rIPEMD320Digest41.RL(n11, 10);
        n11 = rIPEMD320Digest34.RL(n56 + rIPEMD320Digest41.f4(n6, n2, n10) + this.X[12] + 1548603684, 7) + n9;
        int n58 = rIPEMD320Digest34.RL(n2, 10);
        n2 = n58;
        RIPEMD320Digest rIPEMD320Digest43 = this;
        RIPEMD320Digest rIPEMD320Digest44 = this;
        int n59 = n6;
        n6 = this.RL(n9 + this.f4(n11, n6, n2) + this.X[4] + 1548603684, 6) + n10;
        n9 = rIPEMD320Digest44.RL(n59, 10);
        n2 = this.RL(n10 + rIPEMD320Digest44.f4(n6, n11, n9) + this.X[9] + 1548603684, 15) + n2;
        n10 = rIPEMD320Digest43.RL(n11, 10);
        n11 = rIPEMD320Digest34.RL(n58 + rIPEMD320Digest43.f4(n2, n6, n10) + this.X[1] + 1548603684, 13) + n9;
        int n60 = rIPEMD320Digest34.RL(n6, 10);
        n6 = n60;
        RIPEMD320Digest rIPEMD320Digest45 = this;
        int n61 = n10;
        RIPEMD320Digest rIPEMD320Digest46 = this;
        int n62 = n;
        int n63 = n4;
        int n64 = n2;
        n2 = this.RL(n9 + this.f4(n11, n2, n6) + this.X[2] + 1548603684, 11) + n10;
        n4 = this.RL(n64, 10);
        n = this.RL(n63 + this.f3(n13, n, n4) + this.X[3] + 1859775393, 11) + n12;
        int n65 = rIPEMD320Digest46.RL(n62, 10);
        n9 = n65;
        RIPEMD320Digest rIPEMD320Digest47 = this;
        int n66 = n;
        int n67 = n4;
        RIPEMD320Digest rIPEMD320Digest48 = this;
        n4 = this.RL(n12 + this.f3(n, n13, n9) + this.X[10] + 1859775393, 13) + n4;
        n10 = rIPEMD320Digest48.RL(n13, 10);
        n = this.RL(n67 + rIPEMD320Digest48.f3(n4, n, n10) + this.X[14] + 1859775393, 6) + n9;
        n9 = rIPEMD320Digest47.RL(n66, 10);
        n12 = rIPEMD320Digest46.RL(n65 + rIPEMD320Digest47.f3(n, n4, n9) + this.X[4] + 1859775393, 7) + n10;
        int n68 = rIPEMD320Digest46.RL(n4, 10);
        n4 = n68;
        RIPEMD320Digest rIPEMD320Digest49 = this;
        int n69 = n9;
        RIPEMD320Digest rIPEMD320Digest50 = this;
        int n70 = n;
        n = this.RL(n10 + this.f3(n12, n, n4) + this.X[9] + 1859775393, 14) + n9;
        n9 = rIPEMD320Digest50.RL(n70, 10);
        n4 = this.RL(n69 + rIPEMD320Digest50.f3(n, n12, n9) + this.X[15] + 1859775393, 9) + n4;
        n10 = rIPEMD320Digest49.RL(n12, 10);
        n12 = rIPEMD320Digest46.RL(n68 + rIPEMD320Digest49.f3(n4, n, n10) + this.X[8] + 1859775393, 13) + n9;
        int n71 = rIPEMD320Digest46.RL(n, 10);
        n = n71;
        RIPEMD320Digest rIPEMD320Digest51 = this;
        RIPEMD320Digest rIPEMD320Digest52 = this;
        int n72 = n4;
        n4 = this.RL(n9 + this.f3(n12, n4, n) + this.X[1] + 1859775393, 15) + n10;
        n9 = rIPEMD320Digest52.RL(n72, 10);
        n = this.RL(n10 + rIPEMD320Digest52.f3(n4, n12, n9) + this.X[2] + 1859775393, 14) + n;
        n10 = rIPEMD320Digest51.RL(n12, 10);
        n12 = rIPEMD320Digest46.RL(n71 + rIPEMD320Digest51.f3(n, n4, n10) + this.X[7] + 1859775393, 8) + n9;
        int n73 = rIPEMD320Digest46.RL(n4, 10);
        n4 = n73;
        RIPEMD320Digest rIPEMD320Digest53 = this;
        RIPEMD320Digest rIPEMD320Digest54 = this;
        int n74 = n;
        n = this.RL(n9 + this.f3(n12, n, n4) + this.X[0] + 1859775393, 13) + n10;
        n9 = rIPEMD320Digest54.RL(n74, 10);
        n4 = this.RL(n10 + rIPEMD320Digest54.f3(n, n12, n9) + this.X[6] + 1859775393, 6) + n4;
        n10 = rIPEMD320Digest53.RL(n12, 10);
        n12 = rIPEMD320Digest46.RL(n73 + rIPEMD320Digest53.f3(n4, n, n10) + this.X[13] + 1859775393, 5) + n9;
        int n75 = rIPEMD320Digest46.RL(n, 10);
        n = n75;
        RIPEMD320Digest rIPEMD320Digest55 = this;
        RIPEMD320Digest rIPEMD320Digest56 = this;
        int n76 = n4;
        n4 = this.RL(n9 + this.f3(n12, n4, n) + this.X[11] + 1859775393, 12) + n10;
        n9 = rIPEMD320Digest56.RL(n76, 10);
        n = this.RL(n10 + rIPEMD320Digest56.f3(n4, n12, n9) + this.X[5] + 1859775393, 7) + n;
        n10 = rIPEMD320Digest55.RL(n12, 10);
        n12 = rIPEMD320Digest46.RL(n75 + rIPEMD320Digest55.f3(n, n4, n10) + this.X[12] + 1859775393, 5) + n9;
        n4 = rIPEMD320Digest46.RL(n4, 10);
        n6 = this.RL(n61 + rIPEMD320Digest46.f3(n2, n11, n3) + this.X[15] + 1836072691, 9) + n6;
        n11 = rIPEMD320Digest45.RL(n11, 10);
        n3 = rIPEMD320Digest34.RL(n60 + rIPEMD320Digest45.f3(n6, n2, n11) + this.X[5] + 1836072691, 7) + n3;
        n2 = rIPEMD320Digest34.RL(n2, 10);
        n13 = rIPEMD320Digest.RL(n47 + rIPEMD320Digest34.f3(n3, n6, n2) + this.X[1] + 1836072691, 15) + n11;
        int n77 = rIPEMD320Digest.RL(n6, 10);
        n6 = n77;
        RIPEMD320Digest rIPEMD320Digest57 = this;
        int n78 = n2;
        RIPEMD320Digest rIPEMD320Digest58 = this;
        n2 = this.RL(n11 + this.f3(n13, n3, n6) + this.X[3] + 1836072691, 11) + n2;
        n3 = rIPEMD320Digest58.RL(n3, 10);
        n6 = this.RL(n78 + rIPEMD320Digest58.f3(n2, n13, n3) + this.X[7] + 1836072691, 8) + n6;
        n11 = rIPEMD320Digest57.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n77 + rIPEMD320Digest57.f3(n6, n2, n11) + this.X[14] + 1836072691, 6) + n3;
        int n79 = rIPEMD320Digest.RL(n2, 10);
        n2 = n79;
        RIPEMD320Digest rIPEMD320Digest59 = this;
        RIPEMD320Digest rIPEMD320Digest60 = this;
        n3 = this.RL(n3 + this.f3(n13, n6, n2) + this.X[6] + 1836072691, 6) + n11;
        n6 = rIPEMD320Digest60.RL(n6, 10);
        n2 = this.RL(n11 + rIPEMD320Digest60.f3(n3, n13, n6) + this.X[9] + 1836072691, 14) + n2;
        n11 = rIPEMD320Digest59.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n79 + rIPEMD320Digest59.f3(n2, n3, n11) + this.X[11] + 1836072691, 12) + n6;
        int n80 = rIPEMD320Digest.RL(n3, 10);
        n3 = n80;
        RIPEMD320Digest rIPEMD320Digest61 = this;
        RIPEMD320Digest rIPEMD320Digest62 = this;
        int n81 = n2;
        n2 = this.RL(n6 + this.f3(n13, n2, n3) + this.X[8] + 1836072691, 13) + n11;
        n6 = rIPEMD320Digest62.RL(n81, 10);
        n3 = this.RL(n11 + rIPEMD320Digest62.f3(n2, n13, n6) + this.X[12] + 1836072691, 5) + n3;
        n11 = rIPEMD320Digest61.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n80 + rIPEMD320Digest61.f3(n3, n2, n11) + this.X[2] + 1836072691, 14) + n6;
        int n82 = rIPEMD320Digest.RL(n2, 10);
        n2 = n82;
        RIPEMD320Digest rIPEMD320Digest63 = this;
        RIPEMD320Digest rIPEMD320Digest64 = this;
        int n83 = n3;
        n3 = this.RL(n6 + this.f3(n13, n3, n2) + this.X[10] + 1836072691, 13) + n11;
        n6 = rIPEMD320Digest64.RL(n83, 10);
        n2 = this.RL(n11 + rIPEMD320Digest64.f3(n3, n13, n6) + this.X[0] + 1836072691, 13) + n2;
        n11 = rIPEMD320Digest63.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n82 + rIPEMD320Digest63.f3(n2, n3, n11) + this.X[4] + 1836072691, 7) + n6;
        int n84 = rIPEMD320Digest.RL(n3, 10);
        n3 = n84;
        RIPEMD320Digest rIPEMD320Digest65 = this;
        int n85 = n9;
        RIPEMD320Digest rIPEMD320Digest66 = this;
        int n86 = n;
        int n87 = n2;
        n2 = this.RL(n6 + this.f3(n13, n2, n3) + this.X[13] + 1836072691, 5) + n11;
        n6 = this.RL(n87, 10);
        n = this.RL(n11 + this.f4(n12, n, n4) + this.X[1] + -1894007588, 11) + n10;
        int n88 = rIPEMD320Digest66.RL(n86, 10);
        n9 = n88;
        RIPEMD320Digest rIPEMD320Digest67 = this;
        int n89 = n;
        int n90 = n4;
        RIPEMD320Digest rIPEMD320Digest68 = this;
        n4 = this.RL(n10 + this.f4(n, n12, n9) + this.X[9] + -1894007588, 12) + n4;
        n10 = rIPEMD320Digest68.RL(n12, 10);
        n = this.RL(n90 + rIPEMD320Digest68.f4(n4, n, n10) + this.X[11] + -1894007588, 14) + n9;
        n9 = rIPEMD320Digest67.RL(n89, 10);
        n11 = rIPEMD320Digest66.RL(n88 + rIPEMD320Digest67.f4(n, n4, n9) + this.X[10] + -1894007588, 15) + n10;
        int n91 = rIPEMD320Digest66.RL(n4, 10);
        n4 = n91;
        RIPEMD320Digest rIPEMD320Digest69 = this;
        int n92 = n9;
        RIPEMD320Digest rIPEMD320Digest70 = this;
        int n93 = n;
        n = this.RL(n10 + this.f4(n11, n, n4) + this.X[0] + -1894007588, 14) + n9;
        n9 = rIPEMD320Digest70.RL(n93, 10);
        n4 = this.RL(n92 + rIPEMD320Digest70.f4(n, n11, n9) + this.X[8] + -1894007588, 15) + n4;
        n10 = rIPEMD320Digest69.RL(n11, 10);
        n11 = rIPEMD320Digest66.RL(n91 + rIPEMD320Digest69.f4(n4, n, n10) + this.X[12] + -1894007588, 9) + n9;
        int n94 = rIPEMD320Digest66.RL(n, 10);
        n = n94;
        RIPEMD320Digest rIPEMD320Digest71 = this;
        RIPEMD320Digest rIPEMD320Digest72 = this;
        int n95 = n4;
        n4 = this.RL(n9 + this.f4(n11, n4, n) + this.X[4] + -1894007588, 8) + n10;
        n9 = rIPEMD320Digest72.RL(n95, 10);
        n = this.RL(n10 + rIPEMD320Digest72.f4(n4, n11, n9) + this.X[13] + -1894007588, 9) + n;
        n10 = rIPEMD320Digest71.RL(n11, 10);
        n11 = rIPEMD320Digest66.RL(n94 + rIPEMD320Digest71.f4(n, n4, n10) + this.X[3] + -1894007588, 14) + n9;
        int n96 = rIPEMD320Digest66.RL(n4, 10);
        n4 = n96;
        RIPEMD320Digest rIPEMD320Digest73 = this;
        RIPEMD320Digest rIPEMD320Digest74 = this;
        int n97 = n;
        n = this.RL(n9 + this.f4(n11, n, n4) + this.X[7] + -1894007588, 5) + n10;
        n9 = rIPEMD320Digest74.RL(n97, 10);
        n4 = this.RL(n10 + rIPEMD320Digest74.f4(n, n11, n9) + this.X[15] + -1894007588, 6) + n4;
        n10 = rIPEMD320Digest73.RL(n11, 10);
        n11 = rIPEMD320Digest66.RL(n96 + rIPEMD320Digest73.f4(n4, n, n10) + this.X[14] + -1894007588, 8) + n9;
        int n98 = rIPEMD320Digest66.RL(n, 10);
        n = n98;
        RIPEMD320Digest rIPEMD320Digest75 = this;
        RIPEMD320Digest rIPEMD320Digest76 = this;
        int n99 = n4;
        n4 = this.RL(n9 + this.f4(n11, n4, n) + this.X[5] + -1894007588, 6) + n10;
        n9 = rIPEMD320Digest76.RL(n99, 10);
        n = this.RL(n10 + rIPEMD320Digest76.f4(n4, n11, n9) + this.X[6] + -1894007588, 5) + n;
        n10 = rIPEMD320Digest75.RL(n11, 10);
        n11 = rIPEMD320Digest66.RL(n98 + rIPEMD320Digest75.f4(n, n4, n10) + this.X[2] + -1894007588, 12) + n9;
        n4 = rIPEMD320Digest66.RL(n4, 10);
        n3 = this.RL(n85 + rIPEMD320Digest66.f2(n2, n13, n6) + this.X[8] + 2053994217, 15) + n3;
        n12 = rIPEMD320Digest65.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n84 + rIPEMD320Digest65.f2(n3, n2, n12) + this.X[6] + 2053994217, 5) + n6;
        int n100 = rIPEMD320Digest.RL(n2, 10);
        n2 = n100;
        RIPEMD320Digest rIPEMD320Digest77 = this;
        RIPEMD320Digest rIPEMD320Digest78 = this;
        int n101 = n3;
        n3 = this.RL(n6 + this.f2(n13, n3, n2) + this.X[4] + 2053994217, 8) + n12;
        n6 = rIPEMD320Digest78.RL(n101, 10);
        n2 = this.RL(n12 + rIPEMD320Digest78.f2(n3, n13, n6) + this.X[1] + 2053994217, 11) + n2;
        n12 = rIPEMD320Digest77.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n100 + rIPEMD320Digest77.f2(n2, n3, n12) + this.X[3] + 2053994217, 14) + n6;
        int n102 = rIPEMD320Digest.RL(n3, 10);
        n3 = n102;
        RIPEMD320Digest rIPEMD320Digest79 = this;
        RIPEMD320Digest rIPEMD320Digest80 = this;
        int n103 = n2;
        n2 = this.RL(n6 + this.f2(n13, n2, n3) + this.X[11] + 2053994217, 14) + n12;
        n6 = rIPEMD320Digest80.RL(n103, 10);
        n3 = this.RL(n12 + rIPEMD320Digest80.f2(n2, n13, n6) + this.X[15] + 2053994217, 6) + n3;
        n12 = rIPEMD320Digest79.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n102 + rIPEMD320Digest79.f2(n3, n2, n12) + this.X[0] + 2053994217, 14) + n6;
        int n104 = rIPEMD320Digest.RL(n2, 10);
        n2 = n104;
        RIPEMD320Digest rIPEMD320Digest81 = this;
        RIPEMD320Digest rIPEMD320Digest82 = this;
        int n105 = n3;
        n3 = this.RL(n6 + this.f2(n13, n3, n2) + this.X[5] + 2053994217, 6) + n12;
        n6 = rIPEMD320Digest82.RL(n105, 10);
        n2 = this.RL(n12 + rIPEMD320Digest82.f2(n3, n13, n6) + this.X[12] + 2053994217, 9) + n2;
        n12 = rIPEMD320Digest81.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n104 + rIPEMD320Digest81.f2(n2, n3, n12) + this.X[2] + 2053994217, 12) + n6;
        int n106 = rIPEMD320Digest.RL(n3, 10);
        n3 = n106;
        RIPEMD320Digest rIPEMD320Digest83 = this;
        RIPEMD320Digest rIPEMD320Digest84 = this;
        int n107 = n2;
        n2 = this.RL(n6 + this.f2(n13, n2, n3) + this.X[13] + 2053994217, 9) + n12;
        n6 = rIPEMD320Digest84.RL(n107, 10);
        n3 = this.RL(n12 + rIPEMD320Digest84.f2(n2, n13, n6) + this.X[9] + 2053994217, 12) + n3;
        n12 = rIPEMD320Digest83.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n106 + rIPEMD320Digest83.f2(n3, n2, n12) + this.X[7] + 2053994217, 5) + n6;
        int n108 = rIPEMD320Digest.RL(n2, 10);
        n2 = n108;
        RIPEMD320Digest rIPEMD320Digest85 = this;
        int n109 = n9;
        RIPEMD320Digest rIPEMD320Digest86 = this;
        int n110 = n3;
        n3 = this.RL(n6 + this.f2(n13, n3, n2) + this.X[10] + 2053994217, 15) + n12;
        n6 = rIPEMD320Digest86.RL(n110, 10);
        n2 = this.RL(n12 + rIPEMD320Digest86.f2(n3, n13, n6) + this.X[14] + 2053994217, 8) + n2;
        n9 = this.RL(n13, 10);
        n12 = rIPEMD320Digest85.RL(n109 + this.f5(n11, n3, n4) + this.X[4] + -1454113458, 9) + n10;
        int n111 = rIPEMD320Digest85.RL(n3, 10);
        n3 = n111;
        RIPEMD320Digest rIPEMD320Digest87 = this;
        int n112 = n4;
        RIPEMD320Digest rIPEMD320Digest88 = this;
        n4 = this.RL(n10 + this.f5(n12, n11, n3) + this.X[0] + -1454113458, 15) + n4;
        n10 = rIPEMD320Digest88.RL(n11, 10);
        n3 = this.RL(n112 + rIPEMD320Digest88.f5(n4, n12, n10) + this.X[5] + -1454113458, 5) + n3;
        n11 = rIPEMD320Digest87.RL(n12, 10);
        n12 = rIPEMD320Digest85.RL(n111 + rIPEMD320Digest87.f5(n3, n4, n11) + this.X[9] + -1454113458, 11) + n10;
        int n113 = rIPEMD320Digest85.RL(n4, 10);
        n4 = n113;
        RIPEMD320Digest rIPEMD320Digest89 = this;
        RIPEMD320Digest rIPEMD320Digest90 = this;
        int n114 = n3;
        n3 = this.RL(n10 + this.f5(n12, n3, n4) + this.X[7] + -1454113458, 6) + n11;
        n10 = rIPEMD320Digest90.RL(n114, 10);
        n4 = this.RL(n11 + rIPEMD320Digest90.f5(n3, n12, n10) + this.X[12] + -1454113458, 8) + n4;
        n11 = rIPEMD320Digest89.RL(n12, 10);
        n12 = rIPEMD320Digest85.RL(n113 + rIPEMD320Digest89.f5(n4, n3, n11) + this.X[2] + -1454113458, 13) + n10;
        int n115 = rIPEMD320Digest85.RL(n3, 10);
        n3 = n115;
        RIPEMD320Digest rIPEMD320Digest91 = this;
        RIPEMD320Digest rIPEMD320Digest92 = this;
        int n116 = n4;
        n4 = this.RL(n10 + this.f5(n12, n4, n3) + this.X[10] + -1454113458, 12) + n11;
        n10 = rIPEMD320Digest92.RL(n116, 10);
        n3 = this.RL(n11 + rIPEMD320Digest92.f5(n4, n12, n10) + this.X[14] + -1454113458, 5) + n3;
        n11 = rIPEMD320Digest91.RL(n12, 10);
        n12 = rIPEMD320Digest85.RL(n115 + rIPEMD320Digest91.f5(n3, n4, n11) + this.X[1] + -1454113458, 12) + n10;
        int n117 = rIPEMD320Digest85.RL(n4, 10);
        n4 = n117;
        RIPEMD320Digest rIPEMD320Digest93 = this;
        RIPEMD320Digest rIPEMD320Digest94 = this;
        int n118 = n3;
        n3 = this.RL(n10 + this.f5(n12, n3, n4) + this.X[3] + -1454113458, 13) + n11;
        n10 = rIPEMD320Digest94.RL(n118, 10);
        n4 = this.RL(n11 + rIPEMD320Digest94.f5(n3, n12, n10) + this.X[8] + -1454113458, 14) + n4;
        n11 = rIPEMD320Digest93.RL(n12, 10);
        n12 = rIPEMD320Digest85.RL(n117 + rIPEMD320Digest93.f5(n4, n3, n11) + this.X[11] + -1454113458, 11) + n10;
        int n119 = rIPEMD320Digest85.RL(n3, 10);
        n3 = n119;
        RIPEMD320Digest rIPEMD320Digest95 = this;
        RIPEMD320Digest rIPEMD320Digest96 = this;
        int n120 = n4;
        n4 = this.RL(n10 + this.f5(n12, n4, n3) + this.X[6] + -1454113458, 8) + n11;
        n10 = rIPEMD320Digest96.RL(n120, 10);
        n3 = this.RL(n11 + rIPEMD320Digest96.f5(n4, n12, n10) + this.X[15] + -1454113458, 5) + n3;
        n11 = rIPEMD320Digest95.RL(n12, 10);
        n12 = rIPEMD320Digest85.RL(n119 + rIPEMD320Digest95.f5(n3, n4, n11) + this.X[13] + -1454113458, 6) + n10;
        n4 = rIPEMD320Digest85.RL(n4, 10);
        n13 = rIPEMD320Digest.RL(n108 + rIPEMD320Digest85.f1(n2, n, n9) + this.X[12], 8) + n6;
        int n121 = rIPEMD320Digest.RL(n, 10);
        n = n121;
        RIPEMD320Digest rIPEMD320Digest97 = this;
        RIPEMD320Digest rIPEMD320Digest98 = this;
        int n122 = n2;
        n2 = this.RL(n6 + this.f1(n13, n2, n) + this.X[15], 5) + n9;
        n6 = rIPEMD320Digest98.RL(n122, 10);
        n = this.RL(n9 + rIPEMD320Digest98.f1(n2, n13, n6) + this.X[10], 12) + n;
        n9 = rIPEMD320Digest97.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n121 + rIPEMD320Digest97.f1(n, n2, n9) + this.X[4], 9) + n6;
        int n123 = rIPEMD320Digest.RL(n2, 10);
        n2 = n123;
        RIPEMD320Digest rIPEMD320Digest99 = this;
        RIPEMD320Digest rIPEMD320Digest100 = this;
        int n124 = n;
        n = this.RL(n6 + this.f1(n13, n, n2) + this.X[1], 12) + n9;
        n6 = rIPEMD320Digest100.RL(n124, 10);
        n2 = this.RL(n9 + rIPEMD320Digest100.f1(n, n13, n6) + this.X[5], 5) + n2;
        n9 = rIPEMD320Digest99.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n123 + rIPEMD320Digest99.f1(n2, n, n9) + this.X[8], 14) + n6;
        int n125 = rIPEMD320Digest.RL(n, 10);
        n = n125;
        RIPEMD320Digest rIPEMD320Digest101 = this;
        RIPEMD320Digest rIPEMD320Digest102 = this;
        int n126 = n2;
        n2 = this.RL(n6 + this.f1(n13, n2, n) + this.X[7], 6) + n9;
        n6 = rIPEMD320Digest102.RL(n126, 10);
        n = this.RL(n9 + rIPEMD320Digest102.f1(n2, n13, n6) + this.X[6], 8) + n;
        n9 = rIPEMD320Digest101.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n125 + rIPEMD320Digest101.f1(n, n2, n9) + this.X[2], 13) + n6;
        int n127 = rIPEMD320Digest.RL(n2, 10);
        n2 = n127;
        RIPEMD320Digest rIPEMD320Digest103 = this;
        RIPEMD320Digest rIPEMD320Digest104 = this;
        int n128 = n;
        n = this.RL(n6 + this.f1(n13, n, n2) + this.X[13], 6) + n9;
        n6 = rIPEMD320Digest104.RL(n128, 10);
        n2 = this.RL(n9 + rIPEMD320Digest104.f1(n, n13, n6) + this.X[14], 5) + n2;
        n9 = rIPEMD320Digest103.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n127 + rIPEMD320Digest103.f1(n2, n, n9) + this.X[0], 15) + n6;
        int n129 = rIPEMD320Digest.RL(n, 10);
        n = n129;
        RIPEMD320Digest rIPEMD320Digest105 = this;
        RIPEMD320Digest rIPEMD320Digest106 = this;
        int n130 = n2;
        n2 = this.RL(n6 + this.f1(n13, n2, n) + this.X[3], 13) + n9;
        n6 = rIPEMD320Digest106.RL(n130, 10);
        n = this.RL(n9 + rIPEMD320Digest106.f1(n2, n13, n6) + this.X[9], 11) + n;
        n9 = rIPEMD320Digest105.RL(n13, 10);
        n13 = rIPEMD320Digest.RL(n129 + rIPEMD320Digest105.f1(n, n2, n9) + this.X[11], 11) + n6;
        n2 = rIPEMD320Digest.RL(n2, 10);
        rIPEMD320Digest.H0 += n10;
        rIPEMD320Digest.H1 += n12;
        rIPEMD320Digest.H2 += n3;
        rIPEMD320Digest.H3 += n4;
        rIPEMD320Digest.H4 += n9;
        rIPEMD320Digest.H5 += n6;
        rIPEMD320Digest.H6 += n13;
        rIPEMD320Digest.H7 += n;
        rIPEMD320Digest.H8 += n2;
        rIPEMD320Digest.H9 += n11;
        rIPEMD320Digest.xOff = 0;
        n = 0;
        while (true) {
            int[] nArray = this.X;
            if (n == this.X.length) break;
            nArray[n] = 0;
            ++n;
        }
    }

    @Override
    public Memoable copy() {
        return new RIPEMD320Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        this.doCopy((RIPEMD320Digest)memoable);
    }
}

