/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc8032.Ed448;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.Streams;
import java.io.EOFException;
import java.io.InputStream;
import java.security.SecureRandom;

public final class Ed448PrivateKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 57;
    public static final int SIGNATURE_SIZE = 114;
    private final byte[] data;
    private Ed448PublicKeyParameters cachedPublicKey;

    public Ed448PrivateKeyParameters(SecureRandom secureRandom) {
        super(true);
        byte[] byArray = new byte[57];
        Object object = byArray;
        v1.data = byArray;
        Ed448.generatePrivateKey(secureRandom, (byte[])object);
    }

    public Ed448PrivateKeyParameters(byte[] byArray, int n) {
        super(true);
        byte[] byArray2 = new byte[57];
        Object object = byArray2;
        v1.data = byArray2;
        System.arraycopy(byArray, n, object, 0, 57);
    }

    public Ed448PrivateKeyParameters(InputStream object) {
        InputStream inputStream = object;
        super(true);
        byte[] byArray = new byte[57];
        object = byArray;
        this.data = byArray;
        if (57 == Streams.readFully(inputStream, (byte[])object)) {
            return;
        }
        throw new EOFException("EOF encountered in middle of Ed448 private key");
    }

    public void encode(byte[] byArray, int n) {
        System.arraycopy(this.data, 0, byArray, n, 57);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Ed448PublicKeyParameters generatePublicKey() {
        Ed448PrivateKeyParameters ed448PrivateKeyParameters = this;
        byte[] byArray = ed448PrivateKeyParameters.data;
        synchronized (ed448PrivateKeyParameters.data) {
            if (ed448PrivateKeyParameters.cachedPublicKey == null) {
                byte[] byArray2 = new byte[57];
                Ed448.generatePublicKey(this.data, 0, byArray2, 0);
                this.cachedPublicKey = new Ed448PublicKeyParameters(byArray2, 0);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.cachedPublicKey;
        }
    }

    public void sign(int n, Ed448PublicKeyParameters ed448PublicKeyParameters, byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, int n4) {
        this.sign(n, byArray, byArray2, n2, n3, byArray3, n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sign(int n, byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, int n4) {
        byte[] byArray4 = new byte[57];
        this.generatePublicKey().encode(byArray4, 0);
        if (n != 0) {
            if (n != 1) throw new IllegalArgumentException("algorithm");
            if (64 != n3) throw new IllegalArgumentException("msgLen");
            Ed448.signPrehash(this.data, 0, byArray4, 0, byArray, byArray2, n2, byArray3, n4);
            return;
        } else {
            Ed448.sign(this.data, 0, byArray4, 0, byArray, byArray2, n2, n3, byArray3, n4);
        }
    }
}

